/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.GatewayConstants;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.model.AddDeviceAdvanceObj;
import com.huawei.dc.standalone.model.OptixDevInfoObj;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.view.ImportDevSelectFilePanel;
import com.huawei.dc.standalone.view.ImportDeviceFileProgressDlg;
import com.huawei.dc.standalone.view.ImportOptixDeviceParentDialog;
import com.huawei.dc.standalone.view.OptixDevInfoPanel;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ImportOptixDeviceDialog
extends ImportOptixDeviceParentDialog {
    public ImportOptixDeviceDialog(OptixDevInfoPanel optixDevInfoPanel, ImportDevSelectFilePanel selectFilePanel) {
        this.optixDevInfoPanel = optixDevInfoPanel;
        this.importFileTextField = selectFilePanel.m_filePathTxtField;
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    public void importDevice(String strFilePath) {
        this.m_oRowVector = new Vector(2);
        this.oProgressDlg = new ImportDeviceFileProgressDlg(this, false);
        this.oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("IMPORT_DEVICE_FILE"));
        ImportDeviceThread oThread = new ImportDeviceThread("ImportDeviceThread(optix)");
        oThread.start();
        this.oProgressDlg.showDetailInfo();
        this.oProgressDlg.setVisible(true);
    }

    @Override
    public void oKButton_ActionPerformed() {
        String importPath = this.importFileTextField.getText().trim();
        boolean bFileValid = this.isFileAndSizeValid(importPath);
        if (!bFileValid) {
            return;
        }
        if ("xls".equals(importPath.substring(importPath.lastIndexOf(".") + 1))) {
            this.importDevice(importPath);
        } else {
            this.importDevicesForCSV(importPath);
        }
    }

    public void importDevicesForCSV(String strFilePath) {
        this.m_oRowVector = new Vector(2);
        this.oProgressDlg = new ImportDeviceFileProgressDlg(this, false);
        this.oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("IMPORT_DEVICE_FILE"));
        ImportDeviceForCVSThread oThread = new ImportDeviceForCVSThread("ImportDeviceForCVSThread(optix)");
        oThread.start();
        this.setCSVCountSize(strFilePath);
        this.oProgressDlg.showDetailInfo();
        this.oProgressDlg.setVisible(true);
    }

    class ImportDeviceForCVSThread
    extends Thread {
        public ImportDeviceForCVSThread(String threadName) {
            super(threadName);
        }

        @Override
        public void run() {
            DCDebugTracer.trace("[ImportDeviceDialog] ImportDeviceForCVSThread start");
            String strFileName = ImportOptixDeviceDialog.this.importFileTextField.getText().trim();
            if (null == strFileName || 0 == strFileName.length()) {
                return;
            }
            ArrayList<T2000DevInfo> oResList = new ArrayList(0);
            try {
                oResList = ImportOptixDeviceDialog.this.getT2000ResourceList(strFileName);
                if (oResList == null) {
                    if (null != ImportOptixDeviceDialog.this.oProgressDlg && ImportOptixDeviceDialog.this.oProgressDlg.isVisible()) {
                        ImportOptixDeviceDialog.this.oProgressDlg.dispose();
                    }
                    return;
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
                return;
            }
            if (null != ImportOptixDeviceDialog.this.moListDevInfo) {
                ImportOptixDeviceDialog.this.moListDevInfo.clear();
            } else {
                ImportOptixDeviceDialog.this.moListDevInfo = new ArrayList();
            }
            try {
                Thread.sleep(500L);
                ImportOptixDeviceDialog.this.moListDevInfo.clear();
                Enumeration nodeEnum = ImportOptixDeviceDialog.this.optixDevInfoPanel.getAllOptixInfo();
                while (nodeEnum.hasMoreElements()) {
                    TreeTableNode tmpNode = (TreeTableNode)nodeEnum.nextElement();
                    OptixDevInfoObj optixInfoObj = (OptixDevInfoObj)tmpNode.getUserObject();
                    ImportOptixDeviceDialog.this.moListDevInfo.add(optixInfoObj);
                }
                int hasRows = ImportOptixDeviceDialog.this.moListDevInfo.size();
                this.handleDeviceInfo(oResList);
                ImportOptixDeviceDialog.this.oProgressDlg.operatorEnd();
                int countRows = ImportOptixDeviceDialog.this.moListDevInfo.size();
                if (hasRows != countRows) {
                    ImportOptixDeviceDialog.this.setAddDevice(true);
                }
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
            }
            DCDebugTracer.trace("[ImportDeviceDialog] ImportDeviceForCVSThread end..");
        }

        private void handleDeviceInfo(List<T2000DevInfo> oResList) {
            int counter = 0;
            int temp = 0;
            int rowNum = oResList.size();
            ImportOptixDeviceDialog.this.oProgressDlg.setCountSize(oResList.size());
            Iterator<T2000DevInfo> iter = oResList.iterator();
            while (iter.hasNext()) {
                DCErrorCode oErrorCode;
                int iErrrorCode;
                counter = ++temp * 100 / rowNum;
                ImportOptixDeviceDialog.this.oProgressDlg.updateProgress(counter);
                T2000DevInfo devInfo = iter.next();
                if (!ImportOptixDeviceDialog.this.checkRowIsNull(devInfo.getGatewayAddress())) continue;
                OptixDevInfoObj optixDevInfoObj = new OptixDevInfoObj();
                optixDevInfoObj.setKeyMode(devInfo.getKeyMode());
                if (2 == devInfo.getProtocolType()) {
                    optixDevInfoObj.setProtocolType(DCFrameWorkUtil.getLocalizedString("MML_PROTOCOL"));
                } else {
                    optixDevInfoObj.setProtocolType(DCFrameWorkUtil.getLocalizedString("TLL_PROTOCOL"));
                }
                if (2 == devInfo.getGateWayType()) {
                    optixDevInfoObj.setGatewayType(DCFrameWorkUtil.getLocalizedString("OS_GATEWAY_TYPE"));
                } else {
                    optixDevInfoObj.setGatewayType(DCFrameWorkUtil.getLocalizedString("IP_GATEWAY_TYPE"));
                }
                optixDevInfoObj.setDevAddress(devInfo.getGatewayAddress());
                if (2 == devInfo.getProtocolType()) {
                    String sExtendID = String.valueOf(devInfo.getExtendID());
                    if (!ImportOptixDeviceDialog.this.checkNumber(sExtendID, 1, 255)) {
                        ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("DEVICE_EXTEND_ID_HEADER")));
                        continue;
                    }
                    String sNEID = String.valueOf(devInfo.getNEID());
                    if (!ImportOptixDeviceDialog.this.checkNumber(sNEID, 1, 49151)) {
                        ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("NE_ID")));
                        continue;
                    }
                    optixDevInfoObj.setDevExtID(sExtendID);
                    optixDevInfoObj.setNEID(sNEID);
                }
                optixDevInfoObj.setDevName(devInfo.getDeviceName());
                if (!ImportOptixDeviceDialog.this.checkNumber(String.valueOf(devInfo.getPort()), 1, 65535)) {
                    ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("PORT")));
                    continue;
                }
                optixDevInfoObj.setPort(String.valueOf(devInfo.getPort()));
                optixDevInfoObj.setUserName(devInfo.getUserName());
                optixDevInfoObj.setPassword(devInfo.getPass());
                optixDevInfoObj.setDevType(devInfo.getDeviceType());
                optixDevInfoObj.setDevVersion(devInfo.getDevVersion());
                optixDevInfoObj.setIsGateWay(devInfo.getIsGateway());
                optixDevInfoObj.setDevTypeVersion(String.valueOf(devInfo.getDeviceTypeVersionId()));
                AddDeviceAdvanceObj advanceParaInfo = new AddDeviceAdvanceObj();
                advanceParaInfo.setSftpPassPhrase(devInfo.getSFTPPassPhrase());
                advanceParaInfo.setbIsSSH(devInfo.isUseSSH());
                if (devInfo.getSSHLoginMode() == AddDeviceAdvanceObj.KEY_MODE.intValue()) {
                    advanceParaInfo.setbIsKeyMode(true);
                } else {
                    advanceParaInfo.setbIsKeyMode(false);
                }
                advanceParaInfo.setSshLoginKey(devInfo.getSSHLoginKey());
                advanceParaInfo.setSshPassPhrase(devInfo.getSSHPassPhrase());
                optixDevInfoObj.setAdvancedSeting(advanceParaInfo);
                if (optixDevInfoObj.getIProtocolType() == 2) {
                    if (ImportOptixDeviceDialog.this.checkDevRepeatByMMLType(ImportOptixDeviceDialog.this.moListDevInfo, optixDevInfoObj)) {
                        ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(2));
                        continue;
                    }
                } else if (ImportOptixDeviceDialog.this.checkDevRepeatByTL1Type(ImportOptixDeviceDialog.this.moListDevInfo, optixDevInfoObj)) {
                    ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(2));
                    continue;
                }
                if ((iErrrorCode = (oErrorCode = ImportOptixDeviceDialog.this.checkDevInfo(ImportOptixDeviceDialog.this.moListDevInfo, optixDevInfoObj)).getErrorCode()) == 0) {
                    ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), oErrorCode);
                    ImportOptixDeviceDialog.this.moListDevInfo.add(optixDevInfoObj);
                    continue;
                }
                ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), oErrorCode);
            }
        }
    }

    class ImportDeviceThread
    extends Thread {
        public ImportDeviceThread(String threadName) {
            super(threadName);
        }

        @Override
        public void run() {
            DCDebugTracer.trace("[ImportDeviceDialog] importDeviceThread start");
            File excelFile = null;
            Workbook workbook = null;
            int counter = 0;
            if (null != ImportOptixDeviceDialog.this.moListDevInfo) {
                ImportOptixDeviceDialog.this.moListDevInfo.clear();
            } else {
                ImportOptixDeviceDialog.this.moListDevInfo = new ArrayList();
            }
            String filePath = ImportOptixDeviceDialog.this.importFileTextField.getPath().trim();
            try {
                Thread.sleep(500L);
                ImportOptixDeviceDialog.this.optixDevInfoPanel.deleteAllEmptyRow();
                Enumeration nodeEnum = ImportOptixDeviceDialog.this.optixDevInfoPanel.getAllOptixInfo();
                while (nodeEnum.hasMoreElements()) {
                    TreeTableNode tmpNode = (TreeTableNode)nodeEnum.nextElement();
                    OptixDevInfoObj optixInfoObj = (OptixDevInfoObj)tmpNode.getUserObject();
                    ImportOptixDeviceDialog.this.moListDevInfo.add(optixInfoObj);
                }
                int hasRows = ImportOptixDeviceDialog.this.moListDevInfo.size();
                excelFile = new File(filePath);
                workbook = Workbook.getWorkbook((File)excelFile);
                Sheet[] sheet = workbook.getSheets();
                if (sheet.length > 0 && sheet[0].getColumns() == 9) {
                    int rowNum = sheet[0].getRows();
                    for (int i = 1; i < rowNum; ++i) {
                        DCErrorCode oErrorCode;
                        int iErrorCode;
                        counter = (i + 1) * 100 / rowNum;
                        ImportOptixDeviceDialog.this.oProgressDlg.updateProgress(counter);
                        Cell[] cell = sheet[0].getRow(i);
                        if (cell.length < 9 || !ImportOptixDeviceDialog.this.checkRowIsNull(cell[5].getContents())) continue;
                        OptixDevInfoObj optixDevInfoObj = new OptixDevInfoObj();
                        optixDevInfoObj.setKeyMode(1);
                        optixDevInfoObj.setProtocolType(cell[0].getContents().trim());
                        optixDevInfoObj.setGatewayType(cell[4].getContents().trim());
                        optixDevInfoObj.setDevAddress(cell[5].getContents().trim());
                        if (GatewayConstants.STR_MML_PROTOCOL == optixDevInfoObj.getProtocolType()) {
                            if (!ImportOptixDeviceDialog.this.isNull(cell[1].getContents()) && !ImportOptixDeviceDialog.this.checkNumber(cell[1].getContents(), 1, 255)) {
                                ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(1));
                                continue;
                            }
                            if (!ImportOptixDeviceDialog.this.isNull(cell[2].getContents()) && !ImportOptixDeviceDialog.this.checkNumber(cell[2].getContents(), 1, 49151)) {
                                ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("NE_ID")));
                                continue;
                            }
                            optixDevInfoObj.setDevExtID(cell[1].getContents().trim());
                            optixDevInfoObj.setNEID(cell[2].getContents().trim());
                        }
                        optixDevInfoObj.setDevName(cell[3].getContents().trim());
                        if (!ImportOptixDeviceDialog.this.checkNumber(cell[6].getContents(), 1, 65535)) {
                            ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("PORT")));
                            continue;
                        }
                        optixDevInfoObj.setPort(cell[6].getContents().trim());
                        optixDevInfoObj.setUserName(cell[7].getContents().trim());
                        optixDevInfoObj.setPassword(cell[8].getContents().toCharArray());
                        if (optixDevInfoObj.getIProtocolType() == 2) {
                            if (ImportOptixDeviceDialog.this.checkDevRepeatByMMLType(ImportOptixDeviceDialog.this.moListDevInfo, optixDevInfoObj)) {
                                ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(2));
                                continue;
                            }
                        } else if (ImportOptixDeviceDialog.this.checkDevRepeatByTL1Type(ImportOptixDeviceDialog.this.moListDevInfo, optixDevInfoObj)) {
                            ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), new DCErrorCode(2));
                            continue;
                        }
                        if ((iErrorCode = (oErrorCode = ImportOptixDeviceDialog.this.checkDevInfo(ImportOptixDeviceDialog.this.moListDevInfo, optixDevInfoObj)).getErrorCode()) == 0) {
                            ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), oErrorCode);
                            ImportOptixDeviceDialog.this.moListDevInfo.add(optixDevInfoObj);
                        } else {
                            ImportOptixDeviceDialog.this.oProgressDlg.addImportOperator(optixDevInfoObj.getDevAddress(), oErrorCode);
                        }
                        counter = (i + 1) * 100 / rowNum;
                        ImportOptixDeviceDialog.this.oProgressDlg.updateProgress(counter);
                    }
                } else {
                    ImportOptixDeviceDialog.this.oProgressDlg.setVisible(false);
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("MSG_IMPORT_DEVICE_FILE_INVALID"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
                    return;
                }
                ImportOptixDeviceDialog.this.oProgressDlg.operatorEnd();
                int countRows = ImportOptixDeviceDialog.this.moListDevInfo.size();
                if (hasRows != countRows) {
                    ImportOptixDeviceDialog.this.setAddDevice(true);
                }
            }
            catch (BiffException e) {
                ImportOptixDeviceDialog.this.oProgressDlg.operatorEnd();
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_IMPORT_DEVICE_FILE"), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 0);
                DCDebugTracer.trace((Exception)((Object)e));
            }
            catch (IOException e) {
                ImportOptixDeviceDialog.this.oProgressDlg.operatorEnd();
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_IMPORT_DEVICE_FILE_MEMERY_LACK"), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 0);
                DCDebugTracer.trace(e);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
            }
            DCDebugTracer.trace("[ImportDeviceDialog] importDeviceThread end..");
        }
    }
}

