/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.asndatacenter.AsnDevDefImportReq;
import com.huawei.dc.common.asndatacenter.AsnDevDefImportRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.ObjectStore;
import com.swimap.iview.util.SyncCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigInteger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.commustru.fstru.FStruct;

public class ImportNeTypeFileDialog
extends DCModalDialog {
    protected JPanel panel;
    protected JLabel importFilePathJLable;
    protected JTextField importFileTextField;
    protected JButton importFilechooseButton;
    public boolean oMBCancelled = false;
    private BaseCommManager m_oCommManager;
    protected static final int fieldSize = 50;
    private static final String IMPORT_NETYPE_SAVE_PATH_KEY = "IMPORT_NETYPE_SAVE_PATH_KEY";
    private static final String INPORT_DIALOG_NAME = "ImportNeTypeFileDialog_importFileTextField";

    public ImportNeTypeFileDialog() {
        this.jbinit();
        this.addListener();
        this.enableHelpKeyValue();
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
    }

    public void jbinit() {
        this.setResizable(false);
        this.setSize(new Dimension(460, 130));
        this.setTitle(DCFrameWorkUtil.getLocalizedString("IMPORT_NETYPE_FILE"));
        this.createComponent();
        this.addComponent();
    }

    public void createComponent() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.importFilePathJLable = new JLabel(DCFrameWorkUtil.getLocalizedString("IMPORT_NETYPE_FILE") + ":");
        this.importFilePathJLable.setBackground(Color.black);
        this.importFilePathJLable.setPreferredSize(new Dimension(180, 20));
        this.importFileTextField = new JTextField();
        this.importFileTextField.setName(INPORT_DIALOG_NAME);
        this.importFileTextField.setPreferredSize(new Dimension(190, 22));
        String log_save_path = (String)ObjectStore.getInstance().getObjectInstance(IMPORT_NETYPE_SAVE_PATH_KEY);
        if (null == log_save_path) {
            log_save_path = "";
        }
        this.importFileTextField.setText(log_save_path);
        this.importFilechooseButton = new JButton("...");
        this.importFilechooseButton.setPreferredSize(new Dimension(22, 22));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CANCEL_BUTTON"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BUTTON"));
        this.m_oOKBtn.setFocusable(true);
        this.m_oCancelBtn.setFocusable(true);
    }

    public void addComponent() {
        this.setLayout(new GridBagLayout());
        this.panel.add((Component)this.importFilePathJLable, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.panel.add((Component)this.importFileTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.importFilechooseButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.panel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.m_oOKBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 12, 0, new Insets(5, 0, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 10, 10), 0, 0));
    }

    public void addListener() {
        this.importFilechooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnValue;
                File dirSave;
                DCFileChooser oImportFileChooser = new DCFileChooser();
                oImportFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("IMPORT_NETYPE_FILE"));
                oImportFileChooser.setFileSelectionMode(0);
                oImportFileChooser.setControlButtonsAreShown(true);
                oImportFileChooser.setFileFilter(8192);
                oImportFileChooser.setAcceptAllFileFilterUsed(false);
                String strDefPath = (String)ObjectStore.getInstance().getObjectInstance(ImportNeTypeFileDialog.IMPORT_NETYPE_SAVE_PATH_KEY);
                if (null != strDefPath && (dirSave = new File(strDefPath)).exists()) {
                    oImportFileChooser.setSelectedFile(dirSave);
                }
                if (0 != (returnValue = oImportFileChooser.showDialog((Component)((Object)ImportNeTypeFileDialog.this), ResourceManager.getInstance().getResString("OK")))) {
                    return;
                }
                ImportNeTypeFileDialog.this.importFileTextField.setText(oImportFileChooser.getSelectedFile().getAbsolutePath());
                ImportNeTypeFileDialog.this.importFileTextField.setToolTipText(oImportFileChooser.getSelectedFile().getAbsolutePath());
                ObjectStore.getInstance().putObjectInstance(ImportNeTypeFileDialog.IMPORT_NETYPE_SAVE_PATH_KEY, ImportNeTypeFileDialog.this.importFileTextField.getText());
            }
        });
    }

    @Override
    public void oKButton_ActionPerformed() {
        String importPath = this.importFileTextField.getText().trim();
        boolean bFileValid = this.isFileAndSizeValid(importPath);
        if (!bFileValid) {
            return;
        }
        int iErrorCode = this.sendSynAsnMsgtoServer(importPath);
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("OPERTION_SUCCESS"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
        DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeFromDCServer();
        this.closeDialog();
    }

    protected int sendSynAsnMsgtoServer(String importPath) {
        final AsnDevDefImportReq oAsnDevDefImportReq = new AsnDevDefImportReq();
        oAsnDevDefImportReq.strDevDefFilePath = importPath.getBytes();
        final AsnDevDefImportRsp oAsnDevDefImportRsp = new AsnDevDefImportRsp();
        int iErrorCode = 0;
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                if (DCFrameWorkUtil.getCommManager() == null) {
                    DCDebugTracer.trace("DC:ImportNeTypeFileDialog:DCFrameWorkUtil.getCommManager( ) is null");
                }
                BaseCommManager baseCommManager = ImportNeTypeFileDialog.this.m_oCommManager;
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44092), (FStruct)oAsnDevDefImportReq, (FStruct)oAsnDevDefImportRsp);
                return iErrorCode;
            }
        };
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            return iErrorCode;
        }
        iErrorCode = oAsnDevDefImportRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            return iErrorCode;
        }
        return 0;
    }

    protected boolean isFileAndSizeValid(String sFilePath) {
        boolean bValid = true;
        if (sFilePath.equals("")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("PROMPT_SELECT_NETYPE_FILE"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            return false;
        }
        File file = new File(sFilePath);
        if (!file.exists()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("MSG_IMPORT_DEVICE_FILE_INVALID"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            return false;
        }
        return bValid;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_IMPORT_NE_TYPE_FILE";
    }

    private void enableHelpKeyValue() {
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }
}

