/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.view.ImportDeviceDialog;
import com.huawei.dc.standalone.view.ImportOptixDeviceDialog;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.swimap.iview.communicate.MSGListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class ImportDeviceFileProgressDlg
extends ProgressDlg {
    private static final long serialVersionUID = 1337608442632731555L;
    protected ImportDeviceDialog m_oImportDeviceFileDialog = null;
    protected Object m_oSyncObj = new Object();
    protected boolean needOtherInfo = false;
    protected int counter = 0;
    protected int countSize = 0;

    public ImportDeviceFileProgressDlg(int iCommandCode) {
        super(iCommandCode);
    }

    public ImportDeviceFileProgressDlg(ImportDeviceDialog m_oImportDeviceFileDialog, boolean needOtherInfo) {
        this.m_oImportDeviceFileDialog = m_oImportDeviceFileDialog;
        this.needOtherInfo = needOtherInfo;
        this.customizeTableForTelnetError();
        this.m_closeBtn.setText(ResourceManager.getInstance().getResString("OK"));
    }

    protected void setNeedOtherInfo(boolean needOtherInfo) {
        this.needOtherInfo = needOtherInfo;
    }

    @Override
    protected String[] getTableColumnNames() {
        String[] columnNames = new String[]{DCFrameWorkUtil.getLocalizedString("DEVICE_INFO"), DCFrameWorkUtil.getLocalizedString("OPERATE_RESULT"), ResourceManager.getInstance().getResString("ERROR_INFO")};
        return columnNames;
    }

    public void addImportOperator(String name, DCErrorCode oDCErrorCode) {
        ++this.counter;
        DCDebugTracer.trace("ImportDeviceFileProgressDlg - Method addImportOperator start");
        String strResult = "";
        Vector<Object> oRowVector = new Vector<Object>(2);
        if (null == oDCErrorCode) {
            return;
        }
        int iErrorCode = oDCErrorCode.getErrorCode();
        String sErrorMsg = oDCErrorCode.getErrorMsg();
        strResult = 0 == iErrorCode ? DCFrameWorkUtil.getLocalizedString("IMPORT_SUCCESS_OPERATOR") : (2 == iErrorCode ? DCFrameWorkUtil.getLocalizedString("IMPORT_REPEAT_OPERATOR") : (3 == iErrorCode ? DCFrameWorkUtil.getLocalizedString("IMPORT_FAILED_DO_NOT_SUPPORT_DEV_TYPE") : (-1 == iErrorCode ? ResourceManager.getInstance().getResString("IMPORT_FAILED_OPERATOR", new String[]{sErrorMsg}) : (-1 > iErrorCode ? sErrorMsg : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode))))));
        oRowVector.addElement(name);
        oRowVector.addElement(strResult);
        this.updateProgress(this.counter, oRowVector);
        DCDebugTracer.trace("ImportDeviceFileProgressDlg - Method addImportOperator end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgress(final int iCounter, final Vector<Object> oRowVector) {
        Object object = this.m_oSyncObj;
        synchronized (object) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportDeviceFileProgressDlg.this.m_oDetailsTableModel.addRow(oRowVector);
                    ImportDeviceFileProgressDlg.this.m_oImportDeviceFileDialog.addoRowVector(oRowVector);
                    if (0 != ImportDeviceFileProgressDlg.this.countSize) {
                        ImportDeviceFileProgressDlg.this.m_progressBar.setValue(iCounter * 100 / ImportDeviceFileProgressDlg.this.countSize);
                    }
                    if (iCounter >= ImportDeviceFileProgressDlg.this.countSize) {
                        DCDebugTracer.trace("Add device - bIsFinal is true");
                        ImportDeviceFileProgressDlg.this.m_progressBar.setValue(100);
                        ImportDeviceFileProgressDlg.this.m_progressBar.setIndeterminate(false);
                        ImportDeviceFileProgressDlg.this.m_cancelBtn.setEnabled(false);
                        ImportDeviceFileProgressDlg.this.m_closeBtn.setEnabled(true);
                        DCFrameWorkUtil.getCommManager().removeMessageListener(43933, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
                    }
                }
            });
        }
    }

    public void operatorEnd() {
        this.m_progressBar.setValue(100);
        this.m_progressBar.setIndeterminate(false);
        if (null != this.m_oImportDeviceFileDialog) {
            this.m_cancelBtn.setEnabled(true);
        } else {
            this.m_cancelBtn.setEnabled(false);
        }
        this.m_closeBtn.setEnabled(true);
    }

    @Override
    protected void registerCancelBtnListener() {
        this.m_cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int confirm;
                if (null != ImportDeviceFileProgressDlg.this.m_oImportDeviceFileDialog && (confirm = DCOptionPane.showConfirmDialog((Component)((Object)ImportDeviceFileProgressDlg.this.m_oImportDeviceFileDialog), ResourceManager.getInstance().getResString("CONFIRM_VERSION_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0)) == 0) {
                    ImportDeviceFileProgressDlg.this.cancelButtonActionPerformed();
                    ImportDeviceFileProgressDlg.this.setIsAddDevice(false);
                }
            }
        });
    }

    private void registerCloseBtnListener() {
        this.m_closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDeviceFileProgressDlg.this.doCleanUp();
                ToolTipManager.sharedInstance().setEnabled(true);
                ImportDeviceFileProgressDlg.this.setIsAddDevice(true);
            }
        });
    }

    @Override
    public void doCleanUp() {
        if (this.m_closeBtn.isEnabled()) {
            this.m_oDetailsTableModel.getDataVector().removeAllElements();
            this.dispose();
            if (this.needOtherInfo) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("IMPORT_DEVICE_SUCCESS")));
            }
        }
    }

    @Override
    public void updateProgress(int counter) {
        this.m_progressBar.setValue(counter);
    }

    @Override
    protected void cancelButtonActionPerformed() {
        this.setVisible(false);
        if (this.needOtherInfo) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("IMPORT_DEVICE_SUCCESS")));
        }
    }

    public void setCountSize(int countSize) {
        this.countSize = countSize;
    }

    public void resetCounter() {
        this.counter = 0;
    }

    public void setIsAddDevice(boolean isCancle) {
        if (this.m_oImportDeviceFileDialog instanceof ImportOptixDeviceDialog) {
            ((ImportOptixDeviceDialog)this.m_oImportDeviceFileDialog).setAddDevice(isCancle);
        }
    }
}

