/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.GatewayConstants;
import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.standalone.StandAloneCommonOpr;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.huawei.dc.standalone.startup.DCStandaloneDebugTracer;
import com.huawei.dc.standalone.view.ImportRouterDeviceFileProgressDlg;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ImportDeviceDialog
extends DCModalDialog {
    private static final long serialVersionUID = -8437086797273915922L;
    protected static final long FILESIZE = 0x100000L;
    protected static final int ADD_DEVICE_SUCCESS = 0;
    protected static final int ADD_DEVICE_FAILED = 1;
    protected static final int ADD_DEVICE_REPEAT = 2;
    protected static final int ADD_DEVICE_FAILED_NOT_SUPPORT_DEV_TYPE = 3;
    private static int routeColumn = 11;
    protected static final int fieldSize = 65;
    private static final String IMPORT_DEVICE_SAVE_PATH_KEY = "IMPORT_DEVICE_SAVE_PATH_KEY";
    private static final String INPORT_DIALOG_NAME = "ImportDeviceDialog_importFileTextField";
    protected JPanel panel;
    protected JLabel importFilePathJLable;
    protected DCFilePathTextField importFileTextField;
    protected JButton importFilechooseButton;
    protected Vector<Object> m_oRowVector = null;
    public boolean oMBCancelled = false;
    private ImportRouterDeviceFileProgressDlg oProgressDlg;
    private RouterDevInfoPanel routerDevInfoPanel;
    private List m_oCurrentRouterDevList;

    public ImportDeviceDialog() {
        this.jbinit();
        this.addListener();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    public ImportDeviceDialog(RouterDevInfoPanel routerDevInfoPanel) {
        this.routerDevInfoPanel = routerDevInfoPanel;
        this.m_oCurrentRouterDevList = routerDevInfoPanel.getAllDevInfoLst();
        this.jbinit();
        this.addListener();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    public void jbinit() {
        this.setResizable(false);
        this.setSize(new Dimension(460, 130));
        this.setTitle(DCFrameWorkUtil.getLocalizedString("IMPORT_DEVICE_FILE"));
        this.createComponent();
        this.addComponent();
    }

    public void createComponent() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.importFilePathJLable = new JLabel(DCFrameWorkUtil.getLocalizedString("LBL_IMPORT_DEVICE_FILE"));
        this.importFilePathJLable.setBackground(Color.black);
        this.importFilePathJLable.setPreferredSize(new Dimension(170, 20));
        this.importFileTextField = new DCFilePathTextField();
        this.importFileTextField.setName(INPORT_DIALOG_NAME);
        this.importFileTextField.setPreferredSize(new Dimension(220, 22));
        String log_save_path = (String)ObjectStore.getInstance().getObjectInstance(IMPORT_DEVICE_SAVE_PATH_KEY);
        if (null == log_save_path) {
            log_save_path = "";
        }
        this.importFileTextField.setText(log_save_path);
        this.importFilechooseButton = new JButton("...");
        this.importFilechooseButton.setPreferredSize(new Dimension(22, 22));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CANCEL_BUTTON"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BUTTON"));
        this.m_oOKBtn.setFocusable(true);
        this.m_oCancelBtn.setFocusable(true);
    }

    public void addComponent() {
        this.setLayout(new GridBagLayout());
        this.panel.add((Component)this.importFilePathJLable, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.panel.add((Component)this.importFileTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.importFilechooseButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.panel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.m_oOKBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 12, 0, new Insets(5, 0, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 10, 10), 0, 0));
    }

    public void addListener() {
        this.importFilechooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnValue;
                File dirSave;
                DCFileChooser oImportFileChooser = new DCFileChooser();
                oImportFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_DIR"));
                oImportFileChooser.setFileSelectionMode(0);
                oImportFileChooser.setControlButtonsAreShown(true);
                oImportFileChooser.setFileFilter(1);
                oImportFileChooser.setFileFilter(2);
                oImportFileChooser.setFileFilter(8);
                oImportFileChooser.setAcceptAllFileFilterUsed(false);
                String strDefPath = (String)ObjectStore.getInstance().getObjectInstance(ImportDeviceDialog.IMPORT_DEVICE_SAVE_PATH_KEY);
                if (null != strDefPath && (dirSave = new File(strDefPath)).exists()) {
                    oImportFileChooser.setSelectedFile(dirSave);
                }
                if (0 != (returnValue = oImportFileChooser.showDialog((Component)((Object)ImportDeviceDialog.this), ResourceManager.getInstance().getResString("OK")))) {
                    return;
                }
                ImportDeviceDialog.this.importFileTextField.setText(oImportFileChooser.getSelectedFile().getAbsolutePath());
                ImportDeviceDialog.this.importFileTextField.setToolTipText(oImportFileChooser.getSelectedFile().getAbsolutePath());
                ObjectStore.getInstance().putObjectInstance(ImportDeviceDialog.IMPORT_DEVICE_SAVE_PATH_KEY, ImportDeviceDialog.this.importFileTextField.getText());
            }
        });
    }

    @Override
    public void oKButton_ActionPerformed() {
        String importPath = this.importFileTextField.getText().trim();
        boolean bFileValid = this.isFileAndSizeValid(importPath);
        if (!bFileValid) {
            return;
        }
        this.closeDialog();
        this.importDevice();
    }

    public void importDevice() {
        this.m_oRowVector = new Vector(2);
        this.oProgressDlg = new ImportRouterDeviceFileProgressDlg(this.routerDevInfoPanel, 43933, this, false);
        this.oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("IMPORT_DEVICE_FILE"));
        ImportDeviceThread oThread = new ImportDeviceThread("ImportDeviceThread(router)", 1);
        oThread.start();
        this.oProgressDlg.showDetailInfo();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportDeviceDialog.this.oProgressDlg.setVisible(true);
            }
        });
    }

    protected boolean checkCSVDevInfo(String strHeader) {
        String[] strHeaders = strHeader.split("[,]");
        String sStandColumnName = null;
        for (int i = 0; i < strHeaders.length; ++i) {
            sStandColumnName = StandAloneDomainInfo.getInstance().getSelectedDomain() == 2 ? GatewayConstants.ARR_DMS_EXPORT_FILE_HEADER_LIST.get(i).trim() : GatewayConstants.ARR_DMS_FILE_HEADER_LIST.get(i).trim();
            String sColumnNameInFile = strHeaders[i].trim();
            if (sColumnNameInFile.endsWith(sStandColumnName)) continue;
            DCDebugTracer.trace("error file format");
            return false;
        }
        return true;
    }

    protected DeviceTypeInfo checkIsSupportDevType(String strDevTypeId, String strDevTypeVerId) {
        int iDevTypeId = -1;
        if (!this.checkNumber(strDevTypeId, 0, 65535)) {
            return null;
        }
        iDevTypeId = Integer.parseInt(strDevTypeId);
        int iDevTypeVerId = -1;
        if (!this.checkNumber(strDevTypeVerId, 0, 65535)) {
            return null;
        }
        iDevTypeVerId = Integer.parseInt(strDevTypeVerId);
        DeviceTypeInfo oDevType = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDevTypeId, iDevTypeVerId);
        return oDevType;
    }

    protected String getFileEncoding(String strFilePath) {
        String encoding = FileUtil.isUTF8File(strFilePath) ? FileUtil.getUTF8Encoding() : FileUtil.getSystemEncoding();
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importCSVorTXTFile(String strFilePath) {
        FileInputStream oFileStream = null;
        InputStreamReader oFileReader = null;
        BufferedReader oBufferedReader = null;
        try {
            oFileStream = new FileInputStream(strFilePath);
            oFileReader = new InputStreamReader((InputStream)oFileStream, this.getFileEncoding(strFilePath));
            oBufferedReader = new BufferedReader(oFileReader);
            String strLine = oBufferedReader.readLine();
            if (null == strLine) {
                return;
            }
            boolean isRight = this.checkCSVDevInfo(strLine);
            if (!isRight) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INVALID_FILE_MSG"));
                this.oProgressDlg.dispose();
                return;
            }
            ArrayList<AbstractDevInfoObj> m_oListDevInfo = new ArrayList<AbstractDevInfoObj>();
            int practiceRow = 0;
            int currentRow = 0;
            Vector<String> lineContentVec = new Vector<String>();
            strLine = oBufferedReader.readLine();
            while (null != strLine) {
                lineContentVec.add(strLine);
                strLine = oBufferedReader.readLine();
            }
            this.oProgressDlg.setCountSize(lineContentVec.size());
            StandAloneDomainInfo.getInstance().getSelectedDomain();
            for (int i = 0; i < lineContentVec.size(); ++i) {
                DCErrorCode oErrorCode;
                int iErrorCode;
                String[] strDevInfo = ((String)lineContentVec.get(i)).split(",");
                int index = 2;
                RouterDevInfoObj routerDevInfoObj = new RouterDevInfoObj();
                routerDevInfoObj.setDevName(strDevInfo[index++]);
                routerDevInfoObj.setDevAddress(strDevInfo[index++]);
                routerDevInfoObj.setKeyMode(1);
                DeviceTypeInfo oDevType = this.checkIsSupportDevType(strDevInfo[0], strDevInfo[1]);
                if (null == oDevType) {
                    this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), new DCErrorCode(3));
                    ++currentRow;
                    continue;
                }
                routerDevInfoObj.setDevType(oDevType.getDevTypeName());
                if (strDevInfo.length > 11) {
                    if (!this.checkNumber(strDevInfo[11].trim(), 1, 100)) {
                        this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_DEVICE_PORT")));
                        ++currentRow;
                        continue;
                    }
                    routerDevInfoObj.setPort(strDevInfo[11].trim());
                    if (22 == routerDevInfoObj.getIPort()) {
                        routerDevInfoObj.setProtocolType(DCFrameWorkUtil.getLocalizedString("ADD_ROUTER_DEV_PROTOCOL_SSH"));
                    } else {
                        routerDevInfoObj.setProtocolType(DCFrameWorkUtil.getLocalizedString("ADD_ROUTER_DEV_PROTOCOL_TELNET"));
                    }
                } else {
                    this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("IMPORT_DATA_ERROR")));
                    ++currentRow;
                    continue;
                }
                if (strDevInfo.length > 12) {
                    routerDevInfoObj.setUserName(strDevInfo[12].trim());
                }
                if (strDevInfo.length > 18) {
                    routerDevInfoObj.setPassword(DCEncryptServiceUtil.decrypt(strDevInfo[18].toCharArray()));
                }
                if ((iErrorCode = (oErrorCode = this.checkDevInfo(m_oListDevInfo, routerDevInfoObj)).getErrorCode()) == 0) {
                    ++currentRow;
                    ++practiceRow;
                    routerDevInfoObj.setDevID(StandAloneCommonOpr.getInstance().generateDevID());
                    m_oListDevInfo.add(routerDevInfoObj);
                    routerDevInfoObj.setIsFinishInitialize(true);
                    continue;
                }
                this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), oErrorCode);
                ++currentRow;
            }
            if (practiceRow == 0) {
                this.oProgressDlg.operatorEnd();
            } else if (m_oListDevInfo.size() > 0) {
                int iReqId = DCFrameWorkUtil.generateRequestId();
                try {
                    this.routerDevInfoPanel.setImportDevices(true);
                    StandAloneSyncCtrller.getInstance().addDevice(iReqId, m_oListDevInfo, 2, true);
                }
                catch (DCException e) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                }
            } else {
                this.oProgressDlg.operatorEnd();
            }
        }
        catch (FileNotFoundException e) {
            this.handError(ResourceManager.getInstance().getResString("NOT_EXIST_FILE"));
            return;
        }
        catch (IOException e) {
            this.handError(e.getMessage());
            return;
        }
        finally {
            if (null != oBufferedReader) {
                try {
                    oBufferedReader.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oFileReader) {
                try {
                    oFileReader.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oFileStream) {
                try {
                    oFileStream.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importCSVorTXTFile(String strFilePath, int domain) {
        FileInputStream oFileStream = null;
        InputStreamReader oFileReader = null;
        BufferedReader oBufferedReader = null;
        try {
            oFileStream = new FileInputStream(strFilePath);
            oFileReader = new InputStreamReader((InputStream)oFileStream, this.getFileEncoding(strFilePath));
            oBufferedReader = new BufferedReader(oFileReader);
            String strLine = oBufferedReader.readLine();
            if (null == strLine) {
                return;
            }
            boolean isRight = this.checkCSVDevInfo(strLine);
            if (!isRight) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INVALID_FILE_MSG"));
                this.oProgressDlg.dispose();
                return;
            }
            ArrayList<AbstractDevInfoObj> m_oListDevInfo = new ArrayList<AbstractDevInfoObj>();
            int practiceRow = 0;
            int currentRow = 0;
            Vector<String> lineContentVec = new Vector<String>();
            strLine = oBufferedReader.readLine();
            while (null != strLine) {
                lineContentVec.add(strLine);
                strLine = oBufferedReader.readLine();
            }
            this.oProgressDlg.setCountSize(lineContentVec.size());
            StandAloneDomainInfo.getInstance().getSelectedDomain();
            int DMS_CSV_HEAD_SIZE = 11;
            for (int i = 0; i < lineContentVec.size(); ++i) {
                String strDevTypeVerId;
                String[] strDevInfo = ((String)lineContentVec.get(i)).split(",", DMS_CSV_HEAD_SIZE);
                RouterDevInfoObj routerDevInfoObj = new RouterDevInfoObj();
                routerDevInfoObj.setDevName(strDevInfo[0]);
                routerDevInfoObj.setDevAddress(strDevInfo[1]);
                routerDevInfoObj.setKeyMode(1);
                DeviceTypeInfo[] oDeviceTypeInfo = DeviceInfoManagerImpl.getInstance().getDevTypeInfoByTypeName(strDevInfo[2]);
                if (oDeviceTypeInfo.length <= 0 || !(oDeviceTypeInfo[0] instanceof DeviceTypeInfo)) {
                    DCDebugTracer.trace("ImportDeviceDialog#importCSVorTXTFile DeviveTypeInfo:" + strDevInfo[2] + "->IP:" + strDevInfo[1]);
                    this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), new DCErrorCode(3));
                    ++currentRow;
                    continue;
                }
                DeviceTypeInfo oDevType = oDeviceTypeInfo[0];
                String strDevTypeId = Integer.toString(oDevType.getDevTypeID());
                if (null == (oDevType = this.checkIsSupportDevType(strDevTypeId, strDevTypeVerId = Integer.toString(oDevType.getDevTypeVersionId())))) {
                    this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), new DCErrorCode(3));
                    ++currentRow;
                    continue;
                }
                String proxyType = strDevInfo[3];
                int proxyTypeValue = 1;
                try {
                    proxyTypeValue = Integer.valueOf(proxyType);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
                switch (proxyTypeValue) {
                    case 1: {
                        routerDevInfoObj.setProxyType(ResourceManager.getInstance().getResString("ADD_ROUTER_DEV_DIRECT"));
                        break;
                    }
                    case 2: {
                        routerDevInfoObj.setProxyType(ResourceManager.getInstance().getResString("ADD_ROUTER_DEV_AUTO_PROXY"));
                        break;
                    }
                    case 3: {
                        routerDevInfoObj.setProxyType("");
                        break;
                    }
                    default: {
                        routerDevInfoObj.setProxyType(ResourceManager.getInstance().getResString("ADD_ROUTER_DEV_DIRECT"));
                    }
                }
                routerDevInfoObj.setProxyNodeType(strDevInfo[4]);
                routerDevInfoObj.setProtocolType(strDevInfo[5]);
                if (!this.checkNumber(strDevInfo[6].trim(), 1, 100)) {
                    this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_DEVICE_PORT")));
                    ++currentRow;
                    continue;
                }
                routerDevInfoObj.setPort(strDevInfo[6].trim());
                if (22 == routerDevInfoObj.getIPort()) {
                    routerDevInfoObj.setProtocolType(DCFrameWorkUtil.getLocalizedString("ADD_ROUTER_DEV_PROTOCOL_SSH"));
                } else {
                    routerDevInfoObj.setProtocolType(DCFrameWorkUtil.getLocalizedString("ADD_ROUTER_DEV_PROTOCOL_TELNET"));
                }
                if (null != strDevInfo[7] && strDevInfo[7].length() != 0) {
                    routerDevInfoObj.setUserName(strDevInfo[7].trim());
                }
                if (null != strDevInfo[8] && strDevInfo[8].length() != 0) {
                    routerDevInfoObj.setPassword(DCEncryptServiceUtil.encrypt(strDevInfo[8].toCharArray(), true));
                }
                if (null != strDevInfo[9] && strDevInfo[9].length() != 0) {
                    routerDevInfoObj.setSuper3Pass(DCEncryptServiceUtil.encrypt(strDevInfo[9].toCharArray(), true));
                }
                if (null != strDevInfo[10] && strDevInfo[10].length() != 0) {
                    routerDevInfoObj.setVPNName(strDevInfo[10].trim());
                }
                routerDevInfoObj.setDevType(strDevInfo[2]);
                DCErrorCode oErrorCode = this.checkDevInfo(m_oListDevInfo, routerDevInfoObj);
                int iErrorCode = oErrorCode.getErrorCode();
                if (iErrorCode == 0) {
                    ++currentRow;
                    ++practiceRow;
                    routerDevInfoObj.setDevID(StandAloneCommonOpr.getInstance().generateDevID());
                    m_oListDevInfo.add(routerDevInfoObj);
                    routerDevInfoObj.setIsFinishInitialize(true);
                    continue;
                }
                this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), oErrorCode);
                ++currentRow;
            }
            if (practiceRow == 0) {
                this.oProgressDlg.operatorEnd();
            } else if (m_oListDevInfo.size() > 0) {
                int iReqId = DCFrameWorkUtil.generateRequestId();
                try {
                    this.routerDevInfoPanel.setImportDevices(true);
                    StandAloneSyncCtrller.getInstance().addDevice(iReqId, m_oListDevInfo, 2, true);
                }
                catch (DCException e) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                }
            } else {
                this.oProgressDlg.operatorEnd();
            }
        }
        catch (FileNotFoundException e) {
            this.handError(ResourceManager.getInstance().getResString("NOT_EXIST_FILE"));
            return;
        }
        catch (IOException e) {
            this.handError(e.getMessage());
            return;
        }
        finally {
            if (null != oBufferedReader) {
                try {
                    oBufferedReader.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oFileReader) {
                try {
                    oFileReader.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oFileStream) {
                try {
                    oFileStream.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
        }
    }

    private void handError(String message) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), message);
        this.oProgressDlg.operatorEnd();
        this.oProgressDlg.doCleanUp();
    }

    protected void importExcelFile(String strFilePath, int iNEDomain) {
        block21: {
            File excelFile = null;
            Workbook workbook = null;
            ArrayList<AbstractDevInfoObj> m_oListDevInfo = new ArrayList<AbstractDevInfoObj>();
            try {
                Thread.sleep(500L);
                excelFile = new File(strFilePath);
                workbook = Workbook.getWorkbook((File)excelFile);
                Sheet[] sheet = workbook.getSheets();
                if (sheet.length > 0 && sheet[0].getColumns() >= routeColumn) {
                    Cell[] cell;
                    int i;
                    int rowNum = sheet[0].getRows();
                    int practiceRow = 0;
                    int currentRow = 0;
                    for (i = 1; i < rowNum; ++i) {
                        cell = sheet[0].getRow(i);
                        if (cell.length < routeColumn || !this.checkRowIsNull(cell[1].getContents()) || !this.checkIP(cell[1].getContents())) continue;
                        ++practiceRow;
                    }
                    this.oProgressDlg.setCountSize(practiceRow);
                    for (i = 1; i < rowNum; ++i) {
                        cell = sheet[0].getRow(i);
                        if (cell.length < routeColumn || !this.checkRowIsNull(cell[1].getContents()) || !this.checkIP(cell[1].getContents())) continue;
                        if (!this.checkRowIsNull(cell[2].getContents().trim())) {
                            boolean isEmpCol = true;
                            for (int j = 0; j < cell.length; ++j) {
                                if (j == 2 || !this.checkRowIsNull(cell[j].getContents().trim())) continue;
                                isEmpCol = false;
                            }
                            if (isEmpCol) continue;
                            this.oProgressDlg.addImportOperator(cell[1].getContents(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("IMPORT_COLUMN_NULL")));
                            ++currentRow;
                            continue;
                        }
                        RouterDevInfoObj routerDevInfoObj = new RouterDevInfoObj();
                        routerDevInfoObj.setDevName(cell[0].getContents());
                        routerDevInfoObj.setDevAddress(cell[1].getContents().trim());
                        routerDevInfoObj.setKeyMode(1);
                        String strDevType = cell[2].getContents().trim();
                        DeviceTypeInfo[] devTypes = DeviceInfoManagerImpl.getInstance().getDevTypeInfoByTypeName(strDevType);
                        if (null == devTypes || 0 >= devTypes.length) {
                            this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), new DCErrorCode(3));
                            ++currentRow;
                            continue;
                        }
                        routerDevInfoObj.setDevType(strDevType);
                        routerDevInfoObj.setProxyType(cell[3].getContents().trim());
                        routerDevInfoObj.setProxyNodeType(cell[4].getContents().trim());
                        routerDevInfoObj.setProtocolType(cell[5].getContents().trim());
                        if (!this.checkNumber(cell[6].getContents(), 1, 65535)) {
                            this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("DEVICE_PORT")));
                            ++currentRow;
                            continue;
                        }
                        routerDevInfoObj.setPort(cell[6].getContents().trim());
                        routerDevInfoObj.setUserName(cell[7].getContents().trim());
                        if (cell[8].getContents().length() != 0) {
                            routerDevInfoObj.setPassword(DCEncryptServiceUtil.encrypt(cell[8].getContents().toCharArray(), true));
                        }
                        routerDevInfoObj.setSuper3Pass(DCEncryptServiceUtil.encrypt(cell[9].getContents().toCharArray()));
                        routerDevInfoObj.setVPNName(cell[10].getContents().trim());
                        DCErrorCode oErrorCode = this.checkDevInfo(m_oListDevInfo, routerDevInfoObj);
                        int iErrorCode = oErrorCode.getErrorCode();
                        if (iErrorCode == 0) {
                            routerDevInfoObj.setDevID(StandAloneCommonOpr.getInstance().generateDevID());
                            m_oListDevInfo.add(routerDevInfoObj);
                            routerDevInfoObj.setIsFinishInitialize(true);
                            continue;
                        }
                        this.oProgressDlg.addImportOperator(routerDevInfoObj.getDevAddress(), oErrorCode);
                        ++currentRow;
                    }
                    if (practiceRow == 0) {
                        this.oProgressDlg.operatorEnd();
                    } else if (m_oListDevInfo.size() > 0) {
                        int iReqId = DCFrameWorkUtil.generateRequestId();
                        this.oProgressDlg.setProgressDlgId(iReqId);
                        try {
                            this.routerDevInfoPanel.setImportDevices(true);
                            StandAloneSyncCtrller.getInstance().addDevice(iReqId, m_oListDevInfo, 2, true);
                        }
                        catch (DCException e) {
                            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                        }
                    } else {
                        this.oProgressDlg.operatorEnd();
                    }
                    break block21;
                }
                this.oProgressDlg.setVisible(false);
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString(DCFrameWorkUtil.getLocalizedString("MSG_IMPORT_DEVICE_FILE_INVALID")), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 2);
                return;
            }
            catch (BiffException e) {
                this.handError(ResourceManager.getInstance().getResString("ERROR_MESSAGE_IMPORT_DEVICE_FILE"));
                DCDebugTracer.trace((Exception)((Object)e));
            }
            catch (IOException e) {
                this.handError(ResourceManager.getInstance().getResString("ERROR_MESSAGE_IMPORT_DEVICE_FILE_MEMERY_LACK"));
                DCDebugTracer.trace(e);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
                this.oProgressDlg.operatorEnd();
                this.oProgressDlg.doCleanUp();
            }
            catch (ArithmeticException e) {
                this.oProgressDlg.operatorEnd();
                DCDebugTracer.trace("ImportDeviceDialog#importExcelFile:ArithmeticException");
                DCDebugTracer.trace(e);
            }
            catch (Exception e) {
                this.handError(ResourceManager.getInstance().getResString("ERROR_MESSAGE_IMPORT_DEVICE_FILE_EXCEPTION"));
                DCDebugTracer.trace(e);
            }
        }
    }

    protected void addoRowVector(Vector oRowVector) {
        this.m_oRowVector.add(oRowVector);
    }

    protected boolean checkRowIsNull(String needField) {
        if (needField == null || "".equals(needField.trim())) {
            return false;
        }
        return !"".equals(needField.replace('.', ' ').trim());
    }

    protected boolean checkIP(String strSecIP) {
        boolean isCorrIP = true;
        String strPatttern = "([0-9]+)";
        String strCheck = strSecIP;
        String arrSecIP = "";
        int i = 0;
        int secIP = 0;
        while (strCheck != null && !"".equals(strCheck.trim())) {
            if (strCheck.indexOf(".") >= 0) {
                arrSecIP = strCheck.substring(0, strCheck.indexOf("."));
                strCheck = strCheck.substring(strCheck.indexOf(".") + 1);
            } else {
                arrSecIP = strCheck;
                strCheck = "";
            }
            if (!arrSecIP.trim().matches(strPatttern)) {
                isCorrIP = false;
            }
            if (arrSecIP.length() > 1 && arrSecIP.startsWith("0")) {
                isCorrIP = false;
            }
            if ((secIP = Integer.valueOf(arrSecIP.trim()).intValue()) < 0 || secIP > 255) {
                isCorrIP = false;
            }
            ++i;
        }
        if (i != 4) {
            isCorrIP = false;
        }
        return isCorrIP;
    }

    protected boolean checkNumber(String num, int beginNum, int endNum) {
        if (num == null || "".equals(num.trim())) {
            return false;
        }
        String strPatttern = "([0-9]+)";
        if (!num.trim().matches(strPatttern)) {
            return false;
        }
        try {
            int tempNum = Integer.parseInt(num.trim());
            if (tempNum < beginNum || tempNum > endNum) {
                return false;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace("[ImportDeviceDialog] checkNumber.. num is error...");
            return false;
        }
        return true;
    }

    private DCErrorCode checkDevInfo(List<AbstractDevInfoObj> m_oListDevInfo, RouterDevInfoObj routerDevInfoObj) {
        DCDebugTracer.trace("[ImportDeviceDialog] checkDevInfo start");
        if (routerDevInfoObj.getDevName() != null && routerDevInfoObj.getDevName().length() > 65) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("DEVICE_NAME"));
        }
        if (!this.validateAddress(routerDevInfoObj.getDevAddress(), true)) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("DEVICE_IP"));
        }
        if (this.isNull(routerDevInfoObj.getDevType())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("DEVICE_TYPE"));
        }
        if (this.isNull(routerDevInfoObj.getProxyType())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("ADD_DEVICE_PROXY_TYPE_HEADER"));
        }
        if (this.isNull(routerDevInfoObj.getProxyNodeType())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("ADD_DEVICE_PROXY_NODE_TYPE_HEADER"));
        }
        if (this.isNull(routerDevInfoObj.getProtocolType())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("PROTOCOL_TYPE_HEADER"));
        }
        if (StandAloneDomainInfo.getInstance().getSelectedDomain() != 2) {
            if (routerDevInfoObj.getUserName() != null && routerDevInfoObj.getUserName().length() > 65) {
                return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("DEVICE_USER"));
            }
            if (routerDevInfoObj.getPassword() != null && routerDevInfoObj.getPassword().length > 65) {
                return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("USER_PASSWORD"));
            }
            if (routerDevInfoObj.getSuper3Pass() != null && routerDevInfoObj.getSuper3Pass().length > 65) {
                return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("ADD_DEVICE_SUPER3_PASS_HEADER"));
            }
            if (routerDevInfoObj.getVPNName() != null && routerDevInfoObj.getVPNName().length() > 65) {
                return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("ADD_DEVICE_VPN_NAME_HEADER"));
            }
        }
        for (RouterDevInfoObj routerDevInfoObj2 : m_oListDevInfo) {
            if (!routerDevInfoObj2.getDevAddress().trim().equals(routerDevInfoObj.getDevAddress().trim())) continue;
            return new DCErrorCode(2);
        }
        DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDeviceByIP(routerDevInfoObj.getDevAddress().trim());
        if (null != devInfo) {
            return new DCErrorCode(2);
        }
        DCDebugTracer.trace("[ImportDeviceDialog] checkDevInfo end..");
        return new DCErrorCode(0);
    }

    protected boolean isNull(String str) {
        boolean bNull = false;
        if (str == null || "".equals(str.trim())) {
            bNull = true;
        }
        return bNull;
    }

    protected boolean isNull(char[] str) {
        boolean bNull = false;
        if (str == null || "".equals(String.valueOf(str))) {
            bNull = true;
        }
        return bNull;
    }

    protected boolean validateAddress(String address, boolean isAllowToEmpty) {
        if (isAllowToEmpty && "".equals(address.trim())) {
            return true;
        }
        Pattern pattern = Pattern.compile("([1][0-9]{0,2}|2[0-4][0-9]{0,1}|25[0-5]|[1-9][0-9]{0,1})\\.([1][0-9]{0,2}|2[0-4][0-9]{0,1}|25[0-5]|[0-9]|[1-9][0-9]{0,1})\\.([1][0-9]{0,2}|2[0-4][0-9]{0,1}|25[0-5]|[0-9]|[1-9][0-9]{0,1})\\.([1][0-9]{0,2}|2[0-4][0-9]{0,1}|25[0-5]|[1-9][0-9]{0,1})");
        Matcher matcher = pattern.matcher(address);
        return matcher.matches();
    }

    protected boolean isFileAndSizeValid(String sFilePath) {
        boolean bValid = true;
        if (sFilePath.equals("")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("PROMPT_SELECT_DEVICE_FILE"), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 2);
            return false;
        }
        File file = new File(sFilePath);
        if (file.isDirectory()) {
            return false;
        }
        if (!file.exists()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("MSG_IMPORT_DEVICE_FILE_INVALID"), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 2);
            return false;
        }
        return bValid;
    }

    protected boolean comareString(String first, String second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null && second != null) {
            return first.trim().equals(second.trim());
        }
        return false;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_IMPORT_TEMPLET";
    }

    class ImportDeviceThread
    extends Thread {
        int iNEDomain;

        public ImportDeviceThread(String threadName, int iNEDomain) {
            super(threadName);
            this.iNEDomain = 0;
            this.iNEDomain = iNEDomain;
        }

        @Override
        public void run() {
            DCDebugTracer.trace("[ImportDeviceDialog] importDeviceThread start");
            String filePath = ImportDeviceDialog.this.importFileTextField.getText().trim();
            if (filePath.endsWith(".xls")) {
                ImportDeviceDialog.this.importExcelFile(filePath, this.iNEDomain);
            } else if (filePath.endsWith(".csv") || filePath.endsWith(".txt")) {
                if (StandAloneDomainInfo.getInstance().getSelectedDomain() == 2) {
                    ImportDeviceDialog.this.importCSVorTXTFile(filePath, this.iNEDomain);
                } else {
                    ImportDeviceDialog.this.importCSVorTXTFile(filePath);
                }
            } else {
                DCDebugTracer.trace("don't support the file<" + filePath + "> format");
            }
            DCDebugTracer.trace("[ImportDeviceDialog] importDeviceThread end..");
        }
    }
}

