/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCFileChooser;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImportDevSelectFilePanel
extends JPanel {
    private JLabel m_selectFileLbl;
    public DCFilePathTextField m_filePathTxtField;
    private JButton m_selectFileBtn;
    private static final char IMPORT_BUTTON_MNEMONIC = 'I';
    private ResourceManager m_oResManager = ResourceManager.getInstance();

    public ImportDevSelectFilePanel() {
        this.setLayout(new BoxLayout(this, 2));
        this.jInit();
    }

    private void jInit() {
        this.m_selectFileLbl = new JLabel(this.m_oResManager.getResString("IMPORT_DEVICE_FILE_SELECT_FILE_LABEL"));
        this.m_selectFileLbl.setName("com.huawei.dc.standalone.view.SelectFilePanel.m_selectFileLbl");
        this.m_filePathTxtField = new DCFilePathTextField();
        this.m_filePathTxtField.setName("com.huawei.dc.standalone.view.SelectFilePanel.m_filePathTxtField");
        this.m_selectFileBtn = new JButton("...");
        this.m_selectFileBtn.setName("com.huawei.dc.standalone.view.SelectFilePanel.m_selectFileBtn");
        this.m_selectFileBtn.setMinimumSize(new Dimension(21, 21));
        this.m_selectFileBtn.setPreferredSize(new Dimension(21, 21));
        this.m_selectFileBtn.setMaximumSize(new Dimension(21, 21));
        this.m_selectFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDevSelectFilePanel.this.fileBrowseBtnActionPerformed();
            }
        });
        this.m_filePathTxtField.setPreferredSize(new Dimension(500, 21));
        this.m_filePathTxtField.setMaximumSize(new Dimension(1600, 21));
        this.add(this.m_selectFileLbl);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.m_filePathTxtField);
        this.add(this.m_selectFileBtn);
    }

    public String getSelectFile() {
        return this.m_filePathTxtField.getText();
    }

    private void fileBrowseBtnActionPerformed() {
        DCFileChooser oFileChooserDialog = this.getFileChooserDlg();
        String strFileName = this.getFileName(oFileChooserDialog);
        this.m_filePathTxtField.setText(strFileName);
    }

    private DCFileChooser getFileChooserDlg() {
        PrintSupportor.setIsFileSelection(true);
        DCFileChooser oFileChooserDialog = new DCFileChooser();
        oFileChooserDialog.setTitle(this.m_oResManager.getResString("IMPORT_DEVICE_FILE"));
        oFileChooserDialog.setApproveButtonText(this.m_oResManager.getResString("OK_BTN"));
        oFileChooserDialog.setApproveButtonMnemonic('I');
        oFileChooserDialog.setApproveButtonToolTipText("IMPORT_TOOL_TIP");
        oFileChooserDialog.setFileFilter(8);
        oFileChooserDialog.setFileFilter(2);
        oFileChooserDialog.setFileFilter(1);
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        return oFileChooserDialog;
    }

    private String getFileName(DCFileChooser oFileChooserDialog) {
        int iReturnVal = -1;
        iReturnVal = oFileChooserDialog.showOpenDialog(this);
        String strFileName = "";
        if (iReturnVal == 0) {
            strFileName = oFileChooserDialog.getFullFileName();
        }
        return strFileName;
    }

    public void enableAllComponent(boolean bEnable) {
        this.m_filePathTxtField.setEnabled(false);
        this.m_selectFileBtn.setEnabled(false);
    }
}

