/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.model.AccessDevInfoObj;
import com.huawei.dc.standalone.snmpparams.model.SNMPParaInfoModel;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.startup.DCStandaloneDebugTracer;
import com.huawei.dc.standalone.view.AccessDevInfoPanel;
import com.huawei.dc.standalone.view.ImportDevSelectFilePanel;
import com.huawei.dc.standalone.view.ImportDeviceDialog;
import com.huawei.dc.standalone.view.ImportDeviceFileProgressDlg;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ImportAccessDeviceDialog
extends ImportDeviceDialog {
    private static final long serialVersionUID = -5021215725927224224L;
    private AccessDevInfoPanel accessDevInfoPanel;
    private ImportDeviceFileProgressDlg oProgressDlg;
    private static int accessColumn = 9;
    private static final int CLUSTER_COLUMN = 12;
    private boolean isAddDevice = false;
    private static final String SNMP_V1_VERSION = "SNMPv1";
    private static final String SNMP_V2_VERSION = "SNMPv2";
    private static final String SNMP_V3_VERSION = "SNMPv3";
    private static final int IMPORT_DEV_USER_COL = 12;
    private static final int IMPORT_ENV_NAME_COL = 13;
    private static final int IMPORT_ENGINE_ID_COL = 14;
    private static final int IMPORT_DATA_ENCRYP_TYPE_COL = 15;
    private static final int IMPORT_DATA_ENCRYP_PWD_COL = 16;
    private static final int IMPORT_AUTHENTICATION_TYPE_COL = 17;
    private static final int IMPORT_AUTHENTICATION_PWD_COL = 18;

    public ImportAccessDeviceDialog(AccessDevInfoPanel accessDevInfoPanel, ImportDevSelectFilePanel selectFilePanel) {
        this.accessDevInfoPanel = accessDevInfoPanel;
        this.importFileTextField = selectFilePanel.m_filePathTxtField;
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    @Override
    public void oKButton_ActionPerformed() {
        String importPath = "";
        importPath = this.importFileTextField.getText().trim();
        if ("".equals(this.importFileTextField.getText().trim())) {
            return;
        }
        File file = new File(this.importFileTextField.getText().trim());
        if (file.isDirectory()) {
            return;
        }
        boolean bFileValid = this.isFileAndSizeValid(importPath);
        if (!bFileValid) {
            return;
        }
        this.importDevice();
    }

    @Override
    public void importDevice() {
        this.m_oRowVector = new Vector(2);
        this.oProgressDlg = new ImportDeviceFileProgressDlg(this, false);
        this.oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("IMPORT_DEVICE_FILE"));
        int iNEDomain = 3;
        if (StandAloneDomainInfo.getInstance().getSelectedDomain() == 2) {
            iNEDomain = 2;
        }
        ImportDeviceDialog.ImportDeviceThread oThread = new ImportDeviceDialog.ImportDeviceThread(this, "ImportDeviceThread(access)", iNEDomain);
        oThread.start();
        this.oProgressDlg.showDetailInfo();
        this.oProgressDlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importCSVorTXTFile(String strFilePath) {
        FileInputStream oFileStream = null;
        InputStreamReader oFileReader = null;
        BufferedReader oBufferedReader = null;
        try {
            String encoding = null;
            encoding = FileUtil.isUTF8File(strFilePath) ? FileUtil.getUTF8Encoding() : FileUtil.getSystemEncoding();
            oFileStream = new FileInputStream(strFilePath);
            oFileReader = new InputStreamReader((InputStream)oFileStream, encoding);
            oBufferedReader = new BufferedReader(oFileReader);
            String strLine = oBufferedReader.readLine();
            if (null == strLine) {
                return;
            }
            boolean isRight = this.checkCSVDevInfo(strLine);
            if (!isRight) {
                this.handError(ResourceManager.getInstance().getResString("INVALID_FILE_MSG"));
                return;
            }
            ArrayList<AccessDevInfoObj> m_oListDevInfo = new ArrayList<AccessDevInfoObj>();
            this.accessDevInfoPanel.deleteAllEmptyRow();
            Enumeration nodeEnum = this.accessDevInfoPanel.getAllOptixInfo();
            while (nodeEnum.hasMoreElements()) {
                TreeTableNode tmpNode = (TreeTableNode)nodeEnum.nextElement();
                AccessDevInfoObj accessInfoObj = (AccessDevInfoObj)tmpNode.getUserObject();
                m_oListDevInfo.add(accessInfoObj);
            }
            int hasRows = m_oListDevInfo.size();
            int rowNum = 0;
            Vector<String> lineContentVec = new Vector<String>();
            strLine = oBufferedReader.readLine();
            while (null != strLine) {
                ++rowNum;
                lineContentVec.add(strLine);
                strLine = oBufferedReader.readLine();
            }
            this.fillSnmpParaInfo(m_oListDevInfo, rowNum, lineContentVec);
            this.oProgressDlg.operatorEnd();
            int countRows = m_oListDevInfo.size();
            this.accessDevInfoPanel.selectRow(hasRows, countRows - 1);
            if (hasRows != countRows) {
                this.setAddDevice(true);
            }
        }
        catch (FileNotFoundException e) {
            this.handError(ResourceManager.getInstance().getResString("NOT_EXIST_FILE"));
            return;
        }
        catch (IOException e) {
            this.handError(e.getMessage());
            return;
        }
        finally {
            if (null != oBufferedReader) {
                try {
                    oBufferedReader.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oFileReader) {
                try {
                    oFileReader.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oFileStream) {
                try {
                    oFileStream.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
        }
    }

    private void fillSnmpParaInfo(List<AccessDevInfoObj> m_oListDevInfo, int rowNum, Vector<String> lineContentVec) {
        int counter = 0;
        for (int i = 0; i < lineContentVec.size(); ++i) {
            String[] strDevInfo = lineContentVec.get(i).split(",");
            AccessDevInfoObj accessDevInfoObj = new AccessDevInfoObj();
            int index = 2;
            accessDevInfoObj.setDevName(strDevInfo[index++]);
            accessDevInfoObj.setDevAddress(strDevInfo[index++].trim());
            DeviceTypeInfo oDevType = this.checkIsSupportDevType(strDevInfo[0], strDevInfo[1]);
            if (null == oDevType) {
                this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(3));
                continue;
            }
            SnmpParaInfo snmpParaInfo = new SnmpParaInfo();
            snmpParaInfo.setTemplate(strDevInfo[index++].trim());
            snmpParaInfo.setVersion(strDevInfo[index++].trim());
            if (!SNMP_V3_VERSION.equals(snmpParaInfo.getSnmpVersion())) {
                snmpParaInfo.setGetCommunity(strDevInfo[index++].toCharArray(), true);
                snmpParaInfo.setSetCommunity(strDevInfo[index++].toCharArray(), true);
            } else {
                index += 2;
            }
            snmpParaInfo.setSnmpEnum(this.getSelectedVersion(snmpParaInfo.getVersion()));
            if (!this.checkNumber(strDevInfo[index], 1, 120)) {
                this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_TIMEOUT_INTERVAL")));
                continue;
            }
            snmpParaInfo.setTimeOut(Integer.parseInt(strDevInfo[index++].trim()));
            if (!this.checkNumber(strDevInfo[index], 0, 32)) {
                this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_RETRIES")));
                continue;
            }
            snmpParaInfo.setRetries(Integer.parseInt(strDevInfo[index++].trim()));
            if (!this.checkNumber(strDevInfo[index], 0, Short.MAX_VALUE)) {
                this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_POLL_INTERVALS")));
                continue;
            }
            snmpParaInfo.setPollInterval(Integer.parseInt(strDevInfo[index++].trim()));
            if (!this.checkNumber(strDevInfo[index], 0, 65535)) {
                this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_DEVICE_PORT")));
                continue;
            }
            snmpParaInfo.setDevPort(Integer.parseInt(strDevInfo[index++].trim()));
            if (2 == snmpParaInfo.getSnmpEnum()) {
                snmpParaInfo.setUserName(strDevInfo[12].trim());
                snmpParaInfo.setContextName(strDevInfo[13].trim());
                snmpParaInfo.setContextId(strDevInfo[14].trim());
                int dataEncrypType = Integer.parseInt(strDevInfo[15].trim());
                snmpParaInfo.setDataEncryptionType(dataEncrypType);
                snmpParaInfo.setEncrypPasswd(strDevInfo[16].toCharArray(), true);
                int authenticationType = Integer.parseInt(strDevInfo[17].trim());
                snmpParaInfo.setAuthenticationType(authenticationType);
                snmpParaInfo.setAuthenticationPasswd(strDevInfo[18].toCharArray(), true);
            }
            accessDevInfoObj.setSNMPPara(snmpParaInfo);
            DCErrorCode oErrorCode = this.checkDevInfo(m_oListDevInfo, accessDevInfoObj);
            int iErrorCode = oErrorCode.getErrorCode();
            if (iErrorCode == 0) {
                if (!this.checkSnmpParaInfo(accessDevInfoObj.getSNMPPara())) {
                    this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_PARAMETER_DIALOG_TITLE")));
                    continue;
                }
                this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), oErrorCode);
                m_oListDevInfo.add(accessDevInfoObj);
                this.accessDevInfoPanel.addNewRow(accessDevInfoObj);
            } else {
                this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), oErrorCode);
            }
            counter = (i + 1) * 100 / rowNum;
            this.oProgressDlg.updateProgress(counter);
        }
    }

    private void handError(String message) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), message);
        this.oProgressDlg.operatorEnd();
        this.oProgressDlg.doCleanUp();
    }

    @Override
    protected void importExcelFile(String strFilePath, int iNEDomain) {
        File excelFile = null;
        Workbook workbook = null;
        int counter = 0;
        boolean bCluster = false;
        int iColumnSize = accessColumn;
        if (iNEDomain == 2) {
            iColumnSize = 12;
            bCluster = true;
        }
        try {
            ArrayList<AccessDevInfoObj> m_oListDevInfo = new ArrayList<AccessDevInfoObj>();
            Thread.sleep(500L);
            this.accessDevInfoPanel.deleteAllEmptyRow();
            Enumeration nodeEnum = this.accessDevInfoPanel.getAllOptixInfo();
            while (nodeEnum.hasMoreElements()) {
                TreeTableNode tmpNode = (TreeTableNode)nodeEnum.nextElement();
                AccessDevInfoObj accessInfoObj = (AccessDevInfoObj)tmpNode.getUserObject();
                m_oListDevInfo.add(accessInfoObj);
            }
            int hasRows = m_oListDevInfo.size();
            excelFile = new File(strFilePath);
            workbook = Workbook.getWorkbook((File)excelFile);
            Sheet[] sheet = workbook.getSheets();
            if (sheet.length > 0 && sheet[0].getColumns() == iColumnSize) {
                int rowNum = sheet[0].getRows();
                for (int i = 2; i < rowNum; ++i) {
                    Cell[] cell = sheet[0].getRow(i);
                    if (cell.length < iColumnSize || !this.checkRowIsNull(cell[0].getContents())) continue;
                    AccessDevInfoObj accessDevInfoObj = new AccessDevInfoObj();
                    accessDevInfoObj.setKeyMode(1);
                    accessDevInfoObj.setDevAddress(cell[0].getContents().trim());
                    accessDevInfoObj.setDevName(cell[1].getContents());
                    SnmpParaInfo snmpParaInfo = new SnmpParaInfo();
                    snmpParaInfo.setVersion(cell[2].getContents().trim());
                    snmpParaInfo.setGetCommunity(cell[3].getContents().toCharArray(), true);
                    snmpParaInfo.setSetCommunity(cell[4].getContents().toCharArray(), true);
                    snmpParaInfo.setSnmpEnum(this.getSelectedVersion(snmpParaInfo.getVersion()));
                    if (!this.checkNumber(cell[5].getContents(), 1, 120)) {
                        this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_TIMEOUT_INTERVAL")));
                        continue;
                    }
                    snmpParaInfo.setTimeOut(Integer.parseInt(cell[5].getContents().trim()));
                    if (!this.checkNumber(cell[6].getContents(), 0, 32)) {
                        this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_RETRIES")));
                        continue;
                    }
                    snmpParaInfo.setRetries(Integer.parseInt(cell[6].getContents().trim()));
                    if (!this.checkNumber(cell[7].getContents(), 0, Short.MAX_VALUE)) {
                        this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_POLL_INTERVALS")));
                        continue;
                    }
                    snmpParaInfo.setPollInterval(Integer.parseInt(cell[7].getContents().trim()));
                    if (!this.checkNumber(cell[8].getContents(), 0, 65535)) {
                        this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_DEVICE_PORT")));
                        continue;
                    }
                    snmpParaInfo.setDevPort(Integer.parseInt(cell[8].getContents().trim()));
                    if (bCluster) {
                        snmpParaInfo.setUserName(cell[9].getContents().trim());
                        snmpParaInfo.setEncrypPasswd(cell[10].getContents().toCharArray(), true);
                        snmpParaInfo.setAuthenticationPasswd(cell[11].getContents().toCharArray(), true);
                    }
                    accessDevInfoObj.setSNMPPara(snmpParaInfo);
                    DCErrorCode oErrorCode = this.checkDevInfo(m_oListDevInfo, accessDevInfoObj);
                    int iErrorCode = oErrorCode.getErrorCode();
                    if (iErrorCode == 0) {
                        if (!this.checkSnmpParaInfo(accessDevInfoObj.getSNMPPara())) {
                            this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_PARAMETER_DIALOG_TITLE")));
                            continue;
                        }
                        this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), oErrorCode);
                        m_oListDevInfo.add(accessDevInfoObj);
                        this.accessDevInfoPanel.addNewRow(accessDevInfoObj);
                    } else {
                        this.oProgressDlg.addImportOperator(accessDevInfoObj.getDevAddress(), oErrorCode);
                    }
                    counter = (i + 1) * 100 / rowNum;
                    this.oProgressDlg.updateProgress(counter);
                }
            } else {
                this.oProgressDlg.doCleanUp();
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("MSG_IMPORT_DEVICE_FILE_INVALID"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
                return;
            }
            this.oProgressDlg.operatorEnd();
            int countRows = m_oListDevInfo.size();
            this.accessDevInfoPanel.selectRow(hasRows, countRows - 1);
            if (hasRows != countRows) {
                this.setAddDevice(true);
            }
        }
        catch (BiffException e) {
            this.oProgressDlg.operatorEnd();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_IMPORT_DEVICE_FILE"), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 0);
            DCDebugTracer.trace((Exception)((Object)e));
        }
        catch (IOException e) {
            this.oProgressDlg.operatorEnd();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_IMPORT_DEVICE_FILE_MEMERY_LACK"), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 0);
            DCDebugTracer.trace(e);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void setAddDevice(boolean isAddDevice) {
        this.isAddDevice = isAddDevice;
    }

    public boolean isAddDevice() {
        return this.isAddDevice;
    }

    private boolean checkSnmpParaInfo(SnmpParaInfo snmpParaInfo) {
        List<SnmpParaInfo> snmpParaInfoList = SNMPParaInfoModel.getInstance().getParaInfoList();
        for (SnmpParaInfo devInfo : snmpParaInfoList) {
            if (!this.isNull(devInfo.getVersion())) continue;
            devInfo.setVersion(SNMP_V1_VERSION);
        }
        return true;
    }

    private int getSelectedVersion(String version) {
        if (SNMP_V1_VERSION.equals(version)) {
            return 0;
        }
        if (SNMP_V2_VERSION.equals(version)) {
            return 1;
        }
        if (SNMP_V3_VERSION.equals(version)) {
            return 2;
        }
        return 0;
    }

    private DCErrorCode checkDevInfo(List<AccessDevInfoObj> m_oListDevInfo, AccessDevInfoObj accessDevInfoObj) {
        DCDebugTracer.trace("[ImportAccessDeviceDialog] checkDevInfo start");
        if (!this.validateAddress(accessDevInfoObj.getDevAddress(), false)) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_DEVICE_IP"));
        }
        if (accessDevInfoObj.getDevName() != null && accessDevInfoObj.getDevName().length() > 65) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_DEVICE_NAME"));
        }
        if (this.isNull(accessDevInfoObj.getSNMPPara().getVersion())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_VERSION"));
        }
        if (!SNMP_V3_VERSION.equals(accessDevInfoObj.getSNMPPara().getSnmpVersion())) {
            if (this.isNull(accessDevInfoObj.getSNMPPara().getGetCommunity())) {
                return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_GET_COMMUNITY"));
            }
            if (accessDevInfoObj.getSNMPPara().getGetCommunity().length > 65) {
                return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_GET_COMMUNITY"));
            }
            if (this.isNull(accessDevInfoObj.getSNMPPara().getSetCommunity())) {
                return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_SET_COMMUNITY"));
            }
            if (accessDevInfoObj.getSNMPPara().getSetCommunity().length > 65) {
                return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("SNMP_TABLE_SET_COMMUNITY"));
            }
        }
        for (AccessDevInfoObj devInfo : m_oListDevInfo) {
            if (!devInfo.getDevAddress().trim().equals(accessDevInfoObj.getDevAddress().trim())) continue;
            new DCErrorCode(2);
        }
        DCDebugTracer.trace("[ImportAccessDeviceDialog] checkDevInfo end..");
        return new DCErrorCode(0);
    }
}

