/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCSyncCancelReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.components.deviceselection.table.DCDefaultTableRenderer;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.event.IStandAloneNotificationListener;
import com.huawei.dc.standalone.event.StandAloneEvent;
import com.huawei.dc.standalone.event.StandAloneNotifier;
import com.huawei.dc.standalone.view.SoftwareStatisticsDlg;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.swimap.iview.util.SyncCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import net.commustru.fstru.FStruct;

public class DeviceProgressDlg
extends DCModalDialog
implements IStandAloneNotificationListener {
    private static final long serialVersionUID = 1L;
    private JPanel m_oProgressBarPanel;
    private JPanel m_oOperateResultPanel;
    private JProgressBar m_oAddDeviceProgressBar;
    private JScrollPane m_oOperateResultScrollPane;
    private DefaultTableModel m_oOperateResultTableModel;
    private JTable m_oOperateResultTable;
    private boolean m_bShowDetails;
    private ResourceManager m_oResManager;
    private Container m_oContentPane;
    private int m_iEventType;
    private Object m_oSyncObject;
    private static final char DETAIL_BUTTON_MNEMONIC = 'D';
    private static final char SHOW_REPORT_BUTTON_MNEMONIC = 'R';
    private List m_oDeviceIds = new ArrayList(0);
    private int m_iProgressdDlgId = -1;
    private List m_oReportInfoList = new ArrayList(0);
    private JButton m_bShowReport;
    private boolean m_bAddSuccess = true;
    private String writeResoultPath = null;
    private Vector m_oResoults = new Vector();
    private Vector m_oDeviceList_delSNMPFailed = new Vector();
    private Vector m_oOperatrionResult_delSNMPFailed = new Vector();
    private static final int m_iErrorCode_delSNMP = 999293094;
    private int m_iTotalDev = 0;
    private int m_iStartCnt = 0;

    public DeviceProgressDlg(int iEventType, Object oSyncObject) {
        this.m_oResManager = ResourceManager.getInstance();
        this.m_oContentPane = this.getContentPane();
        this.m_iEventType = iEventType;
        this.m_oSyncObject = oSyncObject;
        this.jbinit();
        StandAloneNotifier.getInstance().addStandAloneNotificationListener(this);
    }

    public void setWriteResoultPath(String writeResoultPath) {
        this.writeResoultPath = writeResoultPath;
    }

    public void setDeviceIdList(DeviceInfo[] arrDeviceinfo) {
        int iSelecDevCount = arrDeviceinfo.length;
        for (int i = 0; i < iSelecDevCount; ++i) {
            this.m_oDeviceIds.add(arrDeviceinfo[i].getDevId());
        }
    }

    private void jbinit() {
        this.initDialog();
        this.initProgressBarPanel();
        this.initOperateResultPanel();
        this.addButtons();
    }

    private void initDialog() {
        this.setSize(450, 105);
        this.m_bShowDetails = false;
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setDefaultCloseOperation(0);
        if (0 == this.m_iEventType) {
            this.setTitle(this.m_oResManager.getResString("STANDALONE_ADD_PROGRESS_DIALOG_TITLE"));
        } else if (2 == this.m_iEventType) {
            this.setTitle(this.m_oResManager.getResString("STANDALONE_MODIFY_PROGRESS_DIALOG_TITLE"));
        } else if (1 == this.m_iEventType) {
            this.setTitle(this.m_oResManager.getResString("STANDALONE_DELETE_PROGRESS_DIALOG_TITLE"));
        } else if (3 == this.m_iEventType) {
            this.setTitle(this.m_oResManager.getResString("STANDALONE_EXPORT_PROGRESS_DIALOG_TITLE"));
        } else if (4 == this.m_iEventType) {
            this.setTitle(this.m_oResManager.getResString("SOFTWARE_STATISTIC_PROGRESS_DIALOG_TITLE"));
        } else if (5 == this.m_iEventType) {
            this.setTitle(this.m_oResManager.getResString("DELETE_SNMP_PROGRESS_DIALOG_TITLE"));
        } else if (6 == this.m_iEventType) {
            this.setTitle(this.m_oResManager.getResString("SET_SNMP_PROGRESS_DIALOG_TITLE"));
        }
        this.m_oContentPane.setLayout(null);
    }

    private void initOperateResultPanel() {
        this.m_oOperateResultPanel = new JPanel();
        this.m_oOperateResultPanel.setName("StandAlone_DeviceProgressDlg_m_oOperateResultPanel");
        this.m_oOperateResultPanel.setBounds(10, 80, 425, 180);
        this.m_oOperateResultPanel.setLayout(new BorderLayout());
        this.initOperationResultTable();
        this.initializeTableCellRenderer();
        this.m_oContentPane.add(this.m_oOperateResultPanel);
    }

    private void initializeTableCellRenderer() {
        int iCol = this.m_oOperateResultTableModel.getColumnCount();
        DCDefaultTableRenderer oRenderer = new DCDefaultTableRenderer(false);
        for (int i = 0; i < iCol; ++i) {
            this.m_oOperateResultTable.getColumnModel().getColumn(i).setCellRenderer(oRenderer);
        }
    }

    private void initOperationResultTable() {
        this.createOperateResultTable();
        this.m_oOperateResultScrollPane = new JScrollPane(this.m_oOperateResultTable);
        this.m_oOperateResultPanel.add((Component)this.m_oOperateResultScrollPane, "Center");
    }

    private void createOperateResultTable() {
        Object[] arrColumnNames = new String[]{this.m_oResManager.getResString("DEVICE_PROGRESS_TABLE_DEVICE_INFO"), this.m_oResManager.getResString("DEVICE_PROGRESS_TABLE_OPERATION_RESULT")};
        this.m_oOperateResultTableModel = new DefaultTableModel(arrColumnNames, 0){
            private static final long serialVersionUID = -6670604764681345340L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_oOperateResultTable = new JTable(this.m_oOperateResultTableModel);
        this.m_oOperateResultTable.setName("StandAlone_DeviceProgressDlg_m_oOperateResultTable");
        this.m_oOperateResultTable.setOpaque(true);
        this.m_oOperateResultTable.setFocusable(true);
        this.m_oOperateResultTable.setRowSelectionAllowed(true);
        this.m_oOperateResultTable.getTableHeader().setReorderingAllowed(false);
        this.m_oOperateResultTable.setSelectionMode(0);
    }

    private void initProgressBarPanel() {
        this.m_oProgressBarPanel = new JPanel();
        this.m_oProgressBarPanel.setName("StandAlone_DeviceProgressDlg_m_oProgressBarPanel");
        this.m_oProgressBarPanel.setLayout(null);
        this.m_oProgressBarPanel.setBounds(0, 0, 450, 40);
        this.initProgressBar();
        this.m_oContentPane.add(this.m_oProgressBarPanel);
    }

    private void initProgressBar() {
        this.m_oAddDeviceProgressBar = new JProgressBar();
        this.m_oAddDeviceProgressBar.setName("StandAlone_DeviceProgressDlg_m_oAddDeviceProgressBar");
        this.m_oAddDeviceProgressBar.setBounds(10, 10, 425, 21);
        this.setProgressBarState(false);
        this.m_oProgressBarPanel.add(this.m_oAddDeviceProgressBar);
    }

    private void addButtons() {
        this.initCancelButton();
        this.initOkButton();
        this.initShowReportButton();
        this.initActionListeners();
        this.okBtnActionPerformed();
    }

    private void initShowReportButton() {
        this.m_bShowReport = new JButton();
        this.m_bShowReport.setName("StandAlone_DeviceProgressDlg_m_bShowReport");
        this.m_bShowReport.setBounds(63, 42, 150, 25);
        this.m_bShowReport.setFocusable(true);
        this.m_bShowReport.setText(this.m_oResManager.getResString("SHOW_SOFTWARE_STATISTIC_REPORT"));
        this.m_bShowReport.setMnemonic('R');
        this.m_bShowReport.setVisible(false);
        this.m_bShowReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceProgressDlg.this.showReport_ActionPerformed();
            }
        });
        this.getContentPane().add(this.m_bShowReport);
    }

    protected void showReport_ActionPerformed() {
        if (null == this.m_oReportInfoList || 0 == this.m_oReportInfoList.size()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.m_oResManager.getResString("SOFTWARE_STATISTIC_BLANK_REPORT_ERROR"), this.m_oResManager.getResString("ERROR"), 0);
            return;
        }
        this.closeDialog();
        final SoftwareStatisticsDlg oSoftwareStatDlg = new SoftwareStatisticsDlg(this.m_oReportInfoList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oSoftwareStatDlg.setVisible(true);
            }
        });
    }

    private void initOkButton() {
        this.m_oOKBtn.setBounds(225, 42, 100, 25);
        this.m_oOKBtn.setName("StandAlone_DeviceProgressDlg_m_oOKBtn");
        this.m_oOKBtn.setFocusable(true);
        this.m_oOKBtn.setText(this.m_oResManager.getResString("OPERATE_DETAIL") + " >>");
        this.m_oOKBtn.setMnemonic('D');
        this.getContentPane().add(this.m_oOKBtn);
    }

    private void initCancelButton() {
        this.m_oCancelBtn.setBounds(335, 42, 100, 25);
        this.m_oCancelBtn.setName("StandAlone_DeviceProgressDlg_m_oCancelBtn");
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("LEGEND_CLOSE_BTN"));
        this.enableCancelBtn(false);
        if (4 == this.m_iEventType) {
            this.enableCancelBtn(true);
            this.m_oCancelBtn.setText(this.m_oResManager.getResString("CANCEL_BUTTON"));
        }
        this.m_oContentPane.add(this.m_oCancelBtn);
    }

    private void initActionListeners() {
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                DeviceProgressDlg.this.okBtnActionPerformed();
            }
        });
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        if (1 == this.m_iEventType) {
            if (0 < this.m_oOperatrionResult_delSNMPFailed.size()) {
                this.setVisible(false);
                String strDlgTitle = this.m_oResManager.getResString("CONFIRM_DIALOG_TITLE");
                String[] strColumnNames = new String[]{this.m_oResManager.getResString("DEVICE_PROGRESS_TABLE_DEVICE_INFO"), this.m_oResManager.getResString("DEVICE_PROGRESS_TABLE_OPERATION_RESULT")};
                String strMessage = this.m_oResManager.getResString("FORCE_DELETE_NES");
                int iTypeSign = 1;
                TaskOperationResultDialog resultDialog = new TaskOperationResultDialog(strDlgTitle, 1, true, strColumnNames, iTypeSign);
                resultDialog.setMessage(strMessage);
                for (int i = 0; i < this.m_oOperatrionResult_delSNMPFailed.size(); ++i) {
                    resultDialog.addRowInModel((Vector)this.m_oOperatrionResult_delSNMPFailed.get(i));
                }
                int willContinue = resultDialog.showResultDialog();
                if (0 == willContinue) {
                    this.m_oOperatrionResult_delSNMPFailed.clear();
                    this.deleteDevices();
                } else {
                    this.m_oOperatrionResult_delSNMPFailed.clear();
                    this.m_oDeviceList_delSNMPFailed.clear();
                    StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
                    super.closeDialog();
                }
            } else {
                this.m_oOperatrionResult_delSNMPFailed.clear();
                this.m_oDeviceList_delSNMPFailed.clear();
                StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
                super.closeDialog();
            }
        } else {
            super.cancelButton_ActionPerformed();
        }
    }

    protected void okBtnActionPerformed() {
        if (!this.m_bShowDetails) {
            this.setSize(450, 300);
            this.m_oOKBtn.setText("<< " + this.m_oResManager.getResString("OPERATE_DETAIL"));
            this.m_bShowDetails = true;
        } else {
            this.setSize(450, 105);
            this.m_oOKBtn.setText(this.m_oResManager.getResString("OPERATE_DETAIL") + " >>");
            this.m_bShowDetails = false;
        }
        this.validate();
        this.repaint();
    }

    @Override
    protected String getCurrentContext() {
        DCDebugTracer.trace("help id is empty in " + DeviceProgressDlg.class.getName());
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }

    public void setProgressBarState(boolean bFlag) {
        this.m_oAddDeviceProgressBar.setIndeterminate(bFlag);
    }

    public void setProgressBarText(String strMessage) {
        this.m_oAddDeviceProgressBar.setValue(this.m_oAddDeviceProgressBar.getMaximum());
        this.m_oAddDeviceProgressBar.setString(strMessage);
        this.m_oAddDeviceProgressBar.setStringPainted(true);
    }

    public void setProgress(int iValue) {
        this.m_oAddDeviceProgressBar.setStringPainted(true);
        this.m_oAddDeviceProgressBar.setValue(iValue);
        this.m_oAddDeviceProgressBar.setString(iValue + "%");
    }

    public DefaultTableModel getTableModel() {
        return this.m_oOperateResultTableModel;
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceProgressDlg.this.m_oOperateResultTable.updateUI();
            }
        });
    }

    public void updateDeviceNotification(String strDeviceInfo, String strErrorMessage, boolean bLastDevice) {
        Vector<String> arrTableRow = new Vector<String>(2);
        arrTableRow.add(strDeviceInfo);
        arrTableRow.add(strErrorMessage);
        this.m_oOperateResultTableModel.addRow(arrTableRow);
        boolean isLastDevice = false;
        isLastDevice = this.m_iTotalDev != 0 ? this.m_oOperateResultTableModel.getDataVector().size() == this.m_iTotalDev : bLastDevice;
        if (isLastDevice) {
            if (this.writeResoultPath != null) {
                DCDebugTracer.trace("writeResoultPath != null");
                this.writeReoultToFile();
                DCDebugTracer.trace("After ====== writeResoultPath != null");
            }
            if (4 == this.m_iEventType) {
                this.m_bShowReport.setVisible(true);
            }
            this.setProgressBarState(false);
            this.enableCancelBtn(true);
            this.setProgressBarText("100%");
            if (1 == this.m_iEventType) {
                DCFrameWorkUtil.getDeviceTreePanel().refreshDeviceTree();
            }
            if (null != this.m_oCancelBtn) {
                this.m_oCancelBtn.requestFocus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReoultToFile() {
        FileOutputStream oFileStream = null;
        OutputStreamWriter oFileWriter = null;
        BufferedWriter oBufferedWriter = null;
        Vector m_oResList = this.getDevinfoFromConf();
        try {
            oFileStream = new FileOutputStream(this.writeResoultPath);
            oFileWriter = new OutputStreamWriter((OutputStream)oFileStream, FileUtil.getSystemEncoding());
            oBufferedWriter = new BufferedWriter(oFileWriter);
            if (m_oResList != null) {
                for (int i = 0; i < m_oResList.size(); ++i) {
                    try {
                        oBufferedWriter.write((String)m_oResList.get(i));
                        continue;
                    }
                    catch (IOException e) {
                        DCDebugTracer.trace(e);
                    }
                }
            }
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
            return;
        }
        finally {
            try {
                if (null != oBufferedWriter) {
                    oBufferedWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oFileWriter) {
                    oFileWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oFileStream) {
                    oFileStream.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    private Vector getDevinfoFromConf() {
        Vector<String> m_oResList = new Vector<String>();
        FileReader m_oFileReader = null;
        BufferedReader m_oBufferedReader = null;
        try {
            m_oFileReader = new FileReader(this.writeResoultPath);
            m_oBufferedReader = new BufferedReader(m_oFileReader);
        }
        catch (FileNotFoundException ex) {
            DCDebugTracer.trace(ex);
            return null;
        }
        String strLineContent = null;
        try {
            strLineContent = m_oBufferedReader.readLine();
            while (null != strLineContent) {
                String strContent = this.insertResoult(strLineContent);
                String strLineSeperator = System.getProperty("line.separator");
                m_oResList.add(strContent);
                m_oResList.add(strLineSeperator);
                strLineContent = m_oBufferedReader.readLine();
            }
        }
        catch (IOException ignore) {
            DCDebugTracer.trace(ignore);
        }
        try {
            m_oBufferedReader.close();
        }
        catch (IOException ignore) {
            DCDebugTracer.trace(ignore);
        }
        try {
            m_oFileReader.close();
        }
        catch (IOException ignore) {
            DCDebugTracer.trace(ignore);
        }
        return m_oResList;
    }

    private String insertResoult(String strLineContent) {
        int j;
        if (null == strLineContent || 0 == strLineContent.length()) {
            return "";
        }
        ArrayList<String> oHeaderList = new ArrayList<String>(0);
        String m_strLineContent = strLineContent.trim();
        int iCounter = 0;
        if (-1 == m_strLineContent.indexOf(",")) {
            oHeaderList.add(m_strLineContent);
        } else {
            while (-1 != m_strLineContent.indexOf(",")) {
                int iIndex = m_strLineContent.indexOf(",");
                if (m_strLineContent.substring(0, iIndex).trim() == null) {
                    oHeaderList.add("");
                } else {
                    oHeaderList.add(m_strLineContent.substring(0, iIndex).trim());
                }
                ++iCounter;
                m_strLineContent = m_strLineContent.substring(iIndex + 1).trim();
            }
            oHeaderList.add(m_strLineContent);
        }
        if (null != this.m_oResoults) {
            for (int i = 0; i < this.m_oResoults.size(); ++i) {
                try {
                    String ip = (String)oHeaderList.get(0);
                    Resource oResource = (Resource)this.m_oResoults.get(i);
                    if (null == oResource || !ip.equals(oResource.getDeviceIP())) continue;
                    int fillCommaNum = 5 - oHeaderList.size();
                    if (0 < fillCommaNum) {
                        for (int j2 = 0; j2 < fillCommaNum; ++j2) {
                            oHeaderList.add("");
                        }
                    }
                    oHeaderList.set(4, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oResource.getAddRseoult())));
                    break;
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        m_strLineContent = "";
        StringBuffer tmpLineContent = new StringBuffer("");
        for (j = 0; j < oHeaderList.size() - 1; ++j) {
            tmpLineContent.append(oHeaderList.get(j));
            tmpLineContent.append(",");
        }
        tmpLineContent.append(oHeaderList.get(j));
        m_strLineContent = tmpLineContent.toString();
        return m_strLineContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStandAloneNotification(StandAloneEvent oEvent) {
        DCDebugTracer.trace("Entered in onStandAloneNotification");
        Object object = this.m_oSyncObject;
        synchronized (object) {
            Resource oRes;
            if (null == oEvent || this.m_iEventType != oEvent.getEventType()) {
                DCDebugTracer.trace("(null == oEvent) || (m_iEventType != oEvent.getEventType())");
                return;
            }
            DCDebugTracer.trace("Event Type : " + oEvent.getEventType());
            if (4 == oEvent.getEventType()) {
                List oReportInfo = oEvent.getStatisticsReportInfoList();
                int iReportSize = oReportInfo.size();
                for (int index = 0; index < iReportSize; ++index) {
                    this.m_oReportInfoList.add(oReportInfo.get(index));
                }
            }
            if (null == (oRes = oEvent.getResource())) {
                return;
            }
            oRes.setAddResoult(oEvent.getErrorCode());
            this.m_oResoults.add(oRes);
            if (this.isAddSuccess()) {
                if (0 == oEvent.getErrorCode()) {
                    this.setAddSuccess(true);
                } else {
                    this.setAddSuccess(false);
                }
            }
            String strDeviceInfo = "";
            if (null != oRes.getDeviceName() && null != oRes.getDeviceIP()) {
                strDeviceInfo = 0 == oRes.getDeviceName().length() && 0 == oRes.getDeviceIP().length() ? "" : (0 == oRes.getDeviceIP().length() ? oRes.getDeviceName() : oRes.getDeviceName() + '(' + oRes.getDeviceIP() + ')');
            }
            String strErrorMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oEvent.getErrorCode()));
            if (999293094 == oEvent.getErrorCode()) {
                Vector<String> arrTableRow = new Vector<String>(2);
                arrTableRow.add(strDeviceInfo);
                arrTableRow.add(strErrorMsg);
                this.m_oOperatrionResult_delSNMPFailed.add(arrTableRow);
                this.m_oDeviceList_delSNMPFailed.add(oRes);
            }
            if (null == strErrorMsg) {
                DCDebugTracer.trace("DeviceProgressDlg::onStandAloneNotification ---> null == strErrorMsg");
                if (oEvent.isFinal()) {
                    this.setProgressBarState(false);
                    this.enableCancelBtn(true);
                    this.setProgressBarText("100%");
                }
                return;
            }
            if (1 == oEvent.getEventType() && this.m_iStartCnt < this.m_iTotalDev) {
                this.setProgressBarText(String.valueOf(this.m_iStartCnt++) + "/" + String.valueOf(this.m_iTotalDev));
            }
            this.updateDeviceNotification(strDeviceInfo, strErrorMsg, oEvent.isFinal());
        }
        DCDebugTracer.trace("Exited from onStandAloneNotification");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void closeDialog() {
        block23: {
            block22: {
                if (4 == this.m_iEventType) break block22;
                if (!this.m_oAddDeviceProgressBar.isIndeterminate()) ** GOTO lbl51
                if (0 == this.m_iEventType) {
                    iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("STOP_IMPROT_DEVICE"), this.m_oResManager.getResString("CONFIRMATION_DIALOG_TITLE"), 0);
                    if (0 != iConfirm) {
                        return;
                    }
                    try {
                        m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
                        result = m_oStandAloneSyncCtrller.stopImportDevices();
                        if (result != 0) ** GOTO lbl64
                        this.m_oCancelBtn.setEnabled(true);
                    }
                    catch (DCException e) {
                        DCOptionPane.showMessageDialog((Component)this, e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
                        return;
                    }
                } else if (5 == this.m_iEventType) {
                    iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("STOP_DELETE_SNMP"), this.m_oResManager.getResString("CONFIRMATION_DIALOG_TITLE"), 0);
                    if (0 != iConfirm) {
                        return;
                    }
                    try {
                        m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
                        result = m_oStandAloneSyncCtrller.stopOperationForSNMP(44042);
                        if (result != 0) ** GOTO lbl64
                        this.m_oCancelBtn.setEnabled(true);
                    }
                    catch (DCException e) {
                        DCOptionPane.showMessageDialog((Component)this, e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
                        return;
                    }
                } else if (6 == this.m_iEventType) {
                    iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("STOP_SET_SNMP"), this.m_oResManager.getResString("CONFIRMATION_DIALOG_TITLE"), 0);
                    if (0 != iConfirm) {
                        return;
                    }
                    try {
                        oAsnDCCancelReq = new AsnDCSyncCancelReq();
                        oAsnDCCancelReq.oReqID = BigInteger.valueOf(this.m_iProgressdDlgId);
                        m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
                        result = m_oStandAloneSyncCtrller.stopOperationForSNMP(44043);
                        if (result != 0) ** GOTO lbl64
                        this.m_oCancelBtn.setEnabled(true);
                    }
                    catch (DCException e) {
                        DCOptionPane.showMessageDialog((Component)this, e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
                        return;
                    }
                } else if (1 == this.m_iEventType) {
                    DCOptionPane.showMessageDialog((Component)this, this.m_oResManager.getResString("DEVICE_OPERATION_IN_PROGRESS"), this.m_oResManager.getResString("INFO"), 1);
                    if (this.m_oAddDeviceProgressBar.isIndeterminate()) {
                        return;
                    }
                } else {
                    DCOptionPane.showMessageDialog((Component)this, this.m_oResManager.getResString("DEVICE_OPERATION_IN_PROGRESS"), this.m_oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
                    return;
lbl51:
                    // 1 sources

                    if (1 == this.m_iEventType) {
                        this.cancelButton_ActionPerformed();
                        return;
                    }
                }
                break block23;
            }
            if (this.m_oAddDeviceProgressBar.isIndeterminate()) {
                oAsnDCCancelReq = new AsnDCSyncCancelReq();
                oAsnDCCancelReq.oReqID = BigInteger.valueOf(this.m_iProgressdDlgId);
                try {
                    this.sendCancelRequest(oAsnDCCancelReq);
                }
                catch (DCException e) {
                    return;
                }
            }
        }
        StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
        this.m_oSyncObject = null;
        super.closeDialog();
    }

    public void setProgressDlgId(int iProgressDlgId) {
        this.m_iProgressdDlgId = iProgressDlgId;
    }

    public int getProgressDlgId() {
        return this.m_iProgressdDlgId;
    }

    private void sendCancelRequest(final AsnDCSyncCancelReq oAsnDCCancelReq) throws DCException {
        int iErrorCode;
        final BaseCommManager oCommManager = DCFrameWorkUtil.getCommManager();
        final AsnDCSyncRsp oAsnDCOpertionRsp = new AsnDCSyncRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int iErrorCode = oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43852), (FStruct)oAsnDCCancelReq, (FStruct)oAsnDCOpertionRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult() && 0 != (iErrorCode = ((Integer)syncCommand.getResult()).intValue())) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        if (0 != oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue()) {
            throw new DCException(oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("CANCEL_REQUEST_FAILED"));
        }
    }

    public boolean isAddSuccess() {
        return this.m_bAddSuccess;
    }

    public void setAddSuccess(boolean bAddSuccess) {
        this.m_bAddSuccess = bAddSuccess;
    }

    private void enableCancelBtn(boolean bEnable) {
        if (null == this.m_oCancelBtn) {
            return;
        }
        this.m_oCancelBtn.setEnabled(bEnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDevices() {
        Object object = this.m_oSyncObject;
        synchronized (object) {
            IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
            try {
                int iReqId = DCFrameWorkUtil.generateRequestId();
                oStandAloneSyncCtrller.deleteDevices(iReqId, this.m_oDeviceList_delSNMPFailed, false);
            }
            catch (DCException ex) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(ex.getErrorCode()), this.m_oResManager.getResString("ERROR"), 0);
                return;
            }
            this.setProgressBarText("");
            this.enableCancelBtn(false);
            this.setProgressBarState(true);
            int rowCount = this.m_oOperateResultTableModel.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.m_oOperateResultTableModel.removeRow(0);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public synchronized void run() {
                DeviceProgressDlg.this.setVisible(true);
            }
        });
    }

    public int getTotalDev() {
        return this.m_iTotalDev;
    }

    public void setTotalDev(int iTotalDev) {
        this.m_iTotalDev = iTotalDev;
    }
}

