/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class DCIPAddressEditor
extends AbstractCellEditor
implements TableCellEditor {
    private IPAddressTextField m_ipTextField;
    private JTextField m_OSIAddressTextField;
    private boolean m_isOSIGateway = false;
    private final String m_strOSIGateway = ResourceManager.getInstance().getResString("OS_GATEWAY_TYPE");

    public DCIPAddressEditor() {
        this.m_ipTextField = new IPAddressTextField();
        this.m_OSIAddressTextField = new JTextField();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_isOSIGateway = false;
        if (1 <= column && this.m_strOSIGateway.equals(table.getValueAt(row, column - 1))) {
            if (null != value) {
                this.m_OSIAddressTextField.setText(value.toString());
            }
            this.m_isOSIGateway = true;
            return this.m_OSIAddressTextField;
        }
        if (null != value) {
            if ("".equals(value.toString())) {
                this.m_ipTextField.setText("256.256.256.256");
            } else {
                this.m_ipTextField.setText(value.toString());
            }
        }
        return this.m_ipTextField;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        String str = "";
        try {
            str = this.m_isOSIGateway ? this.m_OSIAddressTextField.getText() : this.m_ipTextField.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        return str;
    }
}

