/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.adapter.swimap.imap12.util.DCInmLengthLimitTextField;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.u2kcbb.U2kPasswordFiled;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneCommUtil;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.search.view.SearchGatewayDeviceDialog;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.view.IAddDevicePanel;
import com.huawei.dc.standalone.view.IAddGatewayAddr;
import com.huawei.dc.standalone.view.PopulateAddGatewayDevIntfDropDown;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class AddGatewayDevicesPanel
extends JPanel
implements IAddDevicePanel,
IAddGatewayAddr {
    private static final long serialVersionUID = -2359714804643778308L;
    private ResourceManager m_oResMgr;
    private JLabel m_oNEIDLabel;
    private JLabel m_oNEExtIDLabel;
    private JLabel m_oNENameLabel;
    private JLabel m_oNENameLabel_Asteriskl;
    private JLabel m_oNETIDLabel;
    private JLabel m_oProtocolTypeLabel;
    private JLabel m_oProtocolTypeLabe_Asteriskl;
    private JLabel m_oGateWayTypeLabel;
    private JLabel m_oGateWayTypeLabel_Asteriskl;
    private JLabel m_oGateWayAddrLabel;
    private JLabel m_oGateWayAddrLabel_Asteriskl;
    private JLabel m_oPortLabel;
    private JLabel m_oPortLabe_Asteriskl;
    private JLabel m_oUserNameLabel;
    private JLabel m_oUserNameLabel_Asteriskl;
    private JTextField m_oNEIDTextField;
    private JTextField m_oNEIDTextField1;
    private JTextField m_oNEExtIDTextField;
    private JTextField m_oNEExtIDTextField1;
    private JLabel m_oPasswdLabel;
    private JLabel m_oPasswdLabel_Asteriskl;
    private JButton m_oSearchButton;
    private JTextField m_oNETIDTextField;
    private JTextField m_oNETIDTextField1;
    private IDCStandAloneSyncCtrller m_oStandAloneSyncCtrller;
    private DCInmLengthLimitTextField m_oNENameField;
    private DCInmLengthLimitTextField m_oNENameField1;
    private ComboBoxWithToolTip m_oProtocolTypeDropDown;
    private ComboBoxWithToolTip m_oProtocolTypeDropDown1;
    private ComboBoxWithToolTip m_oGateWayTypeDropDown;
    private ComboBoxWithToolTip m_oGateWayTypeDropDown1;
    private ComboBoxWithToolTip m_oGateWayTypeDropDown2;
    private DefaultComboBoxModel m_oProtocolTypeModel;
    private DefaultComboBoxModel m_oGateWayTypeModel;
    private ComboBoxWithToolTip m_oGateWayIPAddressDropDown;
    private ComboBoxWithToolTip m_oGateWayIPAddressDropDown1;
    private ComboBoxWithToolTip m_oGateWayAddressDropDown;
    private ComboBoxWithToolTip m_oGateWayAddressDropDown1;
    private IPAddressTextField m_oIPEditorField;
    private Spinner m_oPortField;
    private Spinner m_oPortField1;
    private NumericSpinnerModel m_oPortModel;
    private DCInmLengthLimitTextField m_oUserNameField;
    private U2kPasswordFiled m_oPasswdField;
    private static final int USER_NAME_LENGTH = 64;
    private static final int START_INDEX = 0;
    private String m_strNEName = null;
    private int iNEID;
    private int iDevnum;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.iNEID;
        result = 31 * result + (this.m_strNEName == null ? 0 : this.m_strNEName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddGatewayDevicesPanel other = (AddGatewayDevicesPanel)obj;
        if (this.iNEID != other.iNEID) {
            return false;
        }
        return !(this.m_strNEName == null ? other.m_strNEName != null : !this.m_strNEName.equals(other.m_strNEName));
    }

    @Override
    public String toString() {
        return "AddGatewayDevicesPanel [m_strNEName=" + this.m_strNEName + ", m_iNEID=" + this.iNEID + "]";
    }

    public AddGatewayDevicesPanel() {
        this.setLayout(null);
        this.initMgrs();
        this.initComponents();
    }

    public void devNumisOne(int iSize) {
        this.iDevnum = iSize;
    }

    private void reinitFields() {
        this.m_oNETIDTextField1 = new JTextField();
        this.m_oNENameField1 = new DCInmLengthLimitTextField(64);
        String[] arrProtocolType = new String[]{""};
        this.m_oProtocolTypeModel = new DefaultComboBoxModel<String>(arrProtocolType);
        this.m_oProtocolTypeDropDown1 = new ComboBoxWithToolTip((ComboBoxModel)this.m_oProtocolTypeModel);
        String[] arrGateWayType = new String[]{""};
        this.m_oGateWayTypeModel = new DefaultComboBoxModel<String>(arrGateWayType);
        this.m_oGateWayTypeDropDown1 = new ComboBoxWithToolTip((ComboBoxModel)this.m_oGateWayTypeModel);
        this.m_oGateWayTypeDropDown2 = new ComboBoxWithToolTip((ComboBoxModel)this.m_oGateWayTypeModel);
        this.m_oGateWayIPAddressDropDown1 = new ComboBoxWithToolTip();
        this.m_oNEIDTextField1 = new JTextField("");
        this.m_oNEExtIDTextField1 = new JTextField("");
        this.m_oPortModel = new NumericSpinnerModel(1400, 1, 65535, 1);
        this.m_oPortField1 = new Spinner((SpinnerModel)this.m_oPortModel);
        this.m_oGateWayAddressDropDown1 = new ComboBoxWithToolTip();
    }

    private void realignFields() {
        this.m_oProtocolTypeDropDown1.setBounds(128, 5, 183, 20);
        this.m_oNETIDTextField1.setBounds(128, 37, 183, 20);
        this.m_oNEExtIDTextField1.setBounds(128, 69, 183, 20);
        this.m_oNENameField1.setBounds(128, 101, 183, 20);
        this.m_oGateWayTypeDropDown1.setBounds(128, 133, 183, 20);
        this.m_oGateWayIPAddressDropDown1.setBounds(128, 165, 183, 20);
        this.m_oGateWayTypeDropDown2.setBounds(128, 197, 183, 20);
    }

    private void readdFields() {
        this.add(this.m_oNEIDTextField1);
        this.add(this.m_oNEExtIDTextField1);
        this.add(this.m_oNETIDTextField1);
        this.add((Component)this.m_oNENameField1);
        this.add(this.m_oProtocolTypeDropDown1);
        this.add(this.m_oGateWayTypeDropDown1);
        this.add(this.m_oGateWayTypeDropDown2);
        this.add(this.m_oGateWayIPAddressDropDown1);
        this.add(this.m_oGateWayAddressDropDown1);
        this.add((Component)this.m_oPortField1);
        this.remove(this.m_oNENameLabel_Asteriskl);
    }

    public void resetComponentsEnabled(boolean bFlag) {
        this.m_oNEIDTextField1.setEnabled(bFlag);
        this.m_oNEExtIDTextField1.setEditable(bFlag);
        this.m_oNENameField1.setEnabled(bFlag);
        this.m_oProtocolTypeDropDown1.setEnabled(bFlag);
        this.m_oGateWayTypeDropDown1.setEnabled(bFlag);
        this.m_oGateWayTypeDropDown2.setEnabled(bFlag);
        this.m_oGateWayIPAddressDropDown1.setEnabled(bFlag);
        this.m_oPortField1.setEnabled(bFlag);
        this.m_oNETIDTextField1.setEnabled(bFlag);
    }

    private void resetoldComponentsVisible(boolean bFlag) {
        this.m_oNENameLabel_Asteriskl.setVisible(bFlag);
        this.m_oNENameField.setVisible(bFlag);
        this.m_oNEIDTextField.setVisible(bFlag);
        this.m_oNEExtIDTextField.setVisible(bFlag);
        this.m_oNETIDTextField.setVisible(bFlag);
        this.m_oProtocolTypeDropDown.setVisible(bFlag);
        this.m_oGateWayTypeDropDown.setVisible(bFlag);
        this.m_oPortField.setVisible(bFlag);
        this.m_oGateWayIPAddressDropDown.setVisible(bFlag);
    }

    private void reinitComponents() {
        if (this.iDevnum > 1) {
            this.reinitFields();
            this.realignFields();
            this.readdFields();
            this.resetComponentsEnabled(false);
            this.resetoldComponentsVisible(false);
        }
    }

    private void initMgrs() {
        this.m_oResMgr = ResourceManager.getInstance();
        this.m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
    }

    private void initComponents() {
        this.initLabels();
        this.alignLabels();
        this.addLabels();
        this.initSearchBtn();
        this.initFields();
        this.alignFields();
        this.addFields();
        this.populateProtocolTypeDropDown();
        this.populateGatewayTypeDropDown();
        this.populateGatewayIPDropDown();
        this.initActionListener();
    }

    private void initFields() {
        this.m_oNEIDTextField = new JTextField(){
            private static final long serialVersionUID = 6740014507733776090L;

            @Override
            protected Document createDefaultModel() {
                return new NumberOnlyDocument();
            }

            class NumberOnlyDocument
            extends PlainDocument {
                private static final long serialVersionUID = 2028073778722416163L;

                NumberOnlyDocument() {
                }

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    if (str == null) {
                        return;
                    }
                    char[] chars = str.toCharArray();
                    for (int i = 0; i < chars.length; ++i) {
                        if (chars[i] >= '0' && chars[i] <= '9') continue;
                        return;
                    }
                    super.insertString(offs, new String(chars), a);
                }
            }
        };
        this.m_oNEIDTextField.setName("StandAlone_AddGatewayDevicesPanel_m_oNEIDTextField");
        this.m_oNEExtIDTextField = new JTextField(){
            private static final long serialVersionUID = -5147406190590773669L;

            @Override
            protected Document createDefaultModel() {
                return new NumberOnlyDocument();
            }

            class NumberOnlyDocument
            extends PlainDocument {
                private static final long serialVersionUID = -3661586812186562893L;

                NumberOnlyDocument() {
                }

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    if (str == null) {
                        return;
                    }
                    char[] chars = str.toCharArray();
                    for (int i = 0; i < chars.length; ++i) {
                        if (chars[i] >= '0' && chars[i] <= '9') continue;
                        return;
                    }
                    super.insertString(offs, new String(chars), a);
                }
            }
        };
        this.m_oNETIDTextField = new JTextField();
        this.m_oNETIDTextField.setName("StandAlone_AddGatewayDevicesPanel_m_oNETIDTextField");
        this.m_oNENameField = new DCInmLengthLimitTextField(64);
        this.m_oNENameField.setName("StandAlone_AddGatewayDevicesPanel_m_oNENameField");
        String[] arrProtocolType = new String[]{"MML", "TL1"};
        this.m_oProtocolTypeModel = new DefaultComboBoxModel<String>(arrProtocolType);
        this.m_oProtocolTypeDropDown = new ComboBoxWithToolTip((ComboBoxModel)this.m_oProtocolTypeModel);
        String[] arrGateWayType = new String[]{"IP Gateway", "OSI Gateway"};
        this.m_oGateWayTypeModel = new DefaultComboBoxModel<String>(arrGateWayType);
        this.m_oGateWayTypeDropDown = new ComboBoxWithToolTip((ComboBoxModel)this.m_oGateWayTypeModel);
        this.m_oGateWayTypeDropDown.setName("StandAlone_AddGatewayDevicesPanel_m_oGateWayTypeDropDown");
        this.m_oGateWayIPAddressDropDown = new ComboBoxWithToolTip();
        this.m_oGateWayIPAddressDropDown.setName("StandAlone_AddGatewayDevicesPanel_m_oGateWayIPAddressDropDown");
        this.m_oGateWayIPAddressDropDown.setEditable(true);
        this.m_oIPEditorField = new IPAddressTextField();
        this.m_oIPEditorField.setName("StandAlone_AddGatewayDevicesPanel_m_oIPEditorField");
        this.m_oGateWayIPAddressDropDown.setEditor(new ComboBoxEditor(){

            @Override
            public void addActionListener(ActionListener arg0) {
            }

            @Override
            public Component getEditorComponent() {
                return AddGatewayDevicesPanel.this.m_oIPEditorField;
            }

            @Override
            public Object getItem() {
                return null;
            }

            @Override
            public void removeActionListener(ActionListener arg0) {
            }

            @Override
            public void selectAll() {
            }

            @Override
            public void setItem(Object arg0) {
            }
        });
        this.m_oGateWayIPAddressDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddGatewayDevicesPanel.this.ipGatewayDropDownActionPerformed();
            }
        });
        this.updateGatewayIPDropDown(StandAloneCommUtil.getGateIPAddLst());
        this.m_oGateWayAddressDropDown = new ComboBoxWithToolTip();
        this.m_oGateWayAddressDropDown.setName("StandAlone_AddGatewayDevicesPanel_m_oGateWayAddressDropDown");
        this.m_oGateWayAddressDropDown.setEditable(true);
        this.m_oPortModel = new NumericSpinnerModel(1400, 1, 65535, 1);
        this.m_oPortField = new Spinner((SpinnerModel)this.m_oPortModel);
        this.m_oPortField.setName("StandAlone_AddGatewayDevicesPanel_m_oPortField");
        this.m_oUserNameField = new DCInmLengthLimitTextField(64);
        this.m_oUserNameField.setName("StandAlone_AddGatewayDevicesPanel_m_oUserNameField");
        this.m_oPasswdField = new U2kPasswordFiled(40);
        this.m_oPasswdField.setName("StandAlone_AddGatewayDevicesPanel_m_oPasswdField");
    }

    public DCInmLengthLimitTextField getFileNameTextField() {
        return this.m_oNENameField;
    }

    protected void ipGatewayDropDownActionPerformed() {
        String strSelectedItem = (String)this.m_oGateWayIPAddressDropDown.getItemAt(this.m_oGateWayIPAddressDropDown.getSelectedIndex());
        if (null != strSelectedItem) {
            this.m_oIPEditorField.setText(strSelectedItem);
        }
    }

    public boolean checkDevNameExist(List oResourceLst) {
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        DeviceInfo[] arrDevInfo = oDeviceInfoMgr.getDevices();
        if (null == arrDevInfo || 0 == arrDevInfo.length) {
            return true;
        }
        int iResListSize = oResourceLst.size();
        int iDevListSize = arrDevInfo.length;
        T2000DevInfo oResource = null;
        DeviceInfo oDeviceInfo = null;
        for (int iRes = 0; iRes < iResListSize; ++iRes) {
            oResource = (T2000DevInfo)oResourceLst.get(iRes);
            for (int iDev = 0; iDev < iDevListSize; ++iDev) {
                oDeviceInfo = arrDevInfo[iDev];
                if (!Collator.getInstance().equals(oResource.getDeviceName(), oDeviceInfo.getDevName())) continue;
                this.showErrorMessage(ResourceManager.getInstance().getResString("DEVICE_NAME_EXIST"));
                this.m_oNENameField.setText("");
                this.m_oNENameField.grabFocus();
                return false;
            }
        }
        return true;
    }

    private void alignFields() {
        this.m_oProtocolTypeDropDown.setBounds(128, 5, 183, 20);
        this.m_oNEIDTextField.setBounds(128, 37, 183, 20);
        this.m_oNETIDTextField.setBounds(128, 37, 183, 20);
        this.m_oNEExtIDTextField.setBounds(128, 69, 183, 20);
        this.m_oNENameField.setBounds(128, 101, 183, 20);
        this.m_oGateWayTypeDropDown.setBounds(128, 133, 183, 20);
        this.m_oGateWayIPAddressDropDown.setBounds(128, 165, 183, 20);
        this.m_oSearchButton.setBounds(279, 165, 30, 20);
        this.m_oGateWayAddressDropDown.setBounds(128, 165, 183, 20);
        this.m_oPortField.setBounds(128, 197, 183, 20);
        this.m_oUserNameField.setBounds(128, 229, 183, 20);
        this.m_oPasswdField.setBounds(128, 261, 183, 20);
        this.m_oProtocolTypeLabe_Asteriskl.setBounds(315, 5, 11, 20);
        this.m_oNENameLabel_Asteriskl.setBounds(315, 101, 11, 20);
        this.m_oPasswdLabel_Asteriskl.setBounds(315, 261, 11, 20);
        this.m_oUserNameLabel_Asteriskl.setBounds(315, 229, 11, 20);
        this.m_oPortLabe_Asteriskl.setBounds(315, 197, 11, 20);
        this.m_oGateWayTypeLabel_Asteriskl.setBounds(315, 133, 11, 20);
        this.m_oGateWayAddrLabel_Asteriskl.setBounds(315, 165, 11, 20);
    }

    private void addFields() {
        this.add(this.m_oNEIDTextField);
        this.add(this.m_oNEExtIDTextField);
        this.add(this.m_oNETIDTextField);
        this.add((Component)this.m_oNENameField);
        this.add(this.m_oProtocolTypeDropDown);
        this.add(this.m_oGateWayTypeDropDown);
        this.add(this.m_oGateWayIPAddressDropDown);
        this.add((Component)this.m_oPortField);
        this.add((Component)this.m_oUserNameField);
        this.add(this.m_oPasswdField);
    }

    private void alignFieldsForMML() {
        this.m_oNEExtIDTextField.setBounds(128, 37, 183, 20);
        this.m_oNEIDTextField.setBounds(128, 69, 183, 20);
        this.m_oNENameField.setBounds(128, 101, 183, 20);
        this.m_oGateWayTypeDropDown.setBounds(128, 133, 183, 20);
        this.m_oGateWayIPAddressDropDown.setBounds(128, 165, 183, 20);
        this.m_oSearchButton.setBounds(279, 165, 30, 20);
        this.m_oGateWayAddressDropDown.setBounds(128, 165, 183, 20);
        this.m_oPortField.setBounds(128, 197, 183, 20);
        this.m_oUserNameField.setBounds(128, 229, 183, 20);
        this.m_oPasswdField.setBounds(128, 261, 183, 20);
        this.m_oGateWayTypeLabel_Asteriskl.setBounds(315, 133, 11, 20);
        this.m_oGateWayAddrLabel_Asteriskl.setBounds(315, 165, 11, 20);
        this.m_oPortLabe_Asteriskl.setBounds(315, 197, 11, 20);
        this.m_oPasswdLabel_Asteriskl.setBounds(315, 261, 11, 20);
        this.m_oUserNameLabel_Asteriskl.setBounds(315, 229, 11, 20);
        this.add(this.m_oNEIDTextField);
        this.add((Component)this.m_oNENameField);
        this.add(this.m_oNEExtIDTextField);
        this.remove(this.m_oNETIDTextField);
    }

    private void alignFieldsForTL1() {
        this.m_oNETIDTextField.setBounds(128, 37, 183, 20);
        this.m_oGateWayTypeDropDown.setBounds(128, 69, 183, 20);
        this.m_oGateWayIPAddressDropDown.setBounds(128, 101, 183, 20);
        this.m_oSearchButton.setBounds(279, 101, 30, 20);
        this.m_oGateWayAddressDropDown.setBounds(128, 101, 183, 20);
        this.m_oPortField.setBounds(128, 133, 183, 20);
        this.m_oUserNameField.setBounds(128, 165, 183, 20);
        this.m_oPasswdField.setBounds(128, 197, 183, 20);
        this.m_oGateWayTypeLabel_Asteriskl.setBounds(315, 69, 11, 20);
        this.m_oGateWayAddrLabel_Asteriskl.setBounds(315, 101, 11, 20);
        this.m_oPortLabe_Asteriskl.setBounds(315, 133, 11, 20);
        this.m_oPasswdLabel_Asteriskl.setBounds(315, 165, 11, 20);
        this.m_oUserNameLabel_Asteriskl.setBounds(315, 197, 11, 20);
        this.remove(this.m_oNEExtIDTextField);
        this.remove(this.m_oNEIDTextField);
        this.remove((Component)this.m_oNENameField);
        this.add(this.m_oNETIDTextField);
    }

    public void alignLabelsForMML() {
        this.m_oNEExtIDLabel.setBounds(11, 37, 105, 20);
        this.m_oNEIDLabel.setBounds(11, 69, 105, 20);
        this.m_oNENameLabel.setBounds(11, 101, 105, 20);
        this.m_oGateWayTypeLabel.setBounds(11, 133, 105, 20);
        this.m_oGateWayAddrLabel.setBounds(11, 165, 105, 20);
        this.m_oPortLabel.setBounds(11, 197, 105, 20);
        this.m_oUserNameLabel.setBounds(11, 229, 105, 20);
        this.m_oPasswdLabel.setBounds(11, 261, 105, 20);
        this.add(this.m_oNEIDLabel);
        this.add(this.m_oNEExtIDLabel);
        this.add(this.m_oNENameLabel);
        this.remove(this.m_oNETIDLabel);
    }

    public void alignLabelsForTL1() {
        this.m_oNETIDLabel.setBounds(11, 37, 105, 20);
        this.m_oGateWayTypeLabel.setBounds(11, 69, 105, 20);
        this.m_oGateWayAddrLabel.setBounds(11, 101, 105, 20);
        this.m_oPortLabel.setBounds(11, 133, 105, 20);
        this.m_oUserNameLabel.setBounds(11, 165, 105, 20);
        this.m_oPasswdLabel.setBounds(11, 197, 105, 20);
        this.remove(this.m_oNEIDLabel);
        this.remove(this.m_oNEExtIDLabel);
        this.remove(this.m_oNENameLabel);
        this.add(this.m_oNETIDLabel);
    }

    private void initLabels() {
        this.m_oNEIDLabel = new JLabel(this.m_oResMgr.getResString("DEVICE_ID_LABEL"));
        this.m_oNEExtIDLabel = new JLabel(this.m_oResMgr.getResString("DEVICE_EXTEND_ID_LABEL"));
        this.m_oNENameLabel = new JLabel(this.m_oResMgr.getResString("DEVICE_NAME_LABEL"));
        this.m_oNETIDLabel = new JLabel(this.m_oResMgr.getResString("NE_TID_LABEL"));
        this.m_oProtocolTypeLabel = new JLabel(this.m_oResMgr.getResString("PROTOCOL_TYPE_LABEL"));
        this.m_oGateWayTypeLabel = new JLabel(this.m_oResMgr.getResString("GATEWAY_TYPE_LABEL"));
        this.m_oGateWayAddrLabel = new JLabel(this.m_oResMgr.getResString("GATEWAY_ADDRESS_LABEL"));
        this.m_oPortLabel = new JLabel(this.m_oResMgr.getResString("PORT_LABEL"));
        this.m_oUserNameLabel = new JLabel(this.m_oResMgr.getResString("USER_NAME_LABEL"));
        this.m_oPasswdLabel = new JLabel(this.m_oResMgr.getResString("PASSWORD_LABEL"));
        this.m_oNENameLabel_Asteriskl = new JLabel("*");
        this.m_oProtocolTypeLabe_Asteriskl = new JLabel("*");
        this.m_oGateWayTypeLabel_Asteriskl = new JLabel("*");
        this.m_oGateWayAddrLabel_Asteriskl = new JLabel("*");
        this.m_oPortLabe_Asteriskl = new JLabel("*");
        this.m_oUserNameLabel_Asteriskl = new JLabel("*");
        this.m_oPasswdLabel_Asteriskl = new JLabel("*");
        this.m_oNENameLabel_Asteriskl.setForeground(Color.RED);
        this.m_oProtocolTypeLabe_Asteriskl.setForeground(Color.RED);
        this.m_oGateWayTypeLabel_Asteriskl.setForeground(Color.RED);
        this.m_oGateWayAddrLabel_Asteriskl.setForeground(Color.RED);
        this.m_oPortLabe_Asteriskl.setForeground(Color.RED);
        this.m_oUserNameLabel_Asteriskl.setForeground(Color.RED);
        this.m_oPasswdLabel_Asteriskl.setForeground(Color.RED);
    }

    private void alignLabels() {
        this.m_oProtocolTypeLabel.setBounds(11, 5, 105, 20);
        this.m_oNEIDLabel.setBounds(11, 37, 105, 20);
        this.m_oNETIDLabel.setBounds(11, 37, 105, 20);
        this.m_oNEExtIDLabel.setBounds(11, 69, 105, 20);
        this.m_oNENameLabel.setBounds(11, 101, 105, 20);
        this.m_oGateWayTypeLabel.setBounds(11, 133, 105, 20);
        this.m_oGateWayAddrLabel.setBounds(11, 165, 105, 20);
        this.m_oPortLabel.setBounds(11, 197, 105, 20);
        this.m_oUserNameLabel.setBounds(11, 229, 105, 20);
        this.m_oPasswdLabel.setBounds(11, 261, 105, 20);
    }

    private void addLabels() {
        this.add(this.m_oNEIDLabel);
        this.add(this.m_oNEExtIDLabel);
        this.add(this.m_oNENameLabel);
        this.add(this.m_oNENameLabel_Asteriskl);
        this.add(this.m_oProtocolTypeLabel);
        this.add(this.m_oGateWayTypeLabel);
        this.add(this.m_oGateWayAddrLabel);
        this.add(this.m_oPortLabel);
        this.add(this.m_oUserNameLabel);
        this.add(this.m_oUserNameLabel_Asteriskl);
        this.add(this.m_oPasswdLabel);
        this.add(this.m_oPasswdLabel_Asteriskl);
    }

    private void initSearchBtn() {
        this.m_oSearchButton = new JButton();
        this.m_oSearchButton.setName("StandAlone_AddGatewayDevicesPanel_m_oSearchButton");
        this.m_oSearchButton.setFocusable(false);
        this.m_oSearchButton.setToolTipText(this.m_oResMgr.getResString("SEARCH_BUTTON"));
        this.m_oSearchButton.setIcon(ResourceManager.getInstance().getImage("searchObject.gif"));
        this.add(this.m_oSearchButton);
    }

    public void setComponentsEnabled(boolean bFlag) {
        this.m_oNEIDLabel.setEnabled(bFlag);
        this.m_oNEExtIDLabel.setEnabled(bFlag);
        this.m_oNENameLabel.setEnabled(bFlag);
        this.m_oProtocolTypeLabel.setEnabled(bFlag);
        this.m_oGateWayTypeLabel.setEnabled(bFlag);
        this.m_oGateWayAddrLabel.setEnabled(bFlag);
        this.m_oPortLabel.setEnabled(bFlag);
        this.m_oUserNameLabel.setEnabled(bFlag);
        this.m_oPasswdLabel.setEnabled(bFlag);
        this.m_oNEIDTextField.setEnabled(bFlag);
        this.m_oNEExtIDTextField.setEditable(bFlag);
        this.m_oNENameField.setEnabled(bFlag);
        this.m_oProtocolTypeDropDown.setEnabled(bFlag);
        this.m_oGateWayTypeDropDown.setEnabled(bFlag);
        this.m_oGateWayIPAddressDropDown.setEnabled(bFlag);
        this.m_oPortField.setEnabled(bFlag);
        this.m_oUserNameField.setEnabled(bFlag);
        this.m_oPasswdField.setEnabled(bFlag);
        this.m_oSearchButton.setEnabled(bFlag);
    }

    private void populateProtocolTypeDropDown() {
        CodeValue[] arrCodeValue = PopulateAddGatewayDevIntfDropDown.getProtocolTypes();
        int iSize = arrCodeValue.length;
        this.m_oProtocolTypeModel.removeAllElements();
        for (int index = 0; index < iSize; ++index) {
            this.m_oProtocolTypeModel.addElement(arrCodeValue[index]);
        }
        this.protocolTypeDropDownStateChange();
    }

    private void populateGatewayTypeDropDown() {
        CodeValue[] arrCodeValue = PopulateAddGatewayDevIntfDropDown.getGatewayTypes();
        int iSize = arrCodeValue.length;
        this.m_oGateWayTypeModel.removeAllElements();
        for (int index = 0; index < iSize; ++index) {
            this.m_oGateWayTypeModel.addElement(arrCodeValue[index]);
        }
    }

    private void populateGatewayIPDropDown() {
        this.m_oGateWayIPAddressDropDown.removeAllItems();
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DeviceInfo[] oDevInfos = oDevMgr.getDevices();
        if (null == oDevInfos || oDevInfos.length == 0) {
            return;
        }
        int iInsertIndex = 0;
        for (DeviceInfo oDevInfo : oDevInfos) {
            if (null == oDevInfo || !oDevInfo.getDeviceTypeInfo().isT2000Domain() || oDevInfo.getRoleType() != 1) continue;
            this.m_oGateWayIPAddressDropDown.insertItemAt(oDevInfo.getDevIPAddress(), iInsertIndex);
            ++iInsertIndex;
        }
    }

    private void initActionListener() {
        this.m_oSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddGatewayDevicesPanel.this.searchButtonActionPerformed();
            }
        });
        this.m_oProtocolTypeDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddGatewayDevicesPanel.this.protocolTypeDropDownStateChange();
            }
        });
        this.m_oGateWayTypeDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddGatewayDevicesPanel.this.gatewayTypeDropDownStateChange();
            }
        });
    }

    protected void searchButtonActionPerformed() {
        SearchGatewayDeviceDialog oSearchGatewayDeviceDialog = null;
        int iRequestId = DCFrameWorkUtil.generateRequestId();
        oSearchGatewayDeviceDialog = new SearchGatewayDeviceDialog(1, iRequestId, this);
        try {
            this.m_oStandAloneSyncCtrller.startSearchForGWDev(iRequestId);
        }
        catch (DCException e) {
            DCDebugTracer.trace("DC::searchButtonActionPerformed::throw exception::" + e.getMessage());
            return;
        }
        oSearchGatewayDeviceDialog.setVisible(true);
    }

    protected void protocolTypeDropDownStateChange() {
        CodeValue oCodeValue = (CodeValue)this.m_oProtocolTypeDropDown.getSelectedItem();
        if (4 == oCodeValue.getCode()) {
            this.alignLabelsForTL1();
            this.alignFieldsForTL1();
            this.setPortValue(23);
            this.setUserNameValue("");
            this.setUserPassValue("".toCharArray());
        } else if (2 == oCodeValue.getCode()) {
            this.alignLabelsForMML();
            this.alignFieldsForMML();
            this.setPortValue(1400);
            this.setUserNameValue("");
            this.setUserPassValue("".toCharArray());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddGatewayDevicesPanel.this.updateUI();
            }
        });
    }

    private void setPortValue(int iPort) {
        this.m_oPortField.setValue((Object)iPort);
    }

    private void setUserNameValue(String strUserName) {
        this.m_oUserNameField.setText(strUserName);
    }

    private void setUserPassValue(char[] strUserPass) {
        this.m_oPasswdField.setPassword(strUserPass);
    }

    protected void gatewayTypeDropDownStateChange() {
        CodeValue oCodeValue = (CodeValue)this.m_oGateWayTypeDropDown.getSelectedItem();
        if (2 == oCodeValue.getCode()) {
            this.remove(this.m_oGateWayIPAddressDropDown);
            this.remove(this.m_oSearchButton);
            this.add(this.m_oGateWayAddressDropDown);
        } else if (1 == oCodeValue.getCode()) {
            this.remove(this.m_oGateWayAddressDropDown);
            this.add(this.m_oGateWayIPAddressDropDown);
            this.add(this.m_oSearchButton);
        }
        this.updateUI();
    }

    @Override
    public SnmpParaInfo getSNMPParaInfo() {
        return null;
    }

    @Override
    public List<Resource> getSelectedResourceList() {
        CodeValue oGatewayTypeCode;
        ArrayList<Resource> oResList = new ArrayList<Resource>(0);
        Resource oResource = new Resource();
        CodeValue oProtocolCode = (CodeValue)this.m_oProtocolTypeDropDown.getSelectedItem();
        oResource.setDeviceName(this.m_oNENameField.getText().trim());
        int iCode = oProtocolCode.getCode();
        Collator oEquals = Collator.getInstance();
        if (2 == iCode) {
            oResource.setProtocolType(2);
            if (!oEquals.equals(this.m_oNEIDTextField.getText().trim(), "") && !oEquals.equals(this.m_oNEExtIDTextField.getText().trim(), "")) {
                int iNEID = this.parseNEIDStr(this.m_oNEExtIDTextField.getText().trim() + "-" + this.m_oNEIDTextField.getText().trim());
                oResource.setMMLProtocolPhysicalID(iNEID);
            }
        } else if (4 == iCode) {
            oResource.setProtocolType(4);
            if (!oEquals.equals(this.m_oNETIDTextField.getText().trim(), "")) {
                oResource.setTL1ProtocolPhyID(this.m_oNETIDTextField.getText().trim());
            }
        }
        if (1 == (iCode = (oGatewayTypeCode = (CodeValue)this.m_oGateWayTypeDropDown.getSelectedItem()).getCode())) {
            oResource.setGatewayType(1);
            String ipAddress = "";
            try {
                ipAddress = this.m_oIPEditorField.getTrimedAddress();
            }
            catch (InValideIPAddressException e) {
                DCDebugTracer.trace((Exception)((Object)e));
            }
            oResource.setGatewayAddress(ipAddress);
        } else if (2 == iCode) {
            oResource.setGatewayType(2);
            oResource.setGatewayAddress((String)this.m_oGateWayAddressDropDown.getSelectedItem());
        }
        oResource.setPortValue((Integer)this.m_oPortField.getValue());
        oResource.setUserName(this.m_oUserNameField.getText().trim());
        oResource.setPassword(this.m_oPasswdField.getPasswordInChar());
        oResList.add(oResource);
        return oResList;
    }

    @Override
    public void refreshPanels() {
    }

    @Override
    public void setAllFieldsBlank() {
        this.m_oNEIDTextField.setText("");
        this.m_oNEExtIDTextField.setText("");
        this.m_oNETIDTextField.setText("");
        this.m_oNENameField.setText("");
        this.m_oIPEditorField.setText("");
        this.m_oPortField.setValue((Object)1400);
        this.m_oUserNameField.setText("");
    }

    @Override
    public void setSNMPParaInfo(SnmpParaInfo paraInfo) {
    }

    @Override
    public boolean validateFields() {
        boolean bValidationResult;
        boolean bl = bValidationResult = this.validateDevId() && this.validateGatewayAddr() && this.validatePortValue() && this.validateUserName() && this.validatePassWd();
        if (bValidationResult) {
            this.updateGatewayDropDownHistory();
        }
        return bValidationResult;
    }

    @Override
    public void updateGatewayIPDropDown(List oIPList) {
        boolean bExist = false;
        int iSize = oIPList.size();
        StandAloneCommUtil.setGateIPAddLst(oIPList);
        int iIPCount = this.m_oGateWayIPAddressDropDown.getItemCount();
        for (int index = 0; index < iSize; ++index) {
            bExist = false;
            String strIP = (String)oIPList.get(index);
            for (int i = 0; i < iIPCount; ++i) {
                String strValue = (String)this.m_oGateWayIPAddressDropDown.getItemAt(i);
                if (!Collator.getInstance().equals(strValue, strIP)) continue;
                this.m_oGateWayIPAddressDropDown.removeItemAt(i);
                this.m_oGateWayIPAddressDropDown.insertItemAt(strIP, 0);
                this.m_oGateWayIPAddressDropDown.setSelectedIndex(0);
                bExist = true;
                break;
            }
            if (!bExist) {
                this.m_oGateWayIPAddressDropDown.insertItemAt(strIP, 0);
                iIPCount = this.m_oGateWayIPAddressDropDown.getItemCount();
            }
            this.m_oIPEditorField.setText(strIP);
        }
    }

    private void updateGatewayDropDownHistory() {
        String strValue;
        int index;
        int iCount;
        String strInsertItem;
        boolean bExist = false;
        CodeValue oCode = (CodeValue)this.m_oGateWayTypeDropDown.getSelectedItem();
        int iCode = oCode.getCode();
        Collator oEquals = Collator.getInstance();
        if (1 == iCode) {
            strInsertItem = "";
            try {
                strInsertItem = this.m_oIPEditorField.getTrimedAddress();
            }
            catch (InValideIPAddressException e) {
                DCDebugTracer.trace((Exception)((Object)e));
            }
            iCount = this.m_oGateWayIPAddressDropDown.getItemCount();
            for (index = 0; index < iCount; ++index) {
                strValue = (String)this.m_oGateWayIPAddressDropDown.getItemAt(index);
                if (!oEquals.equals(strValue, strInsertItem)) continue;
                this.m_oGateWayIPAddressDropDown.removeItemAt(index);
                this.m_oGateWayIPAddressDropDown.insertItemAt(strInsertItem, 0);
                this.m_oGateWayIPAddressDropDown.setSelectedIndex(0);
                bExist = true;
                break;
            }
            if (!bExist) {
                this.m_oGateWayIPAddressDropDown.insertItemAt(strInsertItem, 0);
            }
        }
        if (2 == iCode) {
            strInsertItem = (String)this.m_oGateWayAddressDropDown.getSelectedItem();
            iCount = this.m_oGateWayAddressDropDown.getItemCount();
            for (index = 0; index < iCount; ++index) {
                strValue = (String)this.m_oGateWayAddressDropDown.getItemAt(index);
                if (!oEquals.equals(strValue, strInsertItem)) continue;
                this.m_oGateWayAddressDropDown.removeItemAt(index);
                this.m_oGateWayAddressDropDown.insertItemAt(strInsertItem, 0);
                this.m_oGateWayAddressDropDown.setSelectedIndex(0);
                bExist = true;
                break;
            }
            if (!bExist) {
                this.m_oGateWayAddressDropDown.insertItemAt(strInsertItem, 0);
            }
        }
    }

    private boolean validatePassWd() {
        boolean bVal = false;
        char[] chPwd = this.m_oPasswdField.getPasswordInChar();
        boolean bl = bVal = null != chPwd && 0 < chPwd.length;
        if (!bVal) {
            String strMsg = this.m_oResMgr.getResString("PASSWORD_FIELD_BLANK");
            this.showErrorMessage(strMsg);
            this.m_oPasswdField.grabFocus();
        }
        return bVal;
    }

    private boolean validateUserName() {
        boolean bVal = false;
        String strUserName = this.m_oUserNameField.getText().trim();
        boolean bl = bVal = null != strUserName && !Collator.getInstance().equals(strUserName, "");
        if (!bVal) {
            String strMsg = this.m_oResMgr.getResString("USER_NAME_BLANK");
            this.showErrorMessage(strMsg);
            this.m_oUserNameField.grabFocus();
        }
        return bVal;
    }

    private boolean validatePortValue() {
        boolean bVal = false;
        Object oPort = this.m_oPortField.getValue();
        boolean bl = bVal = null != oPort && oPort instanceof Integer;
        if (!bVal) {
            String strMsg = this.m_oResMgr.getResString("PORT_EMPTY");
            this.showErrorMessage(strMsg);
        }
        return bVal;
    }

    private boolean validateGatewayAddr() {
        boolean bVal = false;
        CodeValue oCode = (CodeValue)this.m_oGateWayTypeDropDown.getSelectedItem();
        int iCode = oCode.getCode();
        if (1 == iCode) {
            bVal = this.validateGatewayIpAddrField();
            if (!bVal) {
                String strMsg = this.m_oResMgr.getResString("GATEWAY_ADDR_EMPTY");
                this.showErrorMessage(strMsg);
                this.m_oIPEditorField.grabFocus();
            }
        } else if (2 == iCode) {
            String strGatewayAddr = (String)this.m_oGateWayAddressDropDown.getSelectedItem();
            boolean bl = bVal = null != strGatewayAddr && !Collator.getInstance().equals(strGatewayAddr, "");
            if (!bVal) {
                String strMsg = this.m_oResMgr.getResString("GATEWAY_ADDR_EMPTY");
                this.showErrorMessage(strMsg);
                this.m_oGateWayAddressDropDown.grabFocus();
            }
        }
        return bVal;
    }

    private boolean validateGatewayIpAddrField() {
        boolean bVal = false;
        bVal = this.m_oIPEditorField.isValid();
        return bVal;
    }

    private boolean validateDevId() {
        CodeValue oCode = (CodeValue)this.m_oProtocolTypeDropDown.getSelectedItem();
        int iCode = oCode.getCode();
        String strDevId = null;
        String strNeId = null;
        String strExtId = null;
        if (2 == iCode) {
            strNeId = this.m_oNEIDTextField.getText().trim();
            strExtId = this.m_oNEExtIDTextField.getText().trim();
            if (strExtId.equals("") && !strNeId.equals("")) {
                String strMsg = this.m_oResMgr.getResString("INVALID_DEVICE_EXTID");
                this.showErrorMessage(strMsg);
                return false;
            }
            if (!strExtId.equals("") && strNeId.equals("")) {
                String strMsg = this.m_oResMgr.getResString("INVALID_DEVICE_ID");
                this.showErrorMessage(strMsg);
                return false;
            }
            strDevId = this.m_oNEExtIDTextField.getText().trim() + "-" + this.m_oNEIDTextField.getText().trim();
            if (!strDevId.equals("-") && !"".equals(strDevId)) {
                if (-1 == this.parseNEIDStr(strDevId)) {
                    String strMsg = this.m_oResMgr.getResString("INVALID_DEVICE_ID");
                    this.showErrorMessage(strMsg);
                    return false;
                }
                this.m_oNEIDTextField.grabFocus();
            }
        }
        return true;
    }

    private void showErrorMessage(String strErrorMsg) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
    }

    @Override
    public List<Resource> getT2000Resource() {
        return null;
    }

    public void populateComponents(T2000DevInfo oDevInfo, int iSize) {
        this.m_oNENameField.setText(oDevInfo.getDeviceName());
        this.setProtocolTypeAndGatewayTypeItem(oDevInfo);
        this.setDeviceIdField(oDevInfo);
        this.setGatewayAddr(oDevInfo);
        this.m_oPortField.setValue((Object)oDevInfo.getPort());
        if (iSize > 1) {
            this.m_oUserNameField.setText("");
        } else {
            this.m_oUserNameField.setText(oDevInfo.getUserName());
            this.m_oPasswdField.setPassword(oDevInfo.getPass());
        }
    }

    private void setProtocolTypeAndGatewayTypeItem(T2000DevInfo oDevInfo) {
        int iProtocolType = oDevInfo.getProtocolType();
        int iItemCount = this.m_oProtocolTypeDropDown.getItemCount();
        for (int index = 0; index < iItemCount; ++index) {
            CodeValue oCodeValue = (CodeValue)this.m_oProtocolTypeDropDown.getItemAt(index);
            if (oCodeValue.getCode() != iProtocolType) continue;
            this.m_oProtocolTypeDropDown.setSelectedItem(oCodeValue);
        }
        int iGatewayType = oDevInfo.getGateWayType();
        iItemCount = this.m_oGateWayTypeDropDown.getItemCount();
        for (int index = 0; index < iItemCount; ++index) {
            CodeValue oCodeValue = (CodeValue)this.m_oGateWayTypeDropDown.getItemAt(index);
            if (oCodeValue.getCode() != iGatewayType) continue;
            this.m_oGateWayTypeDropDown.setSelectedItem(oCodeValue);
        }
    }

    private void setDeviceIdField(T2000DevInfo oDevInfo) {
        CodeValue oCodeValue = (CodeValue)this.m_oProtocolTypeDropDown.getSelectedItem();
        if (2 == oCodeValue.getCode()) {
            Integer oIntVal = oDevInfo.getMMLProtocolPhyDevIdDeviceId();
            String strIntVal = this.parseNEIDInt(oIntVal);
            if (null != strIntVal) {
                String[] neIDInfo = strIntVal.split("-");
                if (neIDInfo != null && neIDInfo.length > 1) {
                    this.m_oNEIDTextField.setText(neIDInfo[1]);
                    this.m_oNEExtIDTextField.setText(neIDInfo[0]);
                } else {
                    this.m_oNEIDTextField.setText(strIntVal);
                }
            }
        } else if (4 == oCodeValue.getCode()) {
            this.m_oNETIDTextField.setText(oDevInfo.getTL1ProtocolDevPhyId());
        }
    }

    private void setGatewayAddr(T2000DevInfo oDevInfo) {
        CodeValue oCodeValue = (CodeValue)this.m_oGateWayTypeDropDown.getSelectedItem();
        if (1 == oCodeValue.getCode()) {
            this.m_oIPEditorField.setText(oDevInfo.getGatewayAddress());
        } else if (2 == oCodeValue.getCode()) {
            this.m_oGateWayAddressDropDown.setSelectedItem(oDevInfo.getGatewayAddress());
        }
    }

    public void setNonModifiableCompEnable(boolean bVal) {
        this.m_oNEIDTextField.setEnabled(bVal);
        this.m_oNEExtIDTextField.setEnabled(bVal);
        this.m_oNETIDTextField.setEnabled(bVal);
        this.m_oProtocolTypeDropDown.setEnabled(bVal);
        this.m_oGateWayTypeDropDown.setEnabled(bVal);
        this.m_oGateWayIPAddressDropDown.setEnabled(bVal);
        this.m_oPortField.setEnabled(bVal);
        this.m_oSearchButton.setEnabled(bVal);
        this.m_oSearchButton.setVisible(bVal);
        this.m_oGateWayAddressDropDown.setEnabled(bVal);
        this.reinitComponents();
    }

    @Override
    public void setGatewayDropDown(String strIp) {
        int iItemCount = this.m_oGateWayIPAddressDropDown.getItemCount();
        for (int index = 0; index < iItemCount; ++index) {
            String strValue = (String)this.m_oGateWayIPAddressDropDown.getItemAt(index);
            if (!Collator.getInstance().equals(strIp, strValue)) continue;
            this.m_oGateWayIPAddressDropDown.removeItemAt(index);
            this.m_oGateWayIPAddressDropDown.insertItemAt(strIp, 0);
            this.m_oGateWayIPAddressDropDown.setSelectedIndex(0);
            this.m_oIPEditorField.setText(strIp);
        }
    }

    public int parseNEIDStr(String str) {
        int index2;
        String s = str.trim();
        if (s.length() < 1) {
            return -1;
        }
        int index = s.indexOf(45);
        if (index != (index2 = s.lastIndexOf(45))) {
            return -1;
        }
        int subnet = 9;
        int ne = -1;
        int id = -1;
        String idf = s;
        String idb = "";
        try {
            String ls;
            String fs;
            if (index > -1) {
                fs = s.substring(0, index);
                ls = s.substring(index + 1);
                if (fs.length() > 9 || ls.length() > 9) {
                    return -1;
                }
            } else {
                if (s.length() > 9) {
                    return -1;
                }
                ne = Integer.parseInt(s);
                if (ne < 1) {
                    return -1;
                }
                return ne;
            }
            subnet = Integer.parseInt(fs);
            idf = fs;
            ne = Integer.parseInt(ls);
            idb = ls;
            if (ne < 1) {
                return -1;
            }
            id = (subnet << 16) + ne;
            this.m_strNEName = !idb.equals("") ? idf + '_' + idb : idf;
            this.iNEID = ne;
        }
        catch (Exception e) {
            return -1;
        }
        return id;
    }

    private String parseNEIDInt(int iID) {
        String strNEID = null;
        if (65535 < iID) {
            int iSubNetID = 0;
            int iNEid = 0;
            iSubNetID = iID >> 16;
            iNEid = iID & 0xFFFF;
            strNEID = iSubNetID + "-" + iNEid;
        } else {
            strNEID = Integer.valueOf(iID).toString();
        }
        return strNEID;
    }
}

