/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TempletExportUtil;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.event.IStandAloneNotificationListener;
import com.huawei.dc.standalone.event.StandAloneEvent;
import com.huawei.dc.standalone.event.StandAloneNotifier;
import com.huawei.dc.standalone.view.AccessDevInfoPanel;
import com.huawei.dc.standalone.view.AddDeviceInfoPanel;
import com.huawei.dc.standalone.view.ImportAccessDeviceDialog;
import com.huawei.dc.standalone.view.ImportDevSelectFilePanel;
import com.huawei.dc.standalone.view.ImportOptixDeviceDialog;
import com.huawei.dc.standalone.view.OptixDevInfoPanel;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class AddDevicesDlg
extends DCModalDialog
implements IStandAloneNotificationListener {
    private static final long serialVersionUID = -3440103913582376584L;
    private JRadioButton m_optixRadioBtn;
    private JRadioButton m_switchRadioBtn;
    private JRadioButton m_accessRadioBtn;
    private JButton m_importBtn;
    private JButton m_exportTempleteBtn;
    private JButton m_addDevBtn;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private AddDeviceInfoPanel m_currentAddDevInfoPanel;
    private ImportDevSelectFilePanel m_oSelectFilePanel;
    private IDCStandAloneSyncCtrller m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
    private volatile int addDevCount = 0;
    private Object oSynObj = new Object();

    public AddDevicesDlg(boolean isAddOffLineDevice) {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.setSize(950, 410);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        if (isAddOffLineDevice) {
            this.setTitle(this.m_oResManager.getResString("STANDALONE_ADD_OFF_LINE_DEVICE_DIALOG_TITLE"));
        } else {
            this.setTitle(this.m_oResManager.getResString("STANDALONE_ADD_DEVICE_DIALOG_TITLE"));
        }
        this.setMinimumSize(new Dimension(500, 300));
        StandAloneNotifier.getInstance().addStandAloneNotificationListener(this);
        this.jInit();
        this.setDefaultCloseOperation(0);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void jInit() {
        Container container = this.getContentPane();
        ButtonGroup group = new ButtonGroup();
        this.m_optixRadioBtn = new JRadioButton(this.m_oResManager.getResString("OPTIX_DOMAIN_NAME"));
        this.m_optixRadioBtn.setName("com.huawei.dc.standalone.view.AddDevicesDlg.m_optixRadioBtn");
        this.m_switchRadioBtn = new JRadioButton(this.m_oResManager.getResString("SWITCH_DOMAIN_NAME"));
        this.m_switchRadioBtn.setName("com.huawei.dc.standalone.view.AddDevicesDlg.m_switchRadioBtn");
        this.m_accessRadioBtn = new JRadioButton(this.m_oResManager.getResString("ACCESS_DOMAIN_NAME"));
        this.m_accessRadioBtn.setName("com.huawei.dc.standalone.view.AddDevicesDlg.m_accessRadioBtn");
        group.add(this.m_optixRadioBtn);
        group.add(this.m_switchRadioBtn);
        group.add(this.m_accessRadioBtn);
        final CardLayout cardLayout = new CardLayout();
        final JPanel devInfoPanel = new JPanel(cardLayout);
        final AddDeviceInfoPanel addOptixDevInfoPanel = new AddDeviceInfoPanel(4, this);
        final AddDeviceInfoPanel addAccessDevInfoPanel = new AddDeviceInfoPanel(1, this);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 2));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 3));
        centerPanel.setBorder(BorderFactory.createEtchedBorder());
        centerPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel centerTopPanel = new JPanel();
        centerTopPanel.setLayout(new BoxLayout(centerTopPanel, 2));
        this.m_oSelectFilePanel = new ImportDevSelectFilePanel();
        centerTopPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        centerTopPanel.add(this.m_oSelectFilePanel);
        this.m_importBtn = new JButton(this.m_oResManager.getResString("ADD_DEVICE_EXPORT_IMPORT_BUTTON_TEXT"));
        this.m_importBtn.setMnemonic('I');
        this.m_importBtn.setName("com.huawei.dc.standalone.view.AddDevicesDlg.m_importBtn");
        this.m_importBtn.setMinimumSize(new Dimension(100, 21));
        this.m_importBtn.setPreferredSize(new Dimension(100, 21));
        this.m_importBtn.setMaximumSize(new Dimension(100, 21));
        centerTopPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        centerTopPanel.add(this.m_importBtn);
        this.m_importBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
                if (selectedDomain == 4) {
                    ImportOptixDeviceDialog dialog = new ImportOptixDeviceDialog((OptixDevInfoPanel)addOptixDevInfoPanel.getDevInfoPanel(), AddDevicesDlg.this.m_oSelectFilePanel);
                    dialog.oKButton_ActionPerformed();
                    if (dialog.isAddDevice()) {
                        ((OptixDevInfoPanel)addOptixDevInfoPanel.getDevInfoPanel()).deleteAllEmptyRow();
                        ((OptixDevInfoPanel)addOptixDevInfoPanel.getDevInfoPanel()).addAllRow(dialog.getImprotSuccDevLst());
                    }
                } else {
                    ImportAccessDeviceDialog dialog = new ImportAccessDeviceDialog((AccessDevInfoPanel)addAccessDevInfoPanel.getDevInfoPanel(), AddDevicesDlg.this.m_oSelectFilePanel);
                    String strPath = "";
                    strPath = dialog.importFileTextField.getText().trim();
                    AddDevicesDlg.this.isFileAndSizeValid(strPath);
                    dialog.oKButton_ActionPerformed();
                    if (dialog.isAddDevice()) {
                        AddDevicesDlg.this.addDeviceAction();
                    }
                }
            }
        });
        this.m_exportTempleteBtn = new JButton(this.m_oResManager.getResString("ADD_DEVICE_EXPORT_TEMPLETE_BUTTON_TEXT"));
        this.m_exportTempleteBtn.setMnemonic('E');
        this.m_exportTempleteBtn.setName("com.huawei.dc.standalone.view.AddDevicesDlg.m_exportTempleteBtn");
        this.m_exportTempleteBtn.setMinimumSize(new Dimension(100, 21));
        this.m_exportTempleteBtn.setPreferredSize(new Dimension(115, 21));
        this.m_exportTempleteBtn.setMaximumSize(new Dimension(250, 21));
        centerTopPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        centerTopPanel.add(this.m_exportTempleteBtn);
        centerTopPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        centerPanel.add(centerTopPanel);
        this.m_exportTempleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = StringUtils.removePostfix(AddDevicesDlg.this.getTempleteName(), ".xls");
                TempletExportUtil exportCheckItem = new TempletExportUtil(AddDevicesDlg.this.getOrgTempleteName(), fileName, ResourceManager.getInstance().getResString("EXPORT_DEVICE_TEMPLATE_INFO"));
                exportCheckItem.exportTemple();
            }
        });
        ActionListener radioBoxlistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strText = ((JRadioButton)e.getSource()).getText();
                if (strText.equals(AddDevicesDlg.this.m_oResManager.getResString("OPTIX_DOMAIN_NAME"))) {
                    cardLayout.show(devInfoPanel, "OptixDevInfoPanel");
                    AddDevicesDlg.this.m_currentAddDevInfoPanel = addOptixDevInfoPanel;
                } else if (strText.equals(AddDevicesDlg.this.m_oResManager.getResString("SWITCH_DOMAIN_NAME"))) {
                    DCDebugTracer.trace("device is switch domain name");
                } else {
                    cardLayout.show(devInfoPanel, "AccessDevInfoPanel");
                    AddDevicesDlg.this.m_currentAddDevInfoPanel = addAccessDevInfoPanel;
                }
            }
        };
        this.m_optixRadioBtn.addActionListener(radioBoxlistener);
        this.m_switchRadioBtn.addActionListener(radioBoxlistener);
        this.m_accessRadioBtn.addActionListener(radioBoxlistener);
        int iDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
        if (4 == iDomain) {
            topPanel.add(Box.createRigidArea(new Dimension(5, 10)));
            topPanel.add(this.m_optixRadioBtn);
            this.m_optixRadioBtn.setSelected(true);
            this.m_currentAddDevInfoPanel = addOptixDevInfoPanel;
            devInfoPanel.add((Component)addOptixDevInfoPanel, "OptixDevInfoPanel");
        } else if (3 == iDomain || 2 == iDomain) {
            topPanel.add(Box.createRigidArea(new Dimension(5, 10)));
            topPanel.add(this.m_accessRadioBtn);
            this.m_accessRadioBtn.setSelected(true);
            this.m_currentAddDevInfoPanel = addAccessDevInfoPanel;
            devInfoPanel.add((Component)addAccessDevInfoPanel, "AccessDevInfoPanel");
            if (2 == iDomain) {
                this.m_oSelectFilePanel.enableAllComponent(false);
                this.m_oSelectFilePanel.setVisible(false);
                this.m_importBtn.setEnabled(false);
                this.m_importBtn.setVisible(false);
                this.m_exportTempleteBtn.setEnabled(false);
                this.m_exportTempleteBtn.setVisible(false);
            }
        }
        Box devInfoBox = Box.createHorizontalBox();
        devInfoBox.add(Box.createRigidArea(new Dimension(10, 0)));
        devInfoBox.add(devInfoPanel);
        devInfoBox.add(Box.createRigidArea(new Dimension(10, 0)));
        centerPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        centerPanel.add(devInfoBox);
        centerPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel bottomPanel = new JPanel(new FlowLayout(2, 10, 10));
        this.m_addDevBtn = new JButton(this.m_oResManager.getResString("ADD_DEVICE_BUTTION_TEXT"));
        this.m_addDevBtn.setMnemonic('C');
        this.m_addDevBtn.setName("com.huawei.dc.standalone.view.AddDevicesDlg.m_addDevBtn");
        this.m_addDevBtn.setMinimumSize(new Dimension(120, 21));
        this.m_addDevBtn.setPreferredSize(new Dimension(120, 21));
        this.m_addDevBtn.setMaximumSize(new Dimension(120, 21));
        bottomPanel.add(this.m_addDevBtn);
        this.m_addDevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDevicesDlg.this.addDeviceAction();
            }
        });
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("CLOSE_BUTTON"));
        this.m_oCancelBtn.setName("com.huawei.dc.standalone.view.AddDevicesDlg.m_oCancelBtn");
        this.m_oCancelBtn.setMinimumSize(new Dimension(120, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(120, 21));
        this.m_oCancelBtn.setMaximumSize(new Dimension(120, 21));
        bottomPanel.add(this.m_oCancelBtn);
        container.add((Component)centerPanel, "Center");
        container.add(Box.createHorizontalStrut(5), "East");
        container.add((Component)bottomPanel, "South");
    }

    @Override
    protected String getCurrentContext() {
        int iDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
        String sCurrentContext = "";
        switch (iDomain) {
            case 4: {
                sCurrentContext = "HELP_TOPIC_STANDALONE_ADD_DEV_T2000";
                break;
            }
            case 2: 
            case 3: {
                sCurrentContext = "HELP_TOPIC_STANDALONE_ADD_DEV_ACESSS_SWITCH";
                break;
            }
            default: {
                sCurrentContext = "";
            }
        }
        return sCurrentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceAction() {
        List oDeviceList = null;
        oDeviceList = this.m_currentAddDevInfoPanel.getSelectedDevInfoLst();
        if (null == oDeviceList || 0 == oDeviceList.size()) {
            return;
        }
        try {
            int iDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
            int iReqId = DCFrameWorkUtil.generateRequestId();
            this.m_oCancelBtn.setEnabled(false);
            if (iDomain == 3) {
                this.m_oStandAloneSyncCtrller.addDevice(iReqId, 41, 1, oDeviceList, ((Resource)oDeviceList.get(0)).getSnmpParaInfo(), 3);
            } else if (iDomain == 4) {
                this.m_oStandAloneSyncCtrller.addDevice(iReqId, -1, 0, oDeviceList);
            } else if (iDomain == 1) {
                DCDebugTracer.trace("device domain is switch");
            } else {
                this.m_oStandAloneSyncCtrller.addDevice(iReqId, 1308, 1, oDeviceList, ((Resource)oDeviceList.get(0)).getSnmpParaInfo(), 2);
            }
            Object object = this.oSynObj;
            synchronized (object) {
                this.addDevCount += oDeviceList.size();
            }
            oDeviceList = null;
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)((Object)this), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            this.m_oCancelBtn.setEnabled(true);
            oDeviceList = null;
            return;
        }
    }

    public void changeAddBtnStatus(boolean status) {
        if (null != this.m_addDevBtn) {
            this.m_addDevBtn.setEnabled(status);
        }
    }

    @Override
    protected void closeDialog() {
        if (0 < this.addDevCount) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CLOSE_ADD_DEV_DLG_INFO"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
        } else {
            super.closeDialog();
            StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStandAloneNotification(StandAloneEvent oEvent) {
        if (null == oEvent) {
            DCDebugTracer.trace("AddDevicesDlg#onStandAloneNotification (null == oEvent) || (m_iEventType != oEvent.getEventType())");
            return;
        }
        DCDebugTracer.trace("AddDevicesDlg#onStandAloneNotification Event Type : " + oEvent.getEventType());
        Resource oRes = oEvent.getResource();
        if (null == oRes) {
            return;
        }
        this.m_currentAddDevInfoPanel.notifyResult(oRes, oEvent.getErrorCode());
        this.m_currentAddDevInfoPanel.getDevInfoPanel().notifyResult(oRes, oEvent.getErrorCode());
        if (0 != oEvent.getErrorCode()) {
            this.changeAddBtnStatus(true);
        }
        Object object = this.oSynObj;
        synchronized (object) {
            --this.addDevCount;
            if (oEvent.isFinal()) {
                this.addDevCount = 0;
            }
        }
        if (0 >= this.addDevCount) {
            this.m_oCancelBtn.setEnabled(true);
        }
        if (0 == oEvent.getEventType()) {
            if (0 == this.addDevCount) {
                DCFrameWorkUtil.getDeviceTreePanel().refreshDeviceTree();
            }
            if (this.addDevCount <= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATION_COMPLETED"), ResourceManager.getInstance().getResString("INFO"), 1);
                    }
                });
            }
        }
    }

    private String getTempleteName() {
        String templetName = "";
        int selectedDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
        switch (selectedDomain) {
            case 4: {
                templetName = DCFrameWorkUtil.getLocalizedString("OPTIX_DOMAIN_TEMPLET");
                break;
            }
            case 3: {
                templetName = DCFrameWorkUtil.getLocalizedString("ACCESS_DOMAIN_TEMPLET");
                break;
            }
            case 2: {
                templetName = DCFrameWorkUtil.getLocalizedString("CLUSTER_NE_TEMPLET");
                break;
            }
            default: {
                DCDebugTracer.trace("error login domain");
            }
        }
        return templetName;
    }

    private String getOrgTempleteName() {
        String templetName = "";
        int selectedDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
        switch (selectedDomain) {
            case 4: {
                templetName = DCFrameWorkUtil.getLocalizedString("OPTIX_DOMAIN_TEMPLET_ORG");
                break;
            }
            case 3: {
                templetName = DCFrameWorkUtil.getLocalizedString("ACCESS_DOMAIN_TEMPLET_ORG");
                break;
            }
            case 2: {
                templetName = DCFrameWorkUtil.getLocalizedString("CLUSTER_NE_TEMPLET_ORG");
                break;
            }
            default: {
                DCDebugTracer.trace("error login domain");
            }
        }
        return templetName;
    }

    protected void isFileAndSizeValid(String sFilePath) {
        if (sFilePath.equals("")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("PROMPT_SELECT_DEVICE_FILE"), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 2);
        }
    }
}

