/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.WindowStyleSpecialButton;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.view.AbstractDeviceInfoPanel;
import com.huawei.dc.standalone.view.AccessDevInfoPanel;
import com.huawei.dc.standalone.view.AddDevicesDlg;
import com.huawei.dc.standalone.view.OptixDevInfoPanel;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddDeviceInfoPanel
extends JPanel {
    protected ResourceManager m_oResManager = ResourceManager.getInstance();
    private AbstractDeviceInfoPanel m_devInfoPanel;
    private WindowStyleSpecialButton m_addNewRowBtn;
    private ImageIcon m_addNewRowBtnIcon = ResourceManager.getInstance().getImage("insertRow.gif");
    private WindowStyleSpecialButton m_deleteRowBtn;
    private ImageIcon m_deleteRowBtnIcon = ResourceManager.getInstance().getImage("delete.gif");
    private WindowStyleSpecialButton m_selectAllBtn;
    private ImageIcon m_selectAllBtnIcon = ResourceManager.getInstance().getImage("selectall.gif");
    private AddDevicesDlg parantDlg = null;

    public AddDeviceInfoPanel(int iDeviceDomain, AddDevicesDlg oParantDlg) {
        this.parantDlg = oParantDlg;
        this.setLayout(new BorderLayout());
        switch (iDeviceDomain) {
            case 4: {
                this.initOptixPnl(oParantDlg);
                break;
            }
            case 1: {
                this.initAccessPnl(oParantDlg);
                break;
            }
        }
        this.jInit();
    }

    private void initOptixPnl(DCModalDialog oParantDlg) {
        this.m_devInfoPanel = new OptixDevInfoPanel(this);
    }

    private void initAccessPnl(DCModalDialog oParantDlg) {
        this.m_devInfoPanel = new AccessDevInfoPanel(this, oParantDlg);
    }

    private void jInit() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        this.m_addNewRowBtn = new WindowStyleSpecialButton();
        this.m_addNewRowBtn.setMinimumSize(new Dimension(25, 21));
        this.m_addNewRowBtn.setPreferredSize(new Dimension(25, 21));
        this.m_addNewRowBtn.setMaximumSize(new Dimension(25, 21));
        this.m_addNewRowBtn.setAlignmentX(0.0f);
        this.m_addNewRowBtn.setIcon(this.m_addNewRowBtnIcon);
        this.m_addNewRowBtn.setToolTipText(this.m_oResManager.getResString("ADD_DEVICE_EXPORT_INSERT_NEW_BUTTON_TEXT"));
        this.m_addNewRowBtn.setMnemonic('N');
        this.m_addNewRowBtn.setName("com.huawei.dc.standalone.view.m_addNewRowBtn");
        buttonPanel.add(this.m_addNewRowBtn);
        this.m_addNewRowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDeviceInfoPanel.this.m_devInfoPanel.addNewRow(0);
                AddDeviceInfoPanel.this.updateBtnState();
            }
        });
        this.m_deleteRowBtn = new WindowStyleSpecialButton();
        this.m_deleteRowBtn.setIcon(this.m_deleteRowBtnIcon);
        this.m_deleteRowBtn.setToolTipText(this.m_oResManager.getResString("ADD_DEVICE_EXPORT_DELETE_BUTTON_TEXT"));
        this.m_deleteRowBtn.setMnemonic('D');
        this.m_deleteRowBtn.setName("com.huawei.dc.standalone.view.m_deleteRowBtn");
        this.m_deleteRowBtn.setMinimumSize(new Dimension(25, 21));
        this.m_deleteRowBtn.setPreferredSize(new Dimension(25, 21));
        this.m_deleteRowBtn.setMaximumSize(new Dimension(25, 21));
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        buttonPanel.add(this.m_deleteRowBtn);
        this.m_deleteRowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDeviceInfoPanel.this.m_devInfoPanel.deleteRow();
                int iRowCount = AddDeviceInfoPanel.this.m_devInfoPanel.getTreeTable().getRowCount();
                if (iRowCount > 0) {
                    AddDeviceInfoPanel.this.m_devInfoPanel.getTreeTable().getSelectionModel().setSelectionInterval(0, 0);
                }
                AddDeviceInfoPanel.this.updateBtnState();
            }
        });
        this.m_selectAllBtn = new WindowStyleSpecialButton();
        this.m_selectAllBtn.setIcon(this.m_selectAllBtnIcon);
        this.m_selectAllBtn.setToolTipText(this.m_oResManager.getResString("ADD_DEVICE_EXPORT_SELECT_ALL_BUTTON_TEXT"));
        this.m_selectAllBtn.setMnemonic('S');
        this.m_selectAllBtn.setName("com.huawei.dc.standalone.view.m_selectAllBtn");
        this.m_selectAllBtn.setMinimumSize(new Dimension(25, 21));
        this.m_selectAllBtn.setPreferredSize(new Dimension(25, 21));
        this.m_selectAllBtn.setMaximumSize(new Dimension(25, 21));
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        buttonPanel.add(this.m_selectAllBtn);
        buttonPanel.add(Box.createVerticalGlue());
        this.m_selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDeviceInfoPanel.this.m_devInfoPanel.selectAllRow();
            }
        });
        Box devInfoBox = Box.createHorizontalBox();
        devInfoBox.add(this.m_devInfoPanel);
        devInfoBox.add(Box.createRigidArea(new Dimension(10, 0)));
        devInfoBox.add(buttonPanel);
        this.m_devInfoPanel.getTreeTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddDeviceInfoPanel.this.updateBtnState();
            }
        });
        this.add(devInfoBox);
    }

    protected void updateBtnState() {
        int iRowCount = this.m_devInfoPanel.getTreeTable().getRowCount();
        int iSelectedRowCount = this.m_devInfoPanel.getTreeTable().getSelectedRowCount();
        boolean isAdding = this.isSelectRowAddingDev();
        if (0 < iSelectedRowCount) {
            this.m_deleteRowBtn.setEnabled(!isAdding);
        } else {
            this.m_deleteRowBtn.setEnabled(false);
        }
        if (iRowCount == iSelectedRowCount) {
            this.m_selectAllBtn.setEnabled(false);
        } else {
            this.m_selectAllBtn.setEnabled(true);
        }
        this.parantDlg.changeAddBtnStatus(!isAdding);
    }

    public boolean isSelectRowAddingDev() {
        boolean isAdding = false;
        JTree tree = this.m_devInfoPanel.getTreeTable().getTree();
        int[] iSelectedRows = this.m_devInfoPanel.getTreeTable().getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreeTableNode tmpNode = (TreeTableNode)tree.getPathForRow(iSelectedRows[i]).getLastPathComponent();
            AbstractDevInfoObj devInfoObj = (AbstractDevInfoObj)tmpNode.getUserObject();
            if (-2147483647 != devInfoObj.getErrorCode()) continue;
            isAdding = true;
            break;
        }
        return isAdding;
    }

    protected boolean preCheckForAddDev() {
        this.m_devInfoPanel.stopAllCellEditor();
        int iRowCount = this.m_devInfoPanel.getTreeTable().getRowCount();
        if (0 >= iRowCount) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("ADD_DEVICE_NO_DEV_INFO_ERROR"), this.m_oResManager.getResString("SUGGESTION"), 1);
            return false;
        }
        int iSelectedNodeCount = this.m_devInfoPanel.getTreeTable().getSelectedRowCount();
        if (0 == iSelectedNodeCount) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("SELECT_ADDED_DEVICE"), this.m_oResManager.getResString("SUGGESTION"), 1);
            return false;
        }
        return true;
    }

    protected List getSelectedDevInfoLst() {
        if (this.preCheckForAddDev()) {
            return this.m_devInfoPanel.getSelectedDevInfoLst();
        }
        return null;
    }

    public AbstractDeviceInfoPanel getDevInfoPanel() {
        return this.m_devInfoPanel;
    }

    protected void notifyResult(Resource res, int iErrCode) {
        this.updateBtnState();
    }

    public boolean isDeleteBtnEnable() {
        if (null != this.m_deleteRowBtn) {
            return this.m_deleteRowBtn.isEnabled();
        }
        return false;
    }
}

