/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.AccessDevInfoObj;
import com.huawei.dc.standalone.model.AccessDevTableInfo;
import com.huawei.dc.standalone.model.DCSortTreeTableModel;
import com.huawei.dc.standalone.view.AddDeviceInfoPanel;
import com.huawei.dc.standalone.view.DCIPAddressEditor;
import com.huawei.dc.standalone.view.DCIPAddressRender;
import com.huawei.dc.standalone.view.DevInfoPanelExtForAddingDev;
import com.huawei.dc.standalone.view.SNMPParaEditer;
import com.huawei.dc.standalone.view.SNMPParaRender;
import com.huawei.dc.taskmgmt.model.Resource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.table.TableColumn;

public class AccessDevInfoPanel
extends DevInfoPanelExtForAddingDev {
    private DCModalDialog m_parentDlg;
    private AddDeviceInfoPanel oBasePnl = null;

    public AccessDevInfoPanel(AddDeviceInfoPanel oBasePanel, DCModalDialog parentDlg) {
        this.oBasePnl = oBasePanel;
        AccessDevTableInfo oAccessDevTableInfo = new AccessDevTableInfo();
        DCSortTreeTableModel m_sortTreeTableModel = new DCSortTreeTableModel(oAccessDevTableInfo);
        super.initializeTreeTable(m_sortTreeTableModel);
        this.m_parentDlg = parentDlg;
        this.jInit();
        this.addNewRow(0);
        this.selectAllRow();
        this.selectAllRow();
    }

    private void jInit() {
        SNMPParaRender snmpReander = new SNMPParaRender();
        TableColumn protocolColumn = this.getTreeTable().getColumn(AccessDevInfoPanel.getHeaderEndWithStar(this.m_oResManager.getResString("ADD_DEVICE_DEV_SNMP_PARA_HEADER")));
        protocolColumn.setCellRenderer(snmpReander);
        protocolColumn.setCellEditor(new SNMPParaEditer(this.m_parentDlg));
        TableColumn addressColumn = this.getTreeTable().getColumn(AccessDevInfoPanel.getHeaderEndWithStar(this.m_oResManager.getResString("ADD_DEVICE_DEV_ADDRESS_HEADER")));
        addressColumn.setCellRenderer(new DCIPAddressRender());
        addressColumn.setCellEditor(new DCIPAddressEditor());
    }

    @Override
    protected List getSelectedDevInfoLst() {
        JTree tree = this.getTreeTable().getTree();
        int[] iSelectedRows = this.getTreeTable().getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        ArrayList<Resource> oAccessDevList = new ArrayList<Resource>(iSelectedNodeCount);
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreeTableNode tmpNode = (TreeTableNode)tree.getPathForRow(iSelectedRows[i]).getLastPathComponent();
            AccessDevInfoObj devInfoObj = (AccessDevInfoObj)tmpNode.getUserObject();
            if (!this.validateDevInfo(devInfoObj)) continue;
            devInfoObj.setDevID(++this.m_currentMaxDevID);
            devInfoObj.setErrorCode(-2147483647);
            Resource res = new Resource();
            res.setDeviceID(devInfoObj.getDevID());
            res.setDevTypeId(41);
            res.setDevVersionID(1);
            res.setDeviceIP(devInfoObj.getDevAddress());
            res.setDeviceName(devInfoObj.getDevName());
            res.setSnmpParaInfo(devInfoObj.getSNMPPara());
            res.setKeyMode(devInfoObj.getKeyMode());
            oAccessDevList.add(res);
        }
        this.getTreeTable().updateUI();
        return oAccessDevList;
    }

    private boolean validateDevInfo(AbstractDevInfoObj devInfoObj) {
        String strDevAddress = devInfoObj.getDevAddress().trim();
        if (-2147483647 <= devInfoObj.getErrorCode() && 0 > devInfoObj.getErrorCode()) {
            return false;
        }
        if (strDevAddress.equals("")) {
            String strMsg = this.m_oResManager.getResString("DEVICE_ADDRESS_EMPTY");
            devInfoObj.setOprResult(strMsg);
            return false;
        }
        return 0 != devInfoObj.getErrorCode();
    }

    public Enumeration getAllOptixInfo() {
        return this.getRoot().children();
    }

    @Override
    protected int getDomain() {
        return 3;
    }

    @Override
    protected AbstractDevInfoObj getDefaultDevInfoObj() {
        return new AccessDevInfoObj();
    }

    @Override
    public void checkRightForPopupMenu() {
        super.checkRightForPopupMenu();
        if (null != this.m_deleteRowMenuItem && null != this.oBasePnl) {
            this.m_deleteRowMenuItem.setEnabled(this.oBasePnl.isDeleteBtnEnable());
        }
    }
}

