/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCGUIUtil;
import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.DeviceTreeTableCellRenderer;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.OptixDevInfoObj;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractDeviceInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1769421964009919956L;
    private static String m_strStyle = "<html>REPLACE<a color='red'>*</a></html>";
    private DCSortableTreeTable m_sortTreeTable;
    private AbstractSortTreeTableModel m_sortTreeTableModel;
    private TreeTableNode m_root;
    protected JLabel m_statLbl;
    private String m_strStat;
    protected ResourceManager m_oResManager = ResourceManager.getInstance();
    protected TableCellRenderer defaultTableHeaderRender;
    protected JPopupMenu m_oDevTablePopupMenu;
    protected JScrollPane m_scrollPane;

    public AbstractDeviceInfoPanel() {
        this.setLayout(new BorderLayout(0, 10));
        this.m_oResManager = ResourceManager.getInstance();
    }

    public void initializeTreeTable(AbstractSortTreeTableModel sortTreeTableModel) {
        this.initializeTreeTable(sortTreeTableModel, false);
    }

    public void initializeTreeTable(AbstractSortTreeTableModel sortTreeTableModel, boolean isEditable) {
        this.m_sortTreeTableModel = sortTreeTableModel;
        this.m_sortTreeTable = new DCSortableTreeTable(this.m_sortTreeTableModel, true, isEditable);
        this.m_sortTreeTable.setName("DeviceView_DeviceTablePanel_m_oDeviceTreeTable");
        this.defaultTableHeaderRender = this.m_sortTreeTable.getTableHeader().getDefaultRenderer();
        this.m_sortTreeTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDeviceInfoPanel.this.stopAllCellEditor();
                    }
                });
            }
        });
        this.m_sortTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractDeviceInfoPanel.this.deviceTable_MousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractDeviceInfoPanel.this.updateSelectionState();
            }
        });
        this.m_sortTreeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int iKeyCode = e.getKeyCode();
                if (65 == iKeyCode && 2 == e.getModifiers()) {
                    AbstractDeviceInfoPanel.this.updateSelectionState();
                } else if (38 == iKeyCode || 40 == iKeyCode) {
                    AbstractDeviceInfoPanel.this.updateSelectionState();
                } else {
                    DCDebugTracer.trace("dc won't handle the other key.");
                }
            }
        });
        this.m_sortTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_sortTreeTable.setShowHorizontalLines(true);
        this.m_sortTreeTable.setShowVerticalLines(true);
        this.m_sortTreeTable.setRowHeight(20);
        this.m_sortTreeTable.setDefaultRenderer(String.class, new DeviceTreeTableCellRenderer(this.m_sortTreeTable));
        this.m_scrollPane = new JScrollPane((Component)((Object)this.m_sortTreeTable));
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractDeviceInfoPanel.this.deviceTable_MousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int iClickedRow;
                if (e.getButton() == 1 && (iClickedRow = AbstractDeviceInfoPanel.this.m_sortTreeTable.rowAtPoint(e.getPoint())) == -1 && null != AbstractDeviceInfoPanel.this.m_oDevTablePopupMenu) {
                    AbstractDeviceInfoPanel.this.checkRightForPopupMenu();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDeviceInfoPanel.this.stopAllCellEditor();
                    }
                });
            }
        });
        this.m_strStat = this.m_oResManager.getResString("LBL_SELECT_DEVICE_COUNT");
        this.m_statLbl = new JLabel();
        this.m_statLbl.setName("com.huawei.dc.standalone.view.m_statLbl");
        this.m_root = this.m_sortTreeTableModel.getRoot();
        this.add((Component)this.m_scrollPane, "Center");
        this.add((Component)this.m_statLbl, "South");
    }

    protected void registPopuMenu(JPopupMenu popupMenu) {
        this.m_oDevTablePopupMenu = popupMenu;
    }

    public abstract void checkRightForPopupMenu();

    protected abstract AbstractDevInfoObj getDefaultDevInfoObj();

    public DCSortableTreeTable getTreeTable() {
        return this.m_sortTreeTable;
    }

    public TreeTableNode getRoot() {
        return this.m_root;
    }

    protected static String getHeaderEndWithStar(String str) {
        return m_strStyle.replaceAll("REPLACE", str);
    }

    protected void notifyResult(Resource res, int iErrCode) {
        int iChildCount = this.m_root.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            AbstractDevInfoObj devInfoObj = (AbstractDevInfoObj)((TreeTableNode)this.m_root.getChildAt(i)).getUserObject();
            if (res.getDeviceID() != devInfoObj.getDevID()) continue;
            devInfoObj.setErrorCode(iErrCode);
            devInfoObj.setDevName(res.getDeviceName());
            this.m_sortTreeTable.repaint();
            break;
        }
    }

    protected void updateSelectionState() {
        int iRowCount;
        int iSelectedRowCount = this.m_sortTreeTable.getSelectedRowCount();
        if (iSelectedRowCount > (iRowCount = this.getNodeCount())) {
            iSelectedRowCount = iRowCount;
        }
        String strDeviceCountMsg = MessageFormat.format(this.m_strStat, "" + iSelectedRowCount, "" + iRowCount);
        this.m_statLbl.setText(StringUtils.getHtmlString(strDeviceCountMsg));
    }

    private int getNodeCount() {
        Enumeration<TreeNode> enu = this.m_root.breadthFirstEnumeration();
        int iCount = 0;
        try {
            while (enu.hasMoreElements()) {
                TreeNode obj = enu.nextElement();
                if (this.m_root.equals(obj)) continue;
                ++iCount;
            }
            return iCount;
        }
        catch (Exception e) {
            DCDebugTracer.trace("DC::failed to get node count");
            return iCount;
        }
    }

    public void stopAllCellEditor() {
        if (null != this.m_sortTreeTable.getCellEditor()) {
            this.m_sortTreeTable.getCellEditor().stopCellEditing();
            this.m_sortTreeTable.updateUI();
        }
    }

    private void deviceTable_MousePressed(MouseEvent oMouseEvent) {
        int iClickedRow;
        if (oMouseEvent.getButton() == 1 && (iClickedRow = this.m_sortTreeTable.rowAtPoint(oMouseEvent.getPoint())) == -1 && null != this.m_oDevTablePopupMenu) {
            this.stopAllCellEditor();
            this.checkRightForPopupMenu();
            this.updateSelectionState();
        }
        if (0 != (4 & oMouseEvent.getModifiers()) && null != this.m_oDevTablePopupMenu) {
            this.checkRightForPopupMenu();
            this.m_oDevTablePopupMenu.show(oMouseEvent.getComponent(), oMouseEvent.getX(), oMouseEvent.getY());
        }
    }

    public void addNewRow(int iKeyMode) {
        AbstractDevInfoObj devInfoObj = this.getDefaultDevInfoObj();
        if (null != devInfoObj) {
            devInfoObj.setKeyMode(iKeyMode);
            TreeTableNode node = new TreeTableNode(devInfoObj);
            if (null != node) {
                this.m_root.add(node);
                DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_sortTreeTable));
                this.updateSelectionState();
            }
        }
    }

    public void addNewRow() {
        AbstractDevInfoObj devInfoObj = this.getDefaultDevInfoObj();
        if (null != devInfoObj) {
            devInfoObj.setKeyMode(0);
            TreeTableNode node = new TreeTableNode(devInfoObj);
            if (null != node) {
                this.m_root.add(node);
                DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_sortTreeTable));
                this.updateSelectionState();
            }
        }
    }

    public void addNewRow(AbstractDevInfoObj devInfoObj) {
        if (null != devInfoObj) {
            TreeTableNode node = new TreeTableNode(devInfoObj);
            this.m_root.add(node);
            DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_sortTreeTable));
            this.updateSelectionState();
        }
    }

    public void addAllRow(List<OptixDevInfoObj> m_oListDevInfo) {
        for (int i = 0; i < m_oListDevInfo.size(); ++i) {
            if (null == m_oListDevInfo.get(i)) continue;
            TreeTableNode node = new TreeTableNode(m_oListDevInfo.get(i));
            if (node.getUserObject() instanceof AbstractDevInfoObj) {
                AbstractDevInfoObj obj = (AbstractDevInfoObj)node.getUserObject();
                if (!"".equals(obj.getOprResult().trim())) continue;
                this.m_root.add(node);
                continue;
            }
            this.m_root.add(node);
        }
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_sortTreeTable));
        this.updateSelectionState();
    }

    public void deleteRow() {
        if (null != this.m_sortTreeTable.getCellEditor()) {
            this.m_sortTreeTable.getCellEditor().stopCellEditing();
            this.m_sortTreeTable.updateUI();
        }
        JTree tree = this.m_sortTreeTable.getTree();
        TreePath[] selectedPaths = tree.getSelectionPaths();
        int iSelectedNodeCount = selectedPaths.length;
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreeTableNode tmpNode = (TreeTableNode)selectedPaths[i].getLastPathComponent();
            tmpNode.removeFromParent();
        }
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_sortTreeTable));
        this.updateSelectionState();
    }

    public void selectAllRow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractDeviceInfoPanel.this.stopAllCellEditor();
                AbstractDeviceInfoPanel.this.m_sortTreeTable.selectAll();
                AbstractDeviceInfoPanel.this.updateSelectionState();
            }
        });
    }

    public void selectRow(final int begin, final int end) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractDeviceInfoPanel.this.stopAllCellEditor();
                AbstractDeviceInfoPanel.this.m_sortTreeTable.setRowSelectionInterval(begin, end);
            }
        });
    }

    protected void showRow(int iRow) {
        this.m_scrollPane.validate();
        JScrollBar vScroll = this.m_scrollPane.getVerticalScrollBar();
        vScroll.setValue(DCGUIUtil.calculateScrollValue(iRow, vScroll.getMaximum(), this.m_sortTreeTable.getRowCount()));
        DCFrameWorkUtil.updateUI(vScroll);
        DCFrameWorkUtil.updateUI(this.m_scrollPane);
    }

    public void deleteAllEmptyRow() {
        Enumeration<TreeNode> enu = this.m_root.breadthFirstEnumeration();
        Vector<TreeTableNode> oNodeVec = new Vector<TreeTableNode>();
        while (enu.hasMoreElements()) {
            TreeTableNode oNode = (TreeTableNode)enu.nextElement();
            AbstractDevInfoObj oNodeInfo = (AbstractDevInfoObj)oNode.getUserObject();
            if (null == oNodeInfo || !"".equals(oNodeInfo.getOprResult().trim())) continue;
            oNodeVec.add(oNode);
        }
        for (TreeTableNode oNode : oNodeVec) {
            oNode.removeFromParent();
        }
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_sortTreeTable));
        this.updateSelectionState();
    }

    protected abstract List getSelectedDevInfoLst();

    protected abstract List getAllDevInfoLst();

    protected abstract int getDomain();

    protected abstract void updateCreateBtnStatus();
}

