/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.startup;

import com.huawei.dc.common.asndatacenter.AsnDCConfirmStartupStatusRsp;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.CommManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.StandAloneInitializer;
import com.huawei.dc.standalone.startup.DCStandaloneDebugTracer;
import com.huawei.dc.standalone.startup.StartupAsyncCtrller;
import com.swimap.iview.framework.Main;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Locale;
import net.commustru.fstru.FStruct;

public class StandAloneMain {
    private static final int DEFAULT_TIME_OUT = 500;
    private CommManagerImpl m_oCommManager;

    private static boolean isExistOtherDC() {
        File file = new File("app.lock");
        return file.exists() && !file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAppFile() {
        File file = new File("app.lock");
        RandomAccessFile randomAccessFile = null;
        AbstractInterruptibleChannel channel = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            channel = randomAccessFile.getChannel();
            ((FileChannel)channel).lock();
            DCStandaloneDebugTracer.trace("success to lock app.lock.");
        }
        catch (Exception e) {
            DCStandaloneDebugTracer.trace("fail to lock app.lock.");
            DCStandaloneDebugTracer.trace(e);
        }
        finally {
            if (null != channel) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != randomAccessFile) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
        }
    }

    private boolean notifyOtherDC(boolean isNeedMsg) {
        block5: {
            DCStandaloneDebugTracer.trace("notifyOtherDC.");
            try {
                int errorcode = this.iniCommunicateService(isNeedMsg);
                if (0 == errorcode) {
                    AsnDCConfirmStartupStatusRsp oRsp = new AsnDCConfirmStartupStatusRsp();
                    errorcode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44076, 255), null, (FStruct)oRsp, 500);
                    this.m_oCommManager.getCommHandle().close();
                    if (0 != errorcode) {
                        DCStandaloneDebugTracer.trace("DC::notifyOtherDC--fail to notify other dc, the error is " + errorcode);
                        return false;
                    }
                    if (0 == oRsp.oStartupStatus.value) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (Exception ioEx) {
                DCStandaloneDebugTracer.trace(ioEx);
                return false;
            }
        }
        return true;
    }

    private int iniCommunicateService(boolean isNeedMessage) {
        this.m_oCommManager = new CommManagerImpl();
        int iConnectionStatus = this.m_oCommManager.initializeComm("127.0.0.1", 9800, "Common");
        if (0 != iConnectionStatus) {
            DCStandaloneDebugTracer.trace("DC::registerStandAloneClient--commManager-initializeComm error,return:" + iConnectionStatus);
            if (isNeedMessage) {
                DCOptionPane.showErrorDialog(null, ResourceManager.getInstance().getResString("LOGIN_MDP_SETTING_ERROR"));
            }
        }
        return iConnectionStatus;
    }

    private void registerStandAloneClient() {
        DCFrameWorkUtil.setCommManager(this.m_oCommManager);
        StartupAsyncCtrller.getInstance();
    }

    private boolean checkAndSetDebugMode() {
        boolean isDebugMode = false;
        String strDebugMode = ResourceManager.getInstance().getResString("Data_Center_Execution_Mode", "config");
        DCStandaloneDebugTracer.trace("the debug mode is " + strDebugMode);
        if ("0".equalsIgnoreCase(strDebugMode)) {
            isDebugMode = true;
        }
        DCStandaloneDebugTracer.trace("the new debug mode is " + isDebugMode);
        System.getProperties().put("DCStandaloneDebugMode", (Object)isDebugMode);
        return isDebugMode;
    }

    private boolean checkIsForWebLCT() {
        File oCurrFileWithDot = new File(".");
        File oCurrFile = new File(oCurrFileWithDot.getAbsolutePath());
        String strNeListDirPath = (oCurrFile = oCurrFile.getParentFile()).getParent() + File.separator + "nelist";
        File oNeListDir = new File(strNeListDirPath);
        if (oNeListDir.exists()) {
            DCStandaloneDebugTracer.trace("checkIsForWebLCT:oNeListDir.exists");
            StandAloneDomainInfo.getInstance().updateSelectInfo(4, false);
            System.getProperties().put("StandaloneForWebLCT", (Object)true);
            return true;
        }
        DCStandaloneDebugTracer.trace("checkIsForWebLCT:return false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultLocale() {
        String language = "zh";
        String country = "CN";
        try {
            Locale m_oSystemLocale = Locale.getDefault();
            language = m_oSystemLocale.getLanguage();
            country = m_oSystemLocale.getCountry();
        }
        catch (Exception ioEx) {
            DCStandaloneDebugTracer.trace(ioEx);
        }
        finally {
            DCDebugTracer.trace("DC::StandAloneMain::setDefaultLocale##fileInputStream is null");
        }
        Locale.setDefault(new Locale(language, country));
    }

    public static void main(String[] args) {
        DCFrameWorkUtil.setInstallMode(0);
        int RETRY_TIMES = 3;
        StandAloneMain oStandAloneMain = new StandAloneMain();
        boolean isSuccess = false;
        boolean isExistOtherDC = false;
        int iRetryTimes = 1;
        while (!isSuccess) {
            isExistOtherDC = StandAloneMain.isExistOtherDC();
            if (!isExistOtherDC) {
                DCStandaloneDebugTracer.trace("startup dc");
                StandAloneMain.startServer();
                break;
            }
            DCStandaloneDebugTracer.trace("exist other dc");
            isSuccess = oStandAloneMain.notifyOtherDC(false);
            if (++iRetryTimes < 3) continue;
            DCOptionPane.showErrorDialog(null, ResourceManager.getInstance().getResString("MULTIPLE_DC_INSTANCE_ERROR"));
            break;
        }
        DCStandaloneDebugTracer.trace("exist main.");
    }

    private static void startServer() {
        int iErrCode;
        StandAloneMain oStandAloneMain = new StandAloneMain();
        oStandAloneMain.setDefaultLocale();
        oStandAloneMain.lockAppFile();
        boolean isSuccessToStartupMDP = true;
        if (!oStandAloneMain.checkAndSetDebugMode()) {
            try {
                DCStandaloneDebugTracer.trace("start mdp.");
                StandAloneInitializer.getInstance().startMDP();
            }
            catch (Exception e) {
                DCStandaloneDebugTracer.trace(e);
                DCOptionPane.showErrorDialog(null, e.getMessage());
                isSuccessToStartupMDP = false;
            }
        }
        if (isSuccessToStartupMDP && 0 == (iErrCode = oStandAloneMain.iniCommunicateService(true))) {
            oStandAloneMain.registerStandAloneClient();
            oStandAloneMain.checkIsForWebLCT();
            Main.main((String[])new String[0]);
        }
    }
}

