/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.snmpparams.SNMPParamTableManager;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPParamTemplateDlg;
import com.huawei.dc.standalone.snmpparams.view.ISNMPParamsDlg;
import com.huawei.dc.standalone.snmpparams.view.SNMPParamTabPanel;
import com.huawei.dc.standalone.view.ModifyDeviceDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class ShowSNMPParamsDlg
extends DCModalDialog
implements ISNMPParamsDlg {
    private static final long serialVersionUID = 1L;
    private JButton m_oAddButton;
    private JButton m_oDeleteButton;
    private static final char ADD_BUTTON_MNEMONIC = 'A';
    private static final char DELETE_BUTTON_MNEMONIC = 'D';
    public static final int TEMPLATE_NAME_COLUMN = 0;
    public static final int VERSION_COLUMN = 1;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private SNMPParamTableManager m_oManager;
    private SNMPParamTabPanel m_oTabbedPane;
    private SnmpParaInfo m_oParaInfo;

    public ShowSNMPParamsDlg(DCModalDialog window) throws DCException {
        this.setSize(750, 450);
        this.setTitle(this.m_oResManager.getResString("SNMP_PARAMETER_DIALOG_TITLE"));
        if (null != window) {
            this.setLocationRelativeTo((Component)((Object)window));
        }
        this.m_oTabbedPane = new SNMPParamTabPanel(true);
        this.createButtons();
        this.m_oTabbedPane.setDeleteButton(this.m_oDeleteButton);
        this.addComponentsToDialog();
        this.setAttributesForTable();
        this.m_oManager = new SNMPParamTableManager(this);
        this.m_oManager.populateParamsForAllVersions();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    public ShowSNMPParamsDlg(ModifyDeviceDialog oAddDevicePanel) throws DCException {
        super(oAddDevicePanel);
        this.setSize(750, 450);
        this.setTitle(this.m_oResManager.getResString("SNMP_PARAMETER_DIALOG_TITLE"));
        this.m_oTabbedPane = new SNMPParamTabPanel(true);
        this.createButtons();
        this.m_oTabbedPane.setDeleteButton(this.m_oDeleteButton);
        this.addComponentsToDialog();
        this.setAttributesForTable();
        this.m_oManager = new SNMPParamTableManager(this);
        this.m_oManager.populateParamsForAllVersions();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    @Override
    public int getSelectedVersion() {
        return this.m_oTabbedPane.getSelectedVersion();
    }

    @Override
    public JTable getTableForVersion(int iVersion) {
        return this.m_oTabbedPane.getTableForVersion(iVersion);
    }

    @Override
    public void refreshTable() {
        this.m_oTabbedPane.refreshTable();
    }

    @Override
    public void resetTableSelection(JTable oTable, int iFirstSelectedRow, int iTotalRowCount) {
        this.m_oTabbedPane.resetTableSelection(oTable, iFirstSelectedRow, iTotalRowCount);
    }

    private void createButtons() {
        this.m_oAddButton = new JButton(this.m_oResManager.getResString("ADD_SNMP_TEMPLATE_BTN"));
        this.m_oAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSNMPParamsDlg.this.addButton_ActionPerformed();
            }
        });
        this.m_oAddButton.setMnemonic('A');
        this.m_oDeleteButton = new JButton(this.m_oResManager.getResString("DELETE_SNMP_TEMPLATE_BTN"));
        this.m_oDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSNMPParamsDlg.this.deleteSelSNMPTemplate();
            }
        });
        this.m_oDeleteButton.setMnemonic('D');
        this.m_oOKBtn.setText(this.m_oResManager.getResString("OK_BTN"));
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("CANCEL_BTN"));
    }

    private void addComponentsToDialog() {
        Container oContentPane = this.getContentPane();
        oContentPane.setLayout(null);
        this.m_oTabbedPane.setBounds(10, 15, 722, 360);
        oContentPane.add(this.m_oTabbedPane);
        this.m_oAddButton.setBounds(342, 385, 90, 21);
        this.m_oAddButton.setFocusable(true);
        oContentPane.add(this.m_oAddButton);
        this.m_oDeleteButton.setBounds(442, 385, 90, 21);
        this.m_oDeleteButton.setFocusable(true);
        oContentPane.add(this.m_oDeleteButton);
        this.m_oOKBtn.setBounds(542, 385, 90, 21);
        this.m_oOKBtn.setFocusable(true);
        oContentPane.add(this.m_oOKBtn);
        this.m_oCancelBtn.setBounds(642, 385, 90, 21);
        this.m_oCancelBtn.setFocusable(true);
        oContentPane.add(this.m_oCancelBtn);
    }

    private void setAttributesForTable() {
        JTable oSNMPTable = this.m_oTabbedPane.getSNMPV1Table();
        this.addDeleteKeyHandlerToTable(oSNMPTable);
        oSNMPTable = this.m_oTabbedPane.getSNMPV2Table();
        this.addDeleteKeyHandlerToTable(oSNMPTable);
        oSNMPTable = this.m_oTabbedPane.getSNMPV3Table();
        this.addDeleteKeyHandlerToTable(oSNMPTable);
    }

    private void addDeleteKeyHandlerToTable(JTable oTable) {
        ActionListener oDelKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowSNMPParamsDlg.this.deleteSelSNMPTemplate();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        oTable.registerKeyboardAction(oDelKeyHandler, keyStroke, 2);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_SNMP_CONFIG";
    }

    private void addButton_ActionPerformed() {
        AddSNMPParamTemplateDlg oDlg = new AddSNMPParamTemplateDlg(this);
        oDlg.setVisible(true);
        if (null != this.m_oTabbedPane) {
            this.m_oTabbedPane.refreshTable();
        }
    }

    public SNMPParamTableManager getManager() {
        return this.m_oManager;
    }

    @Override
    protected void oKButton_ActionPerformed() {
        this.m_oParaInfo = this.m_oManager.getSelectedParaInfo();
        if (null == this.m_oParaInfo) {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.m_oResManager.getResString("SNMP_NO_PARA_SELECTED"), this.m_oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
            return;
        }
        this.closeDialog();
    }

    private void deleteSelSNMPTemplate() {
        JTable oTable = this.m_oTabbedPane.getTableForVersion(this.m_oTabbedPane.getSelectedVersion());
        int iSelRowCount = oTable.getSelectedRowCount();
        if (1 == iSelRowCount && "default".equalsIgnoreCase((String)oTable.getValueAt(oTable.getSelectedRow(), 0))) {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.m_oResManager.getResString("DEFAULT_SNMP_TEMPLATE_CANNOT_BE_DELETED"), this.m_oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
            return;
        }
        int iConfirm = DCOptionPane.showConfirmDialog((Component)((Object)this), this.m_oResManager.getResString("DELETE_SNMP_TEMPLATE_CONFIRMATION_MSG"), this.m_oResManager.getResString("CONFIRM"), 0);
        if (iConfirm != 0) {
            return;
        }
        SnmpParaInfo oSnmpParaInfo = this.m_oManager.deleteSelectedTemplates();
        if (null == oSnmpParaInfo) {
            return;
        }
    }

    public SnmpParaInfo getSNMPParaInfo() {
        return this.m_oParaInfo;
    }
}

