/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.deviceselection.table.DCDefaultTableRenderer;
import com.huawei.dc.common.components.table.DefaultTableColumnComparator;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.snmpparams.SNMPParamUtil;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPCommonParameterPanel;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPParamTemplatePanel;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPSecurityParameterPanel;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SNMPParamTabPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane m_oSNMPV1ScrollPane;
    private JTable m_oSNMPV1Table;
    private JScrollPane m_oSNMPV2ScrollPane;
    private JTable m_oSNMPV2Table;
    private JScrollPane m_oSNMPV3ScrollPane;
    private JTable m_oSNMPV3Table;
    private JTabbedPane m_oTabbedPane;
    private int m_iVersionColumn = -1;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private JButton m_oDeleteButton = null;
    private boolean m_bIsAddDeviceOpt = true;
    private AddSNMPParamTemplatePanel m_oSnmpParamTempPnl = null;
    private AddSNMPCommonParameterPanel m_oSnmpCommonParamPnl = null;
    private AddSNMPSecurityParameterPanel m_oSnmpSecurityParameterPanel = null;
    private JTabbedPane snmpOptionTabbedPane;
    private int TAB_INDEX = 1;
    private int rowCount = 0;
    private IDCStandAloneSyncCtrller m_oSyncController = StandAloneSyncCtrller.getInstance();
    private final String[] TABLE_HEADER_SNMP_V1V2 = new String[]{this.m_oResManager.getResString("SNMP_TABLE_TEMPLATE_NAME"), this.m_oResManager.getResString("SNMP_TABLE_VERSION"), this.m_oResManager.getResString("SNMP_TABLE_GET_COMMUNITY"), this.m_oResManager.getResString("SNMP_TABLE_SET_COMMUNITY"), this.m_oResManager.getResString("SNMP_TABLE_TIMEOUT_INTERVAL"), this.m_oResManager.getResString("SNMP_TABLE_RETRIES"), this.m_oResManager.getResString("SNMP_TABLE_POLL_INTERVALS"), this.m_oResManager.getResString("SNMP_TABLE_DEVICE_PORT")};
    private final String[] TABLE_HEADER_SNMP_V3 = new String[]{this.m_oResManager.getResString("SNMP_TABLE_TEMPLATE_NAME"), this.m_oResManager.getResString("SNMP_TABLE_VERSION"), this.m_oResManager.getResString("SNMP_TABLE_TIMEOUT_INTERVAL"), this.m_oResManager.getResString("SNMP_TABLE_RETRIES"), this.m_oResManager.getResString("SNMP_TABLE_POLL_INTERVALS"), this.m_oResManager.getResString("SNMP_TABLE_DEVICE_PORT"), this.m_oResManager.getResString("SNMP_TABLE_DEVICE_USER"), this.m_oResManager.getResString("SNMP_TABLE_CONTEXT_NAME"), this.m_oResManager.getResString("SNMP_TABLE_CONTEXT_ENGINE_ID"), this.m_oResManager.getResString("SNMP_TABLE_DATA_ENCRYPTION"), this.m_oResManager.getResString("SNMP_TABLE_AUTHENTICATION")};
    private final String[] TABLE_HEADER_DEVICE_ACCESS_SNMP_V3 = new String[]{this.m_oResManager.getResString("SNMP_TABLE_DEVICE_NAME"), this.m_oResManager.getResString("SNMP_TABLE_DEVICE_IP"), this.m_oResManager.getResString("SNMP_TABLE_VERSION"), this.m_oResManager.getResString("SNMP_TABLE_TIMEOUT_INTERVAL"), this.m_oResManager.getResString("SNMP_TABLE_RETRIES"), this.m_oResManager.getResString("SNMP_TABLE_POLL_INTERVALS"), this.m_oResManager.getResString("SNMP_TABLE_DEVICE_PORT"), this.m_oResManager.getResString("SNMP_TABLE_DEVICE_USER"), this.m_oResManager.getResString("SNMP_TABLE_CONTEXT_NAME"), this.m_oResManager.getResString("SNMP_TABLE_CONTEXT_ENGINE_ID"), this.m_oResManager.getResString("SNMP_TABLE_DATA_ENCRYPTION"), this.m_oResManager.getResString("SNMP_TABLE_AUTHENTICATION")};
    public final String[] TABLE_HEADER_DEVICE_ACCESS_SNMP_V1V2 = new String[]{this.m_oResManager.getResString("SNMP_TABLE_DEVICE_NAME"), this.m_oResManager.getResString("SNMP_TABLE_DEVICE_IP"), this.m_oResManager.getResString("SNMP_TABLE_VERSION"), this.m_oResManager.getResString("SNMP_TABLE_GET_COMMUNITY"), this.m_oResManager.getResString("SNMP_TABLE_SET_COMMUNITY"), this.m_oResManager.getResString("SNMP_TABLE_TIMEOUT_INTERVAL"), this.m_oResManager.getResString("SNMP_TABLE_RETRIES"), this.m_oResManager.getResString("SNMP_TABLE_POLL_INTERVALS"), this.m_oResManager.getResString("SNMP_TABLE_DEVICE_PORT")};
    private static final int DEVICE_ACCESS_COLUMN_COUNT = 9;

    public SNMPParamTabPanel(boolean bIsAddDeviceOpt) {
        this.m_bIsAddDeviceOpt = bIsAddDeviceOpt;
        this.initTabbedPanel();
        this.createTables();
        this.m_oSnmpSecurityParameterPanel = new AddSNMPSecurityParameterPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_oTabbedPane, "Center");
        this.setSelectionForAllTables();
    }

    private void initTabbedPanel() {
        this.m_oTabbedPane = new JTabbedPane();
        if (this.m_bIsAddDeviceOpt) {
            return;
        }
        this.m_oTabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int iSelectedVersion = SNMPParamTabPanel.this.getSelectedVersion();
                JTable oTable = SNMPParamTabPanel.this.getTableForVersion(iSelectedVersion);
                if (0 != oTable.getRowCount()) {
                    SNMPParamTabPanel.this.resetTableSelection(oTable, 0, 0);
                }
                SNMPParamTabPanel.this.refreshTable();
            }
        });
    }

    public JTabbedPane getTabbedPane() {
        return this.m_oTabbedPane;
    }

    private void createTables() {
        this.addSNMPV1Table();
        this.addSNMPV2Table();
        this.addSNMPV3Table();
    }

    private void addSNMPV1Table() {
        this.m_oSNMPV1Table = this.initTableColumnSNMPV1V2();
        this.setTableColumnSize(this.m_oSNMPV1Table);
        this.addListenerForTable(this.m_oSNMPV1Table);
        this.m_oSNMPV1ScrollPane = new JScrollPane(this.m_oSNMPV1Table);
        this.m_oSNMPV1Table.setAutoResizeMode(0);
        this.setAttributesForTable(this.m_oSNMPV1Table);
        this.m_oSNMPV1Table.setSelectionMode(0);
        this.m_oSNMPV1Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SNMPParamTabPanel.this.rowCount != SNMPParamTabPanel.this.m_oSNMPV1Table.getSelectedRow()) {
                    SNMPParamTabPanel.this.refreshTablePanel(SNMPParamTabPanel.this.m_oSNMPV1Table);
                    SNMPParamTabPanel.this.rowCount = SNMPParamTabPanel.this.m_oSNMPV1Table.getSelectedRow();
                }
            }
        });
        this.m_oTabbedPane.addTab(this.m_oResManager.getResString("SNMP_V1_TAB_NAME"), this.m_oSNMPV1ScrollPane);
    }

    private JTable initTableColumnSNMPV1V2() {
        JTable oTable;
        if (this.m_bIsAddDeviceOpt) {
            this.m_iVersionColumn = 1;
            oTable = new JTable(this.getDefaultTableModel(this.TABLE_HEADER_SNMP_V1V2));
        } else {
            this.m_iVersionColumn = 2;
            oTable = new JTable(this.getDefaultTableModel(this.TABLE_HEADER_DEVICE_ACCESS_SNMP_V1V2));
        }
        return oTable;
    }

    private void addSNMPV2Table() {
        this.m_oSNMPV2Table = this.initTableColumnSNMPV1V2();
        this.setTableColumnSize(this.m_oSNMPV2Table);
        this.addListenerForTable(this.m_oSNMPV2Table);
        this.m_oSNMPV2ScrollPane = new JScrollPane(this.m_oSNMPV2Table);
        this.m_oSNMPV2Table.setAutoResizeMode(0);
        this.setAttributesForTable(this.m_oSNMPV2Table);
        this.m_oSNMPV2Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SNMPParamTabPanel.this.rowCount != SNMPParamTabPanel.this.m_oSNMPV2Table.getSelectedRow()) {
                    SNMPParamTabPanel.this.refreshTablePanel(SNMPParamTabPanel.this.m_oSNMPV2Table);
                    SNMPParamTabPanel.this.rowCount = SNMPParamTabPanel.this.m_oSNMPV2Table.getSelectedRow();
                }
            }
        });
        this.m_oTabbedPane.addTab(this.m_oResManager.getResString("SNMP_V2_TAB_NAME"), this.m_oSNMPV2ScrollPane);
    }

    private void addSNMPV3Table() {
        this.m_oSNMPV3Table = this.initTableColumnSNMPV3();
        this.m_oSNMPV3Table.setAutoResizeMode(0);
        this.setTableColumnSize(this.m_oSNMPV3Table);
        this.addListenerForTable(this.m_oSNMPV3Table);
        this.m_oSNMPV3Table.setMinimumSize(new Dimension(850, 800));
        this.m_oSNMPV3ScrollPane = new JScrollPane(this.m_oSNMPV3Table);
        this.setAttributesForTable(this.m_oSNMPV3Table);
        this.m_oSNMPV3Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SNMPParamTabPanel.this.rowCount != SNMPParamTabPanel.this.m_oSNMPV3Table.getSelectedRow()) {
                    SNMPParamTabPanel.this.refreshTablePanel(SNMPParamTabPanel.this.m_oSNMPV3Table);
                    SNMPParamTabPanel.this.rowCount = SNMPParamTabPanel.this.m_oSNMPV3Table.getSelectedRow();
                }
            }
        });
        this.m_oTabbedPane.addTab(this.m_oResManager.getResString("SNMP_V3_TAB_NAME"), this.m_oSNMPV3ScrollPane);
    }

    private JTable initTableColumnSNMPV3() {
        JTable oTable = this.m_bIsAddDeviceOpt ? new JTable(this.getDefaultTableModel(this.TABLE_HEADER_SNMP_V3)) : new JTable(this.getDefaultTableModel(this.TABLE_HEADER_DEVICE_ACCESS_SNMP_V3));
        return oTable;
    }

    private void addListenerForTable(JTable oTable) {
        oTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SNMPParamTabPanel.this.refreshTable();
            }
        });
        oTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SNMPParamTabPanel.this.refreshTable();
            }
        });
    }

    private void setSelectionForAllTables() {
        if (0 < this.m_oSNMPV1Table.getRowCount()) {
            this.m_oSNMPV1Table.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (0 < this.m_oSNMPV2Table.getRowCount()) {
            this.m_oSNMPV2Table.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.m_bIsAddDeviceOpt && 0 < this.m_oSNMPV3Table.getRowCount()) {
            this.m_oSNMPV3Table.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.refreshTable();
    }

    private DefaultTableModel getDefaultTableModel(String[] arrTableHeader) {
        DefaultTableModel oDefaultTableModel = new DefaultTableModel(arrTableHeader, 0){
            private static final long serialVersionUID = -8492956267061517810L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public Object getValueAt(int row, int column) {
                Object oValue = super.getValueAt(row, column);
                if (SNMPParamTabPanel.this.m_iVersionColumn != column) {
                    return oValue;
                }
                if (oValue instanceof Integer) {
                    return SNMPParamUtil.getSNMPVersionName((Integer)oValue);
                }
                return "";
            }
        };
        return oDefaultTableModel;
    }

    private void setAttributesForTable(JTable oTable) {
        this.initializeTableHeader(oTable);
        this.initializeTableSelectionModel(oTable);
        oTable.setRowHeight(21);
        DCDefaultTableRenderer oRenderer = new DCDefaultTableRenderer();
        SortButtonRenderer oSortButtonRenderer = new SortButtonRenderer();
        int iColumnCount = oTable.getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            oTable.getColumnModel().getColumn(i).setCellRenderer(oRenderer);
            oTable.getColumnModel().getColumn(i).setHeaderRenderer((TableCellRenderer)oSortButtonRenderer);
        }
    }

    private MouseAdapter generateMouseAdapterForTableHeader(final JTable oTable) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SNMPParamTabPanel.this.paramTableHeaderMousePressed(e, oTable);
            }
        };
    }

    private void paramTableHeaderMousePressed(MouseEvent oEvent, JTable oTable) {
        if (0 == (0x10 & oEvent.getModifiers())) {
            return;
        }
        if (oTable.getRowCount() <= 0) {
            return;
        }
        int iCurrentColumn = oTable.getTableHeader().columnAtPoint(oEvent.getPoint());
        TableColumn oColumn = oTable.getColumnModel().getColumn(iCurrentColumn);
        if (null == oColumn) {
            return;
        }
        SortButtonRenderer oRenderer = (SortButtonRenderer)oColumn.getHeaderRenderer();
        boolean bSortType = oRenderer.getState(iCurrentColumn) == 1;
        this.sortColumn(iCurrentColumn, bSortType);
        oRenderer.setSelectedColumn(iCurrentColumn);
        this.refreshTable();
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int iSelectedVersion = SNMPParamTabPanel.this.getSelectedVersion();
                JTable oTable = SNMPParamTabPanel.this.getTableForVersion(iSelectedVersion);
                JScrollPane oScrollPane = SNMPParamTabPanel.this.getScrollPaneForVersion(iSelectedVersion);
                oTable.updateUI();
                ((JComponent)oScrollPane).updateUI();
                if (0 == oTable.getRowCount()) {
                    TableColumn oColumn;
                    if (null != SNMPParamTabPanel.this.m_oDeleteButton) {
                        SNMPParamTabPanel.this.m_oDeleteButton.setEnabled(false);
                    }
                    if (null == (oColumn = oTable.getColumnModel().getColumn(0))) {
                        return;
                    }
                    SortButtonRenderer oRenderer = (SortButtonRenderer)oColumn.getHeaderRenderer();
                    oRenderer.clearSortFlag();
                    if (null != SNMPParamTabPanel.this.m_oSnmpCommonParamPnl) {
                        SNMPParamTabPanel.this.m_oSnmpCommonParamPnl.changeCompentStaus(false);
                        SNMPParamTabPanel.this.m_oSnmpCommonParamPnl.setParamValue(null);
                        SNMPParamTabPanel.this.m_oSnmpParamTempPnl.fillValueToName("", iSelectedVersion);
                    }
                } else {
                    boolean delBtnState = true;
                    int[] rows = oTable.getSelectedRows();
                    for (int i = 0; i < rows.length; ++i) {
                        Object obj = oTable.getValueAt(oTable.getSelectedRow(), 0);
                        if (!(obj instanceof String) || !"default".equalsIgnoreCase((String)obj)) continue;
                        delBtnState = false;
                        break;
                    }
                    if (null != SNMPParamTabPanel.this.m_oSnmpCommonParamPnl) {
                        SNMPParamTabPanel.this.m_oSnmpCommonParamPnl.changeCompentStaus(true);
                    }
                    if (null != SNMPParamTabPanel.this.m_oDeleteButton) {
                        SNMPParamTabPanel.this.m_oDeleteButton.setEnabled(delBtnState);
                    }
                }
                if (!SNMPParamTabPanel.this.m_bIsAddDeviceOpt) {
                    if (2 == iSelectedVersion) {
                        SNMPParamTabPanel.this.m_oSnmpCommonParamPnl.setCommunityVisible(false);
                        SNMPParamTabPanel.this.m_oSnmpCommonParamPnl.reSetBounds(false);
                    } else {
                        SNMPParamTabPanel.this.m_oSnmpCommonParamPnl.setCommunityVisible(true);
                        SNMPParamTabPanel.this.m_oSnmpCommonParamPnl.reSetBounds(true);
                    }
                }
                SNMPParamTabPanel.this.updateDetailParam(oTable);
                oTable.getTableHeader().updateUI();
            }
        });
    }

    public void setDeleteButton(JButton oButton) {
        this.m_oDeleteButton = oButton;
    }

    public void setDevNamePanel(AddSNMPParamTemplatePanel oSnmpParamTempPnl) {
        this.m_oSnmpParamTempPnl = oSnmpParamTempPnl;
    }

    public void setDevParamPanel(AddSNMPCommonParameterPanel oSnmpCommonParamPnl) {
        this.m_oSnmpCommonParamPnl = oSnmpCommonParamPnl;
    }

    public void setDevTableParamPanel(JTabbedPane snmpTabbedPane) {
        this.snmpOptionTabbedPane = snmpTabbedPane;
    }

    public void updateDetailParam(JTable oTable) {
        if (null == this.m_oSnmpParamTempPnl || null == this.m_oSnmpCommonParamPnl) {
            return;
        }
        int iSelectedVersion = this.getSelectedVersion();
        if (null != this.snmpOptionTabbedPane) {
            if (iSelectedVersion != 2) {
                if (this.TAB_INDEX < this.snmpOptionTabbedPane.getTabCount()) {
                    this.snmpOptionTabbedPane.remove(this.TAB_INDEX);
                }
            } else if (this.TAB_INDEX == this.snmpOptionTabbedPane.getTabCount()) {
                int iTabIndex = this.TAB_INDEX;
                DCDebugTracer.trace("DC::SNMPParamTabPanel#updateDetailParam" + ++iTabIndex);
                this.snmpOptionTabbedPane.addTab(this.m_oResManager.getResString("SNMP_SECURITY_PARAMETERS"), this.m_oSnmpSecurityParameterPanel);
                this.snmpOptionTabbedPane.setEnabledAt(this.TAB_INDEX, true);
            }
        }
        try {
            DefaultTableModel oTableModel = (DefaultTableModel)oTable.getModel();
            Vector<Vector> oDataVector = oTableModel.getDataVector();
            int[] iSelectedRows = oTable.getSelectedRows();
            String strTempDevName = "";
            Vector oRowVector = oDataVector.get(iSelectedRows[0]);
            strTempDevName = oRowVector.get(0).toString();
            int iSnmpEnum = Integer.valueOf(oRowVector.get(2).toString());
            this.m_oSnmpParamTempPnl.fillValueToName(strTempDevName, iSnmpEnum);
            int iDevPort = 0;
            int iTimeout = 0;
            int iRetries = 0;
            int iPollInterval = 0;
            String strGetCommunity = null;
            String strSetCommunity = null;
            SnmpParaInfo oParaInfo = new SnmpParaInfo();
            if (iSelectedVersion != 2) {
                strGetCommunity = oRowVector.get(3).toString();
                strSetCommunity = oRowVector.get(4).toString();
                oParaInfo.setGetCommunity(strGetCommunity.toCharArray(), false);
                oParaInfo.setSetCommunity(strSetCommunity.toCharArray(), false);
                iDevPort = Integer.valueOf(oRowVector.get(8).toString());
                iTimeout = Integer.valueOf(oRowVector.get(5).toString());
                iRetries = Integer.valueOf(oRowVector.get(6).toString());
                iPollInterval = Integer.valueOf(oRowVector.get(7).toString());
            } else {
                iDevPort = Integer.valueOf(oRowVector.get(6).toString());
                iTimeout = Integer.valueOf(oRowVector.get(3).toString());
                iRetries = Integer.valueOf(oRowVector.get(4).toString());
                iPollInterval = Integer.valueOf(oRowVector.get(5).toString());
            }
            oParaInfo.setDevPort(iDevPort);
            oParaInfo.setTimeOut(iTimeout);
            oParaInfo.setRetries(iRetries);
            oParaInfo.setPollInterval(iPollInterval);
            if (iSelectedVersion == 2) {
                DeviceInfo oDevType = DeviceInfoManagerImpl.getInstance().getDeviceByIP(oRowVector.get(1).toString());
                Resource resource = new Resource();
                resource.setDeviceID(oDevType.getDevId());
                try {
                    oParaInfo = this.m_oSyncController.getSNMPParaForResource(resource);
                }
                catch (DCException e) {
                    DCDebugTracer.trace(e);
                }
            }
            for (int i = 1; i < iSelectedRows.length; ++i) {
                this.m_oSnmpParamTempPnl.fillValueToName("", iSnmpEnum);
                oRowVector = oDataVector.get(iSelectedRows[i]);
                if (iSelectedVersion != 2) {
                    if (!strGetCommunity.equals((String)oRowVector.get(3))) {
                        strGetCommunity = "";
                    }
                    if (!strSetCommunity.equals((String)oRowVector.get(4))) {
                        strSetCommunity = "";
                    }
                }
                if (iSelectedVersion != 2) {
                    if (iDevPort != Integer.valueOf(oRowVector.get(8).toString())) {
                        iDevPort = 0;
                    }
                    if (iTimeout != Integer.valueOf(oRowVector.get(5).toString())) {
                        iTimeout = 0;
                    }
                    if (iRetries != Integer.valueOf(oRowVector.get(6).toString())) {
                        iRetries = -1;
                    }
                    if (iPollInterval == Integer.valueOf(oRowVector.get(7).toString())) continue;
                    iPollInterval = -1;
                    continue;
                }
                if (iDevPort != Integer.valueOf(oRowVector.get(6).toString())) {
                    iDevPort = 0;
                }
                if (iTimeout != Integer.valueOf(oRowVector.get(3).toString())) {
                    iTimeout = 0;
                }
                if (iRetries != Integer.valueOf(oRowVector.get(4).toString())) {
                    iRetries = -1;
                }
                if (iPollInterval == Integer.valueOf(oRowVector.get(5).toString())) continue;
                iPollInterval = -1;
            }
            this.m_oSnmpCommonParamPnl.setParamValue(oParaInfo);
            if (this.snmpOptionTabbedPane.getTabCount() > this.TAB_INDEX) {
                this.m_oSnmpSecurityParameterPanel.initValue(oParaInfo);
            }
        }
        catch (NumberFormatException e) {
            DCDebugTracer.trace(e);
        }
    }

    public SnmpParaInfo getSnmpInfo() {
        SnmpParaInfo m_osnmpParaInfo = new SnmpParaInfo();
        m_osnmpParaInfo = this.m_oSnmpCommonParamPnl.getSnmpParaInfo();
        m_osnmpParaInfo.setSnmpEnum(this.getSelectedVersion());
        if (this.getSelectedVersion() == 2) {
            if (this.m_oSnmpSecurityParameterPanel.getDeviceUser() != null) {
                m_osnmpParaInfo.setUserName(this.m_oSnmpSecurityParameterPanel.getDeviceUser());
            }
            if (this.m_oSnmpSecurityParameterPanel.getContextName() != null) {
                m_osnmpParaInfo.setContextName(this.m_oSnmpSecurityParameterPanel.getContextName());
            }
            if (this.m_oSnmpSecurityParameterPanel.getContextEngineID() != null) {
                m_osnmpParaInfo.setContextId(this.m_oSnmpSecurityParameterPanel.getContextEngineID());
            }
            m_osnmpParaInfo.setAuthenticationType(this.m_oSnmpSecurityParameterPanel.getAuthentication());
            m_osnmpParaInfo.setDataEncryptionType(this.m_oSnmpSecurityParameterPanel.getDataEncryption());
            if (this.m_oSnmpSecurityParameterPanel.getAuthPassword() != null) {
                m_osnmpParaInfo.setAuthenticationPasswd(this.m_oSnmpSecurityParameterPanel.getAuthPassword(), false);
            }
            if (this.m_oSnmpSecurityParameterPanel.getEncryPassword() != null) {
                m_osnmpParaInfo.setEncrypPasswd(this.m_oSnmpSecurityParameterPanel.getEncryPassword(), false);
            }
        }
        return m_osnmpParaInfo;
    }

    public void refreshTablePanel(JTable ojtable) {
        DefaultTableModel oTableModel = (DefaultTableModel)ojtable.getModel();
        String strTempDevName = "";
        Vector oRowVector = oTableModel.getDataVector().get(ojtable.getSelectedRow());
        strTempDevName = oRowVector.get(0).toString();
        int iSnmpEnum = 0;
        iSnmpEnum = this.m_bIsAddDeviceOpt ? Integer.valueOf(oRowVector.get(1).toString()).intValue() : Integer.valueOf(oRowVector.get(2).toString()).intValue();
        if (null != this.m_oSnmpParamTempPnl) {
            this.m_oSnmpParamTempPnl.fillValueToName(strTempDevName, iSnmpEnum);
        }
        int iSelectedVersion = this.getSelectedVersion();
        int iDevPort = 0;
        int iTimeout = 0;
        int iRetries = 0;
        int iPollInterval = 0;
        SnmpParaInfo oParaInfo = new SnmpParaInfo();
        if (iSelectedVersion == 2) {
            if (this.m_bIsAddDeviceOpt) {
                iDevPort = Integer.valueOf(oRowVector.get(5).toString());
                iTimeout = Integer.valueOf(oRowVector.get(2).toString());
                iRetries = Integer.valueOf(oRowVector.get(3).toString());
                iPollInterval = Integer.valueOf(oRowVector.get(4).toString());
            } else {
                iDevPort = Integer.valueOf(oRowVector.get(6).toString());
                iTimeout = Integer.valueOf(oRowVector.get(3).toString());
                iRetries = Integer.valueOf(oRowVector.get(4).toString());
                iPollInterval = Integer.valueOf(oRowVector.get(5).toString());
            }
        } else {
            String strGetCommunity = oRowVector.get(3).toString();
            String strSetCommunity = oRowVector.get(4).toString();
            oParaInfo.setGetCommunity(strGetCommunity.toCharArray(), false);
            oParaInfo.setSetCommunity(strSetCommunity.toCharArray(), false);
            iDevPort = Integer.valueOf(oRowVector.get(8).toString());
            iTimeout = Integer.valueOf(oRowVector.get(5).toString());
            iRetries = Integer.valueOf(oRowVector.get(6).toString());
            iPollInterval = Integer.valueOf(oRowVector.get(7).toString());
        }
        oParaInfo.setDevPort(iDevPort);
        oParaInfo.setTimeOut(iTimeout);
        oParaInfo.setRetries(iRetries);
        oParaInfo.setPollInterval(iPollInterval);
        if (iSelectedVersion == 2) {
            DeviceInfo oDevType = DeviceInfoManagerImpl.getInstance().getDeviceByIP(oRowVector.get(1).toString());
            Resource resource = new Resource();
            try {
                resource.setDeviceID(oDevType.getDevId());
                oParaInfo = this.m_oSyncController.getSNMPParaForResource(resource);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        }
        this.m_oSnmpCommonParamPnl.setParamValue(oParaInfo);
        if (this.snmpOptionTabbedPane.getTabCount() > this.TAB_INDEX) {
            this.m_oSnmpSecurityParameterPanel.initValue(oParaInfo);
        }
        ojtable.getTableHeader().updateUI();
    }

    private void sortColumn(int iCurrentColumn, boolean bSortType) {
        int iSelectedVersion = this.getSelectedVersion();
        JTable oTable = this.getTableForVersion(iSelectedVersion);
        if (null == oTable) {
            return;
        }
        DefaultTableModel oModel = (DefaultTableModel)oTable.getModel();
        Vector<Vector> data = oModel.getDataVector();
        Collections.sort(data, new DefaultTableColumnComparator(iCurrentColumn, bSortType));
    }

    private void initializeTableSelectionModel(JTable oTable) {
        DefaultListSelectionModel oTaskSelection = new DefaultListSelectionModel();
        if (this.m_bIsAddDeviceOpt) {
            oTaskSelection.setSelectionMode(0);
        } else {
            oTaskSelection.setSelectionMode(2);
        }
        oTable.setSelectionModel(oTaskSelection);
    }

    public int getSelectedVersion() {
        Component oCurrentPane = this.m_oTabbedPane.getSelectedComponent();
        if (oCurrentPane.equals(this.m_oSNMPV1ScrollPane)) {
            return 0;
        }
        if (oCurrentPane.equals(this.m_oSNMPV2ScrollPane)) {
            return 1;
        }
        if (oCurrentPane.equals(this.m_oSNMPV3ScrollPane)) {
            return 2;
        }
        return -1;
    }

    public JTable getTableForVersion(int iVersion) {
        switch (iVersion) {
            case 0: {
                return this.m_oSNMPV1Table;
            }
            case 1: {
                return this.m_oSNMPV2Table;
            }
            case 2: {
                return this.m_oSNMPV3Table;
            }
        }
        return null;
    }

    public JScrollPane getScrollPaneForVersion(int iVersion) {
        switch (iVersion) {
            case 0: {
                return this.m_oSNMPV1ScrollPane;
            }
            case 1: {
                return this.m_oSNMPV2ScrollPane;
            }
            case 2: {
                return this.m_oSNMPV3ScrollPane;
            }
        }
        return null;
    }

    public void resetTableSelection(JTable oTable, int iFirstSelectedRow, int iTotalRowCount) {
        if (iFirstSelectedRow + 1 <= iTotalRowCount) {
            oTable.setRowSelectionInterval(iFirstSelectedRow, iFirstSelectedRow);
        } else {
            oTable.setRowSelectionInterval(0, 0);
        }
    }

    private void initializeTableHeader(JTable oTable) {
        JTableHeader oTableHeader = oTable.getTableHeader();
        oTableHeader.setReorderingAllowed(true);
        oTableHeader.addMouseMotionListener(this.getToolTipRendererForHeader(oTable));
        oTableHeader.addMouseListener(this.generateMouseAdapterForTableHeader(oTable));
    }

    private MouseMotionAdapter getToolTipRendererForHeader(final JTable oTable) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = oTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    oTable.getTableHeader().setToolTipText(oTable.getColumnName(oColNum));
                }
            }
        };
    }

    private void setTableColumnSize(JTable oTable) {
        int iColumnCount = oTable.getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            TableColumn oTableColumn = oTable.getColumnModel().getColumn(i);
            this.setColumnWidth(oTableColumn);
        }
    }

    private void setColumnWidth(TableColumn oTableColumn) {
        oTableColumn.setMinWidth(70);
        oTableColumn.setPreferredWidth(100);
        oTableColumn.setMaxWidth(130);
    }

    public JTable getSNMPV1Table() {
        return this.m_oSNMPV1Table;
    }

    public JTable getSNMPV2Table() {
        return this.m_oSNMPV2Table;
    }

    public JTable getSNMPV3Table() {
        return this.m_oSNMPV3Table;
    }

    public static int getDevAccessColumnCount() {
        return 9;
    }
}

