/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.u2kcbb.DCPasswordFiled;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPSecurityParameterPanel;
import java.awt.Component;
import javax.swing.JLabel;

public class PasswordDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private JLabel m_oNewPasswordLabel;
    private DCPasswordFiled m_oNewPasswordField;
    private JLabel m_oConfirmPasswordLabel;
    private DCPasswordFiled m_oConfirmPasswordField;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private AddSNMPSecurityParameterPanel m_oParentPanel;
    private int m_iPasswordField;

    public PasswordDlg() {
        this.jbinit();
    }

    public void setParentDlg(AddSNMPSecurityParameterPanel oParentPanel) {
        this.m_oParentPanel = oParentPanel;
    }

    public void setPasswordField(int iPasswordField) {
        this.m_iPasswordField = iPasswordField;
    }

    private void jbinit() {
        this.initDialog();
        this.initLabels();
        this.initPasswordFields();
        this.initButtons();
    }

    private void initDialog() {
        this.setSize(260, 135);
        this.setLayout(null);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(this.m_oResManager.getResString("STANDALONE_PASSWORD_DIALOG_TITLE"));
    }

    private void initButtons() {
        this.m_oOKBtn.setBounds(80, 75, 80, 20);
        this.m_oOKBtn.setFocusable(true);
        this.m_oOKBtn.setText(this.m_oResManager.getResString("OK_BTN"));
        this.getContentPane().add(this.m_oOKBtn);
        this.m_oCancelBtn.setBounds(165, 75, 80, 20);
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("CANCEL_BTN"));
        this.getContentPane().add(this.m_oCancelBtn);
    }

    private void initPasswordFields() {
        this.m_oNewPasswordField = new DCPasswordFiled(40);
        this.m_oNewPasswordField.setBounds(125, 15, 120, 20);
        this.getContentPane().add((Component)((Object)this.m_oNewPasswordField));
        this.m_oConfirmPasswordField = new DCPasswordFiled(40);
        this.m_oConfirmPasswordField.setBounds(125, 45, 120, 20);
        this.getContentPane().add((Component)((Object)this.m_oConfirmPasswordField));
    }

    private void initLabels() {
        this.m_oNewPasswordLabel = new JLabel();
        this.m_oNewPasswordLabel.setText(this.m_oResManager.getResString("PASSWORD_DIALOG_NEW_PASSWORD_LABEL"));
        this.m_oNewPasswordLabel.setBounds(15, 15, 100, 20);
        this.getContentPane().add(this.m_oNewPasswordLabel);
        this.m_oConfirmPasswordLabel = new JLabel();
        this.m_oConfirmPasswordLabel.setText(this.m_oResManager.getResString("PASSWORD_DIALOG_CONFIRM_PASSWORD_LABEL"));
        this.m_oConfirmPasswordLabel.setBounds(15, 45, 100, 20);
        this.getContentPane().add(this.m_oConfirmPasswordLabel);
    }

    @Override
    protected String getCurrentContext() {
        DCDebugTracer.trace("help id is empty in " + PasswordDlg.class.getName());
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (0 == this.m_oNewPasswordField.getText().length()) {
            this.showMessageDlg("BLANK_PASSWORD_FIELD_ERROR");
            return;
        }
        if (0 == this.m_oConfirmPasswordField.getText().length()) {
            this.showMessageDlg("BLANK_CONFIRM_PASSWORD_FIELD_ERROR");
            return;
        }
        if (!this.m_oNewPasswordField.getText().equals(this.m_oConfirmPasswordField.getText())) {
            this.showMessageDlg("CONFIRM_PASSWORD_FAILED_ERROR");
            return;
        }
        if (0 == this.m_iPasswordField) {
            this.m_oParentPanel.setAuthenticationPassword(this.m_oNewPasswordField.getText().toCharArray());
        } else if (1 == this.m_iPasswordField) {
            this.m_oParentPanel.setEncryptionPassword(this.m_oNewPasswordField.getText().toCharArray());
        }
        this.closeDialog();
    }

    protected void showMessageDlg(String strMessage) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString(strMessage));
    }
}

