/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.view;

import com.huawei.dc.common.DCCommonProgressDlg;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.standalone.snmpparams.SNMPParamTableManager;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPCommonParameterPanel;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPParamTemplatePanel;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPSecurityParameterPanel;
import com.huawei.dc.standalone.snmpparams.view.ISNMPParamsDlg;
import com.huawei.dc.standalone.snmpparams.view.SNMPParamTabPanel;
import com.huawei.dc.standalone.view.DeviceProgressDlg;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

public class DeviceAccessProtocolDlg
extends DCModalDialog
implements ISNMPParamsDlg,
IDeviceConfigChangeListener {
    private static final long serialVersionUID = -313842703559310128L;
    private SNMPParamTabPanel m_SNMPTabPanel;
    private AddSNMPCommonParameterPanel m_oAddSNMPCommonParameterPanel;
    private AddSNMPParamTemplatePanel m_oAddSNMPParamTemplatePanel;
    private int m_iSNMPVersion;
    private JPanel m_oButtonPanel;
    private ResourceManager m_oResMgr;
    private SNMPParamTableManager m_oManager;
    private JButton m_oApplyBtn;
    private byte[] m_oSyncObject;
    private SnmpParaInfo oSnmpParaInfo;
    private HashMap<Integer, Integer> m_oDeviceRowMap;
    private AddSNMPSecurityParameterPanel addSNMPSecurityParameterPanel;
    private JTabbedPane snmpOptionTabbedPane;
    protected DCCommonProgressDlg m_oProgressDlg = new DCCommonProgressDlg();
    private boolean isApplyActionReturn = false;

    public DeviceAccessProtocolDlg() throws DCException {
        this.m_oProgressDlg.setDefaultCloseOperation(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != DeviceAccessProtocolDlg.this.m_oProgressDlg) {
                    DeviceAccessProtocolDlg.this.m_oProgressDlg.setVisible(true);
                }
            }
        });
        this.m_oSyncObject = new byte[0];
        this.m_oResMgr = ResourceManager.getInstance();
        this.m_SNMPTabPanel = new SNMPParamTabPanel(false);
        this.m_SNMPTabPanel.getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DeviceAccessProtocolDlg.this.refreshTable();
            }
        });
        this.m_iSNMPVersion = this.m_SNMPTabPanel.getSelectedVersion();
        this.initAddSNMPParamTemplatePanel();
        this.initAddSNMPCommonParameterPanel();
        this.initButtonPanel();
        this.m_oManager = new SNMPParamTableManager(this, true);
        boolean bIsHaveDev = this.m_oManager.populateParamsForAllVersions();
        if (!bIsHaveDev) {
            if (null != this.m_oProgressDlg) {
                this.m_oProgressDlg.dispose();
            }
            this.dispose();
            return;
        }
        this.fillParamsInfoToPanel();
        this.registerForServerNotifications();
        this.m_SNMPTabPanel.setDevNamePanel(this.m_oAddSNMPParamTemplatePanel);
        this.m_SNMPTabPanel.setDevTableParamPanel(this.snmpOptionTabbedPane);
        this.m_SNMPTabPanel.setDevParamPanel(this.m_oAddSNMPCommonParameterPanel);
        this.m_oDeviceRowMap = new HashMap();
        this.setLayout(new GridBagLayout());
        this.add(this.m_SNMPTabPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.3, 17, 1, new Insets(12, 8, 5, 12), 0, 0));
        this.add(this.m_oAddSNMPParamTemplatePanel, new GridBagConstraints(-1, 1, 1, 1, 0.5, 0.1, 15, 1, new Insets(0, 3, 0, 12), 0, 0));
        this.add(this.snmpOptionTabbedPane, new GridBagConstraints(-1, 2, 1, 1, 0.5, 0.3, 15, 1, new Insets(0, 12, 5, 12), 0, 0));
        this.add(this.m_oButtonPanel, new GridBagConstraints(-1, 3, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 12, 5, 7), 0, 0));
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.setTitle(this.m_oResMgr.getResString("DEVICE_ACCESS_CONTROL_TITLE"));
        this.setResizable(false);
        this.setSize(590, 500);
        this.updateAppOkBtnStaus();
        if (null != this.m_oProgressDlg) {
            this.m_oProgressDlg.setVisible(false);
            this.m_oProgressDlg.dispose();
            this.m_oProgressDlg = null;
        }
        this.setVisible(true);
    }

    private void initAddSNMPCommonParameterPanel() {
        this.m_oAddSNMPCommonParameterPanel = new AddSNMPCommonParameterPanel(this.m_iSNMPVersion);
        this.m_oAddSNMPCommonParameterPanel.setSize(550, 300);
        this.addSNMPSecurityParameterPanel = new AddSNMPSecurityParameterPanel();
        this.snmpOptionTabbedPane = new JTabbedPane();
        this.snmpOptionTabbedPane.setFocusable(false);
        this.snmpOptionTabbedPane.addTab(this.m_oResMgr.getResString("SNMP_COMMON_PARAMETERS"), this.m_oAddSNMPCommonParameterPanel);
    }

    private void initAddSNMPParamTemplatePanel() {
        this.m_oAddSNMPParamTemplatePanel = new AddSNMPParamTemplatePanel(this.m_iSNMPVersion, false);
        this.m_oAddSNMPParamTemplatePanel.setSize(560, 40);
    }

    private void fillParamsInfoToPanel() throws DCException {
        SnmpParaInfo oParaInfo = this.m_oManager.getSelectedParaInfo();
        this.m_oAddSNMPCommonParameterPanel.setParamValue(oParaInfo);
        if (null != oParaInfo) {
            this.m_oAddSNMPParamTemplatePanel.fillValueToName(oParaInfo.getDevResource().getDeviceName(), this.m_iSNMPVersion);
        } else {
            this.m_oAddSNMPParamTemplatePanel.fillValueToName("", this.m_iSNMPVersion);
        }
    }

    private void initButtonPanel() {
        this.m_oButtonPanel = new JPanel();
        this.m_oOKBtn.setText(this.m_oResMgr.getResString("OK_BTN"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(80, 21));
        this.m_oCancelBtn.setText(this.m_oResMgr.getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 21));
        this.m_oApplyBtn = new JButton();
        this.m_oApplyBtn.setText(this.m_oResMgr.getResString("APPLYBUTTON"));
        this.m_oApplyBtn.setMnemonic('P');
        this.m_oApplyBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oApplyBtn.setMinimumSize(new Dimension(80, 21));
        this.m_oButtonPanel.setLayout(new FlowLayout(2));
        this.m_oButtonPanel.add(this.m_oOKBtn);
        this.m_oButtonPanel.add(this.m_oCancelBtn);
        this.m_oButtonPanel.add(this.m_oApplyBtn);
        this.addMouseListener();
    }

    public void addMouseListener() {
        String strOkCmd = "OkAction";
        String strCancleCmd = "CancleAction";
        String strApplyCmd = "ApplyAction";
        this.m_oOKBtn.setActionCommand("OkAction");
        this.m_oCancelBtn.setActionCommand("CancleAction");
        this.m_oApplyBtn.setActionCommand("ApplyAction");
        ActionListener oListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("OkAction".equals(e.getActionCommand())) {
                    DeviceAccessProtocolDlg.this.okActionPerformed();
                }
                if ("CancleAction".equals(e.getActionCommand())) {
                    DeviceAccessProtocolDlg.this.cancleActionPerformed();
                }
                if ("ApplyAction".equals(e.getActionCommand())) {
                    DeviceAccessProtocolDlg.this.applyActionPerformed();
                }
            }
        };
        this.m_oOKBtn.addActionListener(oListener);
        this.m_oCancelBtn.addActionListener(oListener);
        this.m_oApplyBtn.addActionListener(oListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyActionPerformed() {
        String strDevName;
        this.isApplyActionReturn = false;
        this.oSnmpParaInfo = this.m_SNMPTabPanel.getSnmpInfo();
        int iSnmpEnum = this.m_oAddSNMPParamTemplatePanel.getSnmpEnum();
        this.oSnmpParaInfo.setSnmpEnum(iSnmpEnum);
        if (!this.validInputParam()) {
            this.isApplyActionReturn = true;
            return;
        }
        if (2 == this.oSnmpParaInfo.getSnmpEnum()) {
            if (this.oSnmpParaInfo.getDataEncryptionType() != 1 && (null == this.oSnmpParaInfo.getEncrypPasswd() || 0 == this.oSnmpParaInfo.getEncrypPasswd().length || String.valueOf(this.oSnmpParaInfo.getEncrypPasswd()).equals(""))) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SNMP_DATA_ENCRYPTION_PASSWOR_IS_NULL"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                this.isApplyActionReturn = true;
                return;
            }
            if (this.oSnmpParaInfo.getAuthenticationType() != 1 && (null == this.oSnmpParaInfo.getAuthenticationPasswd() || 0 == this.oSnmpParaInfo.getAuthenticationPasswd().length || String.valueOf(this.oSnmpParaInfo.getAuthenticationPasswd()).equals(""))) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SNMP_AUTHENTICATION_PASSWOR_IS_NULL"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                this.isApplyActionReturn = true;
                return;
            }
        }
        int iSelectedVersion = this.getSelectedVersion();
        JTable oTable = this.getTableForVersion(iSelectedVersion);
        DefaultTableModel oTableModel = (DefaultTableModel)oTable.getModel();
        int[] rows = oTable.getSelectedRows();
        if (1 == rows.length && StringUtils.isNullOrEmptyStr(strDevName = this.m_oAddSNMPParamTemplatePanel.getTemplateName())) {
            DCOptionPane.showWarningDialog((Component)((Object)this), this.m_oResMgr.getResString("DEVICE_NAME_EMPTY"));
            this.isApplyActionReturn = true;
            return;
        }
        byte[] byArray = this.m_oSyncObject;
        synchronized (this.m_oSyncObject) {
            final DeviceProgressDlg oAddDeviceProgressBarDlg = new DeviceProgressDlg(2, this.m_oSyncObject);
            try {
                this.modifySnmpParamDetailToServer(oTableModel, rows);
            }
            catch (DCException ex) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getErrorCode(), this.m_oResMgr.getResString("ERROR"), 0);
                this.isApplyActionReturn = true;
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            oAddDeviceProgressBarDlg.setTotalDev(rows.length);
            oAddDeviceProgressBarDlg.setProgressBarState(true);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public synchronized void run() {
                    oAddDeviceProgressBarDlg.setVisible(true);
                }
            });
            return;
        }
    }

    private void modifySnmpParamDetailToServer(DefaultTableModel oTableModel, int[] rows) throws DCException {
        this.m_oDeviceRowMap.clear();
        ArrayList<Resource> oDevList = new ArrayList<Resource>();
        Resource oDevDetail = null;
        if (1 == rows.length) {
            oDevDetail = (Resource)oTableModel.getValueAt(rows[0], 0);
            String strDevName = this.m_oAddSNMPParamTemplatePanel.getTemplateName();
            oDevDetail.setDeviceName(strDevName);
            this.oSnmpParaInfo.setDevResource(oDevDetail);
            oDevList.add(oDevDetail);
            this.m_oDeviceRowMap.put(oDevDetail.getDeviceID(), rows[0]);
        } else {
            for (int i = rows.length - 1; i >= 0; --i) {
                oDevDetail = (Resource)oTableModel.getValueAt(rows[i], 0);
                oDevList.add(oDevDetail);
                this.m_oDeviceRowMap.put(oDevDetail.getDeviceID(), rows[i]);
            }
        }
        this.m_oManager.modifyDeviceParaInfo(this.oSnmpParaInfo, oDevList);
    }

    private boolean validInputParam() {
        if (2 != this.oSnmpParaInfo.getSnmpEnum()) {
            if (StringUtils.isNullOrEmptyChar(this.oSnmpParaInfo.getGetCommunity())) {
                DCOptionPane.showWarningDialog((Component)((Object)this), this.m_oResMgr.getResString("GET_COMMUNITY_EMPTY"));
                return false;
            }
            if (StringUtils.isNullOrEmptyChar(this.oSnmpParaInfo.getSetCommunity())) {
                DCOptionPane.showWarningDialog((Component)((Object)this), this.m_oResMgr.getResString("SET_COMMUNITY_EMPTY"));
                return false;
            }
        }
        if (0 == this.oSnmpParaInfo.getDevPort()) {
            DCOptionPane.showWarningDialog((Component)((Object)this), this.m_oResMgr.getResString("DEVICE_PORT_EMPTY"));
            return false;
        }
        if (-1 == this.oSnmpParaInfo.getPollInterval()) {
            DCOptionPane.showWarningDialog((Component)((Object)this), this.m_oResMgr.getResString("POLL_INTERVAL_EMPTY"));
            return false;
        }
        if (-1 == this.oSnmpParaInfo.getRetries()) {
            DCOptionPane.showWarningDialog((Component)((Object)this), this.m_oResMgr.getResString("RETRIES_EMPTY"));
            return false;
        }
        if (0 == this.oSnmpParaInfo.getTimeOut()) {
            DCOptionPane.showWarningDialog((Component)((Object)this), this.m_oResMgr.getResString("TIMEOUT_EMPTY"));
            return false;
        }
        return true;
    }

    private void okActionPerformed() {
        this.applyActionPerformed();
        if (this.isApplyActionReturn) {
            return;
        }
        this.unregisterForServerNotifications();
        this.dispose();
    }

    private void cancleActionPerformed() {
        this.unregisterForServerNotifications();
        this.dispose();
    }

    @Override
    public JTable getTableForVersion(int iVersion) {
        return this.m_SNMPTabPanel.getTableForVersion(iVersion);
    }

    @Override
    public int getSelectedVersion() {
        return this.m_SNMPTabPanel.getSelectedVersion();
    }

    @Override
    public void refreshTable() {
        this.m_SNMPTabPanel.refreshTable();
        this.updateAppOkBtnStaus();
    }

    private void updateAppOkBtnStaus() {
        int iSelectedVersion = this.getSelectedVersion();
        JTable oTable = this.getTableForVersion(iSelectedVersion);
        if (0 != oTable.getRowCount()) {
            this.m_oApplyBtn.setEnabled(true);
            this.m_oOKBtn.setEnabled(true);
        } else {
            this.m_oApplyBtn.setEnabled(false);
            this.m_oOKBtn.setEnabled(false);
        }
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_NE_CONFIG_PROTOCOL";
    }

    @Override
    public void resetTableSelection(JTable oTable, int iFirstSelectedRow, int iTotalRowCount) {
        this.m_SNMPTabPanel.resetTableSelection(oTable, iFirstSelectedRow, iTotalRowCount);
    }

    @Override
    public void handleDeviceConfigNotification(int eventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (2 != eventType) {
            return;
        }
        if (null == oDeviceInfoList || oDeviceInfoList.isEmpty()) {
            return;
        }
        if (null != this.m_oDeviceRowMap && 0 != this.m_oDeviceRowMap.size()) {
            this.m_oManager.updateDataToTable(oDeviceInfoList, this.oSnmpParaInfo, this.m_oDeviceRowMap);
        }
    }

    public void registerForServerNotifications() {
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
    }

    public void unregisterForServerNotifications() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
    }
}

