/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.view;

import com.huawei.dc.common.components.u2kcbb.U2kPasswordFiled;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.swimap.imap12.util.InmLengthLimitTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AddSNMPSecurityParameterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel m_oDeviceUserLabel;
    private InmLengthLimitTextField m_oDeviceUserTextField;
    private JLabel m_oContextNameLabel;
    private InmLengthLimitTextField m_oContextNameTextField;
    private JLabel m_oContextEngineIDLabel;
    private InmLengthLimitTextField m_oContextEngineIDTextField;
    private JLabel m_oDataEncryptionLabel;
    private ComboBoxWithToolTip m_oDataEncryptionComboBox;
    private U2kPasswordFiled m_oDataEncryptionButton;
    private JLabel m_oAuthenticationLabel;
    private ComboBoxWithToolTip m_oAuthenticationComboBox;
    private U2kPasswordFiled m_oAuthenticationButton;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private static final String[] DATA_ENCRYPTION_VALUES = new String[]{"NONE", "DES", "AES"};
    private static final String[] AUTHENTICATION_VALUES = new String[]{"NONE", "HMACMD5", "HMACSHA"};

    public AddSNMPSecurityParameterPanel() {
        this.jbinit();
    }

    public AddSNMPSecurityParameterPanel(SnmpParaInfo oParaInfo) {
        this.jbinit();
        this.initValue(oParaInfo);
    }

    private void jbinit() {
        this.initPanel();
        this.initLabels();
        this.initInputFields();
        this.initButtons();
    }

    private void initButtons() {
        this.m_oDataEncryptionButton = new U2kPasswordFiled(40);
        this.m_oDataEncryptionButton.setBounds(230, 90, 25, 20);
        this.add(this.m_oDataEncryptionButton);
        this.m_oDataEncryptionButton.setEnabled(false);
        this.m_oAuthenticationButton = new U2kPasswordFiled(40);
        this.m_oAuthenticationButton.setBounds(510, 90, 25, 20);
        this.add(this.m_oAuthenticationButton);
        this.m_oAuthenticationButton.setEnabled(false);
        this.initActionListeners();
    }

    private void initActionListeners() {
    }

    private void initPanel() {
        this.setLayout(null);
        TitledBorder oTitledBorder = BorderFactory.createTitledBorder(this.getTitleString("SNMP_SECURITY_PARAMETERS"));
        this.setBorder(oTitledBorder);
    }

    private void initLabels() {
        this.m_oDeviceUserLabel = new JLabel(this.getTitleString("SNMP_TABLE_DEVICE_USER") + ':');
        this.m_oDeviceUserLabel.setBounds(20, 30, 100, 20);
        this.add(this.m_oDeviceUserLabel);
        this.m_oContextNameLabel = new JLabel(this.getTitleString("SNMP_TABLE_CONTEXT_NAME") + ':');
        this.m_oContextNameLabel.setBounds(20, 60, 100, 20);
        this.add(this.m_oContextNameLabel);
        this.m_oContextEngineIDLabel = new JLabel(this.getTitleString("SNMP_TABLE_CONTEXT_ENGINE_ID") + ':');
        this.m_oContextEngineIDLabel.setBounds(280, 60, 120, 20);
        this.add(this.m_oContextEngineIDLabel);
        this.m_oDataEncryptionLabel = new JLabel(this.getTitleString("SNMP_TABLE_DATA_ENCRYPTION") + ':');
        this.m_oDataEncryptionLabel.setBounds(20, 90, 100, 20);
        this.add(this.m_oDataEncryptionLabel);
        this.m_oAuthenticationLabel = new JLabel(this.getTitleString("SNMP_TABLE_AUTHENTICATION") + ':');
        this.m_oAuthenticationLabel.setBounds(280, 90, 120, 20);
        this.add(this.m_oAuthenticationLabel);
    }

    private void initInputFields() {
        this.m_oDeviceUserTextField = new InmLengthLimitTextField(64);
        this.m_oDeviceUserTextField.setBounds(120, 30, 130, 20);
        this.m_oDeviceUserTextField.addMouseMotionListener((MouseMotionListener)this.generateMouseListenerAdapter((JTextField)this.m_oDeviceUserTextField));
        this.add((Component)this.m_oDeviceUserTextField);
        this.m_oContextNameTextField = new InmLengthLimitTextField(96);
        this.m_oContextNameTextField.setBounds(120, 60, 130, 20);
        this.m_oContextNameTextField.addMouseMotionListener((MouseMotionListener)this.generateMouseListenerAdapter((JTextField)this.m_oContextNameTextField));
        this.add((Component)this.m_oContextNameTextField);
        this.m_oContextEngineIDTextField = new InmLengthLimitTextField(97);
        this.m_oContextEngineIDTextField.setBounds(400, 60, 130, 20);
        this.addContextIdTextBoxMouseListener();
        this.add((Component)this.m_oContextEngineIDTextField);
        this.m_oDataEncryptionComboBox = new ComboBoxWithToolTip(DATA_ENCRYPTION_VALUES);
        this.m_oDataEncryptionComboBox.setBounds(120, 90, 110, 20);
        this.add(this.m_oDataEncryptionComboBox);
        this.m_oAuthenticationComboBox = new ComboBoxWithToolTip(AUTHENTICATION_VALUES);
        this.m_oAuthenticationComboBox.setBounds(400, 90, 110, 20);
        this.add(this.m_oAuthenticationComboBox);
        this.initActionListenersForComboBox();
    }

    private void addContextIdTextBoxMouseListener() {
        this.m_oContextEngineIDTextField.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                AddSNMPSecurityParameterPanel.this.setContextEngineIDToolTip();
            }
        });
    }

    private void setContextEngineIDToolTip() {
        if (0 != this.m_oContextEngineIDTextField.getText().length()) {
            this.m_oContextEngineIDTextField.setToolTipText(ResourceManager.getInstance().getResString("CONTEXT_ID_ENGINE_TOOLTIP"));
        } else {
            this.m_oContextEngineIDTextField.setToolTipText(null);
        }
    }

    private void initActionListenersForComboBox() {
        this.m_oDataEncryptionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (AddSNMPSecurityParameterPanel.this.m_oDataEncryptionComboBox.getSelectedItem().equals("NONE")) {
                    AddSNMPSecurityParameterPanel.this.m_oDataEncryptionButton.setEnabled(false);
                } else {
                    AddSNMPSecurityParameterPanel.this.m_oDataEncryptionButton.setEnabled(true);
                }
                AddSNMPSecurityParameterPanel.this.m_oDataEncryptionButton.setPassword("".toCharArray());
            }
        });
        this.m_oAuthenticationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (AddSNMPSecurityParameterPanel.this.m_oAuthenticationComboBox.getSelectedItem().equals("NONE")) {
                    AddSNMPSecurityParameterPanel.this.m_oAuthenticationButton.setEnabled(false);
                } else {
                    AddSNMPSecurityParameterPanel.this.m_oAuthenticationButton.setEnabled(true);
                }
                AddSNMPSecurityParameterPanel.this.m_oAuthenticationButton.setPassword("".toCharArray());
            }
        });
    }

    private String getTitleString(String key) {
        return this.m_oResManager.getResString(key);
    }

    public String getDeviceUser() {
        return this.m_oDeviceUserTextField.getText();
    }

    public String getContextName() {
        return this.m_oContextNameTextField.getText();
    }

    public String getContextEngineID() {
        return this.m_oContextEngineIDTextField.getText();
    }

    public int getDataEncryption() {
        String dataEncryption = (String)this.m_oDataEncryptionComboBox.getSelectedItem();
        if (DATA_ENCRYPTION_VALUES[0].equals(dataEncryption)) {
            return 1;
        }
        if (DATA_ENCRYPTION_VALUES[1].equals(dataEncryption)) {
            return 2;
        }
        if (DATA_ENCRYPTION_VALUES[2].equals(dataEncryption)) {
            return 3;
        }
        return 1;
    }

    public int getAuthentication() {
        String authentication = (String)this.m_oAuthenticationComboBox.getSelectedItem();
        if (AUTHENTICATION_VALUES[0].equals(authentication)) {
            return 1;
        }
        if (AUTHENTICATION_VALUES[1].equals(authentication)) {
            return 2;
        }
        if (AUTHENTICATION_VALUES[2].equals(authentication)) {
            return 3;
        }
        return 1;
    }

    public boolean validateFields() {
        boolean bSuccess = true;
        if (null == this.getDeviceUser() || 0 == this.getDeviceUser().length()) {
            this.showErrorMessage("DEVICE_USER_NAME_EMPTY");
            return false;
        }
        if (!this.checkEngineID()) {
            this.showErrorMessage("INCORRECT_CONTEXT_ENGINE_ID");
            return false;
        }
        if (!this.m_oAuthenticationComboBox.getSelectedItem().equals("NONE") && (null == this.m_oAuthenticationButton.getPasswordInChar() || "".equals(String.valueOf(this.m_oAuthenticationButton.getPasswordInChar())))) {
            this.showErrorMessage("AUTH_PASSWORD_EMPTY");
            return false;
        }
        if (!this.m_oDataEncryptionComboBox.getSelectedItem().equals("NONE") && (null == this.m_oDataEncryptionButton.getPasswordInChar() || "".equals(String.valueOf(this.m_oDataEncryptionButton.getPasswordInChar())))) {
            this.showErrorMessage("ENCRY_PASSWORD_EMPTY");
            return false;
        }
        return bSuccess;
    }

    private boolean checkEngineID() {
        String strContextEngineID = this.getContextEngineID();
        if (0 == strContextEngineID.length()) {
            return true;
        }
        if ('#' != strContextEngineID.charAt(0)) {
            return 32 >= strContextEngineID.length();
        }
        return this.checkEngineIDFormat();
    }

    private boolean checkEngineIDFormat() {
        return true;
    }

    private void showErrorMessage(String strKey) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.getTitleString(strKey), this.getTitleString("ERROR"), 0);
    }

    public void setAuthenticationPassword(char[] strPass) {
        this.m_oAuthenticationButton.setPassword(strPass);
    }

    public void setEncryptionPassword(char[] strPass) {
        this.m_oDataEncryptionButton.setPassword(strPass);
    }

    public char[] getAuthPassword() {
        return this.m_oAuthenticationButton.getPasswordInChar();
    }

    public char[] getEncryPassword() {
        return this.m_oDataEncryptionButton.getPasswordInChar();
    }

    private MouseMotionAdapter generateMouseListenerAdapter(final JTextField oTextField) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                AddSNMPSecurityParameterPanel.this.setToolTip(oEvent, oTextField);
            }
        };
    }

    private void setToolTip(MouseEvent oEvent, JTextField oTextField) {
        if (0 != oTextField.getText().trim().length()) {
            oTextField.setToolTipText(oTextField.getText().trim());
        }
    }

    public SnmpParaInfo updateSnmpParaInfo(SnmpParaInfo m_oSnmpParaInfo) {
        if (null == m_oSnmpParaInfo) {
            m_oSnmpParaInfo = new SnmpParaInfo();
        }
        m_oSnmpParaInfo.setUserName(this.getDeviceUser());
        m_oSnmpParaInfo.setContextName(this.getContextName());
        m_oSnmpParaInfo.setContextId(this.getContextEngineID());
        m_oSnmpParaInfo.setDataEncryptionType(this.getDataEncryption());
        m_oSnmpParaInfo.setAuthenticationType(this.getAuthentication());
        m_oSnmpParaInfo.setAuthenticationPasswd(this.getAuthPassword(), false);
        m_oSnmpParaInfo.setEncrypPasswd(this.getEncryPassword(), false);
        return m_oSnmpParaInfo;
    }

    public void initValue(SnmpParaInfo oParaInfo) {
        if (null == oParaInfo) {
            return;
        }
        this.m_oDeviceUserTextField.setText(oParaInfo.getUserName());
        this.m_oContextNameTextField.setText(oParaInfo.getContextName());
        this.m_oContextEngineIDTextField.setText(oParaInfo.getContextId());
        int encryptionType = oParaInfo.getDataEncryptionType();
        if (1 == encryptionType) {
            this.m_oDataEncryptionComboBox.setSelectedIndex(0);
            this.m_oDataEncryptionButton.setPassword("".toCharArray());
        } else if (2 == encryptionType) {
            this.m_oDataEncryptionComboBox.setSelectedIndex(1);
            this.m_oDataEncryptionButton.setPassword(oParaInfo.getEncrypPasswd());
        } else if (3 == encryptionType) {
            this.m_oDataEncryptionComboBox.setSelectedIndex(2);
            this.m_oDataEncryptionButton.setPassword(oParaInfo.getEncrypPasswd());
        } else {
            this.m_oDataEncryptionComboBox.setSelectedIndex(0);
        }
        int authentication = oParaInfo.getAuthenticationType();
        if (1 == authentication) {
            this.m_oAuthenticationComboBox.setSelectedIndex(0);
            this.m_oAuthenticationButton.setPassword("".toCharArray());
        } else if (2 == authentication) {
            this.m_oAuthenticationComboBox.setSelectedIndex(1);
            this.m_oAuthenticationButton.setPassword(oParaInfo.getAuthenticationPasswd());
        } else if (3 == authentication) {
            this.m_oAuthenticationComboBox.setSelectedIndex(2);
            this.m_oAuthenticationButton.setPassword(oParaInfo.getAuthenticationPasswd());
        } else {
            this.m_oAuthenticationComboBox.setSelectedIndex(0);
            this.m_oAuthenticationButton.setPassword("".toCharArray());
        }
    }
}

