/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.view;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.ValidationUtility;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.snmpparams.SNMPParamUtil;
import com.swimap.imap12.util.InmLengthLimitTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddSNMPParamTemplatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel m_oTemplateNameLabel;
    private InmLengthLimitTextField m_oTemplateNameTextField;
    private JLabel m_oVersionLabel;
    private ComboBoxWithToolTip m_oVersionComboBox;
    private int m_iSNMPVersion;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private boolean m_bIsAddDeviceOpt = true;

    public AddSNMPParamTemplatePanel(int iSNMPVersion, boolean bIsAddDeviceOpt) {
        this.m_iSNMPVersion = iSNMPVersion;
        this.m_bIsAddDeviceOpt = bIsAddDeviceOpt;
        this.jbinit();
    }

    private void jbinit() {
        this.setLayout(null);
        this.initLabels();
        this.initInputFields();
    }

    private void initLabels() {
        this.m_oTemplateNameLabel = this.m_bIsAddDeviceOpt ? new JLabel(this.getTitleString("SNMP_TABLE_TEMPLATE_NAME") + ':') : new JLabel(this.getTitleString("SNMP_TABLE_DEVICE_NAME") + ':');
        this.m_oTemplateNameLabel.setBounds(10, 10, 100, 20);
        this.add(this.m_oTemplateNameLabel);
        this.m_oVersionLabel = new JLabel(this.getTitleString("SNMP_TABLE_VERSION") + ':');
        this.m_oVersionLabel.setBounds(340, 10, 100, 20);
        this.add(this.m_oVersionLabel);
    }

    private void initInputFields() {
        this.m_oTemplateNameTextField = new InmLengthLimitTextField(64);
        this.m_oTemplateNameTextField.setBounds(120, 10, 150, 20);
        this.m_oTemplateNameTextField.addMouseMotionListener((MouseMotionListener)this.generateMouseListenerAdapter((JTextField)this.m_oTemplateNameTextField));
        this.add((Component)this.m_oTemplateNameTextField);
        JLabel oStartLabel = new JLabel("*");
        oStartLabel.setForeground(Color.red);
        oStartLabel.setBounds(275, 10, 20, 20);
        this.add(oStartLabel);
        this.m_oVersionComboBox = new ComboBoxWithToolTip();
        this.m_oVersionComboBox.addItem(SNMPParamUtil.getSNMPVersionName(0));
        this.m_oVersionComboBox.addItem(SNMPParamUtil.getSNMPVersionName(1));
        this.m_oVersionComboBox.addItem(SNMPParamUtil.getSNMPVersionName(2));
        this.m_oVersionComboBox.setBounds(400, 10, 150, 20);
        this.m_oVersionComboBox.setEnabled(false);
        if (0 == this.m_iSNMPVersion) {
            this.m_oVersionComboBox.setSelectedIndex(0);
        } else if (1 == this.m_iSNMPVersion) {
            this.m_oVersionComboBox.setSelectedIndex(1);
        } else if (2 == this.m_iSNMPVersion) {
            this.m_oVersionComboBox.setSelectedIndex(2);
        } else {
            DCDebugTracer.trace("AddSNMPParamTemplatePanel#unknow snmp Version:" + this.m_iSNMPVersion);
        }
        this.add(this.m_oVersionComboBox);
        JLabel oVersionLabel = new JLabel("*");
        oVersionLabel.setForeground(Color.red);
        oVersionLabel.setBounds(555, 10, 20, 20);
        this.add(oVersionLabel);
    }

    private String getTitleString(String key) {
        return this.m_oResManager.getResString(key);
    }

    public String getTemplateName() {
        return this.m_oTemplateNameTextField.getText();
    }

    public String getVersion() {
        return (String)this.m_oVersionComboBox.getSelectedItem();
    }

    public int getSnmpEnum() {
        return this.m_oVersionComboBox.getSelectedIndex();
    }

    public boolean validateFields() {
        if (null == this.getTemplateName() || 0 == this.getTemplateName().length()) {
            this.showErrorMessage("TEMPLATE_NAME_EMPTY");
            return false;
        }
        boolean bValidate = this.checkForSpecialCharacters(this.getTemplateName());
        if (!bValidate) {
            this.showErrorMessage("TEMPLATE_NAME_INVALID");
            return false;
        }
        return true;
    }

    private boolean checkForSpecialCharacters(String strName) {
        boolean isValidName = true;
        isValidName = ValidationUtility.validateAlphaNumeric(strName);
        return isValidName;
    }

    protected void showErrorMessage(String strKey) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.getTitleString(strKey), this.getTitleString("ERROR"), 0);
    }

    private MouseMotionAdapter generateMouseListenerAdapter(final JTextField oTextField) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                AddSNMPParamTemplatePanel.this.setToolTip(oEvent, oTextField);
            }
        };
    }

    private void setToolTip(MouseEvent oEvent, JTextField oTextField) {
        if (0 == oTextField.getText().trim().length()) {
            oTextField.setToolTipText(oTextField.getText().trim());
        }
    }

    public void fillValueToName(String strName, int iSnmpVersion) {
        if (strName.trim().isEmpty()) {
            this.m_oTemplateNameTextField.setEditable(false);
        } else {
            this.m_oTemplateNameTextField.setEditable(true);
        }
        this.m_oTemplateNameTextField.setText(strName);
        if (0 == iSnmpVersion) {
            this.m_oVersionComboBox.setSelectedIndex(0);
        } else if (1 == iSnmpVersion) {
            this.m_oVersionComboBox.setSelectedIndex(1);
        } else if (2 == iSnmpVersion) {
            this.m_oVersionComboBox.setSelectedIndex(2);
        } else {
            DCDebugTracer.trace("AddSNMPParamTemplatePanel#unknow snmp Version:" + iSnmpVersion);
        }
    }
}

