/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPCommonParameterPanel;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPParamTemplatePanel;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPSecurityParameterPanel;
import com.huawei.dc.standalone.snmpparams.view.ShowSNMPParamsDlg;
import java.awt.Component;
import java.awt.Cursor;

public class AddSNMPParamTemplateDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private ShowSNMPParamsDlg m_oParentDlg;
    private AddSNMPParamTemplatePanel m_oAddSNMPParamTemplatePanel;
    private AddSNMPSecurityParameterPanel m_oAddSNMPSecurityParameterPanel;
    private AddSNMPCommonParameterPanel m_oAddSNMPCommonParameterPanel;
    private int m_iSNMPVersion;
    private int m_iPanelHeight;
    private int m_iDialogHeight;
    private int m_iButtonPos;
    private int m_iSNMPV3SecurityPam;

    public AddSNMPParamTemplateDlg(ShowSNMPParamsDlg oParentDlg) {
        super(oParentDlg);
        this.m_oParentDlg = oParentDlg;
        this.m_iSNMPVersion = this.m_oParentDlg.getSelectedVersion();
        if (0 == this.m_iSNMPVersion || 1 == this.m_iSNMPVersion) {
            this.m_iPanelHeight = 130;
            this.m_iDialogHeight = 250;
            this.m_iButtonPos = 190;
        } else {
            this.m_iPanelHeight = 100;
            this.m_iDialogHeight = 370;
            this.m_iButtonPos = 300;
            this.m_iSNMPV3SecurityPam = 160;
            this.initAddSNMPSecurityParameterPanel();
        }
        this.initDialog();
        this.initAddSNMPParamTemplatePanel();
        this.initAddSNMPCommonParameterPanel();
        this.addButtons();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void initDialog() {
        this.setSize(580, this.m_iDialogHeight);
        if (0 == this.m_iSNMPVersion) {
            this.setTitle(this.getTitleString("SNMPV1_PARAMETER_DIALOG_TITLE"));
        } else if (1 == this.m_iSNMPVersion) {
            this.setTitle(this.getTitleString("SNMPV2_PARAMETER_DIALOG_TITLE"));
        } else {
            this.setTitle(this.getTitleString("SNMPV3_PARAMETER_DIALOG_TITLE"));
        }
        this.setModal(true);
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.setLocationRelativeTo((Component)((Object)this.m_oParentDlg));
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    private void initAddSNMPCommonParameterPanel() {
        this.m_oAddSNMPCommonParameterPanel = new AddSNMPCommonParameterPanel(this.m_iSNMPVersion);
        this.m_oAddSNMPCommonParameterPanel.setBounds(10, 50, 550, this.m_iPanelHeight);
        this.add(this.m_oAddSNMPCommonParameterPanel);
    }

    private void initAddSNMPParamTemplatePanel() {
        this.m_oAddSNMPParamTemplatePanel = new AddSNMPParamTemplatePanel(this.m_iSNMPVersion, true);
        this.m_oAddSNMPParamTemplatePanel.setBounds(0, 5, 560, 40);
        this.add(this.m_oAddSNMPParamTemplatePanel);
    }

    private void initAddSNMPSecurityParameterPanel() {
        this.m_oAddSNMPSecurityParameterPanel = new AddSNMPSecurityParameterPanel();
        this.m_oAddSNMPSecurityParameterPanel.setBounds(10, this.m_iSNMPV3SecurityPam, 550, 130);
        this.add(this.m_oAddSNMPSecurityParameterPanel);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_SNMP_SETTING";
    }

    @Override
    protected void oKButton_ActionPerformed() {
        boolean m_oValidate = this.validateFields();
        if (!m_oValidate) {
            return;
        }
        SnmpParaInfo oParaInfo = this.getCurrentParaInfo();
        int iResult = this.m_oParentDlg.getManager().addSnmpParaInfo(oParaInfo);
        this.handleResult(iResult);
    }

    private boolean validateFields() {
        boolean bValidate = true;
        bValidate = this.m_oAddSNMPParamTemplatePanel.validateFields();
        if (!bValidate) {
            return bValidate;
        }
        if (2 != this.m_iSNMPVersion && !(bValidate = this.m_oAddSNMPCommonParameterPanel.validateFields())) {
            return bValidate;
        }
        if (2 == this.m_iSNMPVersion && !(bValidate = this.m_oAddSNMPSecurityParameterPanel.validateFields())) {
            return bValidate;
        }
        return bValidate;
    }

    private void handleResult(int iResult) {
        if (0 == iResult) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.getTitleString("OPERATION_SUCCESSFUL"), this.getTitleString("INFO"), 1);
            this.closeDialog();
        } else {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iResult, this.getTitleString("ERROR"), 0);
        }
    }

    private String getTitleString(String key) {
        return this.m_oResourceManager.getResString(key);
    }

    @Override
    protected void closeDialog() {
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.dispose();
    }

    private SnmpParaInfo getCurrentParaInfo() {
        SnmpParaInfo oParaInformation = new SnmpParaInfo();
        oParaInformation.setTemplate(this.m_oAddSNMPParamTemplatePanel.getTemplateName());
        oParaInformation.setVersion(this.m_oAddSNMPParamTemplatePanel.getVersion());
        oParaInformation.setSnmpEnum(this.m_iSNMPVersion);
        oParaInformation.setRetries(this.m_oAddSNMPCommonParameterPanel.getRetries());
        oParaInformation.setTimeOut(this.m_oAddSNMPCommonParameterPanel.getTimeOutIntervals());
        oParaInformation.setDevPort(this.m_oAddSNMPCommonParameterPanel.getDevicePort());
        oParaInformation.setPollInterval(this.m_oAddSNMPCommonParameterPanel.getPollIntervals());
        if (2 == this.m_iSNMPVersion) {
            oParaInformation.setUserName(this.m_oAddSNMPSecurityParameterPanel.getDeviceUser());
            oParaInformation.setContextName(this.m_oAddSNMPSecurityParameterPanel.getContextName());
            oParaInformation.setDataEncryptionType(this.m_oAddSNMPSecurityParameterPanel.getDataEncryption());
            oParaInformation.setContextId(this.m_oAddSNMPSecurityParameterPanel.getContextEngineID());
            oParaInformation.setAuthenticationType(this.m_oAddSNMPSecurityParameterPanel.getAuthentication());
            oParaInformation.setAuthenticationPasswd(this.m_oAddSNMPSecurityParameterPanel.getAuthPassword(), false);
            oParaInformation.setEncrypPasswd(this.m_oAddSNMPSecurityParameterPanel.getEncryPassword(), false);
        }
        if (2 != this.m_iSNMPVersion) {
            oParaInformation.setGetCommunity(this.m_oAddSNMPCommonParameterPanel.getGetCommunity(), false);
            oParaInformation.setSetCommunity(this.m_oAddSNMPCommonParameterPanel.getSetCommunity(), false);
        }
        return oParaInformation;
    }

    private void addButtons() {
        this.initCancelButton();
        this.initOkButton();
    }

    private void initOkButton() {
        this.m_oOKBtn.setBounds(395, this.m_iButtonPos, 80, 20);
        this.m_oOKBtn.setFocusable(true);
        this.m_oOKBtn.setText(this.getTitleString("OK_BTN"));
        this.getContentPane().add(this.m_oOKBtn);
    }

    private void initCancelButton() {
        this.m_oCancelBtn.setBounds(480, this.m_iButtonPos, 80, 20);
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setText(this.getTitleString("CANCEL_BTN"));
        this.getContentPane().add(this.m_oCancelBtn);
    }
}

