/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.view;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.swimap.imap12.util.InmLengthLimitTextField;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class AddSNMPCommonParameterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel m_oGetCommunityLabel;
    private InmLengthLimitTextField m_oGetCommunityTextField;
    private JLabel m_oSetCommunityLabel;
    private InmLengthLimitTextField m_oSetCommunityTextField;
    private JLabel oGetCommunityLabel = new JLabel("*");
    private JLabel oSetCommunityLabel = new JLabel("*");
    private JLabel oRetrialLabel = new JLabel("*");
    private JLabel oTimeoutLabel = new JLabel("*");
    private JLabel oPollLabel = new JLabel("*");
    private JLabel oDevPortLabel = new JLabel("*");
    private JLabel m_oRetriesLabel;
    private Spinner m_oRetriesSpinner;
    private NumericSpinnerModel m_oRetriesSpinnerModel;
    private JLabel m_oTimeOutIntervalsLabel;
    private Spinner m_oTimeOutIntervalsSpinner;
    private NumericSpinnerModel m_oTimeOutIntervalsSpinnerModel;
    private JLabel m_oPollIntervalsLabel;
    private Spinner m_oPollIntervalsSpinner;
    private NumericSpinnerModel m_oPollIntervalsSpinnerModel;
    private JLabel m_oDevicePortLabel;
    private Spinner m_oDevicePortSpinner;
    private NumericSpinnerModel m_oDevicePortSpinnerModel;
    private int m_oControlPos;
    private int m_iSNMPVersion;
    private ResourceManager m_oResManager;
    private Border oTitledBorder;

    public AddSNMPCommonParameterPanel(int iSNMPVersion) {
        this.m_oResManager = ResourceManager.getInstance();
        this.m_iSNMPVersion = iSNMPVersion;
        this.m_oControlPos = 0 == iSNMPVersion || 1 == iSNMPVersion ? 60 : 30;
        this.jbinit();
    }

    public AddSNMPCommonParameterPanel(int iSNMPVersion, Border oTitledBorder) {
        this.setTitleBorder(oTitledBorder);
        this.m_oResManager = ResourceManager.getInstance();
        this.m_iSNMPVersion = iSNMPVersion;
        this.m_oControlPos = 0 == iSNMPVersion || 1 == iSNMPVersion ? 60 : 30;
        this.jbinit();
    }

    private void jbinit() {
        this.initPanel();
        this.initLabels();
        this.initInputFields();
    }

    private void setTitleBorder(Border oTitledBorder) {
        this.oTitledBorder = oTitledBorder;
    }

    private void initPanel() {
        this.setLayout(null);
        if (null == this.oTitledBorder) {
            this.oTitledBorder = BorderFactory.createTitledBorder(this.getTitleString("SNMP_COMMON_PARAMETERS"));
        }
        this.setBorder(this.oTitledBorder);
    }

    private void initLabels() {
        if (0 == this.m_iSNMPVersion || 1 == this.m_iSNMPVersion) {
            this.m_oGetCommunityLabel = new JLabel(this.getTitleString("SNMP_TABLE_GET_COMMUNITY") + ':');
            this.m_oGetCommunityLabel.setBounds(20, 30, 100, 20);
            this.add(this.m_oGetCommunityLabel);
            this.m_oSetCommunityLabel = new JLabel(this.getTitleString("SNMP_TABLE_SET_COMMUNITY") + ':');
            this.m_oSetCommunityLabel.setBounds(280, 30, 120, 20);
            this.add(this.m_oSetCommunityLabel);
        }
        this.m_oRetriesLabel = new JLabel(this.getTitleString("SNMP_TABLE_RETRIES") + ':');
        this.m_oRetriesLabel.setBounds(20, this.m_oControlPos, 100, 20);
        this.add(this.m_oRetriesLabel);
        this.m_oTimeOutIntervalsLabel = new JLabel(this.getTitleString("SNMP_TABLE_TIMEOUT_INTERVAL") + ':');
        this.m_oTimeOutIntervalsLabel.setBounds(280, this.m_oControlPos, 120, 20);
        this.add(this.m_oTimeOutIntervalsLabel);
        this.m_oPollIntervalsLabel = new JLabel(this.getTitleString("SNMP_TABLE_POLL_INTERVALS") + ':');
        this.m_oPollIntervalsLabel.setBounds(20, this.m_oControlPos + 30, 100, 20);
        this.add(this.m_oPollIntervalsLabel);
        this.m_oDevicePortLabel = new JLabel(this.getTitleString("SNMP_TABLE_DEVICE_PORT") + ':');
        this.m_oDevicePortLabel.setBounds(280, this.m_oControlPos + 30, 120, 20);
        this.add(this.m_oDevicePortLabel);
    }

    private void initInputFields() {
        if (0 == this.m_iSNMPVersion || 1 == this.m_iSNMPVersion) {
            this.m_oGetCommunityTextField = new InmLengthLimitTextField(64);
            this.m_oGetCommunityTextField.setText("public");
            this.m_oGetCommunityTextField.setBounds(120, 30, 130, 20);
            this.m_oGetCommunityTextField.addMouseMotionListener((MouseMotionListener)this.generateMouseListenerAdapter((JTextField)this.m_oGetCommunityTextField));
            this.add((Component)this.m_oGetCommunityTextField);
            this.oGetCommunityLabel.setForeground(Color.red);
            this.oGetCommunityLabel.setBounds(255, 30, 10, 20);
            this.add(this.oGetCommunityLabel);
            this.m_oSetCommunityTextField = new InmLengthLimitTextField(64);
            this.m_oSetCommunityTextField.setText("private");
            this.m_oSetCommunityTextField.setBounds(400, 30, 130, 20);
            this.m_oSetCommunityTextField.addMouseMotionListener((MouseMotionListener)this.generateMouseListenerAdapter((JTextField)this.m_oSetCommunityTextField));
            this.add((Component)this.m_oSetCommunityTextField);
            this.oSetCommunityLabel.setForeground(Color.red);
            this.oSetCommunityLabel.setBounds(535, 30, 10, 20);
            this.add(this.oSetCommunityLabel);
        }
        this.createRetrialsJSpinner();
        this.m_oRetriesSpinner.setBounds(120, this.m_oControlPos, 130, 20);
        this.add((Component)this.m_oRetriesSpinner);
        this.oRetrialLabel.setForeground(Color.red);
        this.oRetrialLabel.setBounds(255, this.m_oControlPos, 10, 20);
        this.add(this.oRetrialLabel);
        this.createTimeOutIntervalsJSpinner();
        this.m_oTimeOutIntervalsSpinner.setBounds(400, this.m_oControlPos, 130, 20);
        this.add((Component)this.m_oTimeOutIntervalsSpinner);
        this.oTimeoutLabel.setForeground(Color.red);
        this.oTimeoutLabel.setBounds(535, this.m_oControlPos, 10, 20);
        this.add(this.oTimeoutLabel);
        this.createPollIntervalsJSpinner();
        this.m_oPollIntervalsSpinner.setBounds(120, this.m_oControlPos + 30, 130, 20);
        this.add((Component)this.m_oPollIntervalsSpinner);
        this.oPollLabel.setForeground(Color.red);
        this.oPollLabel.setBounds(255, this.m_oControlPos + 30, 10, 20);
        this.add(this.oPollLabel);
        this.createDevicePortJSpinner();
        this.m_oDevicePortSpinner.setBounds(400, this.m_oControlPos + 30, 130, 20);
        this.add((Component)this.m_oDevicePortSpinner);
        this.oDevPortLabel.setForeground(Color.red);
        this.oDevPortLabel.setBounds(535, this.m_oControlPos + 30, 10, 20);
        this.add(this.oDevPortLabel);
    }

    private String getTitleString(String key) {
        return this.m_oResManager.getResString(key);
    }

    private void createRetrialsJSpinner() {
        int iMaxCount = 32;
        int iMinCount = 0;
        int iCurValue = 2 == this.m_iSNMPVersion ? 5 : 3;
        this.m_oRetriesSpinnerModel = new NumericSpinnerModel(iCurValue, iMinCount, iMaxCount, 1);
        this.m_oRetriesSpinner = new Spinner((SpinnerModel)this.m_oRetriesSpinnerModel);
        this.m_oRetriesSpinner.setToolTipText(iMinCount + " - " + iMaxCount);
    }

    private void createTimeOutIntervalsJSpinner() {
        int iMaxCount = 120;
        int iMinCount = 1;
        int iCurValue = 2 == this.m_iSNMPVersion ? 10 : 5;
        this.m_oTimeOutIntervalsSpinnerModel = new NumericSpinnerModel(iCurValue, iMinCount, iMaxCount, 1);
        this.m_oTimeOutIntervalsSpinner = new Spinner((SpinnerModel)this.m_oTimeOutIntervalsSpinnerModel);
        this.m_oTimeOutIntervalsSpinner.setToolTipText(iMinCount + " - " + iMaxCount);
    }

    private void createPollIntervalsJSpinner() {
        int iMaxCount = Short.MAX_VALUE;
        int iMinCount = 0;
        int iCurValue = 1800;
        this.m_oPollIntervalsSpinnerModel = new NumericSpinnerModel(iCurValue, iMinCount, iMaxCount, 1);
        this.m_oPollIntervalsSpinner = new Spinner((SpinnerModel)this.m_oPollIntervalsSpinnerModel);
        this.m_oPollIntervalsSpinner.setToolTipText(iMinCount + " - " + iMaxCount);
    }

    private void createDevicePortJSpinner() {
        int iMaxCount = 65535;
        int iMinCount = 1;
        int iCurValue = 161;
        this.m_oDevicePortSpinnerModel = new NumericSpinnerModel(iCurValue, iMinCount, iMaxCount, 1);
        this.m_oDevicePortSpinner = new Spinner((SpinnerModel)this.m_oDevicePortSpinnerModel);
        this.m_oDevicePortSpinner.setToolTipText(iMinCount + " - " + iMaxCount);
    }

    public char[] getGetCommunity() {
        return DCEncryptServiceUtil.encrypt(this.m_oGetCommunityTextField.getText().toCharArray(), false);
    }

    public char[] getSetCommunity() {
        return DCEncryptServiceUtil.encrypt(this.m_oSetCommunityTextField.getText().toCharArray());
    }

    public int getRetries() {
        return (Integer)this.m_oRetriesSpinnerModel.getValue();
    }

    public int getTimeOutIntervals() {
        return (Integer)this.m_oTimeOutIntervalsSpinnerModel.getValue();
    }

    public int getPollIntervals() {
        return (Integer)this.m_oPollIntervalsSpinnerModel.getValue();
    }

    public int getDevicePort() {
        return (Integer)this.m_oDevicePortSpinnerModel.getValue();
    }

    public boolean validateFields() {
        boolean bSuccess = true;
        if (2 != this.m_iSNMPVersion) {
            if (StringUtils.isNullOrEmptyChar(this.getGetCommunity())) {
                this.showErrorMessage("GET_COMMUNITY_NAME_EMPTY");
                return false;
            }
            if (StringUtils.isNullOrEmptyChar(this.getSetCommunity())) {
                this.showErrorMessage("SET_COMMUNITY_NAME_EMPTY");
                return false;
            }
            bSuccess = this.checkForSpecialCharacters(this.getGetCommunity());
            if (!bSuccess) {
                this.showErrorMessage("GET_COMMUNITY_NAME_INVALID");
                return false;
            }
            bSuccess = this.checkForSpecialCharacters(this.getSetCommunity());
            if (!bSuccess) {
                this.showErrorMessage("SET_COMMUNITY_NAME_INVALID");
                return false;
            }
        }
        return true;
    }

    private boolean checkForSpecialCharacters(char[] strName) {
        boolean isValidName = true;
        return isValidName;
    }

    protected void showErrorMessage(String strKey) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.getTitleString(strKey), this.getTitleString("ERROR"), 0);
    }

    private MouseMotionAdapter generateMouseListenerAdapter(final JTextField oTextField) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                AddSNMPCommonParameterPanel.this.setToolTip(oEvent, oTextField);
            }
        };
    }

    private void setToolTip(MouseEvent oEvent, JTextField oTextField) {
        if (0 == oTextField.getText().trim().length()) {
            oTextField.setToolTipText(oTextField.getText().trim());
        }
    }

    public void setParamValue(SnmpParaInfo oParaInfo) {
        if (null == oParaInfo) {
            this.m_oGetCommunityTextField.setText("");
            this.m_oSetCommunityTextField.setText("");
            this.m_oRetriesSpinner.setValue((Object)-1);
            this.m_oTimeOutIntervalsSpinner.setValue((Object)-1);
            this.m_oPollIntervalsSpinner.setValue((Object)-1);
            this.m_oDevicePortSpinner.setValue((Object)-1);
            return;
        }
        if (2 != this.m_iSNMPVersion) {
            this.m_oGetCommunityTextField.setText(String.valueOf(DCEncryptServiceUtil.decrypt(oParaInfo.getGetCommunity())));
            this.m_oSetCommunityTextField.setText(String.valueOf(DCEncryptServiceUtil.decrypt(oParaInfo.getSetCommunity())));
        }
        this.m_oDevicePortSpinner.setValue((Object)oParaInfo.getDevPort());
        this.m_oRetriesSpinner.setValue((Object)oParaInfo.getRetries());
        this.m_oTimeOutIntervalsSpinner.setValue((Object)oParaInfo.getTimeOut());
        this.m_oPollIntervalsSpinner.setValue((Object)oParaInfo.getPollInterval());
    }

    public void changeCompentStaus(boolean status) {
        this.m_oGetCommunityTextField.setEnabled(status);
        this.m_oSetCommunityTextField.setEnabled(status);
        this.m_oRetriesSpinner.setEnabled(status);
        this.m_oTimeOutIntervalsSpinner.setEnabled(status);
        this.m_oPollIntervalsSpinner.setEnabled(status);
        this.m_oDevicePortSpinner.setEnabled(status);
    }

    public SnmpParaInfo getSnmpParaInfo() {
        SnmpParaInfo oSnmpParaInfo = new SnmpParaInfo();
        if (2 != this.m_iSNMPVersion) {
            oSnmpParaInfo.setGetCommunity(this.m_oGetCommunityTextField.getText().toCharArray(), false);
            oSnmpParaInfo.setSetCommunity(this.m_oSetCommunityTextField.getText().toCharArray(), false);
        }
        oSnmpParaInfo.setSnmpEnum(this.m_iSNMPVersion);
        oSnmpParaInfo.setPollInterval(Integer.valueOf(this.m_oPollIntervalsSpinner.getValue().toString()));
        oSnmpParaInfo.setDevPort(Integer.valueOf(this.m_oDevicePortSpinner.getValue().toString()));
        oSnmpParaInfo.setRetries(Integer.valueOf(this.m_oRetriesSpinner.getValue().toString()));
        oSnmpParaInfo.setTimeOut(Integer.valueOf(this.m_oTimeOutIntervalsSpinner.getValue().toString()));
        return oSnmpParaInfo;
    }

    public void setCommunityVisible(boolean aFlag) {
        this.m_oGetCommunityLabel.setVisible(aFlag);
        this.m_oGetCommunityTextField.setVisible(aFlag);
        this.oGetCommunityLabel.setVisible(aFlag);
        this.m_oSetCommunityLabel.setVisible(aFlag);
        this.m_oSetCommunityTextField.setVisible(aFlag);
        this.oSetCommunityLabel.setVisible(aFlag);
    }

    public void reSetBounds(boolean aFlag) {
        int iControlPosForV3 = 40;
        int iControlPosForV3Ins = 40;
        if (aFlag) {
            iControlPosForV3 = this.m_oControlPos;
            iControlPosForV3Ins = 30;
        }
        this.m_oRetriesLabel.setBounds(20, iControlPosForV3, 100, 20);
        this.m_oRetriesSpinner.setBounds(120, iControlPosForV3, 130, 20);
        this.oRetrialLabel.setBounds(255, iControlPosForV3, 10, 20);
        this.m_oTimeOutIntervalsLabel.setBounds(280, iControlPosForV3, 120, 20);
        this.m_oTimeOutIntervalsSpinner.setBounds(400, iControlPosForV3, 130, 20);
        this.oTimeoutLabel.setBounds(535, iControlPosForV3, 10, 20);
        this.m_oPollIntervalsLabel.setBounds(20, iControlPosForV3 + iControlPosForV3Ins, 100, 20);
        this.m_oPollIntervalsSpinner.setBounds(120, iControlPosForV3 + iControlPosForV3Ins, 130, 20);
        this.oPollLabel.setBounds(255, iControlPosForV3 + iControlPosForV3Ins, 10, 20);
        this.m_oDevicePortLabel.setBounds(280, iControlPosForV3 + iControlPosForV3Ins, 120, 20);
        this.m_oDevicePortSpinner.setBounds(400, iControlPosForV3 + iControlPosForV3Ins, 130, 20);
        this.oDevPortLabel.setBounds(535, iControlPosForV3 + iControlPosForV3Ins, 10, 20);
    }
}

