/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.model;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.snmpparams.model.ISNMPParaInfoModel;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SNMPParaInfoModel
implements ISNMPParaInfoModel,
IDCObjectDeallocator {
    private static ISNMPParaInfoModel m_oModel;
    private List<SnmpParaInfo> m_oParaList = new ArrayList<SnmpParaInfo>(0);

    private SNMPParaInfoModel() {
        this.initializeParaList();
    }

    public static synchronized ISNMPParaInfoModel getInstance() {
        if (null == m_oModel) {
            m_oModel = new SNMPParaInfoModel();
            DCObjectDestructor.getInstance().addObjectForDestructor((SNMPParaInfoModel)m_oModel);
        }
        return m_oModel;
    }

    private void initializeParaList() {
        try {
            this.m_oParaList = StandAloneSyncCtrller.getInstance().getSnmpParaInfo();
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        if (null == this.m_oParaList) {
            this.m_oParaList = new ArrayList<SnmpParaInfo>(0);
        }
    }

    @Override
    public void addParaInfo(SnmpParaInfo oParaInfo) {
        if (null != oParaInfo) {
            this.m_oParaList.add(oParaInfo);
        }
    }

    @Override
    public SnmpParaInfo getDefaultParaInfo() {
        if (null == this.m_oParaList || 0 >= this.m_oParaList.size()) {
            return null;
        }
        SnmpParaInfo oDefaultPara = this.getParaInfo("default", 0);
        if (null == oDefaultPara) {
            oDefaultPara = this.getParaInfo("default", 1);
        }
        if (null == oDefaultPara) {
            oDefaultPara = this.getParaInfo("default", 2);
        }
        if (null == oDefaultPara) {
            oDefaultPara = this.m_oParaList.get(0);
        }
        return oDefaultPara;
    }

    @Override
    public SnmpParaInfo getParaInfo(String strTemplateName, int iVersion) {
        int iParaCount = this.m_oParaList.size();
        if (0 >= iParaCount || null == strTemplateName) {
            return null;
        }
        SnmpParaInfo oParaInfo = null;
        for (int i = 0; i < iParaCount; ++i) {
            oParaInfo = this.m_oParaList.get(i);
            if (!strTemplateName.equalsIgnoreCase(oParaInfo.getTemplate()) || iVersion != oParaInfo.getSnmpEnum()) continue;
            return oParaInfo;
        }
        return null;
    }

    @Override
    public List<SnmpParaInfo> getParaInfoList() {
        return this.m_oParaList;
    }

    @Override
    public void setToNULL() {
        m_oModel = null;
        this.m_oParaList = null;
    }

    @Override
    public void deleteParaInfo(SnmpParaInfo oParaInfo) {
        if (null != oParaInfo && this.m_oParaList.contains(oParaInfo)) {
            this.m_oParaList.remove(oParaInfo);
        }
    }
}

