/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams.model;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.snmpparams.model.ISNMPParaInfoModel;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class DevAccessSNMPParaModel
implements ISNMPParaInfoModel {
    private List<SnmpParaInfo> m_oParaList = new ArrayList<SnmpParaInfo>(0);

    public DevAccessSNMPParaModel() {
        this.initializeParaList();
    }

    public DevAccessSNMPParaModel(boolean isAccessPanel) {
        try {
            this.m_oParaList = StandAloneSyncCtrller.getInstance().getParaForDevAccess(isAccessPanel);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        if (null == this.m_oParaList) {
            this.m_oParaList = new ArrayList<SnmpParaInfo>(0);
        }
    }

    public void initializeParaList() {
        try {
            this.m_oParaList = StandAloneSyncCtrller.getInstance().getParaForDevAccess();
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        if (null == this.m_oParaList) {
            this.m_oParaList = new ArrayList<SnmpParaInfo>(0);
        }
    }

    @Override
    public void addParaInfo(SnmpParaInfo paraInfo) {
    }

    @Override
    public void deleteParaInfo(SnmpParaInfo paraInfo) {
    }

    @Override
    public SnmpParaInfo getDefaultParaInfo() {
        if (null == this.m_oParaList || 0 >= this.m_oParaList.size()) {
            return null;
        }
        SnmpParaInfo oDefaultPara = this.getParaInfo("default", 0);
        if (null == oDefaultPara) {
            oDefaultPara = this.getParaInfo("default", 1);
        }
        if (null == oDefaultPara) {
            oDefaultPara = this.m_oParaList.get(0);
        }
        return oDefaultPara;
    }

    @Override
    public SnmpParaInfo getParaInfo(String strDevName, int iVersion) {
        int iParaCount = this.m_oParaList.size();
        if (0 >= iParaCount || null == strDevName) {
            return null;
        }
        SnmpParaInfo oParaInfo = null;
        for (int i = 0; i < iParaCount; ++i) {
            oParaInfo = this.m_oParaList.get(i);
            if (!strDevName.equalsIgnoreCase(oParaInfo.getDevResource().getDeviceName()) || iVersion != oParaInfo.getSnmpEnum()) continue;
            return oParaInfo;
        }
        return null;
    }

    @Override
    public List<SnmpParaInfo> getParaInfoList() {
        return this.m_oParaList;
    }

    public List<SnmpParaInfo> test() {
        SnmpParaInfo oSnmpParaInfo = null;
        ArrayList<SnmpParaInfo> oSnmpParaInfoLst = new ArrayList<SnmpParaInfo>();
        for (int i = 0; i < 1; ++i) {
            oSnmpParaInfo = DevAccessSNMPParaModel.getDevSNMPParaFromAsn(i);
            oSnmpParaInfoLst.add(oSnmpParaInfo);
        }
        return oSnmpParaInfoLst;
    }

    public static SnmpParaInfo getDevSNMPParaFromAsn(int value) {
        SnmpParaInfo oSnmpParaInfo = new SnmpParaInfo();
        String strDevName = "Dev" + value;
        String strDevIP = "10.78.220.194";
        Resource oDevDetail = new Resource();
        oDevDetail.setDeviceName(strDevName);
        oDevDetail.setDeviceIP(strDevIP);
        oDevDetail.setDeviceID(2);
        oDevDetail.setDevTypeId(1252);
        oSnmpParaInfo.setDevResource(oDevDetail);
        oSnmpParaInfo.setTimeOut(value + 1);
        oSnmpParaInfo.setRetries(value + 1);
        oSnmpParaInfo.setDevPort(value + 1);
        oSnmpParaInfo.setPollInterval(value + 1);
        if (value % 2 == 0) {
            oSnmpParaInfo.setSnmpEnum(0);
        } else {
            oSnmpParaInfo.setSnmpEnum(1);
        }
        oSnmpParaInfo.setGetCommunity(("" + value).toCharArray(), false);
        oSnmpParaInfo.setSetCommunity(("" + value).toCharArray(), false);
        return oSnmpParaInfo;
    }
}

