/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.snmpparams;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.snmpparams.SNMPParamUtil;
import com.huawei.dc.standalone.snmpparams.model.DevAccessSNMPParaModel;
import com.huawei.dc.standalone.snmpparams.model.ISNMPParaInfoModel;
import com.huawei.dc.standalone.snmpparams.model.SNMPParaInfoModel;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.snmpparams.view.DeviceAccessProtocolDlg;
import com.huawei.dc.standalone.snmpparams.view.ISNMPParamsDlg;
import com.huawei.dc.standalone.snmpparams.view.SNMPParamTabPanel;
import com.huawei.dc.standalone.snmpparams.view.ShowSNMPParamsDlg;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class SNMPParamTableManager {
    private ISNMPParamsDlg m_oParamDlg;
    private IDCStandAloneSyncCtrller m_oSyncController;
    private ResourceManager m_oResManager;
    private ISNMPParaInfoModel m_oSNMPParaModel;

    public SNMPParamTableManager(DCModalDialog oDialog) {
        if (oDialog instanceof ShowSNMPParamsDlg) {
            this.m_oParamDlg = (ShowSNMPParamsDlg)oDialog;
            this.m_oSNMPParaModel = SNMPParaInfoModel.getInstance();
        } else {
            this.m_oParamDlg = (DeviceAccessProtocolDlg)oDialog;
            this.m_oSNMPParaModel = new DevAccessSNMPParaModel();
        }
        this.m_oSyncController = StandAloneSyncCtrller.getInstance();
        this.m_oResManager = ResourceManager.getInstance();
    }

    public SNMPParamTableManager(DCModalDialog oDialog, boolean isAccessPanel) {
        this.m_oParamDlg = (DeviceAccessProtocolDlg)oDialog;
        this.m_oSNMPParaModel = new DevAccessSNMPParaModel(isAccessPanel);
        this.m_oSyncController = StandAloneSyncCtrller.getInstance();
        this.m_oResManager = ResourceManager.getInstance();
    }

    public boolean populateParamsForAllVersions() throws DCException {
        List<SnmpParaInfo> oParaInfoList = this.m_oSNMPParaModel.getParaInfoList();
        if (null == oParaInfoList || oParaInfoList.isEmpty()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("NO_DEVICES"));
            return false;
        }
        SnmpParaInfo oParaInfo = null;
        int iParaCount = oParaInfoList.size();
        for (int i = 0; i < iParaCount; ++i) {
            oParaInfo = oParaInfoList.get(i);
            if (oParaInfo.getSnmpEnum() == 2) {
                this.addParamInfoToTable(oParaInfo, i);
                continue;
            }
            this.addParamInfoToTable(oParaInfo);
        }
        return true;
    }

    private void addParamInfoToTable(SnmpParaInfo oParaInfo) {
        if (null == oParaInfo) {
            return;
        }
        Vector<Object> oRowVector = this.getVectorForParaInfo(oParaInfo);
        JTable oTable = this.m_oParamDlg.getTableForVersion(oParaInfo.getSnmpEnum());
        if (null == oTable) {
            return;
        }
        ((DefaultTableModel)oTable.getModel()).addRow(oRowVector);
        oTable.changeSelection(oTable.getRowCount() - 1, 0, false, false);
        DCFrameWorkUtil.updateUI(oTable);
    }

    private void addParamInfoToTable(SnmpParaInfo oParaInfo, int row) {
        if (null == oParaInfo) {
            return;
        }
        Resource oResource = new Resource();
        oResource = oParaInfo.getDevResource();
        SnmpParaInfo snmpParaInfo = new SnmpParaInfo();
        try {
            snmpParaInfo = this.m_oSyncController.getSNMPParaForResource(oResource);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        if (snmpParaInfo == null) {
            this.addParamInfoToTable(oParaInfo);
        } else {
            Vector<Object> oRowVector = new Vector(16);
            oRowVector = this.getVectorForParaInfo(oParaInfo);
            JTable oTable = this.m_oParamDlg.getTableForVersion(oParaInfo.getSnmpEnum());
            if (null == oTable) {
                return;
            }
            if (snmpParaInfo.getUserName() == null) {
                oRowVector.add(7, " ");
            } else {
                oRowVector.add(7, snmpParaInfo.getUserName());
            }
            if (snmpParaInfo.getContextName() == null) {
                oRowVector.add(8, " ");
            } else {
                oRowVector.add(8, snmpParaInfo.getContextName());
            }
            if (snmpParaInfo.getContextId() == null) {
                oRowVector.add(9, " ");
            } else {
                oRowVector.add(9, snmpParaInfo.getContextId());
            }
            oRowVector.add(10, SNMPParamUtil.getDataEncryptionValue(snmpParaInfo.getDataEncryptionType()));
            oRowVector.add(11, SNMPParamUtil.getAuthorizationValue(snmpParaInfo.getAuthenticationType()));
            ((DefaultTableModel)oTable.getModel()).addRow(oRowVector);
            oTable.changeSelection(oTable.getRowCount() - 1, 0, false, false);
            DCFrameWorkUtil.updateUI(oTable);
        }
    }

    private Vector<Object> getVectorForParaInfo(SnmpParaInfo oParaInfo) {
        Resource oDeviceDetail;
        int iSNMPVersion = oParaInfo.getSnmpEnum();
        Vector<Object> oRowVector = new Vector<Object>(0);
        if (null != oParaInfo.getTemplate()) {
            oRowVector.addElement(oParaInfo.getTemplate());
        }
        if (null != (oDeviceDetail = oParaInfo.getDevResource())) {
            oRowVector.addElement(oDeviceDetail);
            oRowVector.addElement(oDeviceDetail.getDeviceIP());
        }
        oRowVector.addElement(oParaInfo.getSnmpEnum());
        if (0 == iSNMPVersion || 1 == iSNMPVersion) {
            oRowVector.addElement(String.valueOf(DCEncryptServiceUtil.decrypt(oParaInfo.getGetCommunity())));
            oRowVector.addElement(String.valueOf(DCEncryptServiceUtil.decrypt(oParaInfo.getSetCommunity())));
        }
        oRowVector.addElement(oParaInfo.getTimeOut());
        oRowVector.addElement(oParaInfo.getRetries());
        oRowVector.addElement(oParaInfo.getPollInterval());
        oRowVector.addElement(oParaInfo.getDevPort());
        if (2 == iSNMPVersion) {
            oRowVector.addElement(oParaInfo.getUserName());
            oRowVector.addElement(oParaInfo.getContextName());
            oRowVector.addElement(oParaInfo.getContextId());
            int iEncType = oParaInfo.getDataEncryptionType();
            oRowVector.addElement(SNMPParamUtil.getDataEncryptionValue(iEncType));
            int iAuthType = oParaInfo.getAuthenticationType();
            oRowVector.addElement(SNMPParamUtil.getAuthorizationValue(iAuthType));
        }
        return oRowVector;
    }

    private void deleteSNMPParaRow(SnmpParaInfo oParaInfo) {
        if (null == oParaInfo) {
            return;
        }
        this.m_oSNMPParaModel.deleteParaInfo(oParaInfo);
        int iSelectedVersion = this.m_oParamDlg.getSelectedVersion();
        JTable oTable = this.m_oParamDlg.getTableForVersion(iSelectedVersion);
        if (null == oTable) {
            return;
        }
        DefaultTableModel oTableModel = (DefaultTableModel)oTable.getModel();
        Vector<Vector> oDataVector = oTableModel.getDataVector();
        Vector oRowVector = null;
        int iRowCount = oDataVector.size();
        for (int i = iRowCount - 1; i >= 0; --i) {
            oRowVector = oDataVector.get(i);
            String strTemplateName = (String)oRowVector.get(0);
            int iVersion = (Integer)oRowVector.get(1);
            if (!oParaInfo.getTemplate().equalsIgnoreCase(strTemplateName) || oParaInfo.getSnmpEnum() != iVersion) continue;
            oDataVector.remove(oRowVector);
        }
    }

    public SnmpParaInfo deleteSelectedTemplates() {
        int iSelectedVersion = this.m_oParamDlg.getSelectedVersion();
        JTable oTable = this.m_oParamDlg.getTableForVersion(iSelectedVersion);
        if (null == oTable) {
            return null;
        }
        int iSelectedRow = oTable.getSelectedRow();
        if (-1 == iSelectedRow) {
            return null;
        }
        SnmpParaInfo oParaInfo = this.getSelectedParaInfo();
        if (null == oParaInfo) {
            return null;
        }
        if ("default".equalsIgnoreCase(oParaInfo.getTemplate())) {
            DCOptionPane.showMessageDialog((Component)((Object)((ShowSNMPParamsDlg)this.m_oParamDlg)), this.m_oResManager.getResString("DEFAULT_SNMP_TEMPLATE_CANNOT_BE_DELETED"), this.m_oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
            return null;
        }
        ArrayList<SnmpParaInfo> oParaList = new ArrayList<SnmpParaInfo>(0);
        oParaList.add(oParaInfo);
        try {
            this.m_oSyncController.deleteSnmpParaInfos(oParaList);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return null;
        }
        this.m_oSNMPParaModel.deleteParaInfo(oParaInfo);
        this.deleteSNMPParaRow(oParaInfo);
        oTable.updateUI();
        this.m_oParamDlg.refreshTable();
        int iRowCount = oTable.getRowCount();
        if (0 < iRowCount) {
            this.m_oParamDlg.resetTableSelection(oTable, iSelectedRow, iRowCount);
        }
        return oParaInfo;
    }

    public SnmpParaInfo getSelectedParaInfo() {
        int iSelectedVersion = this.m_oParamDlg.getSelectedVersion();
        JTable oTable = this.m_oParamDlg.getTableForVersion(iSelectedVersion);
        if (null == oTable) {
            return null;
        }
        DefaultTableModel oTableModel = (DefaultTableModel)oTable.getModel();
        int iSelectedRow = oTable.getSelectedRow();
        if (0 > iSelectedRow || oTableModel.getRowCount() <= iSelectedRow) {
            return null;
        }
        Vector<Vector> oDataVector = oTableModel.getDataVector();
        Vector oRowVector = oDataVector.get(iSelectedRow);
        String strTempDevName = "";
        int iVersion = -1;
        int columnSize = oRowVector.size();
        strTempDevName = oRowVector.get(0).toString();
        iVersion = SNMPParamTabPanel.getDevAccessColumnCount() == columnSize ? Integer.valueOf(oRowVector.get(2).toString()).intValue() : ((Integer)oRowVector.get(1)).intValue();
        SnmpParaInfo oParaInfo = this.m_oSNMPParaModel.getParaInfo(strTempDevName, iVersion);
        return oParaInfo;
    }

    public int addSnmpParaInfo(SnmpParaInfo oParaInfo) {
        try {
            this.m_oSyncController.setSnmpParaInfo(oParaInfo);
        }
        catch (DCException e) {
            return e.getErrorCode();
        }
        this.m_oSNMPParaModel.addParaInfo(oParaInfo);
        this.addParamInfoToTable(oParaInfo);
        return 0;
    }

    public List<SnmpParaInfo> getSnmpParaInfoList() {
        List<SnmpParaInfo> snmpParaInfoList = null;
        try {
            snmpParaInfoList = this.m_oSyncController.getSnmpParaInfo();
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        return snmpParaInfoList;
    }

    public void modifyDeviceParaInfo(SnmpParaInfo oSnmpParaInfo, List<Resource> oDevList) throws DCException {
        this.m_oSyncController.modifyDevice(oDevList, oSnmpParaInfo);
    }

    public void updateDataToTable(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList, SnmpParaInfo oSnmpParaInfo, HashMap<Integer, Integer> m_oDeviceRowMap) {
        AsnDCDeviceSubmapNtfnInfo oAsnDevSubMapInfo = null;
        AsnDCDeviceInfo oAsnDevInfo = null;
        int iSelectedVersion = this.m_oParamDlg.getSelectedVersion();
        JTable oSelectedTable = this.m_oParamDlg.getTableForVersion(iSelectedVersion);
        DefaultTableModel oSelectedTableModel = (DefaultTableModel)oSelectedTable.getModel();
        if (oSnmpParaInfo.getSnmpEnum() == iSelectedVersion) {
            int iRow = -1;
            for (int i = 0; i < oDeviceInfoList.size(); ++i) {
                oAsnDevSubMapInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
                oAsnDevInfo = oAsnDevSubMapInfo.oDeviceInfo;
                if (0 != oAsnDevInfo.oErrorInfo.iErrorNo.intValue()) continue;
                iRow = m_oDeviceRowMap.get(oAsnDevInfo.iDevId.intValue());
                this.updateOneRowData(oSelectedTableModel, oSnmpParaInfo, iRow);
            }
            DCFrameWorkUtil.updateUI(oSelectedTable);
            this.setDefaultSelectedRow(oSelectedTable);
            return;
        }
        JTable oSnmpAddDataTable = null;
        Vector<Object> oVector = null;
        oSnmpAddDataTable = 0 == iSelectedVersion ? this.m_oParamDlg.getTableForVersion(1) : this.m_oParamDlg.getTableForVersion(0);
        oAsnDevSubMapInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(0);
        oAsnDevInfo = oAsnDevSubMapInfo.oDeviceInfo;
        if (0 == oAsnDevInfo.oErrorInfo.iErrorNo.intValue()) {
            int delRow = m_oDeviceRowMap.get(oAsnDevInfo.iDevId.intValue());
            if (1 != m_oDeviceRowMap.size()) {
                Resource oDevInfo = null;
                oDevInfo = (Resource)oSelectedTable.getValueAt(delRow, 0);
                oSnmpParaInfo.setDevResource(oDevInfo);
            }
            oVector = this.getVectorForParaInfo(oSnmpParaInfo);
            oSelectedTableModel.removeRow(delRow);
            ((DefaultTableModel)oSnmpAddDataTable.getModel()).addRow(oVector);
            DCFrameWorkUtil.updateUI(oSelectedTable);
            DCFrameWorkUtil.updateUI(oSnmpAddDataTable);
            this.setDefaultSelectedRow(oSelectedTable);
        }
    }

    private void setDefaultSelectedRow(JTable oTable) {
        int iRowCount = oTable.getRowCount();
        int selectedRow = oTable.getSelectedRow();
        if (0 < iRowCount && selectedRow < 0) {
            oTable.setRowSelectionInterval(0, 0);
        }
        this.m_oParamDlg.refreshTable();
    }

    public void updateOneRowData(DefaultTableModel oTableModel, SnmpParaInfo oParaInfo, int row) {
        if (null != oParaInfo.getDevResource()) {
            oTableModel.setValueAt(oParaInfo.getDevResource(), row, 0);
        }
        oTableModel.setValueAt(oParaInfo.getSnmpEnum(), row, 2);
        if (oParaInfo.getSnmpEnum() != 2) {
            oTableModel.setValueAt(String.valueOf(oParaInfo.getGetCommunityAfterDecode()), row, 3);
            oTableModel.setValueAt(String.valueOf(oParaInfo.getSetCommunityAfterDecode()), row, 4);
            oTableModel.setValueAt(oParaInfo.getDevPort(), row, 8);
            oTableModel.setValueAt(oParaInfo.getTimeOut(), row, 5);
            oTableModel.setValueAt(oParaInfo.getRetries(), row, 6);
            oTableModel.setValueAt(oParaInfo.getPollInterval(), row, 7);
        }
        if (oParaInfo.getSnmpEnum() == 2) {
            oTableModel.setValueAt(oParaInfo.getDevPort(), row, 6);
            oTableModel.setValueAt(oParaInfo.getTimeOut(), row, 3);
            oTableModel.setValueAt(oParaInfo.getRetries(), row, 4);
            oTableModel.setValueAt(oParaInfo.getPollInterval(), row, 5);
            oTableModel.setValueAt(oParaInfo.getUserName(), row, 7);
            oTableModel.setValueAt(oParaInfo.getContextName(), row, 8);
            oTableModel.setValueAt(oParaInfo.getContextId(), row, 9);
            oTableModel.setValueAt(SNMPParamUtil.getDataEncryptionValue(oParaInfo.getDataEncryptionType()), row, 10);
            oTableModel.setValueAt(SNMPParamUtil.getAuthorizationValue(oParaInfo.getAuthenticationType()), row, 11);
        }
    }
}

