/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.security;

import com.huawei.dc.common.comparefiles.CompareConfigFileDialog;
import com.huawei.dc.common.comparefiles.CompareRautingFileDialog;
import com.huawei.dc.common.components.DataCenterMainPanel;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCParsePackageXmlUtil;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.log.logcollection.LogCollectionDialog;
import com.huawei.dc.log.logcollection.LogCollectionImportDialog;
import com.huawei.dc.security.ISecurityManager;
import com.huawei.dc.security.SecurityManagerImpl;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.securitymanagement.SecurityService;
import com.swimap.iview.framework.util.FrameworkUtilities;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class SecurityAdapter
extends BaseModule
implements SecurityService {
    private static int iInputPwdErrorCnt = 0;
    private static boolean bCntTimeStart = false;
    private static long lStartTime = 0L;

    public SecurityAdapter(ModuleManager moduleMgr) {
        super(moduleMgr);
    }

    public void initialize() {
    }

    public String getModuleName() {
        return "securityservice";
    }

    public boolean login() {
        return true;
    }

    public boolean logout() {
        return true;
    }

    public String getUsername() {
        return "admin";
    }

    public boolean verifyPassword(String string) {
        return true;
    }

    public boolean verifyPassword(char[] agrs) {
        ISecurityManager m_osecurityManager = DCFrameWorkUtil.getSecurityManager();
        ResourceManager oRes = ResourceManager.getInstance();
        if (m_osecurityManager == null) {
            m_osecurityManager = new SecurityManagerImpl();
            DCFrameWorkUtil.setSecurityManager(m_osecurityManager);
        }
        char[] password = DCEncryptServiceUtil.encrypt(agrs);
        if (iInputPwdErrorCnt == 3) {
            boolean bUnLock;
            long lOverTime = System.currentTimeMillis() - lStartTime;
            boolean bl = bUnLock = lOverTime > 1800000L;
            if (bUnLock) {
                bCntTimeStart = false;
                iInputPwdErrorCnt = 0;
            } else {
                String iLeaveMinutes = "" + (int)(30L - lOverTime / 60000L);
                String strMessage = MessageFormat.format(oRes.getResString("FAILURE_TYPE_OVER_MAX_FAILLOGIN"), iLeaveMinutes);
                this.showMessageDlg(strMessage);
                return false;
            }
        }
        int iLoginStatus = m_osecurityManager.doLogin("admin", -1, -1, password);
        String errMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iLoginStatus));
        if (0 != iLoginStatus) {
            if (errMsg.equals(String.valueOf(iLoginStatus))) {
                errMsg = ResourceManager.getInstance().getResString("UNABLE_TO_INITIALISE");
                this.showMessageDlg(errMsg);
                DCDebugTracer.trace("DC::registerStandAloneClient()--m_osecurityManager-doLogin error,return:" + iLoginStatus);
            } else if (DCFrameWorkUtil.getIsSingleClient()) {
                if (1 == ++iInputPwdErrorCnt) {
                    String strMessage = oRes.getResString("FAILURE_TYPE_INVALID_PASSWORD");
                    this.showMessageDlg(strMessage);
                } else if (2 == iInputPwdErrorCnt) {
                    String strMessage = MessageFormat.format(oRes.getResString("BEFOR_ACCOUNT_LOCKING"), "30");
                    this.showMessageDlg(strMessage);
                } else if (3 == iInputPwdErrorCnt) {
                    String strMessage = MessageFormat.format(oRes.getResString("FAILURE_TYPE_OVER_MAX_FAILLOGIN"), "30");
                    if (!bCntTimeStart) {
                        bCntTimeStart = true;
                        lStartTime = System.currentTimeMillis();
                    }
                    this.showMessageDlg(strMessage);
                    FrameworkUtilities.getTerminalManager().lockTerminal();
                }
            }
            password = null;
            return false;
        }
        iInputPwdErrorCnt = 0;
        return true;
    }

    private void showMessageDlg(String strMsg) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strMsg, ResourceManager.getInstance().getResString("PROMPT_FOR_OPIICAL"), 1);
    }

    public boolean checkCommandAreaDesc(DescContainer descContainer) {
        return true;
    }

    public Object[] getSecurityInfo() {
        return null;
    }

    public short[] checkRight(Object[][] objectArray) {
        return null;
    }

    public void showAboutDialog() {
        try {
            Class<?> oAboutDlgClass = Class.forName(DCParsePackageXmlUtil.getInstance().getAboutDlgClassPath());
            Constructor<?> oConstructor = oAboutDlgClass.getConstructor(JFrame.class);
            JDialog oAboutDlg = (JDialog)oConstructor.newInstance(DCFrameWorkUtil.getMainFrame());
            oAboutDlg.setVisible(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public void importFilesActivateWindow() {
        LogCollectionImportDialog dialog = new LogCollectionImportDialog();
        dialog.setVisible(true);
    }

    public void exportFilesActivateWindow() {
        LogCollectionDialog dialog = new LogCollectionDialog();
        dialog.setVisible(true);
    }

    public void compareConfigActivateWindow() {
        CompareConfigFileDialog compareConfigFileDialog = new CompareConfigFileDialog(DCFrameWorkUtil.getMainFrame());
        compareConfigFileDialog.setTitle(ResourceManager.getInstance().getResString("CompareConfigFiles"));
        compareConfigFileDialog.setVisible(true);
    }

    public void compareRoutdingActivateWindow() {
        CompareRautingFileDialog compareRoutdingFileDialog = new CompareRautingFileDialog(DCFrameWorkUtil.getMainFrame());
        compareRoutdingFileDialog.setTitle(ResourceManager.getInstance().getResString("CompareRoutingFiles"));
        compareRoutdingFileDialog.setVisible(true);
    }

    public void printActivateWindow() {
        DataCenterMainPanel.getInstance().printPage();
    }

    public void previewActivateWindow() {
        DataCenterMainPanel.getInstance().printPreviewPage();
    }

    public void pageSetupActivateWindow() {
        PrintSupportor.setupPage();
    }
}

