/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.search.view;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDevInfoList;
import com.huawei.dc.common.asndatacenter.AsnGatewayInfo;
import com.huawei.dc.common.asndatacenter.AsnGatewayInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSearchGatewayRsp;
import com.huawei.dc.common.asndatacenter.AsnSearchNGDeviceRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneCommUtil;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.event.IStandAloneNotificationListener;
import com.huawei.dc.standalone.event.StandAloneEvent;
import com.huawei.dc.standalone.event.StandAloneNotifier;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.search.view.ModifyNGDevDialog;
import com.huawei.dc.standalone.search.view.SearchTableCellRenderer;
import com.huawei.dc.standalone.view.DeviceProgressDlg;
import com.huawei.dc.standalone.view.IAddGatewayAddr;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SearchGatewayDeviceDialog
extends DCModalDialog
implements IStandAloneNotificationListener {
    private static final long serialVersionUID = 1L;
    private JButton m_oStopButton;
    private JButton m_oDetailsButton;
    private JButton m_oAddToDCButton;
    private boolean m_bShowDetails = false;
    private JPanel m_oDeviceInfoPanel;
    private DCExtendedTable m_oDeviceInfoTable;
    private DCSortableTableModel m_oDeivceInfoTableModel;
    private static final int GATEWAY_ADDR_COL = 1;
    private JScrollPane m_oScrollPane;
    private IAddGatewayAddr m_oAddGatewayDevicesPanel;
    private JProgressBar m_progressBar = null;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private int m_iDialogType;
    private int m_iDialogWidth;
    private int m_iRequestId;
    private IDCStandAloneSyncCtrller m_oStandAloneSyncCtrller;
    private T2000DevInfo m_oT2000DevInfo;
    private static final int DEVICE_INFO_TABLE_ID = 0;
    private static final int DEVICE_INFO_TABLE_NAME = 1;
    private static final int DEVICE_INFO_TABLE_PORT = 2;
    private static final int DEVICE_INFO_TABLE_USER_NAME = 3;
    private static final int DEVICE_INFO_TABLE_PASSWORD = 4;
    private byte[] m_oSyncObject;
    private DeviceProgressDlg m_oAddDeviceProgressBarDlg;
    private static final char DETAIL_BUTTON_MNEMONIC = 'D';
    private static final int COLUMN_DEVICENAME = 1;
    private static final int COLUMN_DEVICEID = 0;
    private IStandAloneNotificationListener m_oStandALoneNotificationLstner = null;

    public SearchGatewayDeviceDialog(int iDialogType, int iReqId, IAddGatewayAddr oComp) {
        this(iDialogType, iReqId);
        this.m_oAddGatewayDevicesPanel = oComp;
        this.m_oSyncObject = new byte[0];
    }

    public SearchGatewayDeviceDialog(int iDialogType, int iRequestId, IStandAloneNotificationListener oParentDialog) {
        this(iDialogType, iRequestId);
        this.m_oStandALoneNotificationLstner = oParentDialog;
    }

    public SearchGatewayDeviceDialog(int iDialogType, int iRequestId) {
        this.m_iDialogType = iDialogType;
        this.m_iRequestId = iRequestId;
        this.m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        StandAloneNotifier.getInstance().addStandAloneNotificationListener(this);
        this.m_oSyncObject = new byte[0];
        if (1 == this.m_iDialogType) {
            this.m_iDialogWidth = 400;
            this.m_bShowDetails = false;
        } else {
            this.m_iDialogWidth = 600;
            this.m_bShowDetails = true;
        }
        this.jbinit();
    }

    private void jbinit() {
        this.initButtons();
        this.initDialog();
        this.initializeProgressBar();
        if (2 == this.m_iDialogType) {
            this.initSearchDeviceTable();
            this.m_oAddToDCButton.setVisible(true);
            this.m_oDeviceInfoPanel.setVisible(true);
        } else if (1 == this.m_iDialogType) {
            this.initSearchGatewayTable();
            this.m_oAddToDCButton.setVisible(false);
            this.m_oDeviceInfoPanel.setVisible(false);
        }
        this.initActionListeners();
        this.m_oOKBtn.setName("StandAlone_SearchGatewayDeviceDialog_m_oOKBtn");
        this.m_oCancelBtn.setName("StandAlone_SearchGatewayDeviceDialog_m_oCancelBtn");
    }

    private void initActionListeners() {
        this.detailButtonActionListener();
        this.stopButtonActionListener();
    }

    private void detailButtonActionListener() {
        this.m_oDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchGatewayDeviceDialog.this.detailButtonActionPerformed();
            }
        });
    }

    protected void detailButtonActionPerformed() {
        if (!this.m_bShowDetails) {
            this.m_bShowDetails = true;
            this.m_oDetailsButton.setText("<< " + this.m_oResManager.getResString("OPERATE_DETAIL"));
            this.m_oDeviceInfoPanel.setVisible(true);
            if (2 == this.m_iDialogType) {
                this.setSize(this.m_iDialogWidth, 390);
            } else if (1 == this.m_iDialogType) {
                this.setSize(this.m_iDialogWidth, 360);
            }
            this.validate();
            this.repaint();
        } else {
            this.m_bShowDetails = false;
            this.m_oDetailsButton.setText(this.m_oResManager.getResString("OPERATE_DETAIL") + " >>");
            this.m_oDeviceInfoPanel.setVisible(false);
            this.setSize(this.m_iDialogWidth, 101);
            this.validate();
            this.repaint();
        }
    }

    private void stopButtonActionListener() {
        this.m_oStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchGatewayDeviceDialog.this.stopButtonActionPerformed();
            }
        });
    }

    protected void stopButtonActionPerformed() {
        if (1 == this.m_iDialogType) {
            this.handleSearchGatewayStop();
        } else {
            if (Collator.getInstance().equals(this.m_oStopButton.getText(), this.m_oResManager.getResString("CLOSE_BUTTON"))) {
                this.closeDialog();
                return;
            }
            this.handleStopSearchNGWDevices();
        }
    }

    private void handleStopSearchNGWDevices() {
        StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
        try {
            this.m_oStandAloneSyncCtrller.cancelSearchOperation(this.m_iRequestId, 43953);
        }
        catch (DCException e) {
            DCDebugTracer.trace("DC::handleStopSearchNGWDevices::throw exception::" + e.getMessage());
            return;
        }
        this.m_oStopButton.setText(this.m_oResManager.getResString("CLOSE_BUTTON"));
        this.m_oDetailsButton.setVisible(true);
        this.m_progressBar.setIndeterminate(false);
        this.m_progressBar.setValue(this.m_progressBar.getMaximum());
        this.m_progressBar.setString(this.m_oResManager.getResString("SEARCH_STOP"));
        this.m_progressBar.setStringPainted(true);
        this.refreshTable();
    }

    private void handleSearchGatewayStop() {
        try {
            this.m_oStandAloneSyncCtrller.cancelSearchOperation(this.m_iRequestId, 43951);
        }
        catch (DCException e) {
            DCDebugTracer.trace("DC::handleSearchGatewayStop::throw exception::" + e.getMessage());
            return;
        }
        StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this.m_oStandALoneNotificationLstner);
        StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
        if (1 == this.m_iDialogType) {
            int iCount = this.m_oDeivceInfoTableModel.getRowCount();
            ArrayList<String> oIPList = new ArrayList<String>(0);
            for (int index = 0; index < iCount; ++index) {
                String strIP = (String)this.m_oDeivceInfoTableModel.getValueAt(index, 1);
                oIPList.add(strIP);
            }
            if (null != this.m_oAddGatewayDevicesPanel) {
                int iSelectedRow;
                StandAloneCommUtil.getGateIPAddLst().clear();
                this.m_oAddGatewayDevicesPanel.updateGatewayIPDropDown(oIPList);
                if (0 < iCount && -1 != (iSelectedRow = this.m_oDeviceInfoTable.getSelectedRow())) {
                    this.m_oAddGatewayDevicesPanel.setGatewayDropDown((String)this.m_oDeivceInfoTableModel.getValueAt(iSelectedRow, 1));
                }
            }
        }
        this.closeDialog();
    }

    public void setGatewayInfo(T2000DevInfo oDevInfo) {
        this.m_oT2000DevInfo = oDevInfo;
    }

    private void initButtons() {
        this.initStopButton();
        this.initDetailsButton();
        this.initAddToDCButton();
    }

    private void initAddToDCButton() {
        this.m_oAddToDCButton = new JButton();
        this.m_oAddToDCButton.setName("Standalone_SearchGatewayDeviceDialog_m_oAddToDCButton");
        this.m_oAddToDCButton.setText(this.m_oResManager.getResString("ADD_DEVICE_TO_DC_BUTTON_TEXT"));
        this.m_oAddToDCButton.setMnemonic('C');
        this.m_oAddToDCButton.setBounds(this.m_iDialogWidth - 158, 330, 140, 20);
        this.getContentPane().add(this.m_oAddToDCButton);
        this.m_oAddToDCButton.setEnabled(true);
        this.m_oAddToDCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchGatewayDeviceDialog.this.addDevicetoDc();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDevicetoDc() {
        if (0 == this.m_oDeviceInfoTable.getSelectedRowCount()) {
            this.showMessageDlg("INCORRECT_SELECTION");
            return;
        }
        boolean isAddSelected = this.modifyDeviceData(this.m_oDeviceInfoTable.getSelectedRows());
        if (!isAddSelected) {
            return;
        }
        int[] iSelectedRows = this.m_oDeviceInfoTable.getSelectedRows();
        ArrayList<T2000DevInfo> oT2000DevInfoLst = new ArrayList<T2000DevInfo>(iSelectedRows.length);
        try {
            int iMaxDevID = DCFrameWorkUtil.getDeviceInfoManager().getMaxDevID();
            for (int iSelectedRow : iSelectedRows) {
                Object strPassword;
                String strUserName;
                this.validateDeviceInfoData(iSelectedRow);
                T2000DevInfo oT2000DevInfo = new T2000DevInfo();
                oT2000DevInfo.setDeviceID(++iMaxDevID);
                oT2000DevInfo.setMMLProtocolDevPhyId(DeviceInfoUtil.parseNEIDStr((String)this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 0)));
                String strDevName = (String)this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 1);
                if (null != strDevName && 0 != strDevName.trim().length()) {
                    oT2000DevInfo.setDeviceName(strDevName.trim());
                } else {
                    oT2000DevInfo.setDeviceName("");
                }
                if (this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 2) instanceof Integer) {
                    Integer oPortNum = (Integer)this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 2);
                    oT2000DevInfo.setPort(oPortNum);
                }
                if (null != (strUserName = (String)this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 3)) && 0 != strUserName.trim().length()) {
                    oT2000DevInfo.setUserName(strUserName.trim());
                }
                if ((strPassword = this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 4)) instanceof char[] && !StringUtils.isNullOrEmptyChar((char[])strPassword)) {
                    oT2000DevInfo.setPass((char[])strPassword);
                }
                oT2000DevInfo.setGatewayAddress(this.m_oT2000DevInfo.getGatewayAddress());
                oT2000DevInfo.setGateWayType(1);
                oT2000DevInfo.setProtocolType(2);
                if (DCFrameWorkUtil.getIsSingleClient()) {
                    oT2000DevInfo.setKeyMode(0);
                } else {
                    oT2000DevInfo.setKeyMode(1);
                }
                oT2000DevInfoLst.add(oT2000DevInfo);
            }
            StandAloneNotifier.getInstance().addStandAloneNotificationListener(this);
            byte[] byArray = this.m_oSyncObject;
            synchronized (this.m_oSyncObject) {
                this.m_oAddDeviceProgressBarDlg = new DeviceProgressDlg(0, this.m_oSyncObject);
                int iReqId = DCFrameWorkUtil.generateRequestId();
                this.m_oStandAloneSyncCtrller.addDevice(iReqId, 0, 0, oT2000DevInfoLst);
                this.m_oAddDeviceProgressBarDlg.setTotalDev(oT2000DevInfoLst.size());
                this.m_oAddDeviceProgressBarDlg.setProgressBarState(true);
                // ** MonitorExit[var5_6] (shouldn't be in output)
            }
        }
        catch (DCException e) {
            StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
            DCDebugTracer.trace("DC::addDevicetoDc::throw exception::" + e.getMessage());
            return;
        }
        {
            this.m_oAddDeviceProgressBarDlg.setVisible(true);
            return;
        }
    }

    private void validateDeviceInfoData(int iSelectedRow) throws DCException {
        Object oPortVal = this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 2);
        if (null == oPortVal || oPortVal instanceof String) {
            throw new DCException(this.m_oResManager.getResString("PORT_EMPTY"));
        }
        Object oUserName = this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 3);
        if (null == oUserName || 0 == ((String)oUserName).trim().length()) {
            throw new DCException(this.m_oResManager.getResString("USER_NAME_BLANK"));
        }
        Object oPassword = this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 4);
        if (oPassword instanceof char[] && StringUtils.isNullOrEmptyChar((char[])oPassword)) {
            throw new DCException(this.m_oResManager.getResString("PASSWORD_FIELD_BLANK"));
        }
    }

    private void initDetailsButton() {
        this.m_oDetailsButton = 1 == this.m_iDialogType ? new JButton(this.m_oResManager.getResString("OPERATE_DETAIL") + " >>") : new JButton("<< " + this.m_oResManager.getResString("OPERATE_DETAIL"));
        this.m_oDetailsButton.setName("Standalone_SearchGatewayDeviceDialog_m_oDetailsButton");
        this.m_oDetailsButton.setMnemonic('D');
        this.m_oDetailsButton.setVisible(false);
        this.m_oDetailsButton.setBounds(this.m_iDialogWidth - 224, 40, 100, 20);
        this.add(this.m_oDetailsButton);
    }

    private void initializeCellRenderers() {
        SearchTableCellRenderer oSearchTableCellRenderer = new SearchTableCellRenderer();
        int iColumnCount = this.m_oDeviceInfoTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            this.m_oDeviceInfoTable.getColumnModel().getColumn(i).setCellRenderer(oSearchTableCellRenderer);
        }
    }

    private boolean modifyDeviceData(int[] selectedRows) {
        ArrayList<T2000DevInfo> oT2000DevsInfoLst = null;
        if (selectedRows == null || selectedRows.length == 0) {
            return false;
        }
        oT2000DevsInfoLst = new ArrayList<T2000DevInfo>(selectedRows.length);
        for (int iSelectedRow : selectedRows) {
            Object strPassword;
            String strUserName;
            T2000DevInfo oT2000DevInfo = new T2000DevInfo();
            oT2000DevInfo.setMMLProtocolDevPhyId(DeviceInfoUtil.parseNEIDStr((String)this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 0)));
            String strDevName = (String)this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 1);
            if (null != strDevName && 0 != strDevName.trim().length()) {
                oT2000DevInfo.setDeviceName(strDevName.trim());
            }
            if (this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 2) instanceof Integer) {
                Integer oPortNum = (Integer)this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 2);
                oT2000DevInfo.setPort(oPortNum);
            }
            if (null != (strUserName = (String)this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 3)) && 0 != strUserName.trim().length()) {
                oT2000DevInfo.setUserName(strUserName.trim());
            }
            if ((strPassword = this.m_oDeviceInfoTable.getValueAt(iSelectedRow, 4)) instanceof char[] && !StringUtils.isNullOrEmptyChar((char[])strPassword)) {
                oT2000DevInfo.setPass((char[])strPassword);
            }
            oT2000DevsInfoLst.add(oT2000DevInfo);
        }
        ModifyNGDevDialog oModifyNGDialog = new ModifyNGDevDialog(oT2000DevsInfoLst);
        oModifyNGDialog.setVisible(true);
        boolean bIsOkSelected = oModifyNGDialog.isOKClicked();
        if (bIsOkSelected) {
            List<T2000DevInfo> oT2DevInfoLst = oModifyNGDialog.getT2000devInfoLst();
            this.updateDataInTable(selectedRows, oT2DevInfoLst);
        }
        return bIsOkSelected;
    }

    private void updateDataInTable(int[] iSelectedRows, List<T2000DevInfo> oT2000DevInfoLst) {
        int i = 0;
        for (T2000DevInfo oT2000DevInfo : oT2000DevInfoLst) {
            this.m_oDeivceInfoTableModel.setValueAt((Object)DeviceInfoUtil.parseNEIDInt(oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId()), iSelectedRows[i], 0);
            this.m_oDeivceInfoTableModel.setValueAt((Object)oT2000DevInfo.getDeviceName(), iSelectedRows[i], 1);
            this.m_oDeivceInfoTableModel.setValueAt((Object)oT2000DevInfo.getPort(), iSelectedRows[i], 2);
            this.m_oDeivceInfoTableModel.setValueAt((Object)oT2000DevInfo.getUserName(), iSelectedRows[i], 3);
            this.m_oDeivceInfoTableModel.setValueAt((Object)oT2000DevInfo.getPass(), iSelectedRows[i], 4);
            ++i;
        }
        this.refreshTable();
    }

    private void showMessageDlg(String strMessage) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString(strMessage));
    }

    private void initDialog() {
        int iHeight;
        String strTitle = null;
        if (1 == this.m_iDialogType) {
            strTitle = this.m_oResManager.getResString("SEARCH_GATEWAY_PROGRESS_TITLE");
            DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_NE_SEARCH_GATEWAY");
            this.m_oDetailsButton.setVisible(true);
            iHeight = 101;
        } else {
            strTitle = this.m_oResManager.getResString("SEARCH_DEVICE_PROGRESS_TITLE");
            DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "EHLP_TOPIC_NE_SEARCH_NON_GATEWAY");
            iHeight = 390;
        }
        this.setTitle(strTitle);
        this.setSize(this.m_iDialogWidth, iHeight);
        this.setLayout(null);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void initStopButton() {
        this.m_oStopButton = new JButton();
        this.m_oStopButton.setName("Standalone_SearchGatewayDeviceDialog_m_oStopButton");
        this.m_oStopButton.setText(this.m_oResManager.getResString("STOP_BUTTON"));
        this.m_oStopButton.setBounds(this.m_iDialogWidth - 118, 40, 100, 20);
        this.getContentPane().add(this.m_oStopButton);
    }

    private void initializeProgressBar() {
        this.m_progressBar = new JProgressBar();
        this.m_progressBar.setName("Standalone_SearchGatewayDeviceDialog_m_progressBar");
        this.m_progressBar.setBounds(12, 12, this.m_iDialogWidth - 30, 21);
        String strMessage = 1 == this.m_iDialogType ? this.m_oResManager.getResString("SEARCH_GATEWAY_PROGRESS_TITLE") : this.m_oResManager.getResString("SEARCH_DEVICE_PROGRESS_TITLE");
        this.m_progressBar.setString(strMessage + "...");
        this.m_progressBar.setStringPainted(true);
        this.m_progressBar.setIndeterminate(true);
        this.getContentPane().add(this.m_progressBar);
    }

    private void initSearchDeviceTable() {
        this.m_oDeviceInfoPanel = new JPanel();
        this.m_oDeviceInfoPanel.setName("Standalone_SearchGatewayDeviceDialog_m_oDeviceInfoPanel");
        this.m_oScrollPane = new JScrollPane();
        this.createDeviceInfoTable();
        this.m_oScrollPane.getViewport().add((Component)this.m_oDeviceInfoTable);
        this.m_oDeviceInfoPanel.setLayout(null);
        this.m_oScrollPane.setBounds(0, 0, this.m_iDialogWidth - 30, 250);
        this.m_oDeviceInfoPanel.add(this.m_oScrollPane);
        this.getContentPane().add(this.m_oDeviceInfoPanel);
        this.m_oDeviceInfoPanel.setBounds(12, 70, this.m_iDialogWidth - 30, 250);
        this.refreshTable();
    }

    private void initSearchGatewayTable() {
        this.m_oDeviceInfoPanel = new JPanel();
        this.m_oDeviceInfoPanel.setName("Standalone_SearchGatewayDeviceDialog_m_oDeviceInfoPanel");
        this.m_oScrollPane = new JScrollPane();
        this.createGatewayInfoTable();
        this.m_oScrollPane.getViewport().add((Component)this.m_oDeviceInfoTable);
        this.m_oDeviceInfoPanel.setLayout(null);
        this.m_oScrollPane.setBounds(0, 0, this.m_iDialogWidth - 30, 250);
        this.m_oDeviceInfoPanel.add(this.m_oScrollPane);
        this.getContentPane().add(this.m_oDeviceInfoPanel);
        this.m_oDeviceInfoPanel.setBounds(12, 70, this.m_iDialogWidth - 30, 250);
        this.refreshTable();
    }

    private void createGatewayInfoTable() {
        Object[] arrColumns = this.getGatewaySearchResultColumns();
        this.m_oDeivceInfoTableModel = new DCSortableTableModel(arrColumns, 0){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_oDeviceInfoTable = new DCExtendedTable((SortableTableModel)this.m_oDeivceInfoTableModel);
        this.m_oDeviceInfoPanel.setName("Standalone_SearchGatewayDeviceDialog_m_oDeviceInfoTable");
        this.initializeCellRenderers();
    }

    private void createDeviceInfoTable() {
        Object[] oArrColumns = null;
        oArrColumns = this.getDeviceSearchResultColumns();
        this.m_oDeivceInfoTableModel = new DCSortableTableModel(oArrColumns, 0){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_oDeviceInfoTable = new DCExtendedTable((SortableTableModel)this.m_oDeivceInfoTableModel);
        this.m_oDeviceInfoTable.getColumnModel().getColumn(1).setMaxWidth(0);
        this.m_oDeviceInfoTable.getColumnModel().getColumn(1).setMinWidth(0);
        this.m_oDeviceInfoTable.getColumnModel().getColumn(1).setPreferredWidth(0);
        this.m_oDeviceInfoTable.setName("Standalone_SearchGatewayDeviceDialog_m_oDeviceInfoTable");
        this.m_oDeviceInfoTable.setSortableClickCount(1);
        this.m_oDeviceInfoTable.setColumnSortable(0, true);
        this.initializeCellRenderers();
        this.m_oDeviceInfoTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                int iRowCount = SearchGatewayDeviceDialog.this.m_oDeviceInfoTable.getSelectedRowCount();
                if (iRowCount > 0) {
                    SearchGatewayDeviceDialog.this.m_oAddToDCButton.setEnabled(true);
                } else {
                    SearchGatewayDeviceDialog.this.m_oAddToDCButton.setEnabled(false);
                }
            }
        });
    }

    public void addRows(AsnDevInfo oAsnDevInfo) {
        Vector<String> oRowVector = new Vector<String>(4);
        oRowVector.add(DeviceInfoUtil.parseNEIDInt(oAsnDevInfo.oAsnT2000DevInfo.iNeID.intValue()));
        this.m_oDeivceInfoTableModel.addRow(oRowVector);
    }

    private String[] getDeviceSearchResultColumns() {
        String[] oArrDeviceSerachResultCoulumn = new String[]{this.m_oResManager.getResString("NE_ID"), this.m_oResManager.getResString("DEVICE_NAME"), this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_PORT"), this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_USER_NAME"), this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_PASSWORD")};
        return oArrDeviceSerachResultCoulumn;
    }

    private String[] getGatewaySearchResultColumns() {
        String[] arrGatewaySearchTableCol = new String[]{this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_GATEWAY_TYPE"), this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_GATEWAY_ADDRESS")};
        return arrGatewaySearchTableCol;
    }

    @Override
    protected String getCurrentContext() {
        DCDebugTracer.trace("help id is empty in " + SearchGatewayDeviceDialog.class.getName());
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }

    @Override
    public void onStandAloneNotification(StandAloneEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        switch (oEvent.getEventType()) {
            case 43949: {
                if (1 != this.m_iDialogType) break;
                this.handleSearchGateWayEvent(oEvent);
                break;
            }
            case 43950: {
                if (2 != this.m_iDialogType) break;
                this.handleSearchNGEvent(oEvent);
                break;
            }
        }
    }

    private void handleSearchNGEvent(StandAloneEvent oEvent) {
        Object oUserObject = oEvent.getSource();
        if (oUserObject instanceof AsnSearchNGDeviceRsp) {
            AsnSearchNGDeviceRsp oAsnSearchNGDeviceRsp = (AsnSearchNGDeviceRsp)oUserObject;
            if (null != oAsnSearchNGDeviceRsp.oAsnDevInfoList) {
                this.updateTableWithDevInfo(oAsnSearchNGDeviceRsp.oAsnDevInfoList);
            }
            if (oAsnSearchNGDeviceRsp.bIsFinal) {
                this.stopButtonActionPerformed();
                if (null == this.m_oDeivceInfoTableModel) {
                    return;
                }
                if (0 == this.m_oDeivceInfoTableModel.getRowCount()) {
                    this.m_progressBar.setString(this.m_oResManager.getResString("OPERATION_COMPLETED") + " : " + this.m_oResManager.getResString("SEARCH_DEVICE_NO_DEVICES_FOUND"));
                } else {
                    this.m_progressBar.setString(this.m_oResManager.getResString("OPERATION_COMPLETED"));
                }
                this.m_progressBar.setStringPainted(true);
                StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
            }
        }
    }

    private void updateTableWithDevInfo(AsnDevInfoList oAsnDevInfoList) {
        int iSizeOfLst = oAsnDevInfoList.size();
        for (int i = 0; i < iSizeOfLst; ++i) {
            AsnDevInfo oAsnDevInfo = (AsnDevInfo)oAsnDevInfoList.get(i);
            this.addRows(oAsnDevInfo);
        }
        this.refreshTable();
    }

    private void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchGatewayDeviceDialog.this.m_oDeviceInfoTable.repaint();
            }
        });
    }

    private void handleSearchGateWayEvent(StandAloneEvent oEvent) {
        Object oUserObject = oEvent.getSource();
        if (oUserObject instanceof AsnSearchGatewayRsp) {
            AsnSearchGatewayRsp oAsnSearchGatewayRsp = (AsnSearchGatewayRsp)oUserObject;
            if (null != oAsnSearchGatewayRsp.oGatewayInfoLst) {
                this.updateGatewayInfoTable(oAsnSearchGatewayRsp.oGatewayInfoLst);
            }
            int iErrorCode = oAsnSearchGatewayRsp.oErrorNo.iErrorNo.intValue();
            if (oAsnSearchGatewayRsp.bIsFinal) {
                this.m_progressBar.setValue(this.m_progressBar.getMaximum());
                this.m_progressBar.setIndeterminate(false);
                if (0 == this.m_oDeivceInfoTableModel.getRowCount()) {
                    this.m_progressBar.setString(this.m_oResManager.getResString("OPERATION_COMPLETED") + " : " + this.m_oResManager.getResString("SEARCH_DEVICE_NO_DEVICES_FOUND"));
                } else {
                    this.m_progressBar.setString(this.m_oResManager.getResString("OPERATION_COMPLETED"));
                }
                this.m_progressBar.setStringPainted(true);
                this.m_oStopButton.setText(this.m_oResManager.getResString("CLOSE_BUTTON"));
                if (0 != iErrorCode) {
                    DCOptionPane.showMessageDialog((Component)((Object)this), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
                }
                StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
            }
        }
    }

    private void updateGatewayInfoTable(AsnGatewayInfoLst oGatewayInfoLst) {
        int iSize = oGatewayInfoLst.size();
        for (int index = 0; index < iSize; ++index) {
            AsnGatewayInfo oGatewayInfo = (AsnGatewayInfo)oGatewayInfoLst.get(index);
            String strGatewayAddr = new String(oGatewayInfo.strGatewayIP);
            Vector<String> oVector = new Vector<String>(2);
            oVector.add(ResourceManager.getInstance().getResString("IP_GATEWAY"));
            oVector.add(strGatewayAddr);
            this.m_oDeivceInfoTableModel.addRow(oVector);
            this.refreshTable();
        }
    }

    @Override
    protected void closeDialog() {
        StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
        super.closeDialog();
    }
}

