/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.search.view;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnGatewayInfo;
import com.huawei.dc.common.asndatacenter.AsnGatewayInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSearchGatewayRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.event.IStandAloneNotificationListener;
import com.huawei.dc.standalone.event.StandAloneEvent;
import com.huawei.dc.standalone.event.StandAloneNotifier;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.search.view.GatewayDevDlg;
import com.huawei.dc.standalone.search.view.SearchGatewayDeviceDialog;
import com.huawei.dc.standalone.search.view.SearchTableCellRenderer;
import com.huawei.dc.standalone.view.DeviceProgressDlg;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class SearchDeviceDlg
extends DCModalDialog
implements IStandAloneNotificationListener {
    private static final long serialVersionUID = 1L;
    private ResourceManager m_oResManager;
    private DCExtendedTable m_oSearchTable;
    private DCSortableTableModel m_oSearchTableModel;
    private JScrollPane m_oSearchTableScrollPane;
    private JLabel m_oDevCountLabel;
    private String m_sdevCountText = "";
    private JButton m_oSearchGatewayButton;
    private JButton m_oSearchDeviceButton;
    private JButton m_oModifyButton;
    private JButton m_oDeleteButton;
    private ArrayList<T2000DevInfo> m_oT2000DevInfoList = new ArrayList();
    private boolean m_oOkClicked;
    private IDCStandAloneSyncCtrller m_oStandAloneSyncCtrller;
    SearchGatewayDeviceDialog m_oSearchGatewayDeviceDialog;
    private byte[] m_oSyncObject;
    private DeviceProgressDlg m_oAddDeviceProgressBarDlg;

    public SearchDeviceDlg() throws DCException {
        this.m_oResManager = ResourceManager.getInstance();
        this.m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        this.m_oSyncObject = new byte[0];
        this.jbinit();
        this.getGateDevices();
        this.refreshDevCountLabel();
    }

    private void getGateDevices() throws DCException {
        List<T2000DevInfo> oT2000DevInfoLst = this.m_oStandAloneSyncCtrller.getGateWayDeviceInfo();
        this.populateGatewayInfoInTable(oT2000DevInfoLst);
        oT2000DevInfoLst = null;
    }

    private void jbinit() {
        this.initDialog();
        this.createTableModel();
        this.createTable();
        this.initializeSelectionModel();
        this.initializeScrollPane();
        this.initButtons();
        this.initActionListners();
    }

    private void initActionListners() {
        this.searchGatewayButtonActionListener();
        this.searchDeviceButtonActionListener();
        this.modifyButtonActionListener();
        this.deleteButtonActionListener();
    }

    private void modifyButtonActionListener() {
        this.m_oModifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDeviceDlg.this.modifyButtonActionPerformed();
            }
        });
    }

    protected void modifyButtonActionPerformed() {
        ArrayList devList;
        T2000DevInfo oT2000DevInfo;
        DCDebugTracer.trace("DC::SearchDeviceDlg::modifyButtonActionPerformed");
        ArrayList<T2000DevInfo> oT2000DevInfoLst = new ArrayList<T2000DevInfo>();
        if (0 == this.m_oSearchTable.getSelectedRowCount()) {
            T2000DevInfo oT2000DevInfo2 = new T2000DevInfo();
            oT2000DevInfo2.setGatewayAddress("");
            oT2000DevInfo2.setUserName("");
            oT2000DevInfo2.setPass("".toCharArray());
            oT2000DevInfo2.setKeyMode(0);
            oT2000DevInfoLst.add(oT2000DevInfo2);
        } else {
            int[] iSelectRows = this.m_oSearchTable.getSelectedRows();
            for (int i = 0; i < iSelectRows.length; ++i) {
                String strUserName;
                int row = iSelectRows[i];
                oT2000DevInfo = new T2000DevInfo();
                oT2000DevInfo.setKeyMode(0);
                oT2000DevInfo.setGatewayAddress((String)this.m_oSearchTableModel.getValueAt(row, 1));
                if (this.m_oSearchTableModel.getValueAt(row, 2) instanceof Integer) {
                    oT2000DevInfo.setPort((Integer)this.m_oSearchTableModel.getValueAt(row, 2));
                }
                if ((strUserName = (String)this.m_oSearchTableModel.getValueAt(row, 3)).trim().equals("")) {
                    oT2000DevInfo.setUserName("");
                } else {
                    oT2000DevInfo.setUserName(strUserName);
                }
                char[] strPass = null;
                Object oCellValue = this.m_oSearchTableModel.getValueAt(row, 4);
                if (null != oCellValue) {
                    if (oCellValue instanceof char[]) {
                        strPass = (char[])oCellValue;
                    } else if (oCellValue instanceof String) {
                        strPass = ((String)oCellValue).toCharArray();
                    }
                }
                if (StringUtils.isNullOrEmptyChar(strPass)) {
                    oT2000DevInfo.setPass("".toCharArray());
                } else {
                    oT2000DevInfo.setPass(strPass);
                }
                oT2000DevInfoLst.add(oT2000DevInfo);
            }
        }
        GatewayDevDlg oGatewayDevDlg = new GatewayDevDlg(1, oT2000DevInfoLst);
        oGatewayDevDlg.setVisible(true);
        this.m_oOkClicked = oGatewayDevDlg.isOkClicked();
        boolean isCreateFromServer = oGatewayDevDlg.isCreateGateway();
        this.m_oT2000DevInfoList = devList = oGatewayDevDlg.getT2000DevInfoList();
        if (this.m_oOkClicked) {
            oT2000DevInfo = this.m_oT2000DevInfoList.get(0);
            if (isCreateFromServer) {
                this.sendAddRequest(oT2000DevInfoLst);
            } else {
                int count = this.m_oSearchTableModel.getRowCount();
                int index = -1;
                for (int row = 0; row < count; ++row) {
                    String strDevIP = this.m_oSearchTableModel.getValueAt(row, 1).toString();
                    String devIP = oT2000DevInfo.getGatewayAddress();
                    if (!devIP.equals(strDevIP)) continue;
                    index = row;
                }
                if (index > -1) {
                    this.populateGatewayInfoInTable(oT2000DevInfo, index);
                } else {
                    this.populateGatewayInfoInTable(this.m_oT2000DevInfoList);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAddRequest(List<T2000DevInfo> oT2000DevInfoLst) {
        StandAloneNotifier.getInstance().addStandAloneNotificationListener(this);
        try {
            byte[] byArray = this.m_oSyncObject;
            synchronized (this.m_oSyncObject) {
                this.m_oAddDeviceProgressBarDlg = new DeviceProgressDlg(0, this.m_oSyncObject);
                int iReqId = DCFrameWorkUtil.generateRequestId();
                this.m_oStandAloneSyncCtrller.addDevice(iReqId, 0, 0, oT2000DevInfoLst);
                this.m_oAddDeviceProgressBarDlg.setTotalDev(oT2000DevInfoLst.size());
                this.m_oAddDeviceProgressBarDlg.setProgressBarState(true);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (DCException e) {
            StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
            DCDebugTracer.trace("DC::SearchDeviceDlg::sendAddRequest::throw exception::" + e.getMessage());
            return;
        }
        {
            this.m_oAddDeviceProgressBarDlg.setVisible(true);
            return;
        }
    }

    private void deleteButtonActionListener() {
        this.m_oDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDeviceDlg.this.deleteButtonActionPerformed();
            }
        });
    }

    private void showMessageDlg(String strMessage) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString(strMessage));
    }

    private void addGatewayInfoInTable(T2000DevInfo devInfo) {
        DCDebugTracer.trace("addGatewayInfoInTable begin");
        DCDebugTracer.trace("T2000DevInfo ip->" + devInfo.getGatewayAddress());
        int row = this.getExistGatewayNeRow(devInfo.getGatewayAddress());
        DCDebugTracer.trace("T2000DevInfo ip in table row ->" + row);
        if (-1 < row) {
            this.m_oSearchTableModel.setValueAt((Object)devInfo.getPort(), row, 2);
            this.m_oSearchTableModel.setValueAt((Object)devInfo.getUserName(), row, 3);
            this.m_oSearchTableModel.setValueAt((Object)devInfo.getPass(), row, 4);
        } else {
            Vector<Object> oGatewayInfo = new Vector<Object>(8);
            oGatewayInfo.addElement(ResourceManager.getInstance().getResString("IP_GATEWAY"));
            oGatewayInfo.addElement(devInfo.getGatewayAddress());
            oGatewayInfo.addElement(devInfo.getPort());
            oGatewayInfo.addElement(devInfo.getUserName());
            oGatewayInfo.addElement(devInfo.getPass());
            this.m_oSearchTableModel.addRow(oGatewayInfo);
        }
        this.refreshTable();
    }

    private int getExistGatewayNeRow(String ip) {
        int rowCounts = this.m_oSearchTableModel.getRowCount();
        for (int index = 0; index < rowCounts; ++index) {
            String ipAddress = this.m_oSearchTableModel.getValueAt(index, 1).toString();
            if (!Collator.getInstance().equals(ip, ipAddress)) continue;
            return index;
        }
        return -1;
    }

    private void populateGatewayInfoInTable(T2000DevInfo devInfo, int row) {
        this.m_oSearchTableModel.setValueAt((Object)ResourceManager.getInstance().getResString("IP_GATEWAY"), row, 0);
        this.m_oSearchTableModel.setValueAt((Object)devInfo.getGatewayAddress(), row, 1);
        this.m_oSearchTableModel.setValueAt((Object)devInfo.getPort(), row, 2);
        this.m_oSearchTableModel.setValueAt((Object)devInfo.getUserName(), row, 3);
        this.m_oSearchTableModel.setValueAt((Object)devInfo.getPass(), row, 4);
        this.refreshTable();
    }

    private void populateGatewayInfoInTable(List<T2000DevInfo> oT2000DevInfoLst) {
        int iSizeOfLst = oT2000DevInfoLst.size();
        Vector<Object> oGatewayInfo = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            T2000DevInfo oT2000DevInfo = oT2000DevInfoLst.get(i);
            if (this.isDevicePresent(oT2000DevInfo.getGatewayAddress())) continue;
            oGatewayInfo = new Vector<Object>(8);
            oGatewayInfo.addElement(ResourceManager.getInstance().getResString("IP_GATEWAY"));
            oGatewayInfo.addElement(oT2000DevInfo.getGatewayAddress());
            if (-1 != oT2000DevInfo.getPort()) {
                oGatewayInfo.addElement(oT2000DevInfo.getPort());
            } else {
                oGatewayInfo.addElement(" ");
            }
            if (null != oT2000DevInfo.getUserName()) {
                oGatewayInfo.addElement(oT2000DevInfo.getUserName());
            } else {
                oGatewayInfo.addElement(" ");
            }
            if (null != oT2000DevInfo.getPass()) {
                oGatewayInfo.addElement(oT2000DevInfo.getPass());
            } else {
                oGatewayInfo.addElement(" ");
            }
            this.m_oSearchTableModel.addRow(oGatewayInfo);
        }
        this.refreshTable();
    }

    private boolean isDevicePresent(String strGatewayAddress) {
        boolean bIsDevPresent = false;
        int iRowCOunt = this.m_oSearchTableModel.getRowCount();
        String strGateWayIpAddFrmTable = null;
        for (int i = 0; i < iRowCOunt; ++i) {
            strGateWayIpAddFrmTable = (String)this.m_oSearchTableModel.getValueAt(i, 1);
            if (!strGatewayAddress.equals(strGateWayIpAddFrmTable)) continue;
            bIsDevPresent = true;
            break;
        }
        return bIsDevPresent;
    }

    private void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchDeviceDlg.this.m_oSearchTable.updateUI();
                int iRows = SearchDeviceDlg.this.m_oSearchTable.getRowCount();
                if (0 != iRows) {
                    SearchDeviceDlg.this.m_oModifyButton.setEnabled(true);
                    SearchDeviceDlg.this.m_oDeleteButton.setEnabled(true);
                    SearchDeviceDlg.this.m_oSearchDeviceButton.setEnabled(true);
                    SearchDeviceDlg.this.m_oSearchTable.getSelectionModel().setSelectionInterval(iRows - 1, iRows - 1);
                } else {
                    SearchDeviceDlg.this.m_oDeleteButton.setEnabled(false);
                    SearchDeviceDlg.this.m_oSearchDeviceButton.setEnabled(false);
                }
            }
        });
    }

    public void setOkClicked(boolean bFlag) {
        this.m_oOkClicked = bFlag;
    }

    private void searchDeviceButtonActionListener() {
        this.m_oSearchDeviceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDeviceDlg.this.searchDeviceButtonActionPerformed();
            }
        });
    }

    protected void searchDeviceButtonActionPerformed() {
        if (0 == this.m_oSearchTable.getSelectedRowCount()) {
            this.showMessageDlg("INCORRECT_SELECTION");
            return;
        }
        try {
            int iSelectedRow = this.m_oSearchTable.getSelectedRow();
            T2000DevInfo oT2000DevInfo = new T2000DevInfo();
            this.validateGWDevData(iSelectedRow);
            oT2000DevInfo.setGatewayAddress((String)this.m_oSearchTableModel.getValueAt(iSelectedRow, 1));
            oT2000DevInfo.setPort((Integer)this.m_oSearchTableModel.getValueAt(iSelectedRow, 2));
            oT2000DevInfo.setUserName((String)this.m_oSearchTableModel.getValueAt(iSelectedRow, 3));
            oT2000DevInfo.setPass((char[])this.m_oSearchTableModel.getValueAt(iSelectedRow, 4));
            int iRequestId = DCFrameWorkUtil.generateRequestId();
            this.m_oSearchGatewayDeviceDialog = new SearchGatewayDeviceDialog(2, iRequestId);
            this.m_oSearchGatewayDeviceDialog.setGatewayInfo(oT2000DevInfo);
            this.m_oStandAloneSyncCtrller.startSearchForNGWDevice(iRequestId, oT2000DevInfo);
        }
        catch (DCException e) {
            DCDebugTracer.trace("DC::SearchDeviceDlg::searchDeviceButtonActionPerformed::throw exception::" + e.getMessage());
            return;
        }
        this.m_oSearchGatewayDeviceDialog.setVisible(true);
    }

    private void validateGWDevData(int iSelectedRow) throws DCException {
        char[] strPassWord;
        String strUserName;
        boolean hasError = false;
        if (this.m_oSearchTableModel.getValueAt(iSelectedRow, 2) instanceof String) {
            hasError = true;
        }
        if ((strUserName = (String)this.m_oSearchTableModel.getValueAt(iSelectedRow, 3)) == null || 0 == strUserName.length()) {
            hasError = true;
        }
        if (StringUtils.isNullOrEmptyChar(strPassWord = (char[])this.m_oSearchTableModel.getValueAt(iSelectedRow, 4))) {
            hasError = true;
        }
        if (hasError) {
            throw new DCException(this.m_oResManager.getResString("GATEWAY_SELECTION_NOT_EXIST"));
        }
    }

    private void searchGatewayButtonActionListener() {
        this.m_oSearchGatewayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDeviceDlg.this.searchGatewayButtonActionPerformed();
            }
        });
    }

    protected void searchGatewayButtonActionPerformed() {
        this.refreshTable();
        SearchGatewayDeviceDialog oSearchGatewayDeviceDialog = null;
        StandAloneNotifier.getInstance().addStandAloneNotificationListener(this);
        int iRequestId = DCFrameWorkUtil.generateRequestId();
        oSearchGatewayDeviceDialog = new SearchGatewayDeviceDialog(1, iRequestId, this);
        try {
            this.m_oStandAloneSyncCtrller.startSearchForGWDev(iRequestId);
        }
        catch (DCException e) {
            DCDebugTracer.trace("DC::SearchDeviceDlg::searchGatewayButtonActionPerformed::throw exception::" + e.getMessage());
            StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
            return;
        }
        oSearchGatewayDeviceDialog.setVisible(true);
    }

    private void initButtons() {
        int x = 10;
        int y = 390;
        int iSpace = 5;
        this.m_oDevCountLabel = new JLabel();
        this.m_sdevCountText = ResourceManager.getInstance().getResString("LBL_SELECT_DEVICE_COUNT");
        this.m_oDevCountLabel.setBounds(x, y, 120, 20);
        this.getContentPane().add(this.m_oDevCountLabel);
        x = x + 120 + iSpace;
        this.m_oSearchGatewayButton = new JButton();
        this.m_oSearchGatewayButton.setName("StandAlone_SearchDeviceDlg_m_oSearchGatewayButton");
        this.m_oSearchGatewayButton.setFocusable(false);
        this.m_oSearchGatewayButton.setBounds(x, y, 150, 20);
        this.m_oSearchGatewayButton.setText(this.m_oResManager.getResString("SEARCH_GATEWAY_BUTTON_TEXT"));
        this.m_oSearchGatewayButton.setMnemonic('G');
        this.getContentPane().add(this.m_oSearchGatewayButton);
        x = x + 150 + iSpace;
        this.m_oModifyButton = new JButton();
        this.m_oModifyButton.setName("StandAlone_SearchDeviceDlg_m_oModifyButton");
        this.m_oModifyButton.setFocusable(false);
        this.m_oModifyButton.setBounds(x, y, 150, 20);
        this.m_oModifyButton.setText(this.m_oResManager.getResString("MODIFY_BUTTON_TEXT"));
        this.m_oModifyButton.setMnemonic('A');
        this.getContentPane().add(this.m_oModifyButton);
        x = x + 150 + iSpace;
        this.m_oSearchDeviceButton = new JButton();
        this.m_oSearchDeviceButton.setName("StandAlone_SearchDeviceDlg_m_oSearchDeviceButton");
        this.m_oSearchDeviceButton.setFocusable(false);
        this.m_oSearchDeviceButton.setBounds(x, y, 150, 20);
        this.m_oSearchDeviceButton.setText(this.m_oResManager.getResString("SEARCH_DEVICE_BUTTON_TEXT"));
        this.m_oSearchDeviceButton.setMnemonic('S');
        this.m_oSearchDeviceButton.setEnabled(false);
        this.getContentPane().add(this.m_oSearchDeviceButton);
        x = x + 150 + iSpace;
        this.m_oDeleteButton = new JButton();
        this.m_oDeleteButton.setName("StandAlone_SearchDeviceDlg_m_oDeleteButton");
        this.m_oDeleteButton.setFocusable(false);
        this.m_oDeleteButton.setBounds(x, y, 80, 20);
        this.m_oDeleteButton.setText(this.m_oResManager.getResString("DELETE_BUTTON_TEXT"));
        this.m_oDeleteButton.setMnemonic('D');
        this.m_oDeleteButton.setEnabled(false);
        this.getContentPane().add(this.m_oDeleteButton);
        x = x + 80 + iSpace;
        this.m_oCancelBtn.setBounds(x, y, 80, 20);
        this.m_oCancelBtn.setName("StandAlone_SearchDeviceDlg_m_oCancelBtn");
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("SEARCH_CLOSE_BTN"));
        this.m_oOKBtn.setName("StandAlone_SearchDeviceDlg_m_oOKBtn");
        this.getContentPane().add(this.m_oCancelBtn);
    }

    private void initDialog() {
        this.setSize(780, 450);
        this.setLayout(null);
        this.setTitle(this.m_oResManager.getResString("SEARCH_DEVICE_DIALOG_TITLE"));
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_NE_SEARCH");
    }

    private void createTable() {
        this.m_oSearchTable = new DCExtendedTable((SortableTableModel)this.m_oSearchTableModel);
        this.m_oSearchTable.setName("StandAlone_SearchDeviceDlg_m_oSearchTable");
        this.m_oSearchTable.setOpaque(true);
        this.m_oSearchTable.setFocusable(true);
        this.m_oSearchTable.setRowSelectionAllowed(true);
        this.m_oSearchTable.getTableHeader().setReorderingAllowed(false);
        this.m_oSearchTable.setSortableClickCount(1);
        this.m_oSearchTable.setColumnSortable(1, true);
        this.m_oSearchTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (SearchDeviceDlg.this.m_oSearchTable.getSelectedRows().length > 1) {
                    SearchDeviceDlg.this.m_oSearchDeviceButton.setEnabled(false);
                } else {
                    SearchDeviceDlg.this.m_oSearchDeviceButton.setEnabled(true);
                }
                SearchDeviceDlg.this.refreshDevCountLabel();
            }
        });
        TableColumnModel oTableColumnModel = this.m_oSearchTable.getColumnModel();
        this.setColumnMinWidth(oTableColumnModel);
        this.setColumnPrefferedWidth(oTableColumnModel);
        this.setColumnMaxWidth(oTableColumnModel);
        this.initializeCellRenderers();
    }

    private void refreshDevCountLabel() {
        int iSelectedDevCount = 0;
        int[] arrSelectedRows = this.m_oSearchTable.getSelectedRows();
        if (null != arrSelectedRows) {
            iSelectedDevCount = arrSelectedRows.length;
        }
        int iDevCount = this.m_oSearchTable.getRowCount();
        String strDeviceCountMsg = MessageFormat.format(this.m_sdevCountText, "" + iSelectedDevCount, "" + iDevCount);
        this.m_oDevCountLabel.setText(StringUtils.getHtmlString(strDeviceCountMsg));
    }

    private void initializeCellRenderers() {
        SearchTableCellRenderer oSearchTableCellRenderer = new SearchTableCellRenderer();
        int iColumnCount = this.m_oSearchTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            this.m_oSearchTable.getColumnModel().getColumn(i).setCellRenderer(oSearchTableCellRenderer);
        }
    }

    private void createTableModel() {
        Object[] strColumnNames = new String[]{this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_GATEWAY_TYPE"), this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_GATEWAY_ADDRESS"), this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_PORT"), this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_USER_NAME"), this.m_oResManager.getResString("SEARCH_DEVICE_TABLE_COLUMN_PASSWORD")};
        this.m_oSearchTableModel = new DCSortableTableModel(strColumnNames, 0){
            private static final long serialVersionUID = 1L;

            public boolean isCellEditable(int iRow, int iColumn) {
                return false;
            }
        };
    }

    private void setColumnMinWidth(TableColumnModel oTableColumnModel) {
        oTableColumnModel.getColumn(0).setMinWidth(70);
        oTableColumnModel.getColumn(1).setMinWidth(70);
        oTableColumnModel.getColumn(2).setMinWidth(50);
        oTableColumnModel.getColumn(3).setMinWidth(50);
        oTableColumnModel.getColumn(4).setMinWidth(50);
    }

    private void setColumnPrefferedWidth(TableColumnModel oTableColumnModel) {
        oTableColumnModel.getColumn(0).setPreferredWidth(100);
        oTableColumnModel.getColumn(1).setPreferredWidth(100);
        oTableColumnModel.getColumn(2).setPreferredWidth(70);
        oTableColumnModel.getColumn(3).setPreferredWidth(80);
        oTableColumnModel.getColumn(4).setPreferredWidth(80);
    }

    private void setColumnMaxWidth(TableColumnModel oTableColumnModel) {
        oTableColumnModel.getColumn(0).setMinWidth(120);
        oTableColumnModel.getColumn(1).setMinWidth(120);
        oTableColumnModel.getColumn(2).setMinWidth(90);
        oTableColumnModel.getColumn(3).setMinWidth(100);
        oTableColumnModel.getColumn(4).setMinWidth(100);
    }

    private void initializeSelectionModel() {
        DefaultListSelectionModel devSelection = new DefaultListSelectionModel();
        devSelection.setSelectionMode(2);
    }

    private void initializeScrollPane() {
        this.m_oSearchTableScrollPane = new JScrollPane((Component)this.m_oSearchTable);
        this.m_oSearchTableScrollPane.setName("StandAlone_SearchDeviceDlg_m_oSearchTableScrollPane");
        this.m_oSearchTableScrollPane.setVerticalScrollBarPolicy(22);
        this.m_oSearchTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        KeyStroke oDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        this.m_oSearchTable.registerKeyboardAction(this.generateKeyListenerAdapter(), oDeleteKeyStroke, 2);
        this.m_oSearchTableScrollPane.setBounds(10, 10, 752, 370);
        this.add(this.m_oSearchTableScrollPane);
    }

    private ActionListener generateKeyListenerAdapter() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                SearchDeviceDlg.this.deleteButtonActionPerformed();
            }
        };
    }

    protected void deleteButtonActionPerformed() {
        if (0 == this.m_oSearchTable.getSelectedRowCount()) {
            this.showMessageDlg("INCORRECT_SELECTION");
            return;
        }
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("SEARCH_CONFIRM_DELETE_FILES"), this.m_oResManager.getResString("CONFIRM"), 0);
        if (0 != iConfirm) {
            return;
        }
        int[] selectRows = this.m_oSearchTable.getSelectedRows();
        for (int i = selectRows.length - 1; i >= 0; --i) {
            int row = selectRows[i];
            this.m_oSearchTableModel.removeRow(row);
        }
        this.refreshTable();
    }

    @Override
    protected String getCurrentContext() {
        DCDebugTracer.trace("help id is empty in " + SearchDeviceDlg.class.getName());
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }

    @Override
    public void onStandAloneNotification(StandAloneEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        switch (oEvent.getEventType()) {
            case 43949: {
                this.handleSearchGateWayEvent(oEvent);
                break;
            }
            case 43950: {
                break;
            }
            case 0: {
                this.handleAddGateWayEvent(oEvent);
                break;
            }
            case 2: {
                this.handleModifyGateWayEvent(oEvent);
                break;
            }
        }
    }

    private void handleModifyGateWayEvent(StandAloneEvent oStandAloneEvent) {
        DCDebugTracer.trace("handleModifyGateWayEvent begin");
        Resource oRes = oStandAloneEvent.getResource();
        if (null == oRes) {
            return;
        }
        if (this.m_oT2000DevInfoList.size() == 0) {
            return;
        }
        T2000DevInfo devInfo = this.getT2000DevInfoByIP(oRes.getDeviceIP());
        DCDebugTracer.trace("handleModifyGateWayEvent Device IP" + oRes.getDeviceIP());
        if (0 == oStandAloneEvent.getErrorCode() && devInfo != null) {
            int row = this.getExistGatewayNeRow(devInfo.getGatewayAddress());
            if (row < 0) {
                return;
            }
            this.populateGatewayInfoInTable(devInfo, row);
        }
        StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
    }

    private void handleAddGateWayEvent(StandAloneEvent oStandAloneEvent) {
        Resource oRes = oStandAloneEvent.getResource();
        if (null == oRes) {
            return;
        }
        if (this.m_oT2000DevInfoList.size() == 0) {
            return;
        }
        T2000DevInfo devInfo = this.getT2000DevInfoByIP(oRes.getDeviceIP());
        if (devInfo != null && 0 == oStandAloneEvent.getErrorCode()) {
            this.addGatewayInfoInTable(devInfo);
        }
    }

    private void handleSearchGateWayEvent(StandAloneEvent oEvent) {
        Object oUserObject = oEvent.getSource();
        if (oUserObject instanceof AsnSearchGatewayRsp) {
            AsnSearchGatewayRsp oAsnSearchGatewayRsp = (AsnSearchGatewayRsp)oUserObject;
            int iErrorCode = oAsnSearchGatewayRsp.oErrorNo.iErrorNo.intValue();
            if (0 == iErrorCode) {
                this.createDevInfoLst(oAsnSearchGatewayRsp.oGatewayInfoLst);
            }
            if (oAsnSearchGatewayRsp.bIsFinal) {
                StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
            }
        }
    }

    private void createDevInfoLst(AsnGatewayInfoLst oAsnGatewayInfoLst) {
        int iSizeOfLst = oAsnGatewayInfoLst.size();
        ArrayList<T2000DevInfo> oT2000DevInfoList = new ArrayList<T2000DevInfo>(4);
        T2000DevInfo oT2000DevInfo = null;
        String strIpAddress = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oT2000DevInfo = new T2000DevInfo();
            AsnGatewayInfo oAsnGateWayInfo = (AsnGatewayInfo)oAsnGatewayInfoLst.get(i);
            strIpAddress = new String(oAsnGateWayInfo.strGatewayIP);
            oT2000DevInfo.setGatewayAddress(strIpAddress);
            oT2000DevInfoList.add(oT2000DevInfo);
        }
        this.populateGatewayInfoInTable(oT2000DevInfoList);
    }

    @Override
    protected void closeDialog() {
        StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
        super.closeDialog();
    }

    private T2000DevInfo getT2000DevInfoByIP(String strIP) {
        for (T2000DevInfo devInfo : this.m_oT2000DevInfoList) {
            if (!strIP.equals(devInfo.getGatewayAddress())) continue;
            return devInfo;
        }
        return null;
    }
}

