/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.search.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.u2kcbb.U2kPasswordFiled;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.swimap.imap12.util.InmLengthLimitTextField;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ModifyNGDevDialog
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private InmLengthLimitTextField m_oUserNameTxtField = null;
    private U2kPasswordFiled m_oPassordTxtField = null;
    private NumericSpinnerModel m_oPortNumberSpinnerModel;
    private InmLengthLimitTextField m_oDeviceName = null;
    private JPanel m_oGatewayInfoPanel = null;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private List<T2000DevInfo> m_oT2000DevInfoLst;
    private boolean m_bIsOKClicked;
    private String dialogType = "";
    private IPAddressTextField m_oGatewayIpAddrss = null;
    private String strIP = "";

    public ModifyNGDevDialog(String dialogType, String ipAddress) {
        this.dialogType = dialogType;
        this.strIP = ipAddress;
        this.jbInit();
    }

    public ModifyNGDevDialog(List<T2000DevInfo> oDevInfoLst) {
        this.m_oT2000DevInfoLst = oDevInfoLst;
        this.jbInit();
    }

    private void jbInit() {
        this.setResizable(false);
        this.setLayout(null);
        this.initPanel();
        if (this.dialogType == "MODIFYIP") {
            this.setSize(321, 212);
            this.setTitle(this.m_oResManager.getResString("MODIFY_DEVICE_DIALOG_TITLE"));
            this.initGatewayIpaddressField();
        } else {
            this.setSize(341, 232);
            this.setTitle(this.m_oResManager.getResString("ADD_DEVICE_TO_DC_DIALOG_TITLE"));
            this.initUsernameTxtField();
            this.initPassWordTxtField();
            this.initDeviceNameField();
            this.initPortField();
        }
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModifyNGDevDialog.this.okBtnActionPerformed();
            }
        });
        this.addButtons();
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void okBtnActionPerformed() {
        this.m_bIsOKClicked = true;
        try {
            this.validateFields();
            if (!this.dialogType.equals("MODIFYIP")) {
                for (T2000DevInfo oT2000DevInfo : this.m_oT2000DevInfoLst) {
                    oT2000DevInfo.setMMLProtocolDevPhyId(oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId());
                    if (this.m_oT2000DevInfoLst.size() == 1) {
                        oT2000DevInfo.setDeviceName(this.m_oDeviceName.getText().trim());
                    } else {
                        oT2000DevInfo.setDeviceName(null);
                    }
                    oT2000DevInfo.setPort((Integer)this.m_oPortNumberSpinnerModel.getValue());
                    oT2000DevInfo.setUserName(this.m_oUserNameTxtField.getText());
                    oT2000DevInfo.setPass(this.m_oPassordTxtField.getPasswordInChar());
                }
            } else {
                try {
                    this.strIP = this.m_oGatewayIpAddrss.getTrimedAddress();
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
            this.m_bIsOKClicked = true;
            this.setVisible(false);
        }
        catch (DCException e) {
            DCDebugTracer.trace("DC::ModifyNGDevDialog::okBtnActionPerformed::throw exception::" + e.getMessage());
            return;
        }
    }

    private void validateFields() throws DCException {
        int iPort;
        if (this.dialogType.equals("MODIFYIP")) {
            String strIpField = "";
            try {
                strIpField = this.m_oGatewayIpAddrss.getTrimedAddress();
            }
            catch (InValideIPAddressException e) {
                DCDebugTracer.trace((Exception)((Object)e));
            }
            strIpField = strIpField.trim();
            if (0 == strIpField.length()) {
                throw new DCException(this.m_oResManager.getResString("GATEWAY_ADDR_EMPTY"));
            }
        } else {
            String strDeviceName = this.m_oDeviceName.getText();
            if ((strDeviceName = strDeviceName.trim()).isEmpty() && 1 == this.m_oT2000DevInfoLst.size()) {
                DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("DEFAULT_DEVICE_NAME_INFO"));
            }
            String strUsername = this.m_oUserNameTxtField.getText();
            if (0 == (strUsername = strUsername.trim()).length()) {
                throw new DCException(this.m_oResManager.getResString("USER_NAME_BLANK"));
            }
            if (this.m_oT2000DevInfoLst.size() == 1) {
                ArrayList<T2000DevInfo> oResourceLst = new ArrayList<T2000DevInfo>(0);
                T2000DevInfo oT2000DevInfo = new T2000DevInfo();
                oT2000DevInfo.setDeviceName(strDeviceName);
                oResourceLst.add(oT2000DevInfo);
                if (!this.checkDevNameExist(oResourceLst)) {
                    throw new DCException(this.m_oResManager.getResString("DEVICE_NAME_EXIST"));
                }
            } else {
                DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("CREATE_MORE_DEVICE_NAME_INFO"));
            }
            char[] strPassword = this.m_oPassordTxtField.getPasswordInChar();
            if (0 >= strPassword.length) {
                throw new DCException(this.m_oResManager.getResString("PASSWORD_FIELD_BLANK"));
            }
        }
        if (23 == (iPort = ((Integer)this.m_oPortNumberSpinnerModel.getValue()).intValue())) {
            throw new DCException(this.m_oResManager.getResString("ADD_TL1_FROM_SEARCH_ERROR"));
        }
    }

    private void initPanel() {
        this.m_oGatewayInfoPanel = new JPanel();
        this.m_oGatewayInfoPanel.setName("Standalone_GatewayDevDlg_m_oGatewayInfoPanel");
        this.m_oGatewayInfoPanel.setLayout(null);
        if (this.dialogType.equals("MODIFYIP")) {
            this.m_oGatewayInfoPanel.setBounds(12, 12, 291, 123);
        } else {
            this.m_oGatewayInfoPanel.setBounds(12, 12, 311, 143);
        }
        this.getContentPane().add(this.m_oGatewayInfoPanel);
        this.m_oGatewayInfoPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    private void addButtons() {
        this.m_oOKBtn.setName("Standalone_GatewayDevDlg_m_oOKBtn");
        this.m_oOKBtn.setFocusable(true);
        this.m_oOKBtn.setText(this.m_oResManager.getResString("OK_BTN"));
        this.getContentPane().add(this.m_oOKBtn);
        this.m_oCancelBtn.setName("Standalone_GatewayDevDlg_m_oCancelBtn");
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("CANCEL_BTN"));
        this.getContentPane().add(this.m_oCancelBtn);
        if (this.dialogType.equals("MODIFYIP")) {
            this.m_oOKBtn.setBounds(141, 147, 80, 20);
            this.m_oCancelBtn.setBounds(225, 147, 80, 20);
        } else {
            this.m_oOKBtn.setBounds(161, 167, 80, 20);
            this.m_oCancelBtn.setBounds(245, 167, 80, 20);
        }
    }

    private void initPortField() {
        JLabel oPort = new JLabel();
        oPort.setText(this.m_oResManager.getResString("PORT") + ':');
        oPort.setBounds(12, 45, 100, 21);
        int iMaxCount = 65535;
        int iMinCount = 1;
        int iCurValue = 1400;
        T2000DevInfo t2000DevInfo = this.getTheFirstT2000DevInfo();
        if (-1 != t2000DevInfo.getPort()) {
            iCurValue = t2000DevInfo.getPort();
        }
        Spinner oPortNumberSpinner = null;
        this.m_oPortNumberSpinnerModel = new NumericSpinnerModel(iCurValue, iMinCount, iMaxCount, 1);
        oPortNumberSpinner = new Spinner((SpinnerModel)this.m_oPortNumberSpinnerModel);
        oPortNumberSpinner.setName("Standalone_GatewayDevDlg_oPortNumberSpinner");
        oPortNumberSpinner.setToolTipText(iMinCount + " - " + iMaxCount);
        oPortNumberSpinner.setBounds(128, 45, 160, 21);
        this.m_oGatewayInfoPanel.add(oPort);
        this.m_oGatewayInfoPanel.add((Component)oPortNumberSpinner);
        JLabel oGatewayLabel = new JLabel("*");
        oGatewayLabel.setForeground(Color.red);
        oGatewayLabel.setBounds(292, 45, 10, 21);
        this.m_oGatewayInfoPanel.add(oGatewayLabel);
    }

    private T2000DevInfo getTheFirstT2000DevInfo() {
        return this.m_oT2000DevInfoLst.get(0);
    }

    private void initDeviceNameField() {
        JLabel oDeviceNameLbl = new JLabel();
        oDeviceNameLbl.setText(this.m_oResManager.getResString("DEVICE_NAME_LABEL"));
        oDeviceNameLbl.setBounds(12, 12, 110, 21);
        this.m_oDeviceName = new InmLengthLimitTextField(20);
        this.m_oDeviceName.setName("Standalone_GatewayDevDlg_m_oDeviceName");
        this.m_oDeviceName.setBounds(128, 12, 160, 21);
        if (this.m_oT2000DevInfoLst.size() == 1) {
            T2000DevInfo t2000DevInfo = this.getTheFirstT2000DevInfo();
            if (null != t2000DevInfo.getDeviceName()) {
                this.m_oDeviceName.setText(t2000DevInfo.getDeviceName().trim());
            }
        } else {
            this.m_oDeviceName.setEditable(false);
            this.m_oDeviceName.setEnabled(false);
            this.m_oDeviceName.setDisabledTextColor(Color.GRAY);
            this.m_oDeviceName.setBackground(this.getBackground());
        }
        this.m_oGatewayInfoPanel.add(oDeviceNameLbl);
        this.m_oGatewayInfoPanel.add((Component)this.m_oDeviceName);
    }

    private void initGatewayIpaddressField() {
        JLabel oGatewayIpAdressLbl = new JLabel();
        oGatewayIpAdressLbl.setName("Standalone_GatewayDevDlg_oGatewayIpAdressLbl");
        oGatewayIpAdressLbl.setText(this.m_oResManager.getResString("GATEWAY_ADDRESS") + ":");
        oGatewayIpAdressLbl.setBounds(24, 50, 100, 21);
        this.m_oGatewayIpAddrss = new IPAddressTextField();
        this.m_oGatewayIpAddrss.setName("Standalone_GatewayDevDlg_m_oGatewayIpAddrss");
        if (this.strIP.equals("")) {
            this.m_oGatewayIpAddrss.setText("");
        } else {
            this.m_oGatewayIpAddrss.setText(this.strIP);
        }
        this.m_oGatewayIpAddrss.setBounds(132, 50, 140, 21);
        this.m_oGatewayInfoPanel.add(oGatewayIpAdressLbl);
        this.m_oGatewayInfoPanel.add((Component)this.m_oGatewayIpAddrss);
    }

    private void initUsernameTxtField() {
        JLabel oUserNameLbl = new JLabel();
        oUserNameLbl.setName("Standalone_GatewayDevDlg_oUserNameLbl");
        oUserNameLbl.setText(this.m_oResManager.getResString("USER_NAME_LABEL"));
        oUserNameLbl.setBounds(12, 76, 100, 21);
        this.m_oUserNameTxtField = new InmLengthLimitTextField(20);
        this.m_oUserNameTxtField.setName("Standalone_GatewayDevDlg_m_oUserNameTxtField");
        T2000DevInfo t2000DevInfo = this.getTheFirstT2000DevInfo();
        if (null != t2000DevInfo.getUserName()) {
            this.m_oUserNameTxtField.setText(t2000DevInfo.getUserName().trim());
        } else {
            this.m_oUserNameTxtField.setText("");
        }
        this.m_oUserNameTxtField.setBounds(128, 76, 160, 21);
        this.m_oGatewayInfoPanel.add(oUserNameLbl);
        this.m_oGatewayInfoPanel.add((Component)this.m_oUserNameTxtField);
        JLabel oGatewayLabel = new JLabel("*");
        oGatewayLabel.setForeground(Color.red);
        oGatewayLabel.setBounds(292, 76, 10, 21);
        this.m_oGatewayInfoPanel.add(oGatewayLabel);
    }

    private void initPassWordTxtField() {
        JLabel oPasswordLbl = new JLabel();
        oPasswordLbl.setName("Standalone_GatewayDevDlg_oPasswordLbl");
        oPasswordLbl.setText(this.m_oResManager.getResString("PASSWORD"));
        oPasswordLbl.setBounds(12, 109, 100, 21);
        this.m_oPassordTxtField = new U2kPasswordFiled(40);
        this.m_oPassordTxtField.setName("Standalone_GatewayDevDlg_m_oPassordTxtField");
        this.m_oPassordTxtField.setBounds(128, 109, 160, 21);
        T2000DevInfo t2000DevInfo = this.getTheFirstT2000DevInfo();
        if (null != t2000DevInfo.getPass()) {
            this.m_oPassordTxtField.setPassword(t2000DevInfo.getPass());
        } else {
            this.m_oPassordTxtField.setPassword("".toCharArray());
        }
        this.m_oGatewayInfoPanel.add(oPasswordLbl);
        this.m_oGatewayInfoPanel.add(this.m_oPassordTxtField);
        JLabel oPasswordLabel = new JLabel("*");
        oPasswordLabel.setForeground(Color.red);
        oPasswordLabel.setBounds(292, 109, 10, 21);
        this.m_oGatewayInfoPanel.add(oPasswordLabel);
    }

    public List<T2000DevInfo> getT2000devInfoLst() {
        return this.m_oT2000DevInfoLst;
    }

    public boolean isOKClicked() {
        return this.m_bIsOKClicked;
    }

    @Override
    protected String getCurrentContext() {
        if (this.dialogType == "MODIFYIP") {
            return "HELP_TOPIC_NE_MODIFY";
        }
        return "";
    }

    @Override
    protected void closeDialog() {
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.setVisible(false);
        this.dispose();
        this.m_bIsOKClicked = false;
    }

    public boolean checkDevNameExist(List oResourceLst) {
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        DeviceInfo[] arrDevInfo = oDeviceInfoMgr.getDevices();
        if (null == arrDevInfo || 0 == arrDevInfo.length) {
            return true;
        }
        int iResListSize = oResourceLst.size();
        int iDevListSize = arrDevInfo.length;
        T2000DevInfo oResource = null;
        DeviceInfo oDeviceInfo = null;
        for (int iRes = 0; iRes < iResListSize; ++iRes) {
            oResource = (T2000DevInfo)oResourceLst.get(iRes);
            for (int iDev = 0; iDev < iDevListSize; ++iDev) {
                oDeviceInfo = arrDevInfo[iDev];
                if (!Collator.getInstance().equals(oResource.getDeviceName(), oDeviceInfo.getDevName())) continue;
                return false;
            }
        }
        return true;
    }

    public String getStrIP() {
        return this.strIP;
    }
}

