/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.search.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.u2kcbb.U2kPasswordFiled;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.swimap.imap12.util.InmLengthLimitTextField;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GatewayDevDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private InmLengthLimitTextField m_oUserNameTxtField = null;
    private U2kPasswordFiled m_oPassordTxtField = null;
    private NumericSpinnerModel m_oPortNumberSpinnerModel;
    private IPAddressTextField m_oGatewayIpAddrss = null;
    private JPanel m_oGatewayInfoPanel = null;
    private ResourceManager m_oResManager;
    private T2000DevInfo m_oDevInfo;
    private ArrayList<T2000DevInfo> m_oDevInfoList = new ArrayList();
    private int m_iDialogType;
    private T2000DevInfo m_oT2000DevInfo;
    private boolean m_oOKClicked;
    private IDeviceInfoManager m_oDevInfoManager = null;
    private static final int iIncludeOne = 1;
    private JCheckBox m_oLoginCheckBox;
    private boolean isCreateGateway;

    public GatewayDevDlg(int iDialogType, ArrayList<T2000DevInfo> oDevInfoList) {
        this.m_oResManager = ResourceManager.getInstance();
        this.m_oDevInfoList = oDevInfoList;
        this.m_oDevInfo = this.m_oDevInfoList.get(0);
        this.m_oT2000DevInfo = this.m_oDevInfoList.get(0);
        this.m_iDialogType = iDialogType;
        this.m_oDevInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        this.jbInit();
    }

    private void jbInit() {
        this.setSize(341, 262);
        this.setResizable(false);
        if (1 == this.m_iDialogType) {
            this.setTitle(this.m_oResManager.getResString("ADD_DIALOG_TITLE"));
        } else {
            this.setTitle(this.m_oResManager.getResString("MODIFY_DIALOG_TITLE"));
        }
        this.setLayout(null);
        this.initPanel();
        this.initUsernameTxtField();
        this.initPassWordTxtField();
        this.initGatewayIpaddressField();
        this.initPortField();
        this.initLoginCheckBox();
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GatewayDevDlg.this.okBtnActionPerformed();
            }
        });
        this.addButtons();
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void initPanel() {
        this.m_oGatewayInfoPanel = new JPanel();
        this.m_oGatewayInfoPanel.setName("Standalone_GatewayDevDlg_m_oGatewayInfoPanel");
        this.m_oGatewayInfoPanel.setLayout(null);
        this.m_oGatewayInfoPanel.setBounds(12, 12, 311, 173);
        this.getContentPane().add(this.m_oGatewayInfoPanel);
        this.m_oGatewayInfoPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    private void okBtnActionPerformed() {
        try {
            int iConfirm;
            this.validateFields();
            String gatewayIPAddress = "";
            try {
                gatewayIPAddress = this.m_oGatewayIpAddrss.getTrimedAddress();
            }
            catch (InValideIPAddressException e) {
                DCDebugTracer.trace((Exception)((Object)e));
            }
            int iMaxDevID = DCFrameWorkUtil.getDeviceInfoManager().getMaxDevID();
            for (T2000DevInfo oT2000DevInfo : this.m_oDevInfoList) {
                oT2000DevInfo.setDeviceID(++iMaxDevID);
                if (!gatewayIPAddress.equals("")) {
                    oT2000DevInfo.setGatewayAddress(gatewayIPAddress);
                }
                oT2000DevInfo.setPort((Integer)this.m_oPortNumberSpinnerModel.getValue());
                oT2000DevInfo.setUserName(this.m_oUserNameTxtField.getText());
                oT2000DevInfo.setPass(this.m_oPassordTxtField.getPasswordInChar());
                oT2000DevInfo.setGateWayType(1);
                oT2000DevInfo.setProtocolType(2);
                oT2000DevInfo.setDeviceName("");
            }
            this.isCreateGateway = this.m_oLoginCheckBox.isSelected();
            if (!this.isCreateGateway && 0 != (iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString("LOGIN_DIRECTLY_INFO"), this.m_oResManager.getResString("CONFIRM"), 0))) {
                return;
            }
            this.m_oOKClicked = true;
            this.setVisible(false);
        }
        catch (DCException e) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResManager.getResString(e.getMessage()));
            DCDebugTracer.trace("DC::GatewayDevDlg::okBtnActionPerformed::throw exception::" + e.getMessage());
            return;
        }
    }

    public ArrayList getT2000DevInfoList() {
        return this.m_oDevInfoList;
    }

    public T2000DevInfo getT2000DevInfo() {
        return this.m_oT2000DevInfo;
    }

    public boolean isOkClicked() {
        return this.m_oOKClicked;
    }

    @Override
    protected void closeDialog() {
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.setVisible(false);
        this.dispose();
        this.m_oOKClicked = false;
    }

    private void validateFields() throws DCException {
        if (this.m_oDevInfoList.size() == 1) {
            String strIpField = "";
            try {
                strIpField = this.m_oGatewayIpAddrss.getTrimedAddress();
            }
            catch (InValideIPAddressException e) {
                DCDebugTracer.trace((Exception)((Object)e));
            }
            strIpField = strIpField.trim();
            if (0 == strIpField.length()) {
                throw new DCException(this.m_oResManager.getResString("GATEWAY_ADDR_EMPTY"));
            }
            if (1 == this.m_iDialogType) {
                this.checkIfGateWayIpExists(strIpField);
            }
        }
        String strUsername = this.m_oUserNameTxtField.getText();
        if (0 == (strUsername = strUsername.trim()).length()) {
            throw new DCException(this.m_oResManager.getResString("USER_NAME_BLANK"));
        }
        char[] strPassword = this.m_oPassordTxtField.getPasswordInChar();
        if (0 >= strPassword.length) {
            throw new DCException(this.m_oResManager.getResString("PASSWORD_FIELD_BLANK"));
        }
        int iPort = (Integer)this.m_oPortNumberSpinnerModel.getValue();
        if (23 == iPort) {
            throw new DCException(this.m_oResManager.getResString("ADD_TL1_FROM_SEARCH_ERROR"));
        }
    }

    private void checkIfGateWayIpExists(String strIpField) throws DCException {
        DeviceInfo oDevInfo = this.m_oDevInfoManager.getDeviceByIP(strIpField);
        if (null != oDevInfo && 1 == oDevInfo.getRoleType()) {
            throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855903L)));
        }
    }

    private void addButtons() {
        this.m_oOKBtn.setName("Standalone_GatewayDevDlg_m_oOKBtn");
        this.m_oOKBtn.setBounds(161, 197, 80, 20);
        this.m_oOKBtn.setFocusable(true);
        this.m_oOKBtn.setText(this.m_oResManager.getResString("OK_BTN"));
        this.getContentPane().add(this.m_oOKBtn);
        this.m_oCancelBtn.setName("Standalone_GatewayDevDlg_m_oCancelBtn");
        this.m_oCancelBtn.setBounds(245, 197, 80, 20);
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("CANCEL_BTN"));
        this.getContentPane().add(this.m_oCancelBtn);
    }

    private void initPortField() {
        JLabel oPort = new JLabel();
        oPort.setName("Standalone_GatewayDevDlg_oPort");
        oPort.setText(this.m_oResManager.getResString("PORT") + ':');
        oPort.setBounds(12, 45, 100, 21);
        int iMaxCount = 65535;
        int iMinCount = 1;
        int iCurValue = 1400;
        if (-1 != this.m_oDevInfo.getPort()) {
            iCurValue = this.m_oDevInfo.getPort();
        }
        iMinCount = Math.min(iCurValue, iMinCount);
        Spinner oPortNumberSpinner = null;
        this.m_oPortNumberSpinnerModel = new NumericSpinnerModel(iCurValue, iMinCount, iMaxCount, 1);
        oPortNumberSpinner = new Spinner((SpinnerModel)this.m_oPortNumberSpinnerModel);
        oPortNumberSpinner.setName("Standalone_GatewayDevDlg_oPortNumberSpinner");
        oPortNumberSpinner.setToolTipText(iMinCount + " - " + iMaxCount);
        oPortNumberSpinner.setBounds(138, 45, 160, 21);
        this.m_oGatewayInfoPanel.add(oPort);
        this.m_oGatewayInfoPanel.add((Component)oPortNumberSpinner);
    }

    private void initGatewayIpaddressField() {
        JLabel oGatewayIpAdressLbl = new JLabel();
        oGatewayIpAdressLbl.setName("Standalone_GatewayDevDlg_oGatewayIpAdressLbl");
        oGatewayIpAdressLbl.setText(this.m_oResManager.getResString("GATEWAY_ADDRESS") + ":");
        oGatewayIpAdressLbl.setBounds(12, 12, 110, 21);
        this.m_oGatewayIpAddrss = new IPAddressTextField();
        this.m_oGatewayIpAddrss.setName("Standalone_GatewayDevDlg_m_oGatewayIpAddrss");
        if (this.m_oDevInfoList.size() > 1) {
            this.m_oGatewayIpAddrss.setText("");
            this.m_oGatewayIpAddrss.setEnabled(false);
        } else if (null != this.m_oDevInfo.getGatewayAddress()) {
            this.m_oGatewayIpAddrss.setText(this.m_oDevInfo.getGatewayAddress());
        }
        this.m_oGatewayIpAddrss.setBounds(138, 12, 160, 21);
        this.m_oGatewayInfoPanel.add(oGatewayIpAdressLbl);
        this.m_oGatewayInfoPanel.add((Component)this.m_oGatewayIpAddrss);
    }

    private void initUsernameTxtField() {
        JLabel oUserNameLbl = new JLabel();
        oUserNameLbl.setName("Standalone_GatewayDevDlg_oUserNameLbl");
        oUserNameLbl.setText(this.m_oResManager.getResString("USER_NAME") + ":");
        oUserNameLbl.setBounds(12, 76, 100, 21);
        this.m_oUserNameTxtField = new InmLengthLimitTextField(20);
        this.m_oUserNameTxtField.setName("Standalone_GatewayDevDlg_m_oUserNameTxtField");
        if (null != this.m_oDevInfo.getUserName()) {
            this.m_oUserNameTxtField.setText(this.m_oDevInfo.getUserName().trim());
        }
        this.m_oUserNameTxtField.setBounds(138, 76, 160, 21);
        this.m_oGatewayInfoPanel.add(oUserNameLbl);
        this.m_oGatewayInfoPanel.add((Component)this.m_oUserNameTxtField);
    }

    private void initPassWordTxtField() {
        JLabel oPasswordLbl = new JLabel();
        oPasswordLbl.setName("Standalone_GatewayDevDlg_oPasswordLbl");
        oPasswordLbl.setText(this.m_oResManager.getResString("PASSWORD"));
        oPasswordLbl.setBounds(12, 109, 100, 21);
        this.m_oPassordTxtField = new U2kPasswordFiled(40);
        this.m_oPassordTxtField.setName("Standalone_GatewayDevDlg_m_oPassordTxtField");
        if (null != this.m_oDevInfo.getPass()) {
            this.m_oPassordTxtField.setPassword(this.m_oDevInfo.getPass());
        }
        this.m_oPassordTxtField.setBounds(138, 109, 160, 21);
        this.m_oGatewayInfoPanel.add(oPasswordLbl);
        this.m_oGatewayInfoPanel.add(this.m_oPassordTxtField);
    }

    private void initLoginCheckBox() {
        this.m_oLoginCheckBox = new JCheckBox();
        this.m_oLoginCheckBox.setName("Standalone_GatewayDevDlg_m_oLoginCheckBox");
        this.m_oLoginCheckBox.setText(this.m_oResManager.getResString("LOGIN_DIRECTLY"));
        this.m_oLoginCheckBox.setBounds(12, 142, 120, 21);
        this.m_oLoginCheckBox.setSelected(true);
        this.m_oGatewayInfoPanel.add(this.m_oLoginCheckBox);
        this.m_oLoginCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!GatewayDevDlg.this.m_oLoginCheckBox.isSelected()) {
                    GatewayDevDlg.this.m_oGatewayIpAddrss.setEditable(true);
                    GatewayDevDlg.this.m_oGatewayIpAddrss.setEnabled(true);
                }
            }
        });
        if (this.m_oDevInfoList.size() > 1) {
            this.m_oLoginCheckBox.setEnabled(false);
        }
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_STANDALONE_ADD_GATEWAY_DEVICE";
    }

    public boolean isCreateGateway() {
        return this.isCreateGateway;
    }
}

