/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.model;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDevAddReq;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.standalone.StandAloneCommonOpr;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneCommUtil;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.RouterDevTableInfo;
import java.awt.Component;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class RouterDevInfoObj
extends AbstractDevInfoObj {
    private IDCStandAloneSyncCtrller m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private String m_strDevAddress = "";
    private String m_strDevName = "";
    private DevType m_oDevType = new DevType();
    private ProxyType m_oProxyType = new ProxyType();
    private ProxyNodeType m_oProxyNodeType = new ProxyNodeType();
    private ProtocolType m_oProtocolType = new ProtocolType();
    private String m_strUserName = "";
    private char[] m_strPass = "".toCharArray();
    private char[] m_strSuper3Pass = "".toCharArray();
    private String m_strVPNName = "";
    private RouterDevInfoObj m_parentDevInfoObj = null;
    private String m_strAgentID = "";
    private String m_strPreAgentID = "";
    private boolean m_isNewDevInfo = true;
    private String m_strVersion = "";
    private String m_strPatchVersion = "";
    private boolean m_isFinishInitialize = false;
    private OperationStatus m_oprStatus;
    private Field m_currentChangedField;
    private Object m_strCurrentChangedFiledOldValue;
    private int m_iPreDevID = -1;
    private static final RouterDevTableInfo m_oRouterDevTableInfo = new RouterDevTableInfo();

    public RouterDevInfoObj() {
        this(true);
    }

    public RouterDevInfoObj(boolean isNew) {
        this.m_isNewDevInfo = isNew;
        this.m_oprStatus = new OperationStatus();
    }

    public RouterDevInfoObj(RouterDevInfoObj oParentDevInfoObj) {
        this(oParentDevInfoObj, false);
    }

    public RouterDevInfoObj(RouterDevInfoObj oParentDevInfoObj, boolean isNew) {
        this(isNew);
        this.m_parentDevInfoObj = oParentDevInfoObj;
    }

    @Override
    public void setDevAddress(String strDevAddress) {
        if (!this.m_strDevAddress.equals(strDevAddress)) {
            this.m_strCurrentChangedFiledOldValue = this.m_strDevAddress;
            this.m_strDevAddress = strDevAddress;
            super.setDevAddress(this.m_strDevAddress);
            this.sendDevInfoToServer("m_strDevAddress");
        }
    }

    @Override
    public String getDevAddress() {
        return this.m_strDevAddress;
    }

    @Override
    public long getLDevAddress() {
        return this.convertStringtoLong(this.m_strDevAddress);
    }

    @Override
    public void setDevName(String strDevName) {
        if (!this.m_strDevName.equals(strDevName)) {
            this.m_strCurrentChangedFiledOldValue = this.m_strDevName;
            this.m_strDevName = strDevName;
            this.sendDevInfoToServer("m_strDevName");
        }
    }

    @Override
    public String getDevName() {
        return this.m_strDevName;
    }

    public void setDevType(String strDevType) {
        if (!this.m_oDevType.getDevTypeName().equals(strDevType)) {
            this.m_strCurrentChangedFiledOldValue = new DevType(this.m_oDevType.getDevTypeName());
            this.m_oDevType.setDevTypeName(strDevType);
            this.sendDevInfoToServer("m_oDevType");
        }
    }

    public void setDevTypeName(String strDevType) {
        if (!this.m_oDevType.getDevTypeName().equals(strDevType)) {
            this.m_strCurrentChangedFiledOldValue = new DevType(this.m_oDevType.getDevTypeName());
            this.m_oDevType.setDevTypeName(strDevType);
        }
    }

    public String getDevType() {
        return this.m_oDevType.getDevTypeName();
    }

    public Icon getDevIcon() {
        return this.m_oDevType.getDevTypeIcon();
    }

    public void setIProxyType(int iProxyType) {
        this.m_oProxyType.setProxyTypeValue(iProxyType);
    }

    public int getIProxyType() {
        return this.m_oProxyType.getProxyTypeValue();
    }

    public void setProxyType(String strProxyType) {
        if (!this.m_oProxyType.getProxyTypeName().equals(strProxyType)) {
            this.m_strCurrentChangedFiledOldValue = new ProxyType(this.m_oProxyType.getProxyTypeName());
            ((ProxyType)this.m_strCurrentChangedFiledOldValue).setDevType(this.m_oDevType.getDevTypeName());
            this.m_oProxyType.setProxyTypeName(strProxyType);
            this.m_oProxyType.setProxyTypeValue(this.m_oProxyType.m_iProxyTypeValue);
            this.sendDevInfoToServer("m_oProxyType");
        }
    }

    public String getProxyType() {
        return this.m_oProxyType.getProxyTypeName();
    }

    public void setIProxyNodeType(int iProxyNodeType) {
        this.m_oProxyNodeType.setProxyNodeTypeValue(iProxyNodeType);
    }

    public int getIProxyNodeType() {
        return this.m_oProxyNodeType.getProxyNodeTypeValue();
    }

    public void setProxyNodeType(String strProxyNodeType) {
        if (!this.m_oProxyNodeType.getProxyNodeTypeName().equals(strProxyNodeType)) {
            this.m_strCurrentChangedFiledOldValue = new ProxyNodeType(this.m_oProxyNodeType.getProxyNodeTypeName());
            this.m_oProxyNodeType.setProxyNodeTypeName(strProxyNodeType);
            this.sendDevInfoToServer("m_oProxyNodeType");
        }
    }

    public String getProxyNodeType() {
        return this.m_oProxyNodeType.getProxyNodeTypeName();
    }

    public void setProtocolType(String strProtocolType) {
        if (!this.m_oProtocolType.getProtocolTypeName().equals(strProtocolType)) {
            this.m_strCurrentChangedFiledOldValue = new ProtocolType(this.m_oProtocolType.getProtocolTypeName());
            this.m_oProtocolType.setProtocolTypeName(strProtocolType);
            this.sendDevInfoToServer("m_oProtocolType");
        }
    }

    public String getProtocolType() {
        return this.m_oProtocolType.getProtocolTypeName();
    }

    public void setIProtocolType(int iProtocolType) {
        this.m_oProtocolType.setProtocolTypeValue(iProtocolType);
    }

    public int getIProtocolType() {
        return this.m_oProtocolType.getProtocolTypeValue();
    }

    public void setPort(String strPort) {
        if (!this.m_oProtocolType.getStrPort().equals(strPort)) {
            this.m_strCurrentChangedFiledOldValue = new ProtocolType(this.m_oProtocolType.getProtocolTypeName(), this.m_oProtocolType.getPort());
            try {
                this.m_oProtocolType.setPort(Integer.valueOf(strPort));
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
                this.m_oProtocolType.setPort(23);
            }
            this.sendDevInfoToServer("m_oProtocolType");
        }
    }

    public String getPort() {
        return this.m_oProtocolType.getStrPort();
    }

    public int getIPort() {
        return this.m_oProtocolType.getPort();
    }

    public void setUserName(String strUserName) {
        if (!this.m_strUserName.equals(strUserName)) {
            this.m_strCurrentChangedFiledOldValue = this.m_strUserName;
            this.m_strUserName = strUserName;
            this.sendDevInfoToServer("m_strUserName");
        }
    }

    public String getUserName() {
        return this.m_strUserName;
    }

    public void setPassword(char[] strPassword) {
        if (!String.valueOf(this.m_strPass).equals(String.valueOf(strPassword))) {
            this.m_strCurrentChangedFiledOldValue = this.m_strPass;
            this.m_strPass = strPassword;
            this.sendDevInfoToServer("m_strPass");
        }
    }

    public char[] getPassword() {
        return this.m_strPass;
    }

    public void setSuper3Pass(char[] strSuper3Pass) {
        if (!String.valueOf(this.m_strSuper3Pass).equals(String.valueOf(strSuper3Pass))) {
            this.m_strCurrentChangedFiledOldValue = this.m_strSuper3Pass;
            this.m_strSuper3Pass = strSuper3Pass;
            this.sendDevInfoToServer("m_strSuper3Pass");
        }
    }

    public char[] getSuper3Pass() {
        return this.m_strSuper3Pass;
    }

    public void setVPNName(String strVPNName) {
        if (!this.m_strVPNName.equals(strVPNName)) {
            this.m_strCurrentChangedFiledOldValue = this.m_strVPNName;
            this.m_strVPNName = strVPNName;
            this.sendDevInfoToServer("m_strVPNName");
        }
    }

    public String getVPNName() {
        return this.m_strVPNName;
    }

    public String toString() {
        return this.getDevName();
    }

    public boolean getIsAgent() {
        return this.m_oProxyType.getIsAgent();
    }

    public RouterDevInfoObj getParentDevInfoObj() {
        return this.m_parentDevInfoObj;
    }

    public void setAgentID(String strAgentID) {
        this.m_strAgentID = strAgentID;
    }

    public String getAgentID() {
        if ("".equals(this.m_strAgentID) && this.getIsAgent()) {
            int iTmpAgentID = StandAloneCommonOpr.getInstance().generateAgentID();
            this.m_strAgentID = null != this.m_parentDevInfoObj ? this.m_parentDevInfoObj.getAgentID() + "." + iTmpAgentID : String.valueOf(iTmpAgentID);
        }
        return this.m_strAgentID;
    }

    public void setIsNewDevInfo(boolean isNewDevInfo) {
        this.m_isNewDevInfo = isNewDevInfo;
    }

    public boolean getIsNewDevInfo() {
        return this.m_isNewDevInfo;
    }

    public void setVersion(String strVersion) {
        this.m_strVersion = strVersion;
    }

    public String getVersion() {
        return this.m_strVersion;
    }

    public void setPatchVersion(String strPatchVersion) {
        this.m_strPatchVersion = strPatchVersion;
    }

    public String getPatchVersion() {
        return this.m_strPatchVersion;
    }

    public void setOperationStatus(OperationStatus oprStatus) {
        this.m_oprStatus = oprStatus;
    }

    public OperationStatus getOperationStatus() {
        return this.m_oprStatus;
    }

    public void setIsFinishInitialize(boolean isFinishInitialize) {
        this.m_isFinishInitialize = isFinishInitialize;
    }

    @Override
    public void setOprResult(String strOprResult) {
        if (!this.m_isNewDevInfo) {
            super.setOprResult(strOprResult);
        }
    }

    public boolean sendDevInfoToServer() {
        this.m_isFinishInitialize = true;
        return this.sendDevInfoToServer("");
    }

    private boolean sendDevInfoToServer(String strFieldName) {
        if (this.m_isFinishInitialize) {
            this.setCurrentChangedField(strFieldName);
            if (this.validateDevInfo(!this.m_isNewDevInfo)) {
                if (this.m_isNewDevInfo) {
                    this.m_isNewDevInfo = false;
                    ArrayList<AbstractDevInfoObj> oRouterDevList = new ArrayList<AbstractDevInfoObj>();
                    this.setDevID(StandAloneCommonOpr.getInstance().generateDevID());
                    oRouterDevList.add(this);
                    try {
                        int iReqId = DCFrameWorkUtil.generateRequestId();
                        this.m_oStandAloneSyncCtrller.addDevice(iReqId, oRouterDevList, 2, true);
                        DCDebugTracer.trace("RouterDevInfoObj::addDevice(iDevId = " + this.getDevID() + ")");
                    }
                    catch (DCException e) {
                        this.setErrorCode(e.getErrorCode());
                        DCDebugTracer.trace("RouterDevInfoObj::fail to addDevice(iDevId = " + this.getDevID() + ", error = " + e.getErrorCode() + ")");
                        this.m_isNewDevInfo = true;
                        this.showErrMessage(this.getOprResult(), true);
                        return false;
                    }
                } else {
                    if (!this.getIsAgent() && -1 == this.getDevID()) {
                        this.setDevID(StandAloneCommonOpr.getInstance().generateDevID());
                    }
                    AsnDevAddReq oAddDevReq = new AsnDevAddReq();
                    oAddDevReq.oAsnDevInfoList.add((Object)StandAloneCommUtil.getAsnDevInfo(this));
                    oAddDevReq.oAsnRouterExtInfo = StandAloneCommUtil.getAsnRouterDevExtInfo(this);
                    if (this.getIsAgent()) {
                        this.m_iPreDevID = this.getDevID();
                        this.setDevID(-1);
                    } else {
                        this.m_strPreAgentID = this.getAgentID();
                        this.setAgentID("");
                    }
                    try {
                        this.m_oStandAloneSyncCtrller.modifyRouterDevice(oAddDevReq);
                    }
                    catch (DCException e) {
                        this.setErrorCode(e.getErrorCode());
                        this.rollbackChangedValue();
                        this.showErrMessage(this.getOprResult(), true);
                        return false;
                    }
                }
            } else {
                if (!this.m_isNewDevInfo) {
                    this.rollbackChangedValue(false);
                }
                return false;
            }
        }
        return true;
    }

    private void rollbackDevAndAgentID() {
        this.setDevID(this.m_iPreDevID);
        this.setAgentID(this.m_strPreAgentID);
    }

    public boolean validateDevInfo(boolean isShow) {
        if (null == this.m_currentChangedField) {
            return true;
        }
        if (-2147483647 <= this.getErrorCode() && 0 > this.getErrorCode()) {
            DCDebugTracer.trace("RouterDevInfoObj#validateDevInfo:" + this.getErrorCode());
            return false;
        }
        if (this.m_oResManager.getResString("ADD_ROUTER_DEV_DIRECT").equals(this.getProxyType())) {
            int output;
            if (!this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_HUAWEI").equals(this.m_oProxyNodeType.toString())) {
                String strMsg = this.m_oResManager.getResString("ADD_DEV_WRONG_PROXY_TYPE");
                this.showErrMessage(strMsg, isShow);
                return false;
            }
            if ("".equals(this.getDevType())) {
                String strMsg = this.m_oResManager.getResString("ADD_DEV_NO_EMPTY_DEV_TYPE");
                this.showErrMessage(strMsg, isShow);
                return false;
            }
            if ("m_oProxyType".equals(this.m_currentChangedField.getName()) && (output = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("PROXY_TO_DEV_CONFIRM"), ResourceManager.getInstance().getResString("CONFIRM"), 0)) != 0) {
                return false;
            }
        } else if (this.isUptoMaxAgentLevel()) {
            String strMsg = this.m_oResManager.getResString("UP_TO_MAX_AGENT_LEVEL_PROMT_MES");
            this.showErrMessage(strMsg, isShow);
            return false;
        }
        if (0 >= this.getIPort()) {
            String strMsg = this.m_oResManager.getResString("INVALID_DEVICE_PORT");
            this.showErrMessage(strMsg, isShow);
            return false;
        }
        return true;
    }

    private boolean isUptoMaxAgentLevel() {
        int iCurrentAgentLevel = 0;
        for (RouterDevInfoObj tmpDevInfoObj = this.m_parentDevInfoObj; null != tmpDevInfoObj; tmpDevInfoObj = tmpDevInfoObj.getParentDevInfoObj()) {
            ++iCurrentAgentLevel;
        }
        return iCurrentAgentLevel >= 6;
    }

    public boolean validateDevInfo() {
        return this.validateDevInfo(false);
    }

    private void setCurrentChangedField(String strFieldName) {
        try {
            this.m_currentChangedField = this.getClass().getDeclaredField(strFieldName);
        }
        catch (SecurityException e) {
            DCDebugTracer.trace(e);
        }
        catch (NoSuchFieldException e) {
            DCDebugTracer.trace(e);
        }
        DCDebugTracer.trace("RouterDevInfoObj::setCurrentChangedField(strFieldName = " + strFieldName + ", m_currentChangedField = " + this.m_currentChangedField + ")");
    }

    public String getCurrentChangedFieldName() {
        if (null != this.m_currentChangedField) {
            return this.m_currentChangedField.getName();
        }
        return "";
    }

    public void rollbackChangedValue() {
        this.rollbackChangedValue(true);
    }

    private void rollbackChangedValue(boolean isRollbackID) {
        try {
            this.m_currentChangedField.set(this, this.m_strCurrentChangedFiledOldValue);
            if (this.m_currentChangedField.getName().equals("m_oProxyType")) {
                if (isRollbackID) {
                    this.rollbackDevAndAgentID();
                }
                ((ProxyType)this.m_strCurrentChangedFiledOldValue).rollback();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        DCDebugTracer.trace("RouterDevInfoObj::rollbackChangedValue(m_currentChangedField = " + this.m_currentChangedField + ", m_strCurrentChangedFiledOldValue = " + this.m_strCurrentChangedFiledOldValue + ")");
    }

    private void showErrMessage(final String strErrMsg, boolean isShow) {
        if (isShow) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrMsg, ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                }
            });
        }
    }

    @Override
    public String[] getSortMethods() {
        return m_oRouterDevTableInfo.getSortMethods();
    }

    private class ProtocolType {
        private String m_strProtocolTypeName;
        private int m_iProtocolTypeValue;
        private int m_iPort;

        public ProtocolType() {
            this(5);
        }

        public ProtocolType(String strProtocolTypeName) {
            this.setProtocolTypeName(strProtocolTypeName);
        }

        public ProtocolType(String strProtocolTypeName, int iPort) {
            this.setProtocolTypeName(strProtocolTypeName);
            this.setPort(iPort);
        }

        public ProtocolType(int iProtocolTypeValue) {
            this.setProtocolTypeValue(iProtocolTypeValue);
        }

        public void setProtocolTypeName(String strProtocolTypeName) {
            this.m_strProtocolTypeName = strProtocolTypeName;
            if (RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROTOCOL_TELNET").equals(strProtocolTypeName)) {
                this.m_iPort = 23;
                this.m_iProtocolTypeValue = 5;
            } else {
                this.m_iPort = 22;
                this.m_iProtocolTypeValue = 6;
            }
        }

        public String getProtocolTypeName() {
            return this.m_strProtocolTypeName;
        }

        public void setProtocolTypeValue(int iProtocolTypeValue) {
            this.m_iProtocolTypeValue = iProtocolTypeValue;
            if (iProtocolTypeValue == 5) {
                this.m_strProtocolTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROTOCOL_TELNET");
                this.m_iPort = 23;
            } else {
                this.m_strProtocolTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROTOCOL_SSH");
                this.m_iPort = 22;
            }
        }

        public int getProtocolTypeValue() {
            return this.m_iProtocolTypeValue;
        }

        public void setPort(int iPort) {
            this.m_iPort = iPort;
        }

        public int getPort() {
            return this.m_iPort;
        }

        public String getStrPort() {
            return String.valueOf(this.m_iPort);
        }
    }

    private class ProxyNodeType {
        private String m_strProxyNodeTypeName;
        private int m_iProxyNodeTypeValue;

        public ProxyNodeType() {
            this(4);
        }

        public ProxyNodeType(String strProxyNodeTypeName) {
            this.setProxyNodeTypeName(strProxyNodeTypeName);
        }

        public ProxyNodeType(int iProxyNodeTypeValue) {
            this.setProxyNodeTypeValue(iProxyNodeTypeValue);
        }

        public void setProxyNodeTypeName(String strProxyNodeTypeName) {
            this.m_strProxyNodeTypeName = strProxyNodeTypeName;
            this.m_iProxyNodeTypeValue = strProxyNodeTypeName.equals(RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_CISCO")) ? 1 : (strProxyNodeTypeName.equals(RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_HUAWEI")) ? 4 : (strProxyNodeTypeName.equals(RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_TELNET_HUAWEI")) ? 2 : (strProxyNodeTypeName.equals(RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_SOL")) ? 3 : -1)));
        }

        public String getProxyNodeTypeName() {
            return this.m_strProxyNodeTypeName;
        }

        public void setProxyNodeTypeValue(int iProxyNodeTypeValue) {
            this.m_iProxyNodeTypeValue = iProxyNodeTypeValue;
            switch (iProxyNodeTypeValue) {
                case 1: {
                    this.m_strProxyNodeTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_CISCO");
                    break;
                }
                case 4: {
                    this.m_strProxyNodeTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_HUAWEI");
                    break;
                }
                case 2: {
                    this.m_strProxyNodeTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_TELNET_HUAWEI");
                    break;
                }
                case 3: {
                    this.m_strProxyNodeTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_PROXY_NODE_SOL");
                    break;
                }
                default: {
                    this.m_strProxyNodeTypeName = "";
                }
            }
        }

        public int getProxyNodeTypeValue() {
            return this.m_iProxyNodeTypeValue;
        }

        public String toString() {
            return this.getProxyNodeTypeName();
        }
    }

    private class ProxyType {
        private String m_strProxyTypeName;
        private int m_iProxyTypeValue;
        private boolean m_isAgent = false;
        private String m_strDevType;

        public ProxyType() {
            this(1);
        }

        public ProxyType(String strProxyTypeName) {
            this.setProxyTypeName(strProxyTypeName);
        }

        public ProxyType(int iProxyTypeValue) {
            this.setProxyTypeValue(iProxyTypeValue);
        }

        public void setProxyTypeName(String strProxyTypeName) {
            this.m_strProxyTypeName = strProxyTypeName;
            if (this.m_strProxyTypeName.equals(RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_DIRECT"))) {
                this.m_isAgent = false;
                this.m_iProxyTypeValue = 1;
            } else if (this.m_strProxyTypeName.equals(RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_AUTO_PROXY"))) {
                this.m_iProxyTypeValue = 2;
                this.m_isAgent = true;
            } else {
                this.m_iProxyTypeValue = 3;
                this.m_isAgent = true;
            }
            if (this.m_isAgent) {
                RouterDevInfoObj.this.m_oDevType.setDevTypeName("");
            } else {
                RouterDevInfoObj.this.m_oDevType.initDevType();
            }
        }

        public String getProxyTypeName() {
            return this.m_strProxyTypeName;
        }

        public void setProxyTypeValue(int iProxyTypeValue) {
            this.m_iProxyTypeValue = iProxyTypeValue;
            switch (this.m_iProxyTypeValue) {
                case 1: {
                    this.m_isAgent = false;
                    this.m_strProxyTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_DIRECT");
                    break;
                }
                case 2: {
                    this.m_isAgent = true;
                    this.m_strProxyTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_AUTO_PROXY");
                    break;
                }
                case 3: {
                    this.m_isAgent = true;
                    this.m_strProxyTypeName = "";
                    break;
                }
                default: {
                    this.m_isAgent = false;
                    this.m_strProxyTypeName = RouterDevInfoObj.this.m_oResManager.getResString("ADD_ROUTER_DEV_DIRECT");
                }
            }
            if (this.m_isAgent) {
                RouterDevInfoObj.this.m_oDevType.setDevTypeName("");
            } else {
                RouterDevInfoObj.this.m_oDevType.initDevType();
            }
        }

        public int getProxyTypeValue() {
            return this.m_iProxyTypeValue;
        }

        public boolean getIsAgent() {
            return this.m_isAgent;
        }

        public String toString() {
            return this.getProxyTypeName();
        }

        public void setDevType(String strDevType) {
            this.m_strDevType = strDevType;
        }

        public void rollback() {
            RouterDevInfoObj.this.m_oDevType.setDevTypeName(this.m_strDevType);
        }
    }

    private class DevType {
        private String strDevTypeName = "";
        private Icon oDevTypeIcon = null;

        public DevType() {
            String[] strDevTypes = StandAloneCommonOpr.getInstance().getSupportedDevTypes();
            if (0 < strDevTypes.length) {
                this.setDevTypeName(strDevTypes[0]);
            }
        }

        public DevType(String strDevTypeName) {
            this.setDevTypeName(strDevTypeName);
        }

        public void initDevType() {
            String[] strDevTypes = StandAloneCommonOpr.getInstance().getSupportedDevTypes();
            if (0 < strDevTypes.length) {
                this.setDevTypeName(strDevTypes[0]);
            }
        }

        public void setDevTypeName(String strDevTypeName) {
            this.strDevTypeName = strDevTypeName;
            this.oDevTypeIcon = null;
            DeviceTypeInfo[] devTypes = DeviceInfoManagerImpl.getInstance().getDevTypeInfoByTypeName(strDevTypeName);
            if (null != devTypes && 0 < devTypes.length) {
                this.oDevTypeIcon = ResourceManager.getInstance().getNeTypeImage(devTypes[0]);
            }
            if (null == this.oDevTypeIcon) {
                this.oDevTypeIcon = ResourceManager.getInstance().getImage("versionicon.gif");
            }
        }

        public String getDevTypeName() {
            return this.strDevTypeName;
        }

        public Icon getDevTypeIcon() {
            return this.oDevTypeIcon;
        }
    }
}

