/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.model;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.AddDeviceAdvanceObj;
import com.huawei.dc.standalone.model.OptixDevTableInfo;
import java.util.HashMap;

public class OptixDevInfoObj
extends AbstractDevInfoObj {
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private String m_strProtocolType = this.m_oResManager.getResString("MML_PROTOCOL");
    private String m_strDevExtID = "";
    private String m_strDevPhyID = "";
    private String m_strGatewayType = this.m_oResManager.getResString("IP_GATEWAY_TYPE");
    private String m_strPort = String.valueOf(1400);
    private String m_strUserName = "";
    private char[] m_strPass = "".toCharArray();
    private AddDeviceAdvanceObj m_advanceSettingInfo = null;
    private HashMap<String, Object> m_mmlDevInfoMap = new HashMap();
    private HashMap<String, Object> m_tl1DevInfoMap;
    private HashMap<String, Object> m_currentMap;
    private static final OptixDevTableInfo m_optixDevTableInfo = new OptixDevTableInfo();

    public OptixDevInfoObj() {
        this.m_mmlDevInfoMap.put("getDevType", String.valueOf(0));
        this.m_mmlDevInfoMap.put("getDevExtID", "");
        this.m_mmlDevInfoMap.put("getNEID", "");
        this.m_mmlDevInfoMap.put("getDevName", "");
        this.m_mmlDevInfoMap.put("getGatewayType", this.m_strGatewayType);
        this.m_mmlDevInfoMap.put("getIsGateWay", "");
        this.m_mmlDevInfoMap.put("getDevVersion", "");
        this.m_mmlDevInfoMap.put("getDevAddress", "");
        this.m_mmlDevInfoMap.put("getPort", this.m_strPort);
        this.m_mmlDevInfoMap.put("getUserName", this.m_strUserName);
        this.m_mmlDevInfoMap.put("getPassword", String.valueOf(this.m_strPass));
        this.m_mmlDevInfoMap.put("getAdvancedSeting", this.m_advanceSettingInfo);
        this.m_tl1DevInfoMap = new HashMap();
        this.m_tl1DevInfoMap.put("getDevType", String.valueOf(0));
        this.m_tl1DevInfoMap.put("getDevExtID", "");
        this.m_tl1DevInfoMap.put("getNEID", "");
        this.m_tl1DevInfoMap.put("getDevName", "");
        this.m_tl1DevInfoMap.put("getGatewayType", this.m_strGatewayType);
        this.m_tl1DevInfoMap.put("getIsGateWay", "");
        this.m_tl1DevInfoMap.put("getDevVersion", "");
        this.m_tl1DevInfoMap.put("getDevAddress", "");
        this.m_tl1DevInfoMap.put("getPort", String.valueOf(23));
        this.m_tl1DevInfoMap.put("getUserName", "");
        this.m_tl1DevInfoMap.put("getPassword", "");
        this.m_tl1DevInfoMap.put("getAdvancedSeting", this.m_advanceSettingInfo);
        this.m_currentMap = this.m_mmlDevInfoMap;
    }

    public void setProtocolType(String strProtocolType) {
        if (null != this.m_strProtocolType && this.m_strProtocolType.equals(strProtocolType)) {
            return;
        }
        this.m_strProtocolType = strProtocolType;
        if (this.m_strProtocolType.equals(this.m_oResManager.getResString("MML_PROTOCOL"))) {
            this.m_currentMap = this.m_mmlDevInfoMap;
            this.setUserName("");
            this.setPassword("".toCharArray());
            String gatewayType = this.getGatewayType();
            if (this.m_oResManager.getResString("OS_GATEWAY_TYPE").equals(gatewayType)) {
                this.setPort(String.valueOf(8888));
            } else if (this.m_oResManager.getResString("IP_GATEWAY_TYPE").equals(gatewayType)) {
                this.setPort(String.valueOf(1400));
            } else {
                this.setPort("");
            }
        } else if (this.m_strProtocolType.equals(this.m_oResManager.getResString("TLL_PROTOCOL"))) {
            this.m_currentMap = this.m_tl1DevInfoMap;
            this.setUserName("");
            this.setPassword("".toCharArray());
            String gatewayType = this.getGatewayType();
            if (this.m_oResManager.getResString("OS_GATEWAY_TYPE").equals(gatewayType)) {
                this.setPort("");
            } else if (this.m_oResManager.getResString("IP_GATEWAY_TYPE").equals(gatewayType)) {
                this.setPort(String.valueOf(23));
            } else {
                this.setPort("");
            }
        } else {
            this.setPort("");
            DCDebugTracer.trace("other Protocol:" + strProtocolType);
        }
    }

    public String getProtocolType() {
        return this.m_strProtocolType;
    }

    public int getIProtocolType() {
        if (this.m_strProtocolType.equals(this.m_oResManager.getResString("MML_PROTOCOL"))) {
            return 2;
        }
        return 4;
    }

    @Override
    public void setDevAddress(String strDevAddress) {
        super.setDevAddress(strDevAddress);
        this.m_currentMap.put("getDevAddress", strDevAddress);
    }

    @Override
    public String getDevAddress() {
        return (String)this.m_currentMap.get("getDevAddress");
    }

    @Override
    public void setDevName(String strDevName) {
        super.setDevName(strDevName);
        this.m_currentMap.put("getDevName", strDevName);
    }

    @Override
    public String getDevName() {
        return (String)this.m_currentMap.get("getDevName");
    }

    public void setDevExtID(String strDevExtID) {
        this.m_currentMap.put("getDevExtID", strDevExtID);
        this.m_strDevExtID = strDevExtID;
    }

    public String getDevExtID() {
        return (String)this.m_currentMap.get("getDevExtID");
    }

    public int getIDevExtID() {
        return Integer.parseInt(this.m_strDevExtID);
    }

    public void setNEID(String strDevPhyID) {
        this.m_currentMap.put("getNEID", strDevPhyID);
        this.m_strDevPhyID = strDevPhyID;
    }

    public String getNEID() {
        return (String)this.m_currentMap.get("getNEID");
    }

    public int getINEID() {
        return Integer.parseInt(this.m_strDevPhyID);
    }

    public int getDevPhyID() {
        String strNEID = this.m_strDevExtID + "-" + this.m_strDevPhyID;
        return this.parseNEIDStr(strNEID);
    }

    public void setGatewayType(String strGatewayType) {
        if (null != this.m_strGatewayType && this.m_strGatewayType.equals(strGatewayType)) {
            return;
        }
        String OSI = this.m_oResManager.getResString("OS_GATEWAY_TYPE");
        String IP = this.m_oResManager.getResString("IP_GATEWAY_TYPE");
        String protocolType = this.getProtocolType();
        if (OSI.equals(strGatewayType)) {
            if (protocolType.equals(this.m_oResManager.getResString("MML_PROTOCOL"))) {
                this.setPort(String.valueOf(8888));
            } else if (protocolType.equals(this.m_oResManager.getResString("TLL_PROTOCOL"))) {
                this.setPort("");
            } else {
                this.setPort("");
            }
        } else if (IP.equals(strGatewayType)) {
            if (protocolType.equals(this.m_oResManager.getResString("MML_PROTOCOL"))) {
                this.setPort(String.valueOf(1400));
            } else if (protocolType.equals(this.m_oResManager.getResString("TLL_PROTOCOL"))) {
                this.setPort(String.valueOf(23));
            } else {
                this.setPort("");
            }
        } else {
            DCDebugTracer.trace("other GatewayType:" + strGatewayType);
            this.setPort("");
        }
        this.m_currentMap.put("getGatewayType", strGatewayType);
        this.m_strGatewayType = strGatewayType;
    }

    public String getGatewayType() {
        return (String)this.m_currentMap.get("getGatewayType");
    }

    public int getIGatewayType() {
        if (this.m_strGatewayType.equals(this.m_oResManager.getResString("IP_GATEWAY_TYPE"))) {
            return 1;
        }
        return 2;
    }

    public void setPort(String strPort) {
        this.m_currentMap.put("getPort", strPort);
        this.m_strPort = strPort;
    }

    public String getPort() {
        return (String)this.m_currentMap.get("getPort");
    }

    public int getIPort() {
        return Integer.parseInt(this.m_strPort);
    }

    public void setUserName(String strUserName) {
        this.m_currentMap.put("getUserName", strUserName);
        this.m_strUserName = strUserName;
    }

    public String getUserName() {
        return (String)this.m_currentMap.get("getUserName");
    }

    public void setPassword(char[] strPassword) {
        this.m_currentMap.put("getPassword", String.valueOf(strPassword));
        this.m_strPass = strPassword;
    }

    public char[] getPassword() {
        return ((String)this.m_currentMap.get("getPassword")).toCharArray();
    }

    private int parseNEIDStr(String str) {
        int index2;
        String s = str.trim();
        if (s.length() < 1) {
            return -1;
        }
        int index = s.indexOf(45);
        if (index != (index2 = s.lastIndexOf(45))) {
            return -1;
        }
        int subnet = 9;
        int ne = -1;
        int id = -1;
        try {
            String ls;
            String fs;
            if (index > -1) {
                fs = s.substring(0, index);
                ls = s.substring(index + 1);
                if (fs.length() > 9 || ls.length() > 9) {
                    return -1;
                }
            } else {
                if (s.length() > 9) {
                    return -1;
                }
                ne = Integer.parseInt(s);
                if (ne < 1) {
                    return -1;
                }
                return ne;
            }
            subnet = Integer.parseInt(fs);
            ne = Integer.parseInt(ls);
            if (ne < 1) {
                return -1;
            }
            id = (subnet << 16) + ne;
        }
        catch (Exception e) {
            return -1;
        }
        return id;
    }

    public void setDevType(int strDevType) {
        this.m_currentMap.put("getDevType", String.valueOf(strDevType));
    }

    public String getDevType() {
        return (String)this.m_currentMap.get("getDevType");
    }

    public void setDevVersion(String strVersion) {
        this.m_currentMap.put("setDevVersion", strVersion);
    }

    public String getDevVersion() {
        return (String)this.m_currentMap.get("setDevVersion");
    }

    public void setIsGateWay(String isGateWay) {
        this.m_currentMap.put("setIsGateWay", isGateWay);
    }

    public String getIsGateWay() {
        return (String)this.m_currentMap.get("setIsGateWay");
    }

    public void setDevTypeVersion(String strDevTypeVersion) {
        this.m_currentMap.put("setDevTypeVersion", strDevTypeVersion);
    }

    public String getDevTypeVersion() {
        return (String)this.m_currentMap.get("setDevTypeVersion");
    }

    public void setAdvancedSeting(AddDeviceAdvanceObj advanceParaInfo) {
        this.m_currentMap.put("getAdvancedSeting", advanceParaInfo);
    }

    public AddDeviceAdvanceObj getAdvancedSeting() {
        return (AddDeviceAdvanceObj)this.m_currentMap.get("getAdvancedSeting");
    }

    @Override
    public String[] getSortMethods() {
        return m_optixDevTableInfo.getSortMethods();
    }
}

