/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.model;

import com.huawei.dc.common.components.table.model.ITableInfo;
import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.DCDefaultSortTableComparator;
import com.huawei.dc.standalone.model.OptixDevInfoObj;
import javax.swing.tree.DefaultMutableTreeNode;

public class DCSortTreeTableModel
extends AbstractSortTreeTableModel {
    protected ResourceManager m_oResManager = ResourceManager.getInstance();
    private String[] m_columnNames;
    boolean[] m_isSortable;

    public DCSortTreeTableModel(ITableInfo oTableInfo) {
        super(oTableInfo);
        this.m_columnNames = oTableInfo.getHeader();
        this.m_isSortable = oTableInfo.isSortable();
        DCDefaultSortTableComparator dcSortTableComparator = new DCDefaultSortTableComparator(oTableInfo.getSortMethods());
        this.setComparator(dcSortTableComparator);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        if (node instanceof DefaultMutableTreeNode) {
            OptixDevInfoObj optixDevInfoObj;
            AbstractDevInfoObj devInfoObj = (AbstractDevInfoObj)((DefaultMutableTreeNode)node).getUserObject();
            if (0 == devInfoObj.getErrorCode() || -2147483647 == devInfoObj.getErrorCode()) {
                return false;
            }
            if (devInfoObj instanceof OptixDevInfoObj && (this.m_columnNames[column].equals(this.m_oResManager.getResString("DEVICE_EXTEND_ID_HEADER")) || this.m_columnNames[column].equals(this.m_oResManager.getResString("DEVICE_ID_HEADER"))) && 4 == (optixDevInfoObj = (OptixDevInfoObj)devInfoObj).getIProtocolType()) {
                return false;
            }
        }
        if (this.m_columnNames[column].equals(this.m_oResManager.getResString("OPERATION_RESULT_HEADER")) || this.m_columnNames[column].equals(this.m_oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_VERSION"))) {
            return false;
        }
        return super.isCellEditable(node, column);
    }

    public boolean isSortable(int col) {
        if (null == this.m_isSortable) {
            return false;
        }
        if (this.m_isSortable.length > col) {
            return this.m_isSortable[col];
        }
        return false;
    }

    @Override
    public boolean isColumnSortable(int iColumn) {
        return this.isSortable(iColumn);
    }
}

