/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.model;

import com.huawei.dc.common.components.table.model.ITableInfo;
import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.standalone.model.DCDefaultSortTableComparator;
import com.huawei.dc.standalone.model.RouterDevInfoObj;

public class DCRouterDevTreeTableModel
extends AbstractSortTreeTableModel {
    protected ResourceManager m_oResManager = ResourceManager.getInstance();
    private String[] m_columnNames;
    boolean[] m_isSortable;

    public DCRouterDevTreeTableModel(ITableInfo oTableInfo) {
        super(oTableInfo);
        this.m_columnNames = oTableInfo.getHeader();
        this.m_isSortable = oTableInfo.isSortable();
        DCDefaultSortTableComparator dcSortTableComparator = new DCDefaultSortTableComparator(oTableInfo.getSortMethods());
        this.setComparator(dcSortTableComparator);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        Object userObj;
        if (this.m_columnNames[column].equals(this.m_oResManager.getResString("DEVICE_TABLE_HEADER_OPERATION_STATUS")) || this.m_columnNames[column].equals(this.m_oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_VERSION")) || this.m_columnNames[column].equals(this.m_oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_PATCH_VERSION"))) {
            return false;
        }
        if (node instanceof TreeTableNode && (userObj = ((TreeTableNode)node).getUserObject()) instanceof RouterDevInfoObj) {
            RouterDevInfoObj devInfoObj = (RouterDevInfoObj)userObj;
            if (devInfoObj.getOperationStatus().getIsProgress()) {
                return false;
            }
            if (devInfoObj.getIsAgent() && this.m_columnNames[column].equals(this.m_oResManager.getResString("ADD_DEVICE_VPN_NAME_HEADER"))) {
                return false;
            }
        }
        return super.isCellEditable(node, column);
    }

    public boolean isSortable(int col) {
        if (null == this.m_isSortable) {
            return false;
        }
        if (this.m_isSortable.length > col) {
            return this.m_isSortable[col];
        }
        return false;
    }
}

