/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.model;

import com.huawei.dc.common.components.treetable.ITreeTableNodeInfo;
import com.huawei.dc.common.components.treetable.model.ISortTableComparator;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.util.DCDebugTracer;
import java.lang.reflect.Method;

public class DCDefaultSortTableComparator
implements ISortTableComparator {
    private int m_sortColumn = 0;
    private int m_iDirection = 0;
    private String[] m_oSortMethods;

    public DCDefaultSortTableComparator(String[] oSortMethods) {
        this.m_oSortMethods = oSortMethods;
    }

    @Override
    public int compare(TreeTableNode one, TreeTableNode two) {
        if (null == this.m_oSortMethods || this.m_sortColumn >= this.m_oSortMethods.length) {
            return 0;
        }
        TreeTableNode nodeOne = one;
        TreeTableNode nodeTwo = two;
        ITreeTableNodeInfo first = (ITreeTableNodeInfo)nodeOne.getUserObject();
        ITreeTableNodeInfo second = (ITreeTableNodeInfo)nodeTwo.getUserObject();
        try {
            Method firstMethod = first.getClass().getMethod(this.m_oSortMethods[this.m_sortColumn], null);
            Method secondMethod = second.getClass().getMethod(this.m_oSortMethods[this.m_sortColumn], null);
            if (firstMethod != null && secondMethod != null) {
                Comparable firstValue = (Comparable)firstMethod.invoke((Object)first, null);
                Comparable secondValue = (Comparable)secondMethod.invoke((Object)second, null);
                return this.m_iDirection * firstValue.compareTo(secondValue);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        return 0;
    }

    @Override
    public void setDirection(int direction) {
        this.m_iDirection = direction;
    }

    @Override
    public void setSortColumn(int column) {
        this.m_sortColumn = column;
    }
}

