/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.controller;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnAddDevReq;
import com.huawei.dc.common.asndatacenter.AsnChangeGatewayIPReq;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncCancelReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnDCT2000DeviceRsp;
import com.huawei.dc.common.asndatacenter.AsnDelSNMPReqList;
import com.huawei.dc.common.asndatacenter.AsnDelSNMPRsp;
import com.huawei.dc.common.asndatacenter.AsnDevAddReq;
import com.huawei.dc.common.asndatacenter.AsnDevDelReq;
import com.huawei.dc.common.asndatacenter.AsnDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDevInfoList;
import com.huawei.dc.common.asndatacenter.AsnDeviceInfoReq;
import com.huawei.dc.common.asndatacenter.AsnGatewayDevInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnGatewayInfo;
import com.huawei.dc.common.asndatacenter.AsnGatewayTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnGetDevSnmpParaRsp;
import com.huawei.dc.common.asndatacenter.AsnGetRouterExtInfoReq;
import com.huawei.dc.common.asndatacenter.AsnGetRouterExtInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnProtocolTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnRoleTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnSNMPEnum;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaDevInfoListRsp;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaInfo;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaSetReq;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaValue;
import com.huawei.dc.common.asndatacenter.AsnSearchNGDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnSnmpGetParaInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnT2000DevInfo;
import com.huawei.dc.common.asndatacenter.AsnT2000DevInfoLst;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.controller.IDCStandAloneAsyncCtrller;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneAsyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneCommUtil;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.snmpparams.model.SNMPParaResultInfo;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.commustru.fstru.FStruct;

public class StandAloneSyncCtrller
implements IDCStandAloneSyncCtrller,
IDCObjectDeallocator {
    private static IDCStandAloneSyncCtrller m_oSyncCtrllerInstance;
    public static final int SWITCH1 = 1;
    public static final int ROUTER = 2;
    public static final int BMS = 3;
    public static final int T2000 = 4;
    protected static final FStruct AsnAddDevReq;
    private static boolean bNotifyAlerady;
    private BaseCommManager m_oCommManager;
    private ErrorCodeReader m_oErrorCodeReader;
    private ResourceManager m_oResourceManager;
    private IDCStandAloneAsyncCtrller m_oAsyncController;
    private boolean m_bIsLocked = false;
    protected byte[] m_oGetT2kDevSyncObj = new byte[0];
    private AsnDCSyncCancelReq asnCancelOpReq = new AsnDCSyncCancelReq();

    private StandAloneSyncCtrller() {
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
        this.m_oErrorCodeReader = ErrorCodeReader.getInstance();
        this.m_oResourceManager = ResourceManager.getInstance();
        this.m_oAsyncController = StandAloneAsyncCtrller.getInstance();
        this.m_oCommManager.addMessageListener(43933, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
    }

    public static synchronized IDCStandAloneSyncCtrller getInstance() {
        bNotifyAlerady = false;
        if (null == m_oSyncCtrllerInstance) {
            m_oSyncCtrllerInstance = new StandAloneSyncCtrller();
            DCObjectDestructor.getInstance().addObjectForDestructor((StandAloneSyncCtrller)m_oSyncCtrllerInstance);
        }
        return m_oSyncCtrllerInstance;
    }

    @Override
    public void setToNULL() {
        m_oSyncCtrllerInstance = null;
        this.m_oCommManager = null;
    }

    @Override
    public List<SnmpParaInfo> getSnmpParaInfo() throws DCException {
        AsnSnmpGetParaInfoRsp oAsnSnmpGetParaInfo = new AsnSnmpGetParaInfoRsp();
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43934, null, (FStruct)oAsnSnmpGetParaInfo);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnSnmpGetParaInfo.oErrorNo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        List<SnmpParaInfo> oSnmpParaInfoLst = StandAloneCommUtil.getSnmpParaFrmAsn(oAsnSnmpGetParaInfo.oAsnSNMPParaInfoList);
        return oSnmpParaInfoLst;
    }

    @Override
    public List<SnmpParaInfo> getParaForDevAccess() throws DCException {
        AsnGetDevSnmpParaRsp oAsnSnmpGetParaInfo = new AsnGetDevSnmpParaRsp();
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(44013, null, (FStruct)oAsnSnmpGetParaInfo);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnSnmpGetParaInfo.oErrorNo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        List<SnmpParaInfo> oSnmpParaInfoLst = StandAloneCommUtil.getDevSnmpParaFrmAsn(oAsnSnmpGetParaInfo.oAsnDevSNMPParaList);
        return oSnmpParaInfoLst;
    }

    @Override
    public List<SnmpParaInfo> getParaForDevAccess(boolean isAccessPanel) throws DCException {
        AsnGetDevSnmpParaRsp oAsnSnmpGetParaInfo = new AsnGetDevSnmpParaRsp();
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(44013, null, (FStruct)oAsnSnmpGetParaInfo);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnSnmpGetParaInfo.oErrorNo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        List<SnmpParaInfo> oSnmpParaInfoLst = StandAloneCommUtil.getDevSnmpParaFrmAsn(oAsnSnmpGetParaInfo.oAsnDevSNMPParaList, isAccessPanel);
        return oSnmpParaInfoLst;
    }

    @Override
    public void setSnmpParaInfo(SnmpParaInfo oSnmpParaInfo) throws DCException {
        AsnSNMPParaInfo oAsnSNMPParaInfo;
        AsnDCOpertionRsp oAsnDcOperationRsp = new AsnDCOpertionRsp();
        AsnSNMPParaSetReq oAsnSnmpParaSetReq = new AsnSNMPParaSetReq();
        oAsnSnmpParaSetReq.oAsnSNMPParaInfo = oAsnSNMPParaInfo = StandAloneCommUtil.getAsnSnmpParaInfo(oSnmpParaInfo);
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43931, (FStruct)oAsnSnmpParaSetReq, (FStruct)oAsnDcOperationRsp);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDcOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public List<SNMPParaResultInfo> deleteSnmpParaInfos(List<SnmpParaInfo> oParaList) throws DCException {
        if (null == oParaList || 0 == oParaList.size()) {
            return new ArrayList<SNMPParaResultInfo>(0);
        }
        AsnDelSNMPReqList oAsnDelSNMPReqList = new AsnDelSNMPReqList();
        AsnDelSNMPRsp oAsnDelSNMPRsp = new AsnDelSNMPRsp();
        int iParaCount = oParaList.size();
        AsnSNMPParaValue oAsnSNMPParaValue = null;
        SnmpParaInfo oParaInfo = null;
        for (int i = 0; i < iParaCount; ++i) {
            oParaInfo = oParaList.get(i);
            oAsnSNMPParaValue = new AsnSNMPParaValue();
            oAsnSNMPParaValue.strTemplate = oParaInfo.getTemplate().getBytes();
            oAsnSNMPParaValue.enVersion = new AsnSNMPEnum(oParaInfo.getSnmpEnum());
            oAsnDelSNMPReqList.add((Object)oAsnSNMPParaValue);
        }
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43932, (FStruct)oAsnDelSNMPReqList, (FStruct)oAsnDelSNMPRsp);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDelSNMPRsp.oErrorNo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        List<SNMPParaResultInfo> oResultInfo = StandAloneCommUtil.getResultInfoFromDeleteSNMPParaResponse(oAsnDelSNMPRsp.oAsnDelSNMPReqList);
        return oResultInfo;
    }

    @Override
    public void addDevice(int iReqId, List<AbstractDevInfoObj> oDevInfoObjLst, int iDomain, boolean isAddOffLineDevices) throws DCException {
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        AsnAddDevReq oAsnAddDevReq = new AsnAddDevReq();
        oAsnAddDevReq.oReqID = BigInteger.valueOf(iReqId);
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnAddDevReq.oAsnDomainPEnum.value = iDomain;
        oAsnAddDevReq.isOffLineAdd = isAddOffLineDevices;
        AsnDevAddReq oAsnDevAddReq = null;
        int iLenght = oDevInfoObjLst.size();
        for (int i = 0; i < iLenght; ++i) {
            AbstractDevInfoObj devInfoObj = oDevInfoObjLst.get(i);
            oAsnDevAddReq = new AsnDevAddReq();
            if (devInfoObj instanceof RouterDevInfoObj) {
                oAsnDevAddReq.oAsnRouterExtInfo = StandAloneCommUtil.getAsnRouterDevExtInfo((RouterDevInfoObj)devInfoObj);
            }
            oAsnDevAddReq.oAsnDevInfoList.add((Object)StandAloneCommUtil.getAsnDevInfo(devInfoObj));
            oAsnAddDevReq.oAsnDevAddReqList.add((Object)oAsnDevAddReq);
        }
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43933, (FStruct)oAsnAddDevReq, (FStruct)oAsnRsp);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public void addDevice(int iReqId, List oResourceLst, int iDomain) throws DCException {
        this.addDevice(iReqId, oResourceLst, iDomain, false);
    }

    @Override
    public void addDevice(int iReqId, int iDeviceTypeId, int iDeviceTypeVerId, List<Resource> oResourceLst, SnmpParaInfo oSnmpParaInfo, int DevDomain) throws DCException {
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        AsnAddDevReq oAsnAddDevReq = new AsnAddDevReq();
        oAsnAddDevReq.oReqID = BigInteger.valueOf(iReqId);
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnAddDevReq.oAsnDomainPEnum.value = this.getDevTypeDomain(DevDomain);
        AsnDevAddReq oAsnDevAddReq = new AsnDevAddReq();
        DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDeviceTypeId, iDeviceTypeVerId);
        if (4 != oDevTypeInfo.getDeviceType()) {
            oAsnDevAddReq.oAsnSNMPParaInfo = StandAloneCommUtil.getAsnSnmpParaInfo(oSnmpParaInfo);
        }
        oAsnDevAddReq.oAsnDevInfoList = StandAloneCommUtil.getAsnDevInfoLst(oResourceLst, iDeviceTypeId, iDeviceTypeVerId, false);
        oAsnAddDevReq.oAsnDevAddReqList.add((Object)oAsnDevAddReq);
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43933, (FStruct)oAsnAddDevReq, (FStruct)oAsnRsp);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public void changeDevicesIP(List<BigInteger> DevIDList, AsnGatewayInfo garewayInfo) throws DCException {
        AsnDCOpertionRsp oAsnDcOperationRsp = new AsnDCOpertionRsp();
        AsnChangeGatewayIPReq oAsnChangeGatewayIP = new AsnChangeGatewayIPReq();
        for (BigInteger devID : DevIDList) {
            oAsnChangeGatewayIP.iDeviceIdLst.add((Object)devID);
        }
        oAsnChangeGatewayIP.oAsnGatewayInfo = garewayInfo;
        this.m_oCommManager.addMessageListener(44008, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(44008, (FStruct)oAsnChangeGatewayIP, (FStruct)oAsnDcOperationRsp);
        int iReqId = 0;
        if (oAsnDcOperationRsp.oReqID != null) {
            iReqId = oAsnDcOperationRsp.oReqID.intValue();
        }
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(44008, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDcOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            this.m_oCommManager.removeMessageListener(44008, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    public void deleteDevices(int iReqId, List oResourceList, boolean isDeleteSNMP) throws DCException {
        AsnDevDelReq oAsnDevDelReq = new AsnDevDelReq();
        AsnDCSyncCancelReq asnCancelOpReq = new AsnDCSyncCancelReq();
        oAsnDevDelReq.oReqID = BigInteger.valueOf(iReqId);
        asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        oAsnDevDelReq.oAsnDevInfoList = StandAloneCommUtil.getAsnDevInfoLst(oResourceList, 0, 0, isDeleteSNMP);
        this.m_oCommManager.addMessageListener(43935, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43935, (FStruct)oAsnDevDelReq, (FStruct)oAsnRsp);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43935, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43935, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
    }

    @Override
    public void deleteDevices(int iReqId, List<AbstractDevInfoObj> oDevInfoObjLst, int iDomain) throws DCException {
        AsnDevDelReq oAsnDevDelReq = new AsnDevDelReq();
        AsnDCSyncCancelReq asnCancelOpReq = new AsnDCSyncCancelReq();
        oAsnDevDelReq.oReqID = BigInteger.valueOf(iReqId);
        asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        int iLenght = oDevInfoObjLst.size();
        DCDebugTracer.trace("======start to delete devices======");
        for (int i = 0; i < iLenght; ++i) {
            AbstractDevInfoObj devInfoObj = oDevInfoObjLst.get(i);
            DCDebugTracer.trace("DC::StandAloneSyncCtrller.deleteDevices(devId = " + devInfoObj.getDevID() + ", devName = " + devInfoObj.getDevName() + ", devIP = " + devInfoObj.getDevAddress() + ")");
            oAsnDevDelReq.oAsnDevInfoList.add((Object)StandAloneCommUtil.getAsnDevInfo(devInfoObj));
        }
        DCDebugTracer.trace("======end to delete devices======");
        this.m_oCommManager.addMessageListener(43935, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43935, (FStruct)oAsnDevDelReq, (FStruct)oAsnRsp);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43935, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43935, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
    }

    @Override
    public int stopOperationForSNMP(int cmdCode) throws DCException {
        AsnDCOpertionRsp oAsnDcOperationRsp = new AsnDCOpertionRsp();
        this.m_oCommManager.addMessageListener(cmdCode, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(cmdCode, (FStruct)this.asnCancelOpReq, (FStruct)oAsnDcOperationRsp);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(cmdCode, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDcOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            DCDebugTracer.trace(" oAsnDcOperationRsp.oErrorInfo.iErrorCode :" + iErrorCode);
            return iErrorCode;
        }
        return iErrorCode;
    }

    @Override
    public int stopImportDevices() throws DCException {
        if (null == this.asnCancelOpReq.oReqID) {
            DCDebugTracer.trace(" stopImportDevices#asnCancelOpReq is null");
            return 0;
        }
        AsnDCOpertionRsp oAsnDcOperationRsp = new AsnDCOpertionRsp();
        this.m_oCommManager.addMessageListener(44007, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(44007, (FStruct)this.asnCancelOpReq, (FStruct)oAsnDcOperationRsp);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(44007, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDcOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            DCDebugTracer.trace(" oAsnDcOperationRsp.oErrorInfo.iErrorCode :" + iErrorCode);
            return iErrorCode;
        }
        return iErrorCode;
    }

    @Override
    public synchronized void modifyT2000Device(List oT2000DeviceList, List<Integer> iDeviceIdLst, List<Integer> iDeviceTypeIdLst, List<Integer> iDeviceVerIdLst) throws DCException {
        if (null == oT2000DeviceList) {
            return;
        }
        final AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        AsnDevInfoList oAsnDevInfoList = this.getAsnDevInfoLstToModify(oT2000DeviceList, iDeviceIdLst, iDeviceTypeIdLst, iDeviceVerIdLst);
        final AsnDevAddReq oAsnDevAddReq = new AsnDevAddReq();
        oAsnDevAddReq.oAsnDevInfoList = oAsnDevInfoList;
        this.m_oCommManager.addMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = StandAloneSyncCtrller.this.m_oCommManager;
                StandAloneSyncCtrller.this.m_oCommManager;
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43936), (FStruct)oAsnDevAddReq, (FStruct)oAsnDCOperationRsp);
                return iErrorCode;
            }
        };
        int iErrorCode = 0;
        this.setLocked(true);
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        this.setLocked(false);
        int iReqId = 0;
        if (oAsnDCOperationRsp.oReqID != null) {
            iReqId = oAsnDCOperationRsp.oReqID.intValue();
        }
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            this.m_oCommManager.removeMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public void modifyRouterDevice(AsnDevAddReq oAsnDevAddReq) throws DCException {
        AsnDCOpertionRsp oAsnDcOperationRsp = new AsnDCOpertionRsp();
        this.m_oCommManager.addMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43936, (FStruct)oAsnDevAddReq, (FStruct)oAsnDcOperationRsp);
        int iReqId = 0;
        if (oAsnDcOperationRsp.oReqID != null) {
            iReqId = oAsnDcOperationRsp.oReqID.intValue();
        }
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDcOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
    }

    @Override
    public void modifyDevice(List<Resource> oResourceLst, SnmpParaInfo oSnmpParaInfo) throws DCException {
        if (null == oResourceLst) {
            return;
        }
        AsnDevAddReq oAsnDevAddReq = new AsnDevAddReq();
        oAsnDevAddReq.oAsnDevInfoList = StandAloneCommUtil.getAsnDevInfoLst(oResourceLst, 0, 0, false);
        if (null == oSnmpParaInfo) {
            oAsnDevAddReq.oAsnRouterExtInfo = StandAloneCommUtil.getAsnRouterDevExtInfo(oResourceLst.get(0));
        } else {
            oAsnDevAddReq.oAsnSNMPParaInfo = StandAloneCommUtil.getAsnSnmpParaInfo(oSnmpParaInfo);
        }
        AsnDCOpertionRsp oAsnDcOperationRsp = new AsnDCOpertionRsp();
        this.m_oCommManager.addMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43936, (FStruct)oAsnDevAddReq, (FStruct)oAsnDcOperationRsp);
        int iReqId = 0;
        if (oAsnDcOperationRsp.oReqID != null) {
            iReqId = oAsnDcOperationRsp.oReqID.intValue();
        }
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDcOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43936, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
    }

    @Override
    public SnmpParaInfo getSNMPParaForResource(Resource oResource) throws DCException {
        if (null == oResource) {
            return null;
        }
        int devId = oResource.getDeviceID();
        int[] devIds = new int[]{devId};
        HashMap<Integer, SnmpParaInfo> map = this.getSNMPParaMap(devIds);
        return map.get(devId);
    }

    @Override
    public List<RouterDevInfoObj> getRouterDevExtInfo(List<Integer> devIdLst) throws DCException {
        ArrayList<RouterDevInfoObj> routerDevInfoLst = new ArrayList<RouterDevInfoObj>();
        if (null == devIdLst) {
            return routerDevInfoLst;
        }
        AsnGetRouterExtInfoReq oAsnRouterDevExtInfoReq = new AsnGetRouterExtInfoReq();
        AsnGetRouterExtInfoRsp oAsnRouterDevExtInfoRsp = new AsnGetRouterExtInfoRsp();
        int iDevCount = devIdLst.size();
        for (int i = 0; i < iDevCount; ++i) {
            oAsnRouterDevExtInfoReq.oAsnDevIDLst.add((Object)BigInteger.valueOf(devIdLst.get(i).intValue()));
        }
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(44029, (FStruct)oAsnRouterDevExtInfoReq, (FStruct)oAsnRouterDevExtInfoRsp);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        iErrorCode = oAsnRouterDevExtInfoRsp.oErrorNo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        return StandAloneCommUtil.getRouterDevInfoLst(oAsnRouterDevExtInfoRsp.oAsnRouterExtInfoLst);
    }

    @Override
    public void addDevice(int iReqId, int iDeviceTypeId, int iDeviceTypeVerId, List<T2000DevInfo> oDevInfoLst) throws DCException {
        if (null == oDevInfoLst || 0 == oDevInfoLst.size()) {
            return;
        }
        final AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        AsnDevInfoList oAsnDevInfoList = this.getAsnDevInfoLst(oDevInfoLst, iDeviceTypeId, iDeviceTypeVerId);
        final AsnAddDevReq oAsnAddDevReq = new AsnAddDevReq();
        oAsnAddDevReq.oReqID = BigInteger.valueOf(iReqId);
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnAddDevReq.oAsnDomainPEnum.value = 4;
        AsnDevAddReq oAsnDevAddReq = new AsnDevAddReq();
        oAsnDevAddReq.oAsnDevInfoList = oAsnDevInfoList;
        oAsnAddDevReq.oAsnDevAddReqList.add((Object)oAsnDevAddReq);
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = StandAloneSyncCtrller.this.m_oCommManager;
                StandAloneSyncCtrller.this.m_oCommManager;
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43933), (FStruct)oAsnAddDevReq, (FStruct)oAsnRsp);
                return iErrorCode;
            }
        };
        int iErrorCode = 0;
        this.setLocked(true);
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        this.setLocked(false);
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T2000DevInfo> getT2000Devices(List<Integer> iDevIDLst, int cmdCode, boolean bNeedToGetUserNameAndPwd) throws DCException {
        bNotifyAlerady = false;
        ArrayList<T2000DevInfo> oT2000DevInfoLst = new ArrayList();
        AsnDeviceInfoReq oAsnDeviceInfoReq = new AsnDeviceInfoReq();
        oAsnDeviceInfoReq._bNeedToGetUserNameAndPwd = true;
        oAsnDeviceInfoReq.bNeedToGetUserNameAndPwd = bNeedToGetUserNameAndPwd;
        for (Integer iDevID : iDevIDLst) {
            oAsnDeviceInfoReq.oDevIdLst.add((Object)new BigInteger("" + iDevID));
        }
        AsnDCT2000DeviceRsp asnDCT2000DeviceRsp = new AsnDCT2000DeviceRsp();
        DeviceInfoManagerImpl.getInstance().clearT2kDevLst();
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(cmdCode, (FStruct)oAsnDeviceInfoReq, (FStruct)asnDCT2000DeviceRsp);
        if (iErrorCode != 0) {
            DCDebugTracer.trace("StandAloneSyncCtrller#getT2000Devices:iErrorCode" + iErrorCode);
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = asnDCT2000DeviceRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            DCDebugTracer.trace("StandAloneSyncCtrller#getT2000Devices:asnDCT2000DeviceRsp.oErrorInfo.iErrorNo" + iErrorCode);
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        try {
            byte[] byArray = this.m_oGetT2kDevSyncObj;
            synchronized (this.m_oGetT2kDevSyncObj) {
                if (!bNotifyAlerady) {
                    this.m_oGetT2kDevSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                }
                // ** MonitorExit[var8_9] (shouldn't be in output)
            }
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        {
            oT2000DevInfoLst = DeviceInfoManagerImpl.getInstance().getT2kDevLst();
            return oT2000DevInfoLst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodifyGetT2kDevObj() {
        try {
            byte[] byArray = this.m_oGetT2kDevSyncObj;
            synchronized (this.m_oGetT2kDevSyncObj) {
                bNotifyAlerady = true;
                this.m_oGetT2kDevSyncObj.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        {
            return;
        }
    }

    @Override
    public T2000DevInfo getT2000DeviceInfo(int iDevId) throws DCException {
        ArrayList<Integer> oDevIDLst = new ArrayList<Integer>();
        oDevIDLst.add(iDevId);
        List<T2000DevInfo> oT2000DevInfoLst = this.getT2000Devices(oDevIDLst, 43952, true);
        if (null == oT2000DevInfoLst || oT2000DevInfoLst.size() < 1) {
            DCDebugTracer.trace("getT2000DeviceInfo#iDevID " + iDevId);
            return null;
        }
        return oT2000DevInfoLst.get(0);
    }

    @Override
    public List<T2000DevInfo> getT2000DevInfoLst(List<Integer> oDevIDLst, boolean bNeedToGetUserNameAndPwd) throws DCException {
        List<T2000DevInfo> oT2000DevInfoLst = this.getT2000Devices(oDevIDLst, 43952, bNeedToGetUserNameAndPwd);
        return oT2000DevInfoLst;
    }

    public AsnDevInfoList getAsnDevInfoLst(List oT2000DevInfoList, int iDeviceTypeId, int iDeviceTypeVerId) {
        int iSize = oT2000DevInfoList.size();
        AsnDevInfoList oAsnDevInfoList = new AsnDevInfoList();
        AsnT2000DevInfo oAsnT2000DevInfo = null;
        boolean bUseType = true;
        if (-1 == iDeviceTypeId && -1 == iDeviceTypeVerId) {
            bUseType = false;
        }
        for (int index = 0; index < iSize; ++index) {
            AsnDevInfo oAsnDevInfo = new AsnDevInfo();
            if (!(oT2000DevInfoList.get(index) instanceof T2000DevInfo)) continue;
            T2000DevInfo oT2000DevInfo = (T2000DevInfo)oT2000DevInfoList.get(index);
            oAsnT2000DevInfo = new AsnT2000DevInfo();
            oAsnDevInfo.iKeyMode = BigInteger.valueOf(oT2000DevInfo.getKeyMode());
            oAsnDevInfo.iDevId = BigInteger.valueOf(oT2000DevInfo.getDeviceID());
            oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(oT2000DevInfo.getProtocolType());
            oAsnDevInfo.strDevIp = oT2000DevInfo.getGatewayAddress().getBytes();
            if (bUseType) {
                if (-1 == iDeviceTypeId && 0 == iDeviceTypeVerId) {
                    oAsnDevInfo.iDevTypeId = BigInteger.valueOf(oT2000DevInfo.getDeviceType());
                    oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(iDeviceTypeVerId);
                } else {
                    oAsnDevInfo.iDevTypeId = BigInteger.valueOf(iDeviceTypeId);
                    oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(iDeviceTypeVerId);
                }
            } else {
                oAsnDevInfo.iDevTypeId = BigInteger.valueOf(oT2000DevInfo.getDeviceType());
                oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(oT2000DevInfo.getDeviceTypeVersionId());
            }
            if (2 == oT2000DevInfo.getProtocolType()) {
                if (-1 != oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId()) {
                    oAsnT2000DevInfo.iNeID = BigInteger.valueOf(oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId());
                }
                if (!Collator.getInstance().equals(oT2000DevInfo.getDeviceName(), "")) {
                    oAsnT2000DevInfo.strNEName = oT2000DevInfo.getDeviceName().getBytes();
                    oAsnDevInfo.strDevName = oT2000DevInfo.getDeviceName().getBytes();
                } else {
                    oAsnDevInfo.strDevName = "".getBytes();
                }
            } else if (4 == oT2000DevInfo.getProtocolType()) {
                if (null != oT2000DevInfo.getTL1ProtocolDevPhyId()) {
                    oAsnT2000DevInfo.strNETid = oT2000DevInfo.getTL1ProtocolDevPhyId().getBytes();
                    oAsnT2000DevInfo.strNEName = oT2000DevInfo.getTL1ProtocolDevPhyId().getBytes();
                    oAsnDevInfo.strDevName = oT2000DevInfo.getTL1ProtocolDevPhyId().getBytes();
                } else {
                    oAsnDevInfo.strDevName = "".getBytes();
                }
            }
            oAsnT2000DevInfo.enGatewayType = new AsnGatewayTypeEnum(oT2000DevInfo.getGateWayType());
            oAsnT2000DevInfo.strGatewayIP = oT2000DevInfo.getGatewayAddress().getBytes();
            oAsnT2000DevInfo.iIPPort = BigInteger.valueOf(oT2000DevInfo.getPort());
            oAsnT2000DevInfo.strUserName = oT2000DevInfo.getUserName().getBytes();
            oAsnT2000DevInfo.strPassword = String.valueOf(oT2000DevInfo.getPass()).getBytes();
            oAsnT2000DevInfo.strSFTPPassPhrase = oT2000DevInfo.getSFTPPassPhrase() != null ? String.valueOf(oT2000DevInfo.getSFTPPassPhrase()).getBytes() : "".getBytes();
            oAsnT2000DevInfo.bUseSSH = oT2000DevInfo.isUseSSH();
            oAsnT2000DevInfo._bUseSSH = oT2000DevInfo.isUseSSH();
            oAsnT2000DevInfo.iSSHLoginMode = BigInteger.valueOf(oT2000DevInfo.getSSHLoginMode());
            oAsnT2000DevInfo.strSSHPassPhrase = String.valueOf(oT2000DevInfo.getSSHPassPhrase()).getBytes();
            oAsnT2000DevInfo.strSSHLoginKey = String.valueOf(oT2000DevInfo.getSSHLoginKey()).getBytes();
            oAsnDevInfo.oAsnT2000DevInfo = oAsnT2000DevInfo;
            oAsnDevInfo.enRoleType = ResourceManager.getInstance().getResString("YES").equals(oT2000DevInfo.getIsGateway()) ? new AsnRoleTypeEnum(1) : (ResourceManager.getInstance().getResString("NO").equals(oT2000DevInfo.getIsGateway()) ? new AsnRoleTypeEnum(0) : null);
            oAsnDevInfo.strDevVersion = null != oT2000DevInfo.getDevVersion() ? oT2000DevInfo.getDevVersion().getBytes() : "".getBytes();
            oAsnDevInfoList.add((Object)oAsnDevInfo);
        }
        return oAsnDevInfoList;
    }

    public AsnDevInfoList getAsnDevInfoLstToModify(List oT2000DevInfoList, List<Integer> iDevIdLst, List<Integer> iDeviceTypeIdLst, List<Integer> iDeviceVerIdLst) {
        int iSize = oT2000DevInfoList.size();
        AsnDevInfoList oAsnDevInfoList = new AsnDevInfoList();
        AsnT2000DevInfo oAsnT2000DevInfo = null;
        for (int index = 0; index < iSize; ++index) {
            AsnDevInfo oAsnDevInfo = new AsnDevInfo();
            oAsnDevInfo.iDevTypeId = BigInteger.valueOf(iDeviceTypeIdLst.get(index).intValue());
            oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(iDeviceVerIdLst.get(index).intValue());
            oAsnDevInfo.iDevId = BigInteger.valueOf(iDevIdLst.get(index).intValue());
            if (!(oT2000DevInfoList.get(index) instanceof T2000DevInfo)) continue;
            T2000DevInfo oT2000DevInfo = (T2000DevInfo)oT2000DevInfoList.get(index);
            oAsnT2000DevInfo = new AsnT2000DevInfo();
            oAsnDevInfo.iKeyMode = BigInteger.valueOf(0L);
            oAsnDevInfo.strDevName = oT2000DevInfo.getDeviceName().getBytes();
            oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(oT2000DevInfo.getProtocolType());
            oAsnDevInfo.strDevIp = oT2000DevInfo.getGatewayAddress().getBytes();
            if (2 == oT2000DevInfo.getProtocolType()) {
                oAsnT2000DevInfo.iNeID = BigInteger.valueOf(oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId());
            } else if (4 == oT2000DevInfo.getProtocolType()) {
                oAsnT2000DevInfo.strNETid = oT2000DevInfo.getTL1ProtocolDevPhyId().getBytes();
            }
            oAsnT2000DevInfo.enGatewayType = new AsnGatewayTypeEnum(oT2000DevInfo.getGateWayType());
            oAsnT2000DevInfo.strGatewayIP = oT2000DevInfo.getGatewayAddress().getBytes();
            oAsnT2000DevInfo.iIPPort = BigInteger.valueOf(oT2000DevInfo.getPort());
            T2000DevInfo oT2000DevInfoforUserPwd = (T2000DevInfo)oT2000DevInfoList.get(iSize - 1);
            oAsnT2000DevInfo.strUserName = oT2000DevInfoforUserPwd.getUserName().getBytes();
            oAsnT2000DevInfo.strPassword = String.valueOf(oT2000DevInfoforUserPwd.getPass()).getBytes();
            oAsnT2000DevInfo.bUseSSH = oT2000DevInfo.isUseSSH();
            oAsnT2000DevInfo._bUseSSH = oT2000DevInfo.isUseSSH();
            oAsnT2000DevInfo.strSFTPPassPhrase = String.valueOf(oT2000DevInfo.getSFTPPassPhrase()).getBytes();
            oAsnT2000DevInfo.iSSHLoginMode = BigInteger.valueOf(oT2000DevInfo.getSSHLoginMode());
            oAsnT2000DevInfo.strSSHPassPhrase = String.valueOf(oT2000DevInfo.getSSHPassPhrase()).getBytes();
            oAsnT2000DevInfo.strSSHLoginKey = String.valueOf(oT2000DevInfo.getSSHLoginKey()).getBytes();
            oAsnDevInfo.oAsnT2000DevInfo = oAsnT2000DevInfo;
            oAsnDevInfoList.add((Object)oAsnDevInfo);
        }
        return oAsnDevInfoList;
    }

    @Override
    public void startSearchForGWDev(int iReqId) throws DCException {
        AsnDCReq oAsnReq = new AsnDCReq();
        oAsnReq.oReqID = BigInteger.valueOf(iReqId);
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        this.m_oCommManager.addMessageListener(43949, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43949, (FStruct)oAsnReq, (FStruct)oAsnRsp);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43949, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            this.m_oCommManager.removeMessageListener(43949, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public void cancelSearchOperation(int iRequestId, int iCmdCode) throws DCException {
        AsnDCSyncCancelReq oAsnCancelOpReq = new AsnDCSyncCancelReq();
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        oAsnCancelOpReq.oReqID = BigInteger.valueOf(iRequestId);
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(iCmdCode, (FStruct)oAsnCancelOpReq, (FStruct)oAsnRsp);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public void startSearchForNGWDevice(int iReqId, T2000DevInfo oDevInfo) throws DCException {
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        this.m_oCommManager.addMessageListener(43950, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        AsnSearchNGDeviceReq oAsnSearchNGDevReq = new AsnSearchNGDeviceReq();
        oAsnSearchNGDevReq.strGatewayIP = oDevInfo.getGatewayAddress().getBytes();
        oAsnSearchNGDevReq.iIPPort = BigInteger.valueOf(oDevInfo.getPort());
        oAsnSearchNGDevReq.strUserName = oDevInfo.getUserName().getBytes();
        oAsnSearchNGDevReq.strPassword = String.valueOf(oDevInfo.getPass()).getBytes();
        oAsnSearchNGDevReq.enGatewayType = new AsnGatewayTypeEnum(1);
        oAsnSearchNGDevReq.oReqID = BigInteger.valueOf(iReqId);
        this.asnCancelOpReq.oReqID = BigInteger.valueOf(iReqId);
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43950, (FStruct)oAsnSearchNGDevReq, (FStruct)oAsnRsp);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43950, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            this.m_oCommManager.removeMessageListener(43950, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public void getSoftwareStatisticsInfo(int iReqId, DeviceInfo[] arrDevInfo) throws DCException {
        int iSize = arrDevInfo.length;
        AsnDCSyncReq oAsnSwstatReq = new AsnDCSyncReq();
        AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        oAsnSwstatReq.oReqID = BigInteger.valueOf(iReqId);
        for (int index = 0; index < iSize; ++index) {
            oAsnSwstatReq.oDevIDLst.add((Object)BigInteger.valueOf(arrDevInfo[index].getDevId()));
        }
        this.m_oCommManager.addMessageListener(43956, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43956, (FStruct)oAsnSwstatReq, (FStruct)oRsp);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43956, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            this.m_oCommManager.removeMessageListener(43956, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public List<T2000DevInfo> getGateWayDeviceInfo() throws DCException {
        ArrayList<T2000DevInfo> oT2000DevInfoLst = new ArrayList<T2000DevInfo>(4);
        AsnGatewayDevInfoRsp oAsnGatewayDevInfoRsp = new AsnGatewayDevInfoRsp();
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43963, null, (FStruct)oAsnGatewayDevInfoRsp);
        if (iErrorCode != 0) {
            this.m_oCommManager.removeMessageListener(43956, (MSGListener)((StandAloneAsyncCtrller)this.m_oAsyncController));
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnGatewayDevInfoRsp.oErrorNo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, this.m_oErrorCodeReader.getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        AsnT2000DevInfoLst oAsnT2000DevInfoLst = oAsnGatewayDevInfoRsp.oGatewayDevInfoLst;
        int iSizeOfLst = oAsnT2000DevInfoLst.size();
        T2000DevInfo oT200DevInfo = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oT200DevInfo = new T2000DevInfo();
            AsnT2000DevInfo oAsnT2000DevInfo = (AsnT2000DevInfo)oAsnT2000DevInfoLst.get(i);
            oT200DevInfo.setGatewayAddress(new String(oAsnT2000DevInfo.strGatewayIP));
            oT200DevInfo.setUserName(new String(oAsnT2000DevInfo.strUserName));
            oT200DevInfo.setPass(DCCommonUtil.convertByteArrayToChar(oAsnT2000DevInfo.strPassword));
            oT200DevInfo.setPort(oAsnT2000DevInfo.iIPPort.intValue());
            oT2000DevInfoLst.add(oT200DevInfo);
        }
        return oT2000DevInfoLst;
    }

    public synchronized boolean isLocked() {
        return this.m_bIsLocked;
    }

    public synchronized void setLocked(boolean isLocked) {
        this.m_bIsLocked = isLocked;
    }

    public int getDevTypeDomain(int AsnDcDevDomainEnumValue) {
        int AsnDomainPEnumValue = AsnDcDevDomainEnumValue;
        AsnDomainPEnumValue = AsnDcDevDomainEnumValue == 3 ? 3 : 2;
        return AsnDomainPEnumValue;
    }

    @Override
    public HashMap<Integer, SnmpParaInfo> getSNMPParaMap(int[] devIds) throws DCException {
        DeviceInfo[] devInfos;
        if (null == devIds || devIds.length == 0) {
            return new HashMap<Integer, SnmpParaInfo>();
        }
        AsnDevInfoList oAsnDevInfoList = new AsnDevInfoList();
        for (DeviceInfo devInfo : devInfos = DeviceInfoManagerImpl.getInstance().getDevices(devIds)) {
            if (null == devInfo) continue;
            AsnDevInfo oAsnDevInfo = new AsnDevInfo();
            DeviceTypeInfo devType = devInfo.getDeviceTypeInfo();
            Resource oResource = DCFrameWorkUtil.getDeviceInfoManager().getResourceForID(devInfo.getDevId());
            oAsnDevInfo.iKeyMode = BigInteger.valueOf(oResource.getKeyMode());
            if (null == devType) {
                oAsnDevInfo.iDevTypeId = BigInteger.valueOf(0L);
                oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(0L);
            } else {
                oAsnDevInfo.iDevTypeId = BigInteger.valueOf(devType.getDevTypeID());
                oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(devType.getDevTypeVersionId());
            }
            oAsnDevInfo.iDevId = BigInteger.valueOf(devInfo.getDevId());
            oAsnDevInfo.strDevName = devInfo.getDevName().getBytes();
            oAsnDevInfo.strDevIp = devInfo.getDevIPAddress().getBytes();
            oAsnDevInfoList.add((Object)oAsnDevInfo);
        }
        AsnSNMPParaDevInfoListRsp oAsnSNMPParaDevInfoListRsp = new AsnSNMPParaDevInfoListRsp();
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(43937, (FStruct)oAsnDevInfoList, (FStruct)oAsnSNMPParaDevInfoListRsp);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, this.m_oResourceManager.getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnSNMPParaDevInfoListRsp.oErrorNo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        return StandAloneCommUtil.getSNMPParaMapFromAsnParaInfo(oAsnSNMPParaDevInfoListRsp);
    }

    @Override
    public void cleanAsnCancelOpReq() {
        this.asnCancelOpReq.oReqID = null;
    }

    static {
        AsnAddDevReq = null;
        bNotifyAlerady = false;
    }
}

