/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.controller;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.asndatacenter.AsnAgentDevInfo;
import com.huawei.dc.common.asndatacenter.AsnAgentDevInfoLst;
import com.huawei.dc.common.asndatacenter.AsnAgentNodeType;
import com.huawei.dc.common.asndatacenter.AsnDelSNMPReqList;
import com.huawei.dc.common.asndatacenter.AsnDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDevInfoList;
import com.huawei.dc.common.asndatacenter.AsnDevSNMPPara;
import com.huawei.dc.common.asndatacenter.AsnDevSNMPParaList;
import com.huawei.dc.common.asndatacenter.AsnGetRouterExtInfo;
import com.huawei.dc.common.asndatacenter.AsnGetRouterExtInfoLst;
import com.huawei.dc.common.asndatacenter.AsnProtocolTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnRouterExtInfo;
import com.huawei.dc.common.asndatacenter.AsnSNMPEnum;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaDevInfo;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaDevInfoList;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaDevInfoListRsp;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaInfo;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaInfoList;
import com.huawei.dc.common.asndatacenter.AsnSNMPParaValue;
import com.huawei.dc.common.asndatacenter.AsnSnmpAuthentication;
import com.huawei.dc.common.asndatacenter.AsnSnmpDataEncryption;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.standalone.StandAloneCommonOpr;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.huawei.dc.standalone.snmpparams.model.SNMPParaResultInfo;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StandAloneCommUtil {
    private static List<String> m_oGateIPAddLst = new ArrayList<String>(8);

    public static List<SnmpParaInfo> getSnmpParaFrmAsn(AsnSNMPParaInfoList oAsnSnmpParaInfoLst) {
        ArrayList<SnmpParaInfo> oSnmpParaInfoLst = new ArrayList<SnmpParaInfo>(2);
        int iSizeOfLst = oAsnSnmpParaInfoLst.size();
        AsnSNMPParaInfo oAsnSNMPParaInfo = null;
        SnmpParaInfo oSnmpParaInfo = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnSNMPParaInfo = (AsnSNMPParaInfo)oAsnSnmpParaInfoLst.get(i);
            oSnmpParaInfo = StandAloneCommUtil.getSNMPParaInfoFromAsnParaInfo(oAsnSNMPParaInfo);
            oSnmpParaInfoLst.add(oSnmpParaInfo);
        }
        return oSnmpParaInfoLst;
    }

    public static List<SnmpParaInfo> getDevSnmpParaFrmAsn(AsnDevSNMPParaList oAsnDevSnmpParaLst) {
        ArrayList<SnmpParaInfo> oSnmpParaInfoLst = new ArrayList<SnmpParaInfo>(2);
        int iSizeOfLst = oAsnDevSnmpParaLst.size();
        AsnDevSNMPPara oAsnSNMPParaInfo = null;
        SnmpParaInfo oSnmpParaInfo = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnSNMPParaInfo = (AsnDevSNMPPara)oAsnDevSnmpParaLst.get(i);
            oSnmpParaInfo = StandAloneCommUtil.getDevSNMPParaFromAsn(oAsnSNMPParaInfo);
            oSnmpParaInfoLst.add(oSnmpParaInfo);
        }
        return oSnmpParaInfoLst;
    }

    public static List<SnmpParaInfo> getDevSnmpParaFrmAsn(AsnDevSNMPParaList oAsnDevSnmpParaLst, boolean isAccessPanel) {
        ArrayList<SnmpParaInfo> oSnmpParaInfoLst = new ArrayList<SnmpParaInfo>(2);
        int iSizeOfLst = oAsnDevSnmpParaLst.size();
        AsnDevSNMPPara oAsnSNMPParaInfo = null;
        SnmpParaInfo oSnmpParaInfo = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnSNMPParaInfo = (AsnDevSNMPPara)oAsnDevSnmpParaLst.get(i);
            oSnmpParaInfo = StandAloneCommUtil.getDevSNMPParaFromAsn(oAsnSNMPParaInfo, isAccessPanel);
            oSnmpParaInfoLst.add(oSnmpParaInfo);
        }
        return oSnmpParaInfoLst;
    }

    public static SnmpParaInfo getDevSNMPParaFromAsn(AsnDevSNMPPara oAsnSNMPParaInfo) {
        SnmpParaInfo oSnmpParaInfo = new SnmpParaInfo();
        String strDevName = new String(oAsnSNMPParaInfo.strDevName);
        String strDevIP = new String(oAsnSNMPParaInfo.strDevIP);
        Resource oDevDetail = new Resource();
        oDevDetail.setDeviceName(strDevName);
        oDevDetail.setDeviceIP(strDevIP);
        oDevDetail.setDeviceID(oAsnSNMPParaInfo.iDevID.intValue());
        oDevDetail.setDevTypeId(oAsnSNMPParaInfo.iDevTypeID.intValue());
        oSnmpParaInfo.setDevResource(oDevDetail);
        oSnmpParaInfo.setTimeOut(oAsnSNMPParaInfo.iTimeOut.intValue());
        oSnmpParaInfo.setRetries(oAsnSNMPParaInfo.iRetries.intValue());
        oSnmpParaInfo.setDevPort(oAsnSNMPParaInfo.iDevPort.intValue());
        oSnmpParaInfo.setPollInterval(oAsnSNMPParaInfo.iStatusPollInterval.intValue());
        oSnmpParaInfo.setSnmpEnum(StandAloneCommUtil.getSnmpEnumFrmServer(oAsnSNMPParaInfo.enVersion.value));
        oSnmpParaInfo.setGetCommunity(DCCommonUtil.convertByteArrayToChar(oAsnSNMPParaInfo.strGetCommunity), false);
        oSnmpParaInfo.setSetCommunity(DCCommonUtil.convertByteArrayToChar(oAsnSNMPParaInfo.strSetCommunity), false);
        return oSnmpParaInfo;
    }

    public static SnmpParaInfo getDevSNMPParaFromAsn(AsnDevSNMPPara oAsnSNMPParaInfo, boolean isAccessPanel) {
        SnmpParaInfo oSnmpParaInfo = new SnmpParaInfo();
        String strDevName = new String(oAsnSNMPParaInfo.strDevName);
        String strDevIP = new String(oAsnSNMPParaInfo.strDevIP);
        Resource oDevDetail = new Resource();
        oDevDetail.setDeviceName(strDevName);
        oDevDetail.setDeviceIP(strDevIP);
        oDevDetail.setDeviceID(oAsnSNMPParaInfo.iDevID.intValue());
        oDevDetail.setDevTypeId(oAsnSNMPParaInfo.iDevTypeID.intValue());
        oSnmpParaInfo.setDevResource(oDevDetail);
        oSnmpParaInfo.setTimeOut(oAsnSNMPParaInfo.iTimeOut.intValue());
        oSnmpParaInfo.setRetries(oAsnSNMPParaInfo.iRetries.intValue());
        oSnmpParaInfo.setDevPort(oAsnSNMPParaInfo.iDevPort.intValue());
        oSnmpParaInfo.setPollInterval(oAsnSNMPParaInfo.iStatusPollInterval.intValue());
        oSnmpParaInfo.setSnmpEnum(StandAloneCommUtil.getSnmpEnumFrmServer(oAsnSNMPParaInfo.enVersion.value));
        oSnmpParaInfo.setGetCommunity(DCCommonUtil.convertByteArrayToChar(oAsnSNMPParaInfo.strGetCommunity));
        oSnmpParaInfo.setSetCommunity(DCCommonUtil.convertByteArrayToChar(oAsnSNMPParaInfo.strSetCommunity));
        return oSnmpParaInfo;
    }

    private static int getSnmpEnumFrmServer(int iValue) {
        int iSnmpEnum = -1;
        switch (iValue) {
            case 0: {
                iSnmpEnum = 0;
                break;
            }
            case 1: {
                iSnmpEnum = 1;
                break;
            }
            case 3: {
                iSnmpEnum = 2;
                break;
            }
        }
        return iSnmpEnum;
    }

    public static SnmpParaInfo getSNMPParaInfoFromAsnParaInfo(AsnSNMPParaInfo oAsnSNMPParaInfo) {
        SnmpParaInfo oSnmpParaInfo = new SnmpParaInfo();
        String strTemplate = new String(oAsnSNMPParaInfo.strTemplate);
        oSnmpParaInfo.setTemplate(strTemplate);
        oSnmpParaInfo.setTimeOut(oAsnSNMPParaInfo.iTimeOut.intValue());
        oSnmpParaInfo.setRetries(oAsnSNMPParaInfo.iRetries.intValue());
        oSnmpParaInfo.setDevPort(oAsnSNMPParaInfo.iDevPort.intValue());
        oSnmpParaInfo.setPollInterval(oAsnSNMPParaInfo.nStatusPollInterval.intValue());
        oSnmpParaInfo.setSnmpEnum(StandAloneCommUtil.getSnmpEnumFrmServer(oAsnSNMPParaInfo.enVersion.value));
        StandAloneCommUtil.updateSnmpParaInfo(oSnmpParaInfo, oAsnSNMPParaInfo);
        return oSnmpParaInfo;
    }

    public static HashMap<Integer, SnmpParaInfo> getSNMPParaMapFromAsnParaInfo(AsnSNMPParaDevInfoListRsp oAsnSNMPParaDevInfoListRsp) {
        AsnSNMPParaDevInfoList oAsnSNMPParaDevInfoList = oAsnSNMPParaDevInfoListRsp.oAsnSNMPParaDevInfoList;
        int length = oAsnSNMPParaDevInfoList.size();
        HashMap<Integer, SnmpParaInfo> snmpMap = new HashMap<Integer, SnmpParaInfo>(length);
        for (int index = 0; index < length; ++index) {
            AsnSNMPParaDevInfo oSNMPParaDevInfo = (AsnSNMPParaDevInfo)oAsnSNMPParaDevInfoList.get(index);
            AsnSNMPParaInfo oAsnSNMPParaInfo = oSNMPParaDevInfo.oSNMPParaInfo;
            snmpMap.put(oSNMPParaDevInfo.iDevId.intValue(), StandAloneCommUtil.getSNMPParaInfoFromAsnParaInfo(oAsnSNMPParaInfo));
        }
        return snmpMap;
    }

    private static void updateSnmpParaInfo(SnmpParaInfo oSnmpParaInfo, AsnSNMPParaInfo oAsnSNMPParaInfo) {
        if (oSnmpParaInfo.getSnmpEnum() != 2) {
            if (null != oAsnSNMPParaInfo.strGetCommunity) {
                oSnmpParaInfo.setGetCommunity(DCCommonUtil.convertByteArrayToChar(oAsnSNMPParaInfo.strGetCommunity), false);
            }
            if (null != oAsnSNMPParaInfo.strSetCommunity) {
                oSnmpParaInfo.setSetCommunity(DCCommonUtil.convertByteArrayToChar(oAsnSNMPParaInfo.strSetCommunity), false);
            }
        }
        if (null != oAsnSNMPParaInfo.strUserName) {
            oSnmpParaInfo.setUserName(new String(oAsnSNMPParaInfo.strUserName));
        }
        if (null != oAsnSNMPParaInfo.strContextId) {
            oSnmpParaInfo.setContextId(new String(oAsnSNMPParaInfo.strContextId));
        }
        if (null != oAsnSNMPParaInfo.strContextName) {
            oSnmpParaInfo.setContextName(new String(oAsnSNMPParaInfo.strContextName));
        }
        if (null != oAsnSNMPParaInfo.strAuthenticationPasswd) {
            oSnmpParaInfo.setAuthenticationPasswd(DCCommonUtil.convertByteArrayToChar(oAsnSNMPParaInfo.strAuthenticationPasswd), false);
        }
        if (null != oAsnSNMPParaInfo.strEncrypPasswd) {
            oSnmpParaInfo.setEncrypPasswd(DCCommonUtil.convertByteArrayToChar(oAsnSNMPParaInfo.strEncrypPasswd), false);
        }
        if (null != oAsnSNMPParaInfo.enDataEncryption) {
            oSnmpParaInfo.setDataEncryptionType(oAsnSNMPParaInfo.enDataEncryption.value);
        }
        if (null != oAsnSNMPParaInfo.enAuthentication) {
            oSnmpParaInfo.setAuthenticationType(oAsnSNMPParaInfo.enAuthentication.value);
        }
    }

    public static AsnSNMPParaInfo getAsnSnmpParaInfo(SnmpParaInfo oSnmpParaInfo) {
        AsnSNMPParaInfo oAsnParainfo = new AsnSNMPParaInfo();
        if (null == oSnmpParaInfo) {
            return null;
        }
        oAsnParainfo.strTemplate = null != oSnmpParaInfo.getTemplate() && !oSnmpParaInfo.getTemplate().isEmpty() ? oSnmpParaInfo.getTemplate().getBytes() : "default".getBytes();
        oAsnParainfo.enVersion = StandAloneCommUtil.getAsnSnmpEnum(oSnmpParaInfo.getSnmpEnum());
        oAsnParainfo.iDevPort = BigInteger.valueOf(oSnmpParaInfo.getDevPort());
        oAsnParainfo.iRetries = BigInteger.valueOf(oSnmpParaInfo.getRetries());
        oAsnParainfo.iTimeOut = BigInteger.valueOf(oSnmpParaInfo.getTimeOut());
        StandAloneCommUtil.updateAsnSnmpParaInfo(oSnmpParaInfo, oAsnParainfo);
        oAsnParainfo.nStatusPollInterval = BigInteger.valueOf(oSnmpParaInfo.getPollInterval());
        return oAsnParainfo;
    }

    private static AsnSNMPEnum getAsnSnmpEnum(int iValue) {
        AsnSNMPEnum oAsnSnmpEnum = new AsnSNMPEnum(0);
        switch (iValue) {
            case 0: {
                oAsnSnmpEnum = new AsnSNMPEnum(0);
                break;
            }
            case 1: {
                oAsnSnmpEnum = new AsnSNMPEnum(1);
                break;
            }
            case 2: {
                oAsnSnmpEnum = new AsnSNMPEnum(3);
                break;
            }
        }
        return oAsnSnmpEnum;
    }

    private static void updateAsnSnmpParaInfo(SnmpParaInfo oSnmpParaInfo, AsnSNMPParaInfo oAsnParainfo) {
        if (null != oSnmpParaInfo.getSetCommunity()) {
            oAsnParainfo.strSetCommunity = String.valueOf(oSnmpParaInfo.getSetCommunity()).getBytes();
        }
        if (null != oSnmpParaInfo.getGetCommunity()) {
            oAsnParainfo.strGetCommunity = String.valueOf(oSnmpParaInfo.getGetCommunity()).getBytes();
        }
        if (null != oSnmpParaInfo.getUserName()) {
            oAsnParainfo.strUserName = oSnmpParaInfo.getUserName().getBytes();
        }
        if (null != oSnmpParaInfo.getContextId()) {
            oAsnParainfo.strContextId = oSnmpParaInfo.getContextId().getBytes();
        }
        if (null != oSnmpParaInfo.getContextName()) {
            oAsnParainfo.strContextName = oSnmpParaInfo.getContextName().getBytes();
        }
        if (null != oSnmpParaInfo.getAuthenticationPasswd()) {
            oAsnParainfo.strAuthenticationPasswd = String.valueOf(oSnmpParaInfo.getAuthenticationPasswd()).getBytes();
        }
        if (null != oSnmpParaInfo.getEncrypPasswd()) {
            oAsnParainfo.strEncrypPasswd = String.valueOf(oSnmpParaInfo.getEncrypPasswd()).getBytes();
        }
        if (-1 != oSnmpParaInfo.getDataEncryptionType()) {
            oAsnParainfo.enDataEncryption = new AsnSnmpDataEncryption(oSnmpParaInfo.getDataEncryptionType());
        }
        if (-1 != oSnmpParaInfo.getAuthenticationType()) {
            oAsnParainfo.enAuthentication = new AsnSnmpAuthentication(oSnmpParaInfo.getAuthenticationType());
        }
    }

    public static AsnDevInfoList getAsnDevInfoLst(List<Resource> oResourceLst, int iDevTypeID, int iDevTypeVerID, boolean isDeleteSNMP) {
        DeviceInfo deviceInfo;
        int iSizeOfLst = oResourceLst.size();
        AsnDevInfo oAsnDevInfo = null;
        Resource oResource = null;
        AsnDevInfoList oAsnDevInfoList = new AsnDevInfoList();
        int iProtocolType = 1;
        DeviceTypeInfo oDevTypeInfo = null;
        if (0 != iDevTypeID && 0 != iDevTypeVerID) {
            oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
            iProtocolType = oDevTypeInfo.getDeviceType();
        } else if (oResourceLst.size() > 0 && (deviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(oResourceLst.get(0).getDeviceID())) != null) {
            oDevTypeInfo = deviceInfo.getDeviceTypeInfo();
            iProtocolType = oDevTypeInfo.getDeviceType();
        }
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnDevInfo = new AsnDevInfo();
            oResource = oResourceLst.get(i);
            oAsnDevInfo.iKeyMode = BigInteger.valueOf(oResource.getKeyMode());
            oAsnDevInfo.iDevTypeId = BigInteger.valueOf(iDevTypeID);
            oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(iDevTypeVerID);
            oAsnDevInfo.strDevName = oResource.getDeviceName().getBytes();
            oAsnDevInfo.strDevIp = oResource.getDeviceIP().getBytes();
            iProtocolType = oResource.getProtocolType();
            if (4 == iProtocolType || 5 == iProtocolType) {
                oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(5);
                oAsnDevInfo.oAsnRouterExtInfo = new AsnRouterExtInfo();
                oAsnDevInfo.oAsnRouterExtInfo.oAsnProtocolType = oAsnDevInfo.enDevProtocol;
            } else if (6 == iProtocolType) {
                oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(6);
                oAsnDevInfo.oAsnRouterExtInfo = new AsnRouterExtInfo();
                oAsnDevInfo.oAsnRouterExtInfo.oAsnProtocolType = oAsnDevInfo.enDevProtocol;
            } else {
                oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(1);
                oAsnDevInfo.oAsnSNMPParaInfo = StandAloneCommUtil.getAsnSnmpParaInfo(oResource.getSnmpParaInfo());
            }
            if (null != oAsnDevInfo.oAsnRouterExtInfo) {
                oAsnDevInfo.oAsnRouterExtInfo.oAsnAgentType.value = oResource.getProxyType();
                if (-1 != oResource.getProxyNodeType()) {
                    oAsnDevInfo.oAsnRouterExtInfo.oAsnAgentNodeType = new AsnAgentNodeType(oResource.getProxyNodeType());
                }
                if (null != oResource.getUserName()) {
                    oAsnDevInfo.oAsnRouterExtInfo.strUserName = oResource.getUserName().getBytes();
                }
                if (null != oResource.getPassword()) {
                    oAsnDevInfo.oAsnRouterExtInfo.strPassword = StringUtils.convertCharsToBytes(oResource.getPassword());
                }
                if (null != oResource.getSuperPassword()) {
                    oAsnDevInfo.oAsnRouterExtInfo.superPassword = String.valueOf(oResource.getSuperPassword()).getBytes();
                }
                oAsnDevInfo.oAsnRouterExtInfo.iPort = BigInteger.valueOf(oResource.getPortValue());
                if (null != oResource.getVPNName()) {
                    oAsnDevInfo.oAsnRouterExtInfo.strVPN = oResource.getVPNName().getBytes();
                }
            }
            if (-1 != oResource.getDeviceID()) {
                oAsnDevInfo.iDevId = BigInteger.valueOf(oResource.getDeviceID());
                oAsnDevInfo.bAsnDeleteSnmpPara = null != oDevTypeInfo && oDevTypeInfo.getDevDomain() == 2 ? isDeleteSNMP : false;
            }
            oAsnDevInfoList.add((Object)oAsnDevInfo);
        }
        return oAsnDevInfoList;
    }

    public static AsnDevInfoList getAsnDevInfoLst(Resource oResource) {
        AsnDevInfo oAsnDevInfo = null;
        AsnDevInfoList oAsnDevInfoList = new AsnDevInfoList();
        oAsnDevInfo = new AsnDevInfo();
        oAsnDevInfo.iKeyMode = BigInteger.valueOf(oResource.getKeyMode());
        oAsnDevInfo.iDevTypeId = BigInteger.valueOf(oResource.getDevTypeId());
        oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(oResource.getDevVersionID());
        oAsnDevInfo.strDevName = oResource.getDeviceName().getBytes();
        oAsnDevInfo.strDevIp = oResource.getDeviceIP().getBytes();
        try {
            oAsnDevInfo.strDevUserName = oResource.getUserName().getBytes();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        try {
            oAsnDevInfo.strDevUserPassword = StringUtils.convertCharsToBytes(oResource.getPassword());
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        try {
            if (null != oResource.getSuperPassword()) {
                oAsnDevInfo.strSuperDevUserPassword = String.valueOf(oResource.getSuperPassword()).getBytes();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        oAsnDevInfo.bAsnDeleteSnmpPara = false;
        oAsnDevInfo.bAsnSetSnmpPara = true;
        oAsnDevInfo.bAsnDeleteFlash = false;
        oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(1);
        int iProtocolType = oResource.getProtocolType();
        if (4 == iProtocolType || 5 == iProtocolType) {
            oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(5);
            oAsnDevInfo.oAsnRouterExtInfo = new AsnRouterExtInfo();
            oAsnDevInfo.oAsnRouterExtInfo.oAsnProtocolType = oAsnDevInfo.enDevProtocol;
        } else if (6 == iProtocolType) {
            oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(6);
            oAsnDevInfo.oAsnRouterExtInfo = new AsnRouterExtInfo();
            oAsnDevInfo.oAsnRouterExtInfo.oAsnProtocolType = oAsnDevInfo.enDevProtocol;
        } else {
            oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(1);
        }
        if (null != oAsnDevInfo.oAsnRouterExtInfo) {
            oAsnDevInfo.oAsnRouterExtInfo.oAsnAgentType.value = oResource.getProxyType();
            if (-1 != oResource.getProxyNodeType()) {
                oAsnDevInfo.oAsnRouterExtInfo.oAsnAgentNodeType = new AsnAgentNodeType(oResource.getProxyNodeType());
            }
            if (null != oResource.getUserName()) {
                oAsnDevInfo.oAsnRouterExtInfo.strUserName = oResource.getUserName().getBytes();
            }
            if (null != oResource.getPassword()) {
                oAsnDevInfo.oAsnRouterExtInfo.strPassword = StringUtils.convertCharsToBytes(oResource.getPassword());
            }
            if (null != oResource.getSuperPassword()) {
                oAsnDevInfo.oAsnRouterExtInfo.superPassword = String.valueOf(oResource.getSuperPassword()).getBytes();
            }
            oAsnDevInfo.oAsnRouterExtInfo.iPort = BigInteger.valueOf(oResource.getPortValue());
            if (null != oResource.getVPNName()) {
                oAsnDevInfo.oAsnRouterExtInfo.strVPN = oResource.getVPNName().getBytes();
            }
        }
        if (-1 != oResource.getProtocolType()) {
            oAsnDevInfo.enDevProtocol.value = oResource.getProtocolType();
        }
        if (-1 != oResource.getDeviceID()) {
            oAsnDevInfo.iDevId = BigInteger.valueOf(oResource.getDeviceID());
        }
        oAsnDevInfoList.add((Object)oAsnDevInfo);
        return oAsnDevInfoList;
    }

    public static AsnDevInfo getAsnDevInfo(AbstractDevInfoObj devInfoObj) {
        AsnDevInfo oAsnDevInfo = null;
        if (devInfoObj instanceof RouterDevInfoObj) {
            RouterDevInfoObj routerDevInfoObj = (RouterDevInfoObj)devInfoObj;
            oAsnDevInfo = new AsnDevInfo();
            oAsnDevInfo.iKeyMode = BigInteger.valueOf(devInfoObj.getKeyMode());
            String sChangeName = routerDevInfoObj.getCurrentChangedFieldName();
            boolean bChangNeType = "m_oDevType".equals(sChangeName);
            DeviceTypeInfo oDevTypeInfo = null;
            if (!bChangNeType) {
                DeviceTypeInfo[] devTypes;
                DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(routerDevInfoObj.getDevID());
                if (null != oDevInfo) {
                    oDevTypeInfo = oDevInfo.getDeviceTypeInfo();
                }
                if ((null == oDevInfo || null == oDevTypeInfo) && null != (devTypes = DeviceInfoManagerImpl.getInstance().getDevTypeInfoByTypeName(routerDevInfoObj.getDevType())) && 0 < devTypes.length) {
                    oDevTypeInfo = devTypes[0];
                }
            } else {
                DeviceTypeInfo[] devTypes = DeviceInfoManagerImpl.getInstance().getDevTypeInfoByTypeName(routerDevInfoObj.getDevType());
                if (null != devTypes && 0 < devTypes.length) {
                    oDevTypeInfo = devTypes[0];
                }
            }
            if (null != oDevTypeInfo) {
                oAsnDevInfo.iDevTypeId = BigInteger.valueOf(oDevTypeInfo.getDevTypeID());
                oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(oDevTypeInfo.getDevTypeVersionId());
            } else {
                oAsnDevInfo.iDevTypeId = BigInteger.valueOf(0L);
                oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(0L);
            }
            if (DCConstants.UNKNOW_TYPE.equals(routerDevInfoObj.getDevType())) {
                oAsnDevInfo.iDevTypeId = BigInteger.valueOf(DCConstants.UNKNOW_TYPE_ID);
                oAsnDevInfo.iDevTypeVersionId = BigInteger.valueOf(DCConstants.UNKNOW_TYPE_ID);
            }
            oAsnDevInfo.strDevName = devInfoObj.getDevName().getBytes();
            oAsnDevInfo.strDevIp = devInfoObj.getDevAddress().getBytes();
            try {
                oAsnDevInfo.strDevUserName = routerDevInfoObj.getUserName().getBytes();
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
            if (StandAloneDomainInfo.getInstance().getSelectedDomain() != 2) {
                try {
                    oAsnDevInfo.strDevUserPassword = StringUtils.convertCharsToBytes(DCEncryptServiceUtil.decrypt(routerDevInfoObj.getPassword()));
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            } else {
                oAsnDevInfo.strDevUserPassword = StringUtils.convertCharsToBytes(routerDevInfoObj.getPassword());
            }
            try {
                oAsnDevInfo.strSuperDevUserPassword = String.valueOf(routerDevInfoObj.getSuper3Pass()).getBytes();
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
            oAsnDevInfo.bAsnDeleteSnmpPara = false;
            oAsnDevInfo.bAsnSetSnmpPara = true;
            oAsnDevInfo.bAsnDeleteFlash = false;
            oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(1);
            oAsnDevInfo.enDevProtocol = new AsnProtocolTypeEnum(routerDevInfoObj.getIProtocolType());
            if (!routerDevInfoObj.getIsAgent()) {
                oAsnDevInfo.oAsnRouterExtInfo = new AsnRouterExtInfo();
                oAsnDevInfo.oAsnRouterExtInfo.oAsnProtocolType = oAsnDevInfo.enDevProtocol;
                oAsnDevInfo.oAsnRouterExtInfo.oAsnAgentType.value = routerDevInfoObj.getIProxyType();
                if (-1 != routerDevInfoObj.getIProxyNodeType()) {
                    oAsnDevInfo.oAsnRouterExtInfo.oAsnAgentNodeType = new AsnAgentNodeType(routerDevInfoObj.getIProxyNodeType());
                }
                if (null != routerDevInfoObj.getUserName()) {
                    oAsnDevInfo.oAsnRouterExtInfo.strUserName = routerDevInfoObj.getUserName().getBytes();
                }
                if (null != routerDevInfoObj.getPassword()) {
                    oAsnDevInfo.oAsnRouterExtInfo.strPassword = StringUtils.convertCharsToBytes(routerDevInfoObj.getPassword());
                }
                if (null != routerDevInfoObj.getSuper3Pass()) {
                    oAsnDevInfo.oAsnRouterExtInfo.superPassword = StringUtils.convertCharsToBytes(routerDevInfoObj.getSuper3Pass());
                }
                oAsnDevInfo.oAsnRouterExtInfo.iPort = BigInteger.valueOf(routerDevInfoObj.getIPort());
                if (null != routerDevInfoObj.getVPNName()) {
                    oAsnDevInfo.oAsnRouterExtInfo.strVPN = routerDevInfoObj.getVPNName().getBytes();
                }
            }
            if (-1 != routerDevInfoObj.getIProtocolType()) {
                oAsnDevInfo.enDevProtocol.value = routerDevInfoObj.getIProtocolType();
            }
            if (-1 != routerDevInfoObj.getDevID()) {
                oAsnDevInfo.iDevId = BigInteger.valueOf(routerDevInfoObj.getDevID());
            }
            if (!"".equals(routerDevInfoObj.getAgentID())) {
                oAsnDevInfo.strOldAgentId = routerDevInfoObj.getAgentID().getBytes();
            }
            oAsnDevInfo.oAsnAgentDevInfoLst = new AsnAgentDevInfoLst();
            if (routerDevInfoObj.getIsAgent()) {
                oAsnDevInfo.oAsnAgentDevInfoLst.add((Object)StandAloneCommUtil.getAsnAgentDevInfo(routerDevInfoObj));
            }
            for (RouterDevInfoObj tmpDevInfoObj = routerDevInfoObj.getParentDevInfoObj(); null != tmpDevInfoObj; tmpDevInfoObj = tmpDevInfoObj.getParentDevInfoObj()) {
                oAsnDevInfo.oAsnAgentDevInfoLst.add((Object)StandAloneCommUtil.getAsnAgentDevInfo(tmpDevInfoObj));
            }
        }
        return oAsnDevInfo;
    }

    public static AsnAgentDevInfo getAsnAgentDevInfo(RouterDevInfoObj devInfoObj) {
        AsnAgentDevInfo oAsnAgentDevInfo = new AsnAgentDevInfo();
        oAsnAgentDevInfo.strAgentID = devInfoObj.getAgentID().getBytes();
        oAsnAgentDevInfo.strAgentDevIp = devInfoObj.getDevAddress().getBytes();
        oAsnAgentDevInfo.strAgentDevName = devInfoObj.getDevName().getBytes();
        oAsnAgentDevInfo.oAsnRouterExtInfo.oAsnProtocolType.value = devInfoObj.getIProtocolType();
        oAsnAgentDevInfo.oAsnRouterExtInfo.oAsnAgentType.value = devInfoObj.getIProxyType();
        if (-1 != devInfoObj.getIProxyNodeType()) {
            oAsnAgentDevInfo.oAsnRouterExtInfo.oAsnAgentNodeType = new AsnAgentNodeType(devInfoObj.getIProxyNodeType());
        }
        if (null != devInfoObj.getUserName()) {
            oAsnAgentDevInfo.oAsnRouterExtInfo.strUserName = devInfoObj.getUserName().getBytes();
        }
        if (null != devInfoObj.getPassword()) {
            oAsnAgentDevInfo.oAsnRouterExtInfo.strPassword = StringUtils.convertCharsToBytes(DCEncryptServiceUtil.decrypt(devInfoObj.getPassword()));
        }
        if (null != devInfoObj.getSuper3Pass()) {
            oAsnAgentDevInfo.oAsnRouterExtInfo.superPassword = StringUtils.convertCharsToBytes(DCEncryptServiceUtil.decrypt(devInfoObj.getSuper3Pass()));
        }
        oAsnAgentDevInfo.oAsnRouterExtInfo.iPort = BigInteger.valueOf(devInfoObj.getIPort());
        if (null != devInfoObj.getVPNName()) {
            oAsnAgentDevInfo.oAsnRouterExtInfo.strVPN = devInfoObj.getVPNName().getBytes();
        }
        return oAsnAgentDevInfo;
    }

    public static List<SNMPParaResultInfo> getResultInfoFromDeleteSNMPParaResponse(AsnDelSNMPReqList oAsnDelSNMPReqList) {
        ArrayList<SNMPParaResultInfo> oResultInfoList = new ArrayList<SNMPParaResultInfo>(0);
        if (null == oAsnDelSNMPReqList || 0 == oAsnDelSNMPReqList.size()) {
            return oResultInfoList;
        }
        int iFailedParaCount = oAsnDelSNMPReqList.size();
        AsnSNMPParaValue oParaValue = null;
        SNMPParaResultInfo oResultInfo = null;
        String strTemplateName = null;
        for (int i = 0; i < iFailedParaCount; ++i) {
            oParaValue = (AsnSNMPParaValue)oAsnDelSNMPReqList.get(i);
            oResultInfo = new SNMPParaResultInfo();
            strTemplateName = new String(oParaValue.strTemplate);
            oResultInfo.setTemplateName(strTemplateName);
            oResultInfo.setVersion(oParaValue.enVersion.value);
            oResultInfo.setErrorCode(oParaValue.oErrorNo.iErrorNo);
            oResultInfoList.add(oResultInfo);
        }
        return oResultInfoList;
    }

    public static List<String> getGateIPAddLst() {
        return m_oGateIPAddLst;
    }

    public static void setGateIPAddLst(List<String> oGateIPAddLst) {
        m_oGateIPAddLst = oGateIPAddLst;
    }

    public static AsnRouterExtInfo getAsnRouterDevExtInfo(RouterDevInfoObj devInfoObj) {
        AsnRouterExtInfo oAsnRouterDevExtInfo = null;
        String strUserName = "";
        String strPass = "";
        oAsnRouterDevExtInfo = new AsnRouterExtInfo();
        if (null != devInfoObj.getUserName()) {
            strUserName = devInfoObj.getUserName();
        }
        if (null != devInfoObj.getPassword()) {
            strPass = String.valueOf(DCEncryptServiceUtil.decrypt(devInfoObj.getPassword()));
        }
        oAsnRouterDevExtInfo.iPort = BigInteger.valueOf(devInfoObj.getIPort());
        oAsnRouterDevExtInfo.strUserName = strUserName.getBytes();
        oAsnRouterDevExtInfo.strPassword = strPass.getBytes();
        return oAsnRouterDevExtInfo;
    }

    public static AsnRouterExtInfo getAsnRouterDevExtInfo(Resource oRes) {
        AsnRouterExtInfo oAsnRouterDevExtInfo = null;
        String strUserName = "";
        char[] strPass = "".toCharArray();
        oAsnRouterDevExtInfo = new AsnRouterExtInfo();
        if (null != oRes.getUserName()) {
            strUserName = oRes.getUserName();
        }
        if (null != oRes.getPassword()) {
            strPass = oRes.getPassword();
        }
        oAsnRouterDevExtInfo.iPort = BigInteger.valueOf(oRes.getPortValue());
        oAsnRouterDevExtInfo.strUserName = strUserName.getBytes();
        oAsnRouterDevExtInfo.strPassword = StringUtils.convertCharsToBytes(strPass);
        return oAsnRouterDevExtInfo;
    }

    public static List<RouterDevInfoObj> getRouterDevInfoLst(AsnGetRouterExtInfoLst oAsnRouterExtInfoLst) {
        ArrayList<RouterDevInfoObj> routerDevInfoLst = new ArrayList<RouterDevInfoObj>();
        int iDevCount = oAsnRouterExtInfoLst.size();
        for (int i = 0; i < iDevCount; ++i) {
            AsnGetRouterExtInfo oAsnRoutExtInfo = (AsnGetRouterExtInfo)oAsnRouterExtInfoLst.get(i);
            if (0 != oAsnRoutExtInfo.oErrorNo.iErrorNo.intValue()) continue;
            RouterDevInfoObj tmpDevInfoObj = StandAloneCommUtil.parseAgentInfo(oAsnRoutExtInfo.oAsnAgentDevInfoLst);
            tmpDevInfoObj.setDevID(oAsnRoutExtInfo.iDevId.intValue());
            tmpDevInfoObj.setIProxyType(oAsnRoutExtInfo.oAsnRouterExtInfo.oAsnAgentType.value);
            if (null != oAsnRoutExtInfo.oAsnRouterExtInfo.oAsnAgentNodeType) {
                tmpDevInfoObj.setIProxyNodeType(oAsnRoutExtInfo.oAsnRouterExtInfo.oAsnAgentNodeType.value);
            }
            tmpDevInfoObj.setIProtocolType(oAsnRoutExtInfo.oAsnRouterExtInfo.oAsnProtocolType.value);
            tmpDevInfoObj.setPort(oAsnRoutExtInfo.oAsnRouterExtInfo.iPort.toString());
            if (null != oAsnRoutExtInfo.oAsnRouterExtInfo.strUserName) {
                tmpDevInfoObj.setUserName(new String(oAsnRoutExtInfo.oAsnRouterExtInfo.strUserName));
            }
            if (null != oAsnRoutExtInfo.oAsnRouterExtInfo.strPassword) {
                tmpDevInfoObj.setPassword(DCCommonUtil.convertByteArrayToChar(oAsnRoutExtInfo.oAsnRouterExtInfo.strPassword));
            }
            if (null != oAsnRoutExtInfo.oAsnRouterExtInfo.superPassword) {
                tmpDevInfoObj.setSuper3Pass(DCCommonUtil.convertByteArrayToChar(oAsnRoutExtInfo.oAsnRouterExtInfo.superPassword));
            }
            if (null != oAsnRoutExtInfo.oAsnRouterExtInfo.strVPN) {
                tmpDevInfoObj.setVPNName(new String(oAsnRoutExtInfo.oAsnRouterExtInfo.strVPN));
            }
            tmpDevInfoObj.setIsFinishInitialize(true);
            routerDevInfoLst.add(tmpDevInfoObj);
        }
        return routerDevInfoLst;
    }

    private static RouterDevInfoObj parseAgentInfo(AsnAgentDevInfoLst oAsnAgentDevInfoLst) {
        RouterDevInfoObj preRouterDevInfo = null;
        if (null != oAsnAgentDevInfoLst) {
            int iAgentCount = oAsnAgentDevInfoLst.size();
            for (int i = 0; i < iAgentCount; ++i) {
                AsnAgentDevInfo tmpAsnAgentInfo = (AsnAgentDevInfo)oAsnAgentDevInfoLst.get(i);
                RouterDevInfoObj tmpDevInfoObj = new RouterDevInfoObj(preRouterDevInfo);
                tmpDevInfoObj.setAgentID(new String(tmpAsnAgentInfo.strAgentID));
                tmpDevInfoObj.setDevAddress(new String(tmpAsnAgentInfo.strAgentDevIp));
                tmpDevInfoObj.setDevName(new String(tmpAsnAgentInfo.strAgentDevName));
                tmpDevInfoObj.setIProxyType(tmpAsnAgentInfo.oAsnRouterExtInfo.oAsnAgentType.value);
                if (null != tmpAsnAgentInfo.oAsnRouterExtInfo.oAsnAgentNodeType) {
                    tmpDevInfoObj.setIProxyNodeType(tmpAsnAgentInfo.oAsnRouterExtInfo.oAsnAgentNodeType.value);
                }
                tmpDevInfoObj.setIProtocolType(tmpAsnAgentInfo.oAsnRouterExtInfo.oAsnProtocolType.value);
                tmpDevInfoObj.setPort(tmpAsnAgentInfo.oAsnRouterExtInfo.iPort.toString());
                if (null != tmpAsnAgentInfo.oAsnRouterExtInfo.strUserName) {
                    tmpDevInfoObj.setUserName(new String(tmpAsnAgentInfo.oAsnRouterExtInfo.strUserName));
                }
                if (null != tmpAsnAgentInfo.oAsnRouterExtInfo.strPassword) {
                    tmpDevInfoObj.setPassword(DCEncryptServiceUtil.decrypt(DCCommonUtil.convertByteArrayToChar(tmpAsnAgentInfo.oAsnRouterExtInfo.strPassword)));
                }
                if (null != tmpAsnAgentInfo.oAsnRouterExtInfo.superPassword) {
                    tmpDevInfoObj.setSuper3Pass(DCEncryptServiceUtil.decrypt(DCCommonUtil.convertByteArrayToChar(tmpAsnAgentInfo.oAsnRouterExtInfo.superPassword)));
                }
                if (null != tmpAsnAgentInfo.oAsnRouterExtInfo.strVPN) {
                    tmpDevInfoObj.setVPNName(new String(tmpAsnAgentInfo.oAsnRouterExtInfo.strVPN));
                }
                tmpDevInfoObj.setIsFinishInitialize(true);
                preRouterDevInfo = tmpDevInfoObj;
            }
        }
        if (null != preRouterDevInfo) {
            String strAgentID = preRouterDevInfo.getAgentID();
            int index = strAgentID.lastIndexOf(".");
            StandAloneCommonOpr.getInstance().setMaxAgentID(Integer.parseInt(strAgentID.substring(index + 1)));
        }
        return new RouterDevInfoObj(preRouterDevInfo);
    }
}

