/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.controller;

import com.huawei.dc.common.asndatacenter.AsnAgentDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDevInfo;
import com.huawei.dc.common.asndatacenter.AsnSWStatDevInfo;
import com.huawei.dc.common.asndatacenter.AsnSWStatisticsRsp;
import com.huawei.dc.common.asndatacenter.AsnSearchGatewayRsp;
import com.huawei.dc.common.asndatacenter.AsnSearchNGDeviceRsp;
import com.huawei.dc.common.asndatacenter.AsnT2000Board;
import com.huawei.dc.common.asndatacenter.AsnT2000BoardList;
import com.huawei.dc.common.asndatacenter.AsnT2000DevInfo;
import com.huawei.dc.common.asndatacenter.AsndetailedVersion;
import com.huawei.dc.common.asndatacenter.AsndetailedVersionList;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.standalone.controller.IDCStandAloneAsyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.event.StandAloneEvent;
import com.huawei.dc.standalone.event.StandAloneNotifier;
import com.huawei.dc.standalone.model.BoardInformation;
import com.huawei.dc.standalone.model.DeviceStatisticsReportInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKDeviceFactory;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;

public class StandAloneAsyncCtrller
extends MSGReceiver
implements IDCStandAloneAsyncCtrller,
IDCObjectDeallocator {
    private static IDCStandAloneAsyncCtrller m_oASyncCtrllerInstance = null;
    private BaseCommManager m_oCommManager = DCFrameWorkUtil.getCommManager();

    private StandAloneAsyncCtrller() {
    }

    public static synchronized IDCStandAloneAsyncCtrller getInstance() {
        if (null == m_oASyncCtrllerInstance) {
            m_oASyncCtrllerInstance = new StandAloneAsyncCtrller();
            DCObjectDestructor.getInstance().addObjectForDestructor((StandAloneAsyncCtrller)m_oASyncCtrllerInstance);
        }
        return m_oASyncCtrllerInstance;
    }

    @Override
    public void setToNULL() {
        this.close();
        if (null != this.m_oCommManager) {
            this.m_oCommManager.removeMessageListener(43935, (MSGListener)this);
            this.m_oCommManager.removeMessageListener(43936, (MSGListener)this);
            this.m_oCommManager.removeMessageListener(43949, (MSGListener)this);
            this.m_oCommManager.removeMessageListener(43950, (MSGListener)this);
            this.m_oCommManager.removeMessageListener(43956, (MSGListener)this);
            this.m_oCommManager.removeMessageListener(44008, (MSGListener)this);
        }
        m_oASyncCtrllerInstance = null;
        this.m_oCommManager = null;
    }

    public synchronized void processMessage(MSGPacketExt packetExt) {
        try {
            this.processAsynMessage(packetExt);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    protected void processAsynMessage(MSGPacketExt oPacketExt) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        DCDebugTracer.trace("[STANDALONE] receive asyn msg cmdCode= " + oPacketExt.mheader.cmdCode);
        switch (oPacketExt.mheader.cmdCode) {
            case 43935: {
                this.sendNotificationForDeviceDeletion(oPacketExt);
                break;
            }
            case 43936: {
                this.sendNotificationForDeviceModification(oPacketExt);
                break;
            }
            case 43949: {
                this.sendNotificationForSearchGWDev(oPacketExt);
                break;
            }
            case 43950: {
                this.sendNotificationForSearchNGWDev(oPacketExt);
                break;
            }
            case 43956: {
                this.sendNotificationForSWStatisticsInfo(oPacketExt);
                break;
            }
            case 44008: {
                this.sendNotificationForChangeGatewayIP(oPacketExt);
                break;
            }
        }
    }

    private void sendNotificationForSWStatisticsInfo(MSGPacketExt oPacketExt) {
        AsnSWStatisticsRsp oAsnSWStatRsp = new AsnSWStatisticsRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnSWStatRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        StandAloneEvent oStandAloneEvent = this.getEventObjForSWStatistics(oAsnSWStatRsp, 4);
        StandAloneNotifier.getInstance().notifyStandAloneEvent(oStandAloneEvent);
        if (oAsnSWStatRsp.bIsFinal) {
            this.m_oCommManager.removeMessageListener(43956, (MSGListener)this);
        }
    }

    private void sendNotificationForSearchNGWDev(MSGPacketExt oPacketExt) {
        AsnSearchNGDeviceRsp oAsnSearchNGWDevRsp = new AsnSearchNGDeviceRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnSearchNGWDevRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        StandAloneEvent oStandAloneEvent = new StandAloneEvent(oAsnSearchNGWDevRsp, 43950);
        StandAloneNotifier.getInstance().notifyStandAloneEvent(oStandAloneEvent);
        if (oAsnSearchNGWDevRsp.bIsFinal) {
            this.m_oCommManager.removeMessageListener(43950, (MSGListener)this);
        }
    }

    private void sendNotificationForSearchGWDev(MSGPacketExt oPacketExt) {
        AsnSearchGatewayRsp oAsnSearchGatewayRsp = new AsnSearchGatewayRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnSearchGatewayRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        StandAloneEvent oStandAloneEvent = new StandAloneEvent(oAsnSearchGatewayRsp, 43949);
        StandAloneNotifier.getInstance().notifyStandAloneEvent(oStandAloneEvent);
    }

    private void sendNotificationForDeviceDeletion(MSGPacketExt oPacketExt) {
        AsnDevInfo oAsnDeviceInfo = new AsnDevInfo();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDeviceInfo, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        int iDevId = oAsnDeviceInfo.iDevId.intValue();
        if (0 >= iDevId) {
            StandAloneEvent oEvent = this.getEventObjectForNotification(oAsnDeviceInfo, 1);
            StandAloneNotifier.getInstance().notifyStandAloneEvent(oEvent);
        }
        if (oAsnDeviceInfo.bFinal) {
            this.m_oCommManager.removeMessageListener(43935, (MSGListener)this);
        }
    }

    private void sendNotificationForDeviceModification(MSGPacketExt oPacketExt) {
        while (((StandAloneSyncCtrller)StandAloneSyncCtrller.getInstance()).isLocked()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
            }
        }
        ((StandAloneSyncCtrller)StandAloneSyncCtrller.getInstance()).setLocked(false);
        AsnDevInfo oAsnDeviceInfo = new AsnDevInfo();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDeviceInfo, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        StandAloneEvent oEvent = this.getEventObjectForNotification(oAsnDeviceInfo, 2);
        StandAloneNotifier.getInstance().notifyStandAloneEvent(oEvent);
        if (oAsnDeviceInfo.bFinal) {
            this.m_oCommManager.removeMessageListener(43936, (MSGListener)this);
        }
    }

    private StandAloneEvent getEventObjectForNotification(AsnDevInfo oAsnDeviceInfo, int iEventType) {
        String DevName;
        StandAloneEvent oEvent = new StandAloneEvent(iEventType);
        Resource oRes = new Resource();
        oRes.setDevTypeId(oAsnDeviceInfo.iDevTypeId.intValue());
        oRes.setDevVersionID(oAsnDeviceInfo.iDevTypeVersionId.intValue());
        if (null != oAsnDeviceInfo.iDevId) {
            oRes.setDeviceID(oAsnDeviceInfo.iDevId.intValue());
        }
        if ((DevName = new String(oAsnDeviceInfo.strDevName)).equals("") && null != oAsnDeviceInfo.oAsnT2000DevInfo && oAsnDeviceInfo.oAsnT2000DevInfo.iNeID != null) {
            DevName = DeviceInfoUtil.parseNEIDInt(oAsnDeviceInfo.oAsnT2000DevInfo.iNeID.intValue());
        }
        oRes.setDeviceName(DevName);
        oRes.setDeviceIP(new String(oAsnDeviceInfo.strDevIp));
        if (null != oAsnDeviceInfo.oAsnAgentDevInfoLst && 0 < oAsnDeviceInfo.oAsnAgentDevInfoLst.size()) {
            AsnAgentDevInfo asnAgentDevInfo = (AsnAgentDevInfo)oAsnDeviceInfo.oAsnAgentDevInfoLst.get(0);
            oRes.setAgentID(new String(asnAgentDevInfo.strAgentID));
            DevName = new String(asnAgentDevInfo.strAgentDevName);
            oRes.setDeviceIP(new String(asnAgentDevInfo.strAgentDevIp));
            oRes.setDeviceName(DevName);
        }
        oEvent.setResource(oRes);
        if (null != oAsnDeviceInfo.oErrorNo) {
            oEvent.setErrorCode(oAsnDeviceInfo.oErrorNo.iErrorNo.intValue());
        } else {
            oEvent.setErrorCode(0);
        }
        oEvent.setFinal(oAsnDeviceInfo.bFinal);
        return oEvent;
    }

    private StandAloneEvent getEventObjForSWStatistics(AsnSWStatisticsRsp oAsnRsp, int iEventType) {
        StandAloneEvent oEvent = new StandAloneEvent(iEventType);
        DeviceStatisticsReportInfo oReportInfo = new DeviceStatisticsReportInfo();
        ArrayList<BoardInformation> oBoardList = new ArrayList<BoardInformation>(0);
        ArrayList<DeviceStatisticsReportInfo> oReportInfoList = new ArrayList<DeviceStatisticsReportInfo>(0);
        AsnSWStatDevInfo oAsnSWStatDevInfo = oAsnRsp.oAsnSWStatDevInfo;
        AsnT2000BoardList oAsnBoardList = oAsnRsp.oAsnT2000BoardList;
        int iBoardListSize = oAsnBoardList.size();
        int iDevId = oAsnSWStatDevInfo.iDevID.intValue();
        IDeviceInfoManager oDeviceInfoMgr = DeviceInfoManagerImpl.getInstance();
        DeviceInfo oDeviceInfo = oDeviceInfoMgr.getDevice(iDevId);
        String strIP = oDeviceInfo.getDevIPAddress();
        String strDeviceName = new String(oAsnSWStatDevInfo.strDevName);
        String strDeviceID = new String(oAsnSWStatDevInfo.strNEId);
        String strDeviceVerName = null;
        strDeviceVerName = null != oAsnSWStatDevInfo.strDevVersion ? new String(oAsnSWStatDevInfo.strDevVersion) : "";
        String strDeviceTypeName = new String(oAsnSWStatDevInfo.strDevType);
        for (int index = 0; index < iBoardListSize; ++index) {
            AsnT2000Board oAsnBoard = (AsnT2000Board)oAsnBoardList.get(index);
            BoardInformation oBoardInformation = new BoardInformation();
            int iBoardId = oAsnBoard.iSlotId.intValue();
            int iBoardType = oAsnBoard.iSlotType.intValue();
            String strBoardName = new String(oAsnBoard.strSlotName);
            oBoardInformation.setBoardId(iBoardId);
            oBoardInformation.setBoardName(strBoardName);
            oBoardInformation.setBoardType(iBoardType);
            AsndetailedVersionList oAsnDetailedVerList = oAsnBoard.oAsndetailedVersionList;
            int iDetailedVerListSize = oAsnDetailedVerList.size();
            for (int i = 0; i < iDetailedVerListSize; ++i) {
                AsndetailedVersion oAsnDetailedVersion = (AsndetailedVersion)oAsnDetailedVerList.get(i);
                String strKeyName = new String(oAsnDetailedVersion.strKeyname);
                String strVal = new String(oAsnDetailedVersion.strValue);
                oBoardInformation.populateVersionMap(strKeyName, strVal);
            }
            oBoardList.add(oBoardInformation);
        }
        oReportInfo.setDeviceName(strDeviceName);
        oReportInfo.setDeviceTypeName(strDeviceTypeName);
        oReportInfo.setDeviceId(strDeviceID);
        oReportInfo.setDeviceVerName(strDeviceVerName);
        oReportInfo.setBoardList(oBoardList);
        if (0 != oBoardList.size()) {
            oReportInfoList.add(oReportInfo);
        }
        Resource oRes = new Resource();
        oRes.setDeviceName(new String(oAsnRsp.oAsnSWStatDevInfo.strDevName));
        oRes.setDeviceIP(strIP);
        oEvent.setStatisticsReportInfo(oReportInfoList);
        oEvent.setResource(oRes);
        oEvent.setErrorCode(oAsnRsp.oErrorNo.iErrorNo.intValue());
        oEvent.setFinal(oAsnRsp.bIsFinal);
        return oEvent;
    }

    private void sendNotificationForChangeGatewayIP(MSGPacketExt oPacketExt) {
        while (((StandAloneSyncCtrller)StandAloneSyncCtrller.getInstance()).isLocked()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
            }
        }
        ((StandAloneSyncCtrller)StandAloneSyncCtrller.getInstance()).setLocked(false);
        AsnDevInfo oAsnDeviceInfo = new AsnDevInfo();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDeviceInfo, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        StandAloneEvent oEvent = this.getEventObjectForNotification(oAsnDeviceInfo, 2);
        StandAloneNotifier.getInstance().notifyStandAloneEvent(oEvent);
        if (oAsnDeviceInfo.bFinal) {
            this.m_oCommManager.removeMessageListener(44008, (MSGListener)this);
        }
        this.handleChangeGWEventForTK(oAsnDeviceInfo);
    }

    public void timeout(int strArg0, Character strArg1) {
    }

    private void handleChangeGWEventForTK(AsnDevInfo oAsnDeviceInfo) {
        if (null == oAsnDeviceInfo) {
            return;
        }
        int iNEID = -1;
        String sOldGateway = "";
        String sNewGateway = "";
        String sPort = "";
        int iGatewayType = -1;
        AsnT2000DevInfo oAsnT2000DevInfo = oAsnDeviceInfo.oAsnT2000DevInfo;
        if (null != oAsnT2000DevInfo) {
            iNEID = null == oAsnT2000DevInfo.iNeID ? -1 : oAsnT2000DevInfo.iNeID.intValue();
            sNewGateway = new String(oAsnT2000DevInfo.strGatewayIP);
            sPort = oAsnT2000DevInfo.iIPPort.toString();
            iGatewayType = oAsnT2000DevInfo.enGatewayType.value;
        }
        TKDeviceFactory.switchGateway(iNEID, sOldGateway, sNewGateway, sPort, iGatewayType);
    }
}

