/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.about;

import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.DebugTracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.Collator;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AboutDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String strHttplink = "";
    private JLabel huaweiLink = new JLabel();
    private Hashtable m_AboutHashTable;
    private Hashtable m_PatchHashTable;
    private String language = "EN";

    public AboutDlg(JFrame parentFrame) {
        super((Frame)parentFrame, true);
        try {
            this.pack();
            this.setSize(400, 307);
            this.setTitle(ResourceManager.getInstance().getResString("ABOUT_DIALOG_TITLE"));
            this.setResizable(false);
            this.setLocationRelativeTo(parentFrame);
            this.setDefaultCloseOperation(2);
            this.jbInit();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
            return;
        }
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    private String getCurrentContext() {
        return "HELP_TOPIC_VIEW_DEVICE_INFORMATION";
    }

    private void jbInit() throws Exception {
        Border border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(103, 101, 98), new Color(148, 145, 140));
        JPanel aboutPanel = new JPanel();
        aboutPanel.setName("Standalone_AboutDlg_aboutPanel");
        aboutPanel.setLayout(null);
        JLabel productLbl = new JLabel();
        aboutPanel.setName("Standalone_AboutDlg_productLbl");
        productLbl.setText(this.getVersionFromXML());
        this.m_AboutHashTable = null;
        this.m_PatchHashTable = null;
        productLbl.setBounds(new Rectangle(75, 0, 294, 30));
        JLabel copyRightLbl = new JLabel();
        copyRightLbl.setName("Standalone_AboutDlg_copyRightLbl");
        copyRightLbl.setHorizontalAlignment(2);
        copyRightLbl.setText(ResourceManager.getInstance().getResString("ABOUT_HUAWEI_COPYRIGHT"));
        copyRightLbl.setBounds(new Rectangle(75, 20, 294, 30));
        JLabel rightReservedLbl = new JLabel();
        rightReservedLbl.setName("Standalone_AboutDlg_rightReservedLbl");
        rightReservedLbl.setHorizontalAlignment(2);
        rightReservedLbl.setText(ResourceManager.getInstance().getResString("ABOUT_HUAWEI_RIGHT_RESERVERD"));
        rightReservedLbl.setBounds(new Rectangle(75, 40, 294, 30));
        this.huaweiLink.setText(ResourceManager.getInstance().getResString("ABOUT_HUAWEI_LINK"));
        this.huaweiLink.setBounds(new Rectangle(new Rectangle(75, 60, 294, 30)));
        this.huaweiLink.setForeground(Color.blue);
        this.strHttplink = ResourceManager.getInstance().getResString("ABOUT_HUAWEI_LINK");
        MouseAdapter httpListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                String osName = System.getProperty("os.name");
                String[] execString = new String[2];
                execString[1] = AboutDlg.this.strHttplink;
                if (osName != null) {
                    if (osName.indexOf("Solaris") != -1 || osName.indexOf("SunOS") != -1 || osName.indexOf("Linux") != -1 || osName.indexOf("HP-UX") != -1) {
                        execString[0] = "netscape";
                    } else if (osName.charAt(0) == 'W' || osName.charAt(0) == 'w') {
                        execString[0] = "explorer";
                    }
                    try {
                        Runtime.getRuntime().exec(execString);
                    }
                    catch (Exception ex) {
                        DCDebugTracer.trace(ex);
                        return;
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                Font font = AboutDlg.this.huaweiLink.getFont();
                Font newFont = new Font(font.getName(), 1, font.getSize());
                AboutDlg.this.huaweiLink.setFont(newFont);
                Cursor cur = new Cursor(12);
                DCFrameWorkUtil.setCursor(AboutDlg.this.getContentPane(), cur);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                Font font = AboutDlg.this.huaweiLink.getFont();
                Font newFont = new Font(font.getName(), 0, font.getSize());
                AboutDlg.this.huaweiLink.setFont(newFont);
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(AboutDlg.this.getContentPane(), cur);
            }
        };
        this.huaweiLink.addMouseListener(httpListener);
        JLabel imageLbl = new JLabel();
        imageLbl.setName("Standalone_AboutDlg_imageLbl");
        imageLbl.setIcon(ResourceManager.getInstance().getImage("about.jpg"));
        imageLbl.setBounds(0, 0, 400, 150);
        JLabel imageLogoLbl = new JLabel();
        imageLogoLbl.setIcon(ResourceManager.getInstance().getImage("logo.png"));
        imageLogoLbl.setBounds(new Rectangle(0, 0, 80, 74));
        JPanel jPanel1 = new JPanel();
        jPanel1.setBorder(border1);
        jPanel1.setBounds(new Rectangle(10, 170, 375, 86));
        jPanel1.setLayout(null);
        jPanel1.add((Component)imageLogoLbl, null);
        jPanel1.add((Component)productLbl, null);
        jPanel1.add((Component)this.huaweiLink, null);
        jPanel1.add((Component)rightReservedLbl, null);
        jPanel1.add((Component)copyRightLbl, null);
        aboutPanel.add((Component)imageLbl, null);
        aboutPanel.add((Component)jPanel1, null);
        this.getContentPane().add((Component)aboutPanel, "Center");
        ActionListener escKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDlg.this.dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.rootPane.registerKeyboardAction(escKeyHandler, keyStroke, 0);
    }

    private String getVersionFromXML() {
        String packageName;
        String strDiscription;
        this.language = ConfigurationInfo.getInstance().getLocale().getLanguage().toUpperCase(ResourceMng.getInstance().getLocale());
        try {
            String defaultStyledir = ConfigurationInfo.getInstance().getProductStyleDir();
            String aboutDirectoryName = defaultStyledir + "conf" + "/" + "about";
            if (ConfigurationInfo.getInstance().isConfigFilesInJar()) {
                this.loadFromJar(aboutDirectoryName);
            } else {
                this.loadFromFolder(aboutDirectoryName);
            }
        }
        catch (Exception e) {
            return "";
        }
        if (null != this.m_PatchHashTable) {
            strDiscription = (String)this.m_PatchHashTable.get("package_description");
            packageName = "";
            try {
                packageName = new String(strDiscription.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (Exception e) {
                return "";
            }
            String packageVersion = (String)this.m_PatchHashTable.get("package_version");
            return packageName + "(" + packageVersion + ")";
        }
        if (null != this.m_AboutHashTable) {
            strDiscription = (String)this.m_AboutHashTable.get("package_description");
            packageName = "";
            try {
                packageName = new String(strDiscription.getBytes("GB2312"), "GB2312");
            }
            catch (Exception e) {
                return "";
            }
            String packageVersion = (String)this.m_AboutHashTable.get("package_version");
            return packageName + "(" + packageVersion + ")";
        }
        return "";
    }

    private void loadFromJar(String aboutDirectoryName) {
        try {
            String fileName = ConfigurationInfo.getInstance().getStyleDirectory() + "DC_package.xml";
            Document document = ConfigurationInfo.getInstance().loadDocumentFromFile(fileName);
            if (null == document) {
                fileName = ConfigurationInfo.getInstance().getStyleDirectory() + "DC_package_patch.xml";
                document = ConfigurationInfo.getInstance().loadDocumentFromFile(fileName);
            }
            this.m_AboutHashTable = new Hashtable(100);
            this.m_PatchHashTable = this.load(document, this.m_PatchHashTable);
        }
        catch (Exception e) {
            DebugTracer.trace((Exception)e);
        }
    }

    private void loadFromFolder(String aboutDirectoryName) throws IOException {
        File aboutDirectory = new File(aboutDirectoryName);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File aFilePath) {
                if (aFilePath.isFile()) {
                    String strFileName = aFilePath.getName();
                    return strFileName.toLowerCase(ResourceMng.getInstance().getLocale()).endsWith(".xml");
                }
                return aFilePath.isDirectory();
            }
        };
        File[] aboutXmlFiles = aboutDirectory.listFiles(fileFilter);
        if (aboutXmlFiles != null && aboutXmlFiles.length > 0) {
            int fileListLength = aboutXmlFiles.length;
            for (int i = 0; i < fileListLength; ++i) {
                Document document;
                if (Collator.getInstance().equals(aboutXmlFiles[i].getName(), "DC_package.xml")) {
                    this.m_AboutHashTable = new Hashtable(100);
                    document = ConfigurationInfo.getInstance().loadDocumentFromFile(aboutXmlFiles[i].getAbsolutePath());
                    this.m_AboutHashTable = this.load(document, this.m_AboutHashTable);
                }
                if (!Collator.getInstance().equals(aboutXmlFiles[i].getName(), "DC_package_patch.xml")) continue;
                this.m_PatchHashTable = new Hashtable(100);
                document = ConfigurationInfo.getInstance().loadDocumentFromFile(aboutXmlFiles[i].getAbsolutePath());
                this.m_PatchHashTable = this.load(document, this.m_PatchHashTable);
            }
        }
    }

    public Hashtable load(Document document, Hashtable hashTable) {
        if (null == document) {
            return null;
        }
        Element rootNode = document.getDocumentElement();
        rootNode.normalize();
        NodeList rootNodeList = rootNode.getElementsByTagName("AREADESC");
        Element areanameNode = (Element)rootNodeList.item(0);
        NodeList descNodeList = areanameNode.getElementsByTagName("DESC");
        String displayProperties = "DISPLAYNAME_" + this.language;
        String displayname = "";
        for (int i = 0; i < descNodeList.getLength(); ++i) {
            Node descNode = descNodeList.item(i);
            NamedNodeMap descNodeMap = descNode.getAttributes();
            Node packageTypeNode = descNodeMap.getNamedItem("descname");
            String strPackageType = "";
            if (packageTypeNode != null) {
                strPackageType = packageTypeNode.getNodeValue();
            }
            NodeList parameters = ((Element)descNode).getElementsByTagName("PARAS");
            int parametersLength = parameters.getLength();
            for (int j = 0; j < parametersLength; ++j) {
                NodeList paramNameValueList = ((Element)parameters.item(j)).getElementsByTagName("PARA");
                int parameterLength = paramNameValueList.getLength();
                for (int k = 0; k < parameterLength; ++k) {
                    Node parameter = paramNameValueList.item(k);
                    NamedNodeMap map = parameter.getAttributes();
                    Node nameNode = map.getNamedItem("name");
                    String name = "";
                    if (nameNode != null) {
                        name = nameNode.getNodeValue();
                    }
                    Node valueNode = map.getNamedItem("value");
                    String value = "";
                    if (valueNode != null) {
                        value = valueNode.getNodeValue();
                    }
                    if (!Collator.getInstance().equals(name, displayProperties)) continue;
                    displayname = value;
                }
                if (strPackageType.length() <= 0) continue;
                hashTable.put(strPackageType, displayname);
            }
        }
        return hashTable;
    }
}

