/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.standalone.IStandAloneInitializer;
import com.huawei.dc.standalone.StreamReaderThread;
import com.huawei.dc.standalone.startup.DCStandaloneDebugTracer;
import com.swimap.iview.framework.Main;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class StandAloneInitializer
implements IStandAloneInitializer {
    private static IStandAloneInitializer m_oInstance;
    private Process m_oDCServerProcess;
    private Process m_oMDPProcess;
    private Process m_oTKServerProcess;
    private Runtime m_oRuntime;
    private boolean m_bFlag;
    private Object oSynObjForMDP = new Object();

    private StandAloneInitializer() {
        this.m_oRuntime = Runtime.getRuntime();
    }

    public static synchronized IStandAloneInitializer getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new StandAloneInitializer();
        }
        return m_oInstance;
    }

    public static void main(String[] args) {
        try {
            m_oInstance = null;
            StandAloneInitializer.getInstance().startStandAloneDC();
        }
        catch (Exception e) {
            DCStandaloneDebugTracer.trace(e);
            return;
        }
        ((StandAloneInitializer)StandAloneInitializer.getInstance()).setToNull();
    }

    @Override
    public void startMDP() throws Exception {
        DCStandaloneDebugTracer.trace("startMDP begin.");
        String strCurrPath = this.getiMapInstallationPath();
        String sMdpProcessName = strCurrPath + "\\" + "server\\bin" + "\\" + "mdp";
        DCStandaloneDebugTracer.trace("sMdpProcessName = " + sMdpProcessName);
        this.m_oMDPProcess = this.startProcess(sMdpProcessName, 5000L);
        DCStandaloneDebugTracer.trace("startMDP end.");
    }

    @Override
    public void startStandAloneDC() throws Exception {
        DCStandaloneDebugTracer.trace("startStandAloneDC start.");
        String strCurrPath = this.getiMapInstallationPath();
        String sDCServerProcessName = strCurrPath + "\\" + "server\\common\\dc\\bin" + "\\" + "DCServer";
        String STKServerProcessName = strCurrPath + "\\" + "server\\common\\toolkit\\server" + "\\" + "toolkit";
        this.m_oDCServerProcess = this.startProcess(sDCServerProcessName, 100L);
        this.m_oTKServerProcess = this.startProcess(STKServerProcessName, 100L);
        DCStandaloneDebugTracer.trace("startStandAloneDC end.");
    }

    @Override
    public void shutdownStandAloneDC() throws Exception {
        DCStandaloneDebugTracer.trace(this.getClass().getName() + "shut down standalone DC start");
        List<Process> oTelnetProcessList = DCFrameWorkUtil.getTelnetTerminalProcess();
        if (null != oTelnetProcessList) {
            for (int i = 0; i < oTelnetProcessList.size(); ++i) {
                this.shutDownProcess(oTelnetProcessList.get(i));
                this.pauseThread(500L);
            }
        }
        if (null != this.m_oDCServerProcess) {
            this.shutDownProcess(this.m_oDCServerProcess);
        }
        if (null != this.m_oTKServerProcess) {
            this.shutDownProcess(this.m_oTKServerProcess);
        }
        if (null != this.m_oMDPProcess) {
            this.shutDownProcess(this.m_oMDPProcess);
        }
        this.pauseThread(1000L);
        DCStandaloneDebugTracer.trace(this.getClass().getName() + "shut down standalone DC end..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process startProcess(String strProcessName, long lMillisToWait) throws Exception {
        DCStandaloneDebugTracer.trace("startProcess begin.");
        DCStandaloneDebugTracer.trace("strProcessName = " + strProcessName);
        String strCurrPath = this.getiMapInstallationPath();
        Process oProcess = null;
        String strNotifyFileName = strCurrPath + "\\" + "server\\common\\dc\\conf" + "\\Notify.cfg";
        File oFile = new File(strNotifyFileName);
        if (strProcessName.endsWith("mdp") || strProcessName.endsWith("toolkit")) {
            oProcess = this.m_oRuntime.exec(strProcessName);
        } else if (strProcessName.endsWith("DCServer")) {
            FileWriter oFileWriter = null;
            Writer oWriter = null;
            try {
                oFileWriter = new FileWriter(oFile);
                oWriter = new BufferedWriter(oFileWriter);
                oWriter.write(48);
                oProcess = this.m_oRuntime.exec(strProcessName);
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            finally {
                try {
                    if (null != oWriter) {
                        oWriter.close();
                    }
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        if (null == oProcess) {
            DCStandaloneDebugTracer.trace("startProcess begin(progress is null).");
            throw new Exception(ResourceManager.getInstance().getResString("DC_PROCESSES_COULD_NOT_START", new String[]{strProcessName}));
        }
        StreamReaderThread oThread1 = null;
        oThread1 = strProcessName.endsWith("mdp") ? new StreamReaderThread(oProcess.getInputStream(), 0, this.oSynObjForMDP, true) : new StreamReaderThread(oProcess.getInputStream(), 0);
        StreamReaderThread oThread2 = new StreamReaderThread(oProcess.getErrorStream(), 1);
        oThread1.start();
        oThread2.start();
        if (strProcessName.endsWith("DCServer")) {
            int iContent = 0;
            this.m_bFlag = true;
            Thread oThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(StandAloneInitializer.getDCServerTimeoutPeriod());
                        StandAloneInitializer.this.setTimeOut(false);
                    }
                    catch (InterruptedException e) {
                        DCStandaloneDebugTracer.trace(e);
                    }
                }
            });
            oThread.start();
            BufferedReader oReader = null;
            FileReader oFileReader = null;
            try {
                while (this.m_bFlag) {
                    this.pauseThread(lMillisToWait);
                    oFileReader = new FileReader(oFile);
                    oReader = new BufferedReader(oFileReader);
                    iContent = oReader.read();
                    if (49 == iContent) {
                        this.pauseThread(lMillisToWait);
                        this.m_bFlag = false;
                    }
                    oReader.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            finally {
                try {
                    if (null != oReader) {
                        oReader.close();
                    }
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (49 == iContent) {
                DCStandaloneDebugTracer.trace("startProcess end(iContent = 1).");
                return oProcess;
            }
        } else {
            this.pauseThread(lMillisToWait);
            if (this.isProcessRunning(oProcess)) {
                DCStandaloneDebugTracer.trace("startProcess end(progress is running.)");
                return oProcess;
            }
        }
        DCStandaloneDebugTracer.trace("startProcess end.");
        throw new Exception(ResourceManager.getInstance().getResString("DC_PROCESSES_COULD_NOT_START", new String[]{strProcessName}));
    }

    protected void setTimeOut(boolean bFlag) {
        this.m_bFlag = bFlag;
    }

    private String getiMapInstallationPath() {
        File oCurrDir = new File(".");
        File oDC_Cli_Lib = new File(oCurrDir.getAbsolutePath());
        File oDC_Cli = oDC_Cli_Lib.getParentFile();
        if (null == oDC_Cli) {
            return "";
        }
        File oIMap = oDC_Cli.getParentFile();
        if (null == oIMap) {
            return "";
        }
        return oIMap.getAbsolutePath();
    }

    private void shutDownProcess(Process oProcess) throws Exception {
        DCStandaloneDebugTracer.trace(this.getClass().getName() + "shutdown Process start");
        DCStandaloneDebugTracer.trace(" oProcess " + oProcess.toString());
        oProcess.destroy();
        int iExitValue = this.getExitValueOfProcess(oProcess);
        String sProcessName = oProcess.toString();
        if (-1 == iExitValue) {
            throw new Exception(ResourceManager.getInstance().getResString("DC_PROCESSES_COULD_NOT_STOP", new String[]{sProcessName}));
        }
        DCStandaloneDebugTracer.trace(this.getClass().getName() + "shutdown Process end..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseThread(long lMillis) {
        Object object = this.oSynObjForMDP;
        synchronized (object) {
            try {
                this.oSynObjForMDP.wait(lMillis);
            }
            catch (InterruptedException e) {
                DCStandaloneDebugTracer.trace(e);
            }
        }
    }

    public void startClient() {
        String[] str = new String[]{"DCClient"};
        Main.main((String[])str);
    }

    private int getExitValueOfProcess(Process oProcess) {
        int MAX_VALUE = 600;
        for (int iCounter = 0; iCounter < 600; ++iCounter) {
            try {
                return oProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this.pauseThread(100L);
                continue;
            }
        }
        return -1;
    }

    private boolean isProcessRunning(Process oProcess) {
        try {
            oProcess.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            DCStandaloneDebugTracer.trace(e);
            return true;
        }
    }

    public void setToNull() {
        this.m_oRuntime = null;
        this.m_oMDPProcess = null;
        this.m_oDCServerProcess = null;
        this.m_oTKServerProcess = null;
        m_oInstance = null;
    }

    private static long getDCServerTimeoutPeriod() {
        long iMilliSeconds = 30000L;
        String strSeconds = ResourceManager.getInstance().getResString("DC_Server_Timeout_Period", "config");
        iMilliSeconds = Long.parseLong(strSeconds);
        return iMilliSeconds;
    }
}

