/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone;

import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.IOStreamClose;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class StandAloneDomainInfo {
    private int m_iCurrentSelectedDomain = 4;
    private static StandAloneDomainInfo m_instance = null;
    private boolean m_isShow = true;
    private static final int SWITCH1_INITIALIZATION_DEV_ID = 1000000;
    private static final int ROUTER_INITIALIZATION_DEV_ID = 2000000;
    private static final int BMS_INITIALIZATION_DEV_ID = 3000000;
    private static final int T2000_INITIALIZATION_DEV_ID = 4000000;
    private int m_iInitializationDevId = 2000000;

    private StandAloneDomainInfo() {
        String sLoginMode = System.getProperty("DCLoginMode", "0");
        DCDebugTracer.trace("The DCLoginMode =" + sLoginMode);
        if ("0".equals(sLoginMode)) {
            this.initSelectionInfo();
        }
    }

    public static synchronized StandAloneDomainInfo getInstance() {
        if (null == m_instance) {
            m_instance = new StandAloneDomainInfo();
        }
        return m_instance;
    }

    public void setSelectedDomain(int iDomain) {
        this.m_iCurrentSelectedDomain = iDomain;
        switch (iDomain) {
            case 1: {
                this.m_iInitializationDevId = 1000000;
                break;
            }
            case 2: {
                this.m_iInitializationDevId = 2000000;
                break;
            }
            case 3: {
                this.m_iInitializationDevId = 3000000;
                break;
            }
            case 4: {
                this.m_iInitializationDevId = 4000000;
                break;
            }
            default: {
                this.m_iInitializationDevId = 4000000;
            }
        }
        this.nelicMenuReInit();
    }

    public void nelicMenuReInit() {
        try {
            if (null == DCFrameWorkUtil.getDCModuleManager()) {
                return;
            }
            MenuManager oMenuManager = (MenuManager)DCFrameWorkUtil.getDCModuleManager().getModule("mainmenumanager");
            if (null == oMenuManager) {
                return;
            }
            Menu m_oneLicenseMenu = oMenuManager.getMenu("mainMenu", "neLicense");
            if (3 != this.m_iCurrentSelectedDomain && null != m_oneLicenseMenu && null != m_oneLicenseMenu.getMenuItem("neLicenseManage")) {
                m_oneLicenseMenu.getMenuItem("neLicenseManage").setVisible(true);
            }
        }
        catch (ModuleManagementException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
    }

    public int getSelectedDomain() {
        return this.m_iCurrentSelectedDomain;
    }

    public boolean getIsShow() {
        return this.m_isShow;
    }

    public void updateSelectInfo(int iDomain, boolean isShow) {
        this.setSelectedDomain(iDomain);
    }

    public int getInitializationDevId() {
        return this.m_iInitializationDevId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSelectionInfo() {
        String strFileName = ConfigurationInfo.getInstance().getStyleDirectory() + "selectionInfoForLogin.properties";
        FileInputStream oFileInputStream = null;
        try {
            oFileInputStream = new FileInputStream(strFileName);
            Properties properties = new Properties();
            properties.load(oFileInputStream);
            int iDomain = Integer.valueOf(properties.getProperty("SELECT_DOMAIN_INFO"));
            this.setSelectedDomain(iDomain);
            String strIsShow = properties.getProperty("IS_SHOW");
            this.m_isShow = "yes".equalsIgnoreCase(strIsShow);
        }
        catch (Exception e) {
            try {
                DCDebugTracer.trace("initSelectionInfo : " + strFileName);
                DCDebugTracer.trace(e);
            }
            catch (Throwable throwable) {
                IOStreamClose.close(oFileInputStream);
                throw throwable;
            }
            IOStreamClose.close(oFileInputStream);
        }
        IOStreamClose.close(oFileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recordSelectionInfo(int iDomain, boolean isShow) {
        Properties properties = new Properties();
        properties.setProperty("SELECT_DOMAIN_INFO", String.valueOf(iDomain));
        if (isShow) {
            properties.setProperty("IS_SHOW", "yes");
        } else {
            properties.setProperty("IS_SHOW", "no");
        }
        String strFileName = ConfigurationInfo.getInstance().getStyleDirectory() + "selectionInfoForLogin.properties";
        FileOutputStream fout = null;
        boolean isThrowException = true;
        try {
            fout = new FileOutputStream(strFileName);
            properties.store(fout, "this is for select info.");
            this.m_isShow = isShow;
        }
        catch (Exception e) {
            try {
                DCDebugTracer.trace(e);
                DCDebugTracer.trace("recordSelectionInfo : " + strFileName);
                isThrowException = false;
            }
            catch (Throwable throwable) {
                IOStreamClose.close(fout);
                throw throwable;
            }
            IOStreamClose.close(fout);
        }
        IOStreamClose.close(fout);
        return isThrowException;
    }
}

