/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.security;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCLoginReq;
import com.huawei.dc.common.asndatacenter.AsnDCLoginRsp;
import com.huawei.dc.common.asndatacenter.AsnDCLogoutReq;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.security.ISecurityManager;
import com.huawei.dc.security.LoginInfo;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;

public class SecurityManagerImpl
implements ISecurityManager,
IDeviceConfigChangeListener,
IDCObjectDeallocator {
    private int clientId;
    public LoginInfo loginInfo;
    private AsnDCIntegerLst m_oAsnDCDeviceIdLst;
    private AsnDCIntegerLst m_oAsnDCDevIdAccessLst = null;
    private TIntHashSet m_setOfDevices = null;
    private int m_iUserId;
    private String m_UserPwd;
    private boolean isGetDevLst = false;

    public SecurityManagerImpl() {
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
    }

    @Override
    public int doLogin(String aUserName, int iSessionId, int iUserId, char[] aStrPassword) {
        int returnCode;
        final BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        final AsnDCLoginReq asnLoginReq = new AsnDCLoginReq();
        asnLoginReq.oAsnDomainPEnum.value = DCFrameWorkUtil.getIsSingleClient() ? StandAloneDomainInfo.getInstance().getSelectedDomain() : 0;
        asnLoginReq.iSessionID = BigInteger.valueOf(iSessionId);
        asnLoginReq.iUserId = BigInteger.valueOf(iUserId);
        asnLoginReq.strUserName = aUserName.getBytes();
        asnLoginReq.strPassword = StringUtils.convertCharsToBytes(aStrPassword);
        final AsnDCLoginRsp asnLoginRsp = new AsnDCLoginRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = commManager.sendSyncMsg(BaseCommManager.getMSGHead(43813), (FStruct)asnLoginReq, (FStruct)asnLoginRsp, 25000);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCDebugTracer.trace("send syn msg error cmdcode=43813");
            return returnCode;
        }
        int errorcode = asnLoginRsp.oErrorInfo.iErrorNo.intValue();
        if (errorcode != 0) {
            return errorcode;
        }
        this.loginInfo = new LoginInfo();
        this.loginInfo.setUserName(aUserName);
        if (errorcode == 0) {
            this.clientId = asnLoginRsp.iClientIdOpt.intValue();
        }
        DCDebugTracer.trace("clientId = " + this.clientId);
        return errorcode;
    }

    @Override
    public LoginInfo getLoginInfo() {
        return this.loginInfo;
    }

    @Override
    public int doLogOut() {
        int returnCode;
        final BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        final AsnDCLogoutReq asnLogoutReq = new AsnDCLogoutReq();
        asnLogoutReq.iClientId = BigInteger.valueOf(this.clientId);
        final AsnDCOpertionRsp asnOperationRsp = new AsnDCOpertionRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = commManager.sendSyncMsg(BaseCommManager.getMSGHead(43814), (FStruct)asnLogoutReq, (FStruct)asnOperationRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            return returnCode;
        }
        int errorcode = asnOperationRsp.oErrorInfo.iErrorNo.intValue();
        return errorcode;
    }

    @Override
    public int getClientId() {
        return this.clientId;
    }

    @Override
    public TIntHashSet getSetOfDevices() {
        return this.m_setOfDevices;
    }

    @Override
    public AsnDCIntegerLst getAsnListOfDevices() {
        return this.m_oAsnDCDeviceIdLst;
    }

    @Override
    public synchronized boolean isGetDevLst() {
        return this.isGetDevLst;
    }

    @Override
    public synchronized void setGetDevLst(boolean isGetDevLst) {
        this.isGetDevLst = isGetDevLst;
    }

    @Override
    public synchronized int getDevAccessList() {
        int returnCode;
        final BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        final AsnDCLogoutReq asnDCLogoutReq = new AsnDCLogoutReq();
        int clientId = this.getClientId();
        asnDCLogoutReq.iClientId = BigInteger.valueOf(clientId);
        final AsnDCLoginRsp asnDCLoginRsp = new AsnDCLoginRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = commManager.sendSyncMsg(BaseCommManager.getMSGHead(43839), (FStruct)asnDCLogoutReq, (FStruct)asnDCLoginRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            return returnCode;
        }
        int errorcode = asnDCLoginRsp.oErrorInfo.iErrorNo.intValue();
        if (errorcode != 0) {
            return errorcode;
        }
        if (null != asnDCLoginRsp.oAsnDevIdAccessLst) {
            this.m_oAsnDCDevIdAccessLst = asnDCLoginRsp.oAsnDevIdAccessLst;
            this.convertLstToVerList();
            this.m_setOfDevices = new TIntHashSet();
            for (int i = 0; i < this.m_oAsnDCDevIdAccessLst.size(); ++i) {
                BigInteger iDevID = (BigInteger)this.m_oAsnDCDevIdAccessLst.elementAt(i);
                this.m_setOfDevices.add(iDevID.intValue());
            }
            DCDebugTracer.trace("get access device list success : " + this.m_setOfDevices.size());
        }
        return errorcode;
    }

    private void convertLstToVerList() {
        this.m_oAsnDCDeviceIdLst = new AsnDCIntegerLst();
        if (this.m_oAsnDCDevIdAccessLst != null) {
            for (int i = 0; i < this.m_oAsnDCDevIdAccessLst.size(); ++i) {
                BigInteger iDevID = (BigInteger)this.m_oAsnDCDevIdAccessLst.elementAt(i);
                this.m_oAsnDCDeviceIdLst.add((Object)iDevID);
            }
        }
    }

    public void handleDeviceAddNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || 0 == oDeviceInfoList.size()) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            BigInteger iDevID = oAsnDeviceInfo.oDeviceInfo.iDevId;
            if (null == this.m_setOfDevices) {
                this.m_setOfDevices = new TIntHashSet();
            }
            this.m_setOfDevices.add(iDevID.intValue());
            if (null == this.m_oAsnDCDeviceIdLst) {
                this.m_oAsnDCDeviceIdLst = new AsnDCIntegerLst();
            }
            this.m_oAsnDCDeviceIdLst.add((Object)iDevID);
        }
    }

    public void handleDeviceDeleteNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || 0 == oDeviceInfoList.size()) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            BigInteger iDeleteDeviceId = oAsnDeviceInfo.oDeviceInfo.iDevId;
            if (null != this.m_oAsnDCDeviceIdLst) {
                this.m_oAsnDCDeviceIdLst.remove((Object)iDeleteDeviceId);
            }
            if (null == this.m_setOfDevices) continue;
            this.m_setOfDevices.remove(iDeleteDeviceId.intValue());
        }
    }

    @Override
    public int getUserId() {
        return this.m_iUserId;
    }

    @Override
    public void setUserPwd(String pwd) {
        this.m_UserPwd = pwd;
    }

    @Override
    public String getUserPwd() {
        return this.m_UserPwd;
    }

    @Override
    public void setUserId(int iUserId) {
        this.m_iUserId = iUserId;
    }

    @Override
    public void setToNULL() {
        this.loginInfo = null;
        if (null != this.m_oAsnDCDeviceIdLst) {
            this.m_oAsnDCDeviceIdLst.clear();
            this.m_oAsnDCDeviceIdLst = null;
        }
        if (null != this.m_oAsnDCDevIdAccessLst) {
            this.m_oAsnDCDevIdAccessLst.clear();
            this.m_oAsnDCDevIdAccessLst = null;
        }
        if (null != this.m_setOfDevices) {
            this.m_setOfDevices.clear();
            this.m_setOfDevices = null;
        }
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst deviceInfoList) {
        switch (iEventType) {
            case 0: {
                this.handleDeviceAddNotification(deviceInfoList);
                break;
            }
            case 1: {
                this.handleDeviceDeleteNotification(deviceInfoList);
                break;
            }
        }
    }
}

