/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view.search;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.sam.view.SAMFileInfoTablePanel;
import com.huawei.dc.sam.view.search.SAMSearchCriteria;
import com.huawei.dc.sam.view.search.SAMSearchDialog;
import com.huawei.dc.sam.view.search.SAMSearchManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class SAMSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DefaultComboBoxModel m_oSearchHistoryModel;
    private JLabel m_oSearchLabel;
    private ComboBoxWithToolTip m_oSearchHistoryDropdown;
    private JButton m_oSearchButton;
    private int SEARCH_HISTORY_MAX_SIZE = 5;
    private boolean m_bProcessSearch;
    private SAMFileInfoTablePanel m_oSAMFileInfoTablePanel;
    private SAMSearchManager m_oSAMSearchManager;
    private JButton m_oOkButton;

    public SAMSearchPanel(SAMFileInfoTablePanel oSAMFileInfoTablePanel) {
        this.m_oSAMFileInfoTablePanel = oSAMFileInfoTablePanel;
        SAMSearchDialog oSAMSearchDialog = new SAMSearchDialog(this, this.m_oSAMFileInfoTablePanel);
        this.m_oSAMSearchManager = new SAMSearchManager(oSAMSearchDialog, this.m_oSAMFileInfoTablePanel);
        this.jInit();
        this.m_bProcessSearch = true;
    }

    private void jInit() {
        this.initializeFields();
        this.addFieldsToPanel();
        this.initalizeListenersForFields();
        this.initializeKeyEventForF3();
    }

    private void initializeFields() {
        this.m_oSearchLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SEARCH_PANEL_SEARCH_LABEL"));
        this.m_oSearchHistoryModel = new DefaultComboBoxModel();
        this.m_oSearchHistoryDropdown = new ComboBoxWithToolTip((ComboBoxModel)this.m_oSearchHistoryModel);
        this.m_oSearchHistoryDropdown.setName("sam_SAMSearchPanel_m_oSearchHistoryDropdown");
        this.m_oSearchHistoryDropdown.setEditable(true);
        this.m_oSearchButton = new JButton(DCFrameWorkUtil.getLocalizedString("SEARCH_PANEL_SEARCH_BUTTON_LABEL"));
        this.m_oSearchButton.setName("sam_SAMSearchPanel_m_oSearchButton");
        this.m_oSearchButton.setToolTipText(DCFrameWorkUtil.getLocalizedString("SEARCH_SAM"));
        this.m_oSearchButton.setMnemonic('F');
        this.m_oSearchButton.setPreferredSize(new Dimension(120, 23));
        this.m_oOkButton = new JButton(DCFrameWorkUtil.getLocalizedString("FIND_NEXT_BUTTON"));
        this.m_oOkButton.setName("DeviceView_DeviceSearchPanel_m_oOkButton");
        this.m_oOkButton.setToolTipText(DCFrameWorkUtil.getLocalizedString("FIND_NEXT_BUTTON"));
        this.m_oOkButton.setMnemonic('I');
        this.m_oOkButton.setPreferredSize(new Dimension(120, 23));
    }

    private void addFieldsToPanel() {
        GridBagLayout oGrid = new GridBagLayout();
        this.setLayout(oGrid);
        GridBagConstraints oConstraints = new GridBagConstraints();
        oConstraints.fill = 2;
        oConstraints.insets = new Insets(8, 12, 4, 1);
        oConstraints.anchor = 17;
        oConstraints.ipady = -4;
        oConstraints.gridwidth = 2;
        oConstraints.gridheight = 1;
        oConstraints.gridx = 0;
        oConstraints.gridy = 0;
        oConstraints.weightx = 0.0;
        this.add((Component)this.m_oSearchLabel, oConstraints);
        oConstraints.insets = new Insets(8, 12, 4, 2);
        oConstraints.gridwidth = 10;
        oConstraints.gridheight = 1;
        oConstraints.gridx = 2;
        oConstraints.gridy = 0;
        oConstraints.weightx = 0.25;
        this.add((Component)this.m_oSearchHistoryDropdown, oConstraints);
        oConstraints.anchor = 13;
        oConstraints.insets = new Insets(8, 12, 8, 12);
        oConstraints.gridwidth = 2;
        oConstraints.gridheight = 1;
        oConstraints.gridx = -1;
        oConstraints.weightx = 0.0;
        oConstraints.gridy = 0;
        this.add((Component)this.m_oSearchButton, oConstraints);
        oConstraints.anchor = 13;
        oConstraints.insets = new Insets(8, 0, 8, 12);
        oConstraints.gridwidth = 2;
        oConstraints.gridheight = 1;
        oConstraints.gridx = -1;
        oConstraints.weightx = 0.0;
        oConstraints.gridy = 0;
        this.add((Component)this.m_oOkButton, oConstraints);
    }

    private void initalizeListenersForFields() {
        this.m_oSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SAMSearchPanel.this.openSearchDialog();
            }
        });
        this.m_oOkButton.addActionListener(this.generateActionListenerForSearchHistory());
    }

    private ActionListener generateActionListenerForSearchHistory() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (null == SAMSearchPanel.this.m_oSearchHistoryDropdown) {
                    return;
                }
                SAMSearchPanel.this.searchFromHistory();
                SAMSearchPanel.this.m_oSearchHistoryDropdown.setPrototypeDisplayValue(20);
            }
        };
    }

    private void searchFromHistory() {
        Object oCriteria;
        if (!this.m_bProcessSearch) {
            return;
        }
        if (0 == this.m_oSearchHistoryDropdown.getItemCount()) {
            Object strContent = this.m_oSearchHistoryDropdown.getModel().getSelectedItem();
            if (null == strContent || strContent.toString().trim().isEmpty()) {
                DCOptionPane.showWarningDialog(this, DCFrameWorkUtil.getLocalizedString("CONDITION_EMPTY"));
                return;
            }
            this.m_oSearchHistoryDropdown.insertItemAt(strContent, 0);
        }
        if (null == (oCriteria = this.m_oSearchHistoryDropdown.getSelectedItem()) || oCriteria.toString().trim().isEmpty()) {
            DCOptionPane.showWarningDialog(this, DCFrameWorkUtil.getLocalizedString("CONDITION_EMPTY"));
            return;
        }
        int iStatusCode = this.m_oSAMSearchManager.findNextDevice(oCriteria);
        if (100 != iStatusCode) {
            this.processErrorCode(iStatusCode);
        }
    }

    private void initializeKeyEventForF3() {
        ActionListener f3KeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAMSearchPanel.this.openSearchDialog();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(114, 0);
        this.registerKeyboardAction(f3KeyHandler, keyStroke, 2);
    }

    private void openSearchDialog() {
        SAMSearchDialog oDialog = new SAMSearchDialog(this, this.m_oSAMFileInfoTablePanel);
        oDialog.setVisible(true);
    }

    public void updateSearchHistoryModel(SAMSearchCriteria oCriteria) {
        int iModelSize = this.m_oSearchHistoryDropdown.getItemCount();
        if (this.SEARCH_HISTORY_MAX_SIZE == iModelSize) {
            this.m_oSearchHistoryModel.removeElementAt(iModelSize - 1);
        }
        this.m_bProcessSearch = false;
        if (this.isCriteriaAlreadyPresentInModel(oCriteria)) {
            this.m_oSearchHistoryDropdown.setSelectedItem(oCriteria);
            this.m_bProcessSearch = true;
            return;
        }
        boolean iStartIndex = false;
        this.m_oSearchHistoryModel.insertElementAt(oCriteria, 0);
        this.m_oSearchHistoryDropdown.setSelectedItem(oCriteria);
        this.m_bProcessSearch = true;
    }

    private boolean isCriteriaAlreadyPresentInModel(Object oCriteria) {
        int iModelSize = this.m_oSearchHistoryDropdown.getItemCount();
        Object oExistingCriteria = null;
        for (int i = 0; i < iModelSize; ++i) {
            oExistingCriteria = this.m_oSearchHistoryModel.getElementAt(i);
            if (null == oExistingCriteria || !oCriteria.equals(oExistingCriteria)) continue;
            return true;
        }
        return false;
    }

    protected void processErrorCode(int ErrorCode) {
        if (101 == ErrorCode) {
            DCOptionPane.showWarningDialog(this, DCFrameWorkUtil.getLocalizedString("SAM_SEARCH_STATUS_ZERO_RESULTS"));
        }
    }

    public void disposePanel() {
        this.m_oSearchHistoryModel = null;
        this.m_oSearchLabel = null;
        this.m_oSearchHistoryDropdown = null;
        this.m_oSearchButton = null;
        this.m_oOkButton = null;
        if (null != this.m_oSAMSearchManager) {
            this.m_oSAMSearchManager.cleanUp();
        }
        this.m_oSAMSearchManager = null;
        this.m_oSAMFileInfoTablePanel = null;
    }

    public JButton getSearchBtn() {
        return this.m_oOkButton;
    }
}

