/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view.search;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.AbstractDeviceSearchManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchCriteria;
import com.huawei.dc.sam.view.SAMFileInfoTablePanel;
import com.huawei.dc.sam.view.search.ISAMSearchManager;
import com.huawei.dc.sam.view.search.SAMSearchCriteria;
import com.huawei.dc.sam.view.search.SAMSearchDialog;
import com.huawei.dc.sam.view.search.SAMSearchPanel;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Component;
import java.text.Collator;
import javax.swing.JTable;

public class SAMSearchManager
extends AbstractDeviceSearchManager
implements ISAMSearchManager {
    private SAMSearchDialog m_oSAMSearchDialog;
    private SAMFileInfoTablePanel m_oSAMFileInfoTablePanel;

    public SAMSearchManager(SAMSearchDialog oSAMSearchDialog, SAMFileInfoTablePanel oSAMFileInfoTablePanel) {
        this.m_oSAMSearchDialog = oSAMSearchDialog;
        this.m_oSAMFileInfoTablePanel = oSAMFileInfoTablePanel;
    }

    @Override
    public void storeSearchCriteria(SAMSearchPanel oSAMSearchPanel, SAMSearchCriteria oSearchCriteria) {
        oSAMSearchPanel.updateSearchHistoryModel(oSearchCriteria);
    }

    @Override
    public int validateSearchString(String strSearchString) {
        if (null == strSearchString || 0 == strSearchString.length()) {
            return 14;
        }
        return this.isValidNameSearchString(strSearchString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int isValidNameSearchString(String strSearchName) {
        String strName = null;
        String strExt = null;
        int iDotIndex = strSearchName.indexOf(46);
        int strLen = strSearchName.length();
        if (-1 != strSearchName.indexOf("*")) {
            if (-1 != iDotIndex) {
                strName = strSearchName.substring(0, iDotIndex);
                if (iDotIndex + 1 >= strLen) return 10;
                strExt = strSearchName.substring(iDotIndex + 1);
            } else {
                strName = strSearchName;
            }
        }
        if (null != strName && -1 != strName.indexOf("*") && !strName.endsWith("*")) {
            return 11;
        }
        if (null != strName && -1 != strName.indexOf("*") && strName.lastIndexOf("*") != strName.indexOf("*")) {
            return 12;
        }
        if (null == strExt || -1 == strExt.indexOf("*") || 1 >= strExt.length()) return 9;
        return 13;
    }

    @Override
    public void processErrorCode(int errorCode) {
        switch (errorCode) {
            case 14: {
                this.showErrorMessageFor("SAM_SEARCH_EMPTY_STRING_ERROR");
                return;
            }
            case 10: {
                this.showErrorMessageFor("SAM_SEARCH_DOT_AT_END_ERROR");
                return;
            }
            case 11: {
                this.showErrorMessageFor("SAM_SEARCH_INVALID_WILD_CHAR_IN_NAME_ERROR");
                return;
            }
            case 12: {
                this.showErrorMessageFor("SAM_SEARCH_MULTIPLE_WILD_CHAR_IN_NAME_ERROR");
                return;
            }
            case 13: {
                this.showErrorMessageFor("SAM_SEARCH_INVALID_WILD_CHAR_IN_EXT_ERROR");
                return;
            }
            case 101: {
                this.showErrorMessageFor("SAM_SEARCH_STATUS_ZERO_RESULTS");
                return;
            }
        }
    }

    protected void showErrorMessageFor(String strErrorMessage) {
        DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMSearchDialog), DCFrameWorkUtil.getLocalizedString(strErrorMessage), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 0);
    }

    @Override
    public int findNextDevice(Object oSearchInfo) {
        int iCurrentlySelectedIndex = -1;
        int iDirection = -1;
        if (oSearchInfo instanceof SAMSearchCriteria) {
            SAMSearchCriteria oSearchCriteria = (SAMSearchCriteria)oSearchInfo;
            this.selectedTreeNode(oSearchCriteria);
            iDirection = oSearchCriteria.getSearchDirection();
        } else {
            iDirection = 0;
        }
        iCurrentlySelectedIndex = this.getCurrentSelectedIndex(iDirection);
        int iSearchStatus = 0;
        iSearchStatus = this.searchFileInTable(oSearchInfo, iCurrentlySelectedIndex);
        return iSearchStatus;
    }

    @Override
    public int filterDevice(Object oSearchCriteria) {
        return 0;
    }

    public int findNextDevice(DeviceSearchCriteria strSearchCriteria, boolean bFirstTime) {
        return -1;
    }

    private void selectedTreeNode(SAMSearchCriteria oSearchCriteria) {
        if (null == oSearchCriteria.getDeviceTypeInfo()) {
            this.m_oSAMFileInfoTablePanel.selectRootNode();
        } else if (null == oSearchCriteria.getDeviceVersion()) {
            this.m_oSAMFileInfoTablePanel.selectDeviceTypeNode(oSearchCriteria.getDeviceTypeInfo());
        } else {
            this.m_oSAMFileInfoTablePanel.selectDeviceTypeNode(oSearchCriteria.getDeviceTypeInfo(), oSearchCriteria.getDeviceVersion());
        }
    }

    private int getCurrentSelectedIndex(int iDirection) {
        int iCurrentlySelectedIndex = this.m_oSAMFileInfoTablePanel.getTable().getSelectedRow();
        iCurrentlySelectedIndex = 0 == iDirection ? (iCurrentlySelectedIndex < this.m_oSAMFileInfoTablePanel.getTable().getRowCount() - 1 ? ++iCurrentlySelectedIndex : 0) : (iCurrentlySelectedIndex > 0 ? --iCurrentlySelectedIndex : this.m_oSAMFileInfoTablePanel.getTable().getRowCount() - 1);
        return iCurrentlySelectedIndex;
    }

    private int searchFileInTable(Object oSearchCriteria, int iCurrentlySelectedIndex) {
        if (0 == this.m_oSAMFileInfoTablePanel.getTable().getRowCount()) {
            return 101;
        }
        int iRowToBeSelected = -1;
        iRowToBeSelected = oSearchCriteria instanceof SAMSearchCriteria ? this.searchForRow((SAMSearchCriteria)oSearchCriteria, iCurrentlySelectedIndex) : this.searchForRow(oSearchCriteria.toString(), iCurrentlySelectedIndex);
        if (-1 == iRowToBeSelected) {
            return 101;
        }
        iCurrentlySelectedIndex = iRowToBeSelected;
        this.m_oSAMFileInfoTablePanel.getTable().getSelectionModel().setSelectionInterval(iRowToBeSelected, iRowToBeSelected);
        this.m_oSAMFileInfoTablePanel.showRow(iRowToBeSelected);
        return 100;
    }

    private int searchForRow(String oSearchCriteria, int iCurrentlySelectedIndex) {
        boolean isWholeWordMatch = false;
        boolean isCaseSensitive = false;
        String strSearchKey = oSearchCriteria;
        boolean bKeyFound = false;
        JTable oTable = this.m_oSAMFileInfoTablePanel.getTable();
        int iRowCount = oTable.getRowCount();
        int iBegin = iCurrentlySelectedIndex;
        int iEnd = iRowCount - 1;
        int iEnter = 0;
        for (int i = iBegin; i <= iEnd; ++i) {
            bKeyFound = this.searchFile((String)oTable.getValueAt(i, 1), strSearchKey, isWholeWordMatch, isCaseSensitive);
            if (!bKeyFound) {
                bKeyFound = this.searchFile(oTable.getValueAt(i, 2).toString(), strSearchKey, isWholeWordMatch, isCaseSensitive);
            }
            if (!bKeyFound) {
                bKeyFound = this.searchFile((String)oTable.getValueAt(i, 3), strSearchKey, isWholeWordMatch, isCaseSensitive);
            }
            if (!bKeyFound) {
                bKeyFound = this.searchFile((String)oTable.getValueAt(i, 5), strSearchKey, isWholeWordMatch, isCaseSensitive);
            }
            if (!bKeyFound) {
                bKeyFound = this.searchFile(oTable.getValueAt(i, 6).toString(), strSearchKey, isWholeWordMatch, isCaseSensitive);
            }
            if (bKeyFound) {
                return i;
            }
            if (i <= 0 || i != iEnd || false != iEnter) continue;
            iEnd = iBegin;
            i = -1;
            ++iEnter;
        }
        return -1;
    }

    private int searchForRow(SAMSearchCriteria oSearchCriteria, int iCurrentlySelectedIndex) {
        int iDirection = oSearchCriteria.getSearchDirection();
        int iFindRow = -1;
        iFindRow = 0 == iDirection ? this.downDirectionSearch(oSearchCriteria, iCurrentlySelectedIndex) : this.upDirectionSearch(oSearchCriteria, iCurrentlySelectedIndex);
        return iFindRow;
    }

    private int upDirectionSearch(SAMSearchCriteria oSearchCriteria, int iCurrentlySelectedIndex) {
        boolean isWholeWordMatch = oSearchCriteria.isMatchWholeWord();
        boolean isCaseSensitive = oSearchCriteria.isCaseSensitive();
        String strSearchKey = oSearchCriteria.getSearchString();
        String strContentSearch = null;
        if (null != oSearchCriteria.getContentType()) {
            strContentSearch = oSearchCriteria.getContentType().toString();
        }
        boolean bKeyFound = false;
        JTable oTable = this.m_oSAMFileInfoTablePanel.getTable();
        int iRowCount = oTable.getRowCount();
        int iBegin = iCurrentlySelectedIndex;
        int iEnd = 0;
        int iEnter = 0;
        for (int i = iBegin; i >= iEnd; --i) {
            if (null == strContentSearch) {
                bKeyFound = this.searchFile((String)oTable.getValueAt(i, 1), strSearchKey, isWholeWordMatch, isCaseSensitive);
                bKeyFound = bKeyFound && this.isMatchVersionAndType(i, oSearchCriteria);
            } else {
                String strContentType = oTable.getValueAt(i, 2).toString();
                if (Collator.getInstance().equals(strContentSearch, strContentType)) {
                    bKeyFound = this.searchFile((String)oTable.getValueAt(i, 1), strSearchKey, isWholeWordMatch, isCaseSensitive);
                    boolean bl = bKeyFound = bKeyFound && this.isMatchVersionAndType(i, oSearchCriteria);
                }
            }
            if (bKeyFound) {
                return i;
            }
            if (i <= 0 || i != iEnd || false != iEnter) continue;
            iEnd = iBegin;
            i = iRowCount;
            ++iEnter;
        }
        return -1;
    }

    private int downDirectionSearch(SAMSearchCriteria oSearchCriteria, int iCurrentlySelectedIndex) {
        boolean isWholeWordMatch = oSearchCriteria.isMatchWholeWord();
        boolean isCaseSensitive = oSearchCriteria.isCaseSensitive();
        String strSearchKey = oSearchCriteria.getSearchString();
        String strContentSearch = null;
        if (null != oSearchCriteria.getContentType()) {
            strContentSearch = oSearchCriteria.getContentType().toString();
        }
        boolean bKeyFound = false;
        JTable oTable = this.m_oSAMFileInfoTablePanel.getTable();
        int iRowCount = oTable.getRowCount();
        int iBegin = iCurrentlySelectedIndex;
        int iEnd = iRowCount - 1;
        int iEnter = 0;
        for (int i = iBegin; i <= iEnd; ++i) {
            if (null == strContentSearch) {
                bKeyFound = this.searchFile((String)oTable.getValueAt(i, 1), strSearchKey, isWholeWordMatch, isCaseSensitive);
            } else {
                String strContentType = oTable.getValueAt(i, 2).toString();
                if (Collator.getInstance().equals(strContentSearch, strContentType)) {
                    bKeyFound = this.searchFile((String)oTable.getValueAt(i, 1), strSearchKey, isWholeWordMatch, isCaseSensitive);
                }
            }
            if (bKeyFound) {
                return i;
            }
            if (i <= 0 || i != iEnd || false != iEnter) continue;
            iEnd = iBegin;
            i = -1;
            ++iEnter;
        }
        return -1;
    }

    private boolean isMatchVersionAndType(int rowNumber, SAMSearchCriteria oSearchCriteria) {
        boolean bIsWholeWordMatch = oSearchCriteria.isMatchWholeWord();
        boolean bIsCaseSensitive = oSearchCriteria.isCaseSensitive();
        JTable oTable = this.m_oSAMFileInfoTablePanel.getTable();
        boolean isDevTypeMatch = false;
        boolean isVersionMatch = false;
        DeviceTypeInfo oDevTypeInfo = oSearchCriteria.getDeviceTypeInfo();
        if (null == oDevTypeInfo) {
            isDevTypeMatch = true;
        } else {
            String sTableDevTypeID = oTable.getValueAt(rowNumber, 7).toString();
            String sDevTypeID = oDevTypeInfo.getDevTypeName();
            isDevTypeMatch = this.compareNames(sTableDevTypeID, sDevTypeID, bIsWholeWordMatch, bIsCaseSensitive);
        }
        String sDevVersion = oSearchCriteria.getDeviceVersion();
        if (null == sDevVersion || sDevVersion.trim().length() == 0) {
            isVersionMatch = true;
        } else {
            String sTableVersion = (String)oTable.getValueAt(rowNumber, 3);
            isVersionMatch = this.compareNames(sTableVersion, sDevVersion, bIsWholeWordMatch, bIsCaseSensitive);
        }
        return isDevTypeMatch && isVersionMatch;
    }

    public void cleanUp() {
        if (null != this.m_oSAMSearchDialog) {
            this.m_oSAMSearchDialog.clearRes();
            this.m_oSAMSearchDialog.dispose();
            this.m_oSAMSearchDialog = null;
        }
    }

    private boolean searchFile(String strDest, String strKey, boolean bWholeWordMatch, boolean bCaseSensitive) {
        boolean bRetVal = false;
        if (!bCaseSensitive) {
            strDest = strDest.toLowerCase(ResourceMng.getInstance().getLocale());
            strKey = strKey.toLowerCase(ResourceMng.getInstance().getLocale());
        }
        if (bWholeWordMatch) {
            if (Collator.getInstance().equals(strDest, strKey)) {
                bRetVal = true;
            }
        } else {
            bRetVal = this.validDestAndKey(strDest, strKey);
        }
        return bRetVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validDestAndKey(String strDest, String strKey) {
        boolean bRetVal = false;
        if (-1 == strDest.indexOf("*") && strDest.contains(strKey)) {
            return true;
        }
        String strDestName = null;
        String strDestExt = null;
        String strKeyName = null;
        String strKeyExt = null;
        if (-1 != strDest.indexOf(46)) {
            strDestName = strDest.substring(0, strDest.indexOf(46));
            strDestExt = strDest.substring(strDest.indexOf(46) + 1);
        } else {
            strDestName = strDest;
        }
        if (-1 != strKey.indexOf(46)) {
            strKeyName = strKey.substring(0, strKey.indexOf(46));
            strKeyExt = strKey.substring(strKey.indexOf(46) + 1);
        } else {
            strKeyName = strKey;
        }
        if (-1 != strKey.indexOf(46) && -1 == strDest.indexOf(46)) {
            return false;
        }
        if (null != strKeyExt) {
            if (!strKeyExt.equals("*")) {
                if (!Collator.getInstance().equals(strDestExt, strKeyExt)) return false;
                bRetVal = true;
            } else {
                bRetVal = true;
            }
        }
        if (null == strKeyName) return bRetVal;
        return this.validString(strDestName, strKeyName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validString(String strDestName, String strKeyName) {
        boolean bRetVal = false;
        if (strKeyName.equals("*")) {
            return true;
        }
        if (strKeyName.endsWith("*")) {
            if (!strDestName.startsWith(strKeyName.substring(0, strKeyName.length() - 1))) return false;
            return true;
        }
        if (!Collator.getInstance().equals(strDestName, strKeyName)) return false;
        return true;
    }

    @Override
    public void setToNULL() {
    }
}

