/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view.search;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.TextFieldFilter;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.sam.model.ISAMDataModel;
import com.huawei.dc.sam.model.SAMDataModel;
import com.huawei.dc.sam.view.SAMFileInfoTablePanel;
import com.huawei.dc.sam.view.search.ISAMSearchManager;
import com.huawei.dc.sam.view.search.SAMSearchCriteria;
import com.huawei.dc.sam.view.search.SAMSearchManager;
import com.huawei.dc.sam.view.search.SAMSearchPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.AbstractDocument;

public class SAMSearchDialog
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private Container m_oContentPane;
    private JLabel m_oDeviceTypesLabel;
    private JLabel m_oContentTypeLabel;
    private JLabel m_oSearchTextLabel;
    private JLabel redStarLabel = new JLabel("*");
    private JLabel m_oDeviceVersionLabel;
    private TextFieldFilter m_oSearchTextFilter;
    private ComboBoxWithToolTip m_oDeviceTypesDropDown;
    private ComboBoxWithToolTip m_oDeviceVersionDropDown;
    private ComboBoxWithToolTip m_oContentTypeDropDown;
    private JTextField m_oSearchTextField;
    private JCheckBox m_oMatchWholeWordCheckBox;
    private JCheckBox m_oMatchCaseCheckBox;
    private JRadioButton m_oDirectionUpRadioButton;
    private JRadioButton m_oDirectionDownRadioButton;
    private ButtonGroup m_oButtonGroup;
    private JButton m_oFindNextBtn;
    private DefaultComboBoxModel m_oDeviceTypesModel;
    private SAMSearchPanel m_oSAMSearchPanel;
    private ISAMDataModel m_oSAMDataModel;
    private transient ISAMSearchManager m_oSAMSearchManager;
    protected IDeviceInfoManager c_oDeviceInfoManager;
    private KeyStroke m_oEnterKeyStroke;
    private KeyListener m_oKeyListener;

    public SAMSearchDialog(SAMSearchPanel oSAMSearchPanel, SAMFileInfoTablePanel oSAMFileInfoTablePanel) {
        this.m_oSAMSearchPanel = oSAMSearchPanel;
        this.m_oSAMSearchManager = new SAMSearchManager(this, oSAMFileInfoTablePanel);
        this.initializeDataModel();
        this.initializeDeviceInfoManager();
        this.initializeDialog();
        this.initializeContentPane();
        this.createLabels();
        this.createFields();
        this.createButtons();
        this.initializeKeyEventForEnterBtn();
        this.requestFocusToSearchString();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SAM_SEARCH_FILE");
    }

    private void initializeDataModel() {
        this.m_oSAMDataModel = SAMDataModel.getInstance();
    }

    protected void initializeDeviceInfoManager() {
        this.c_oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
    }

    private void setFocusToSearchStringField() {
        this.m_oSearchTextField.requestFocus();
    }

    private void initializeDialog() {
        this.setSize(425, 220);
        this.setTitle(DCFrameWorkUtil.getLocalizedString("SAM_SEARCH_DIALOG_TITLE"));
    }

    private void initializeContentPane() {
        this.m_oContentPane = this.getContentPane();
        this.m_oContentPane.setLayout(new GridBagLayout());
    }

    private void createLabels() {
        this.initializeLabels();
        this.addLabelsToPane();
        this.alignLabels();
    }

    private void initializeLabels() {
        this.m_oDeviceTypesLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_SEARCH_DEVICE_TYPE_LABEL"));
        this.m_oContentTypeLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_SEARCH_CONTENT_TYPE_LABEL"));
        this.m_oSearchTextLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_FILENAME_LABEL"));
        this.m_oDeviceVersionLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_SEARCH_DEVICE_VERSION_LABEL"));
    }

    private void alignLabels() {
        this.m_oSearchTextLabel.setPreferredSize(new Dimension(90, 20));
        this.m_oSearchTextLabel.setMinimumSize(new Dimension(90, 20));
        this.redStarLabel.setPreferredSize(new Dimension(10, 20));
        this.redStarLabel.setMinimumSize(new Dimension(10, 20));
        this.redStarLabel.setForeground(Color.RED);
        this.m_oDeviceTypesLabel.setPreferredSize(new Dimension(90, 20));
        this.m_oDeviceTypesLabel.setMinimumSize(new Dimension(90, 20));
        this.m_oDeviceVersionLabel.setPreferredSize(new Dimension(90, 20));
        this.m_oDeviceVersionLabel.setMinimumSize(new Dimension(90, 20));
        this.m_oContentTypeLabel.setPreferredSize(new Dimension(90, 20));
        this.m_oContentTypeLabel.setMinimumSize(new Dimension(90, 20));
    }

    private void addLabelsToPane() {
        this.m_oContentPane.add((Component)this.m_oSearchTextLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oDeviceTypesLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oDeviceVersionLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oContentTypeLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
    }

    private void createFields() {
        this.initializeFields();
        this.addFieldsToPane();
        this.alignFields();
    }

    private void initializeFields() {
        this.initializeDropDown();
        this.initializeSearchTextField();
        this.m_oMatchWholeWordCheckBox = new JCheckBox(DCFrameWorkUtil.getLocalizedString("SEARCH_DEVICE_MATCH_WHOLE_WORD_ONLY"));
        this.m_oMatchWholeWordCheckBox.setName("sam_SAMSearchDialog_m_oMatchWholeWordCheckBox");
        this.m_oMatchWholeWordCheckBox.setFocusable(false);
        this.m_oMatchCaseCheckBox = new JCheckBox(DCFrameWorkUtil.getLocalizedString("SEARCH_DEVICE_MATCH_CASE"));
        this.m_oMatchCaseCheckBox.setName("sam_SAMSearchDialog_m_oMatchCaseCheckBox");
        this.m_oMatchCaseCheckBox.setFocusable(false);
        this.initializeDirectionFields();
    }

    private void initializeSearchTextField() {
        this.m_oSearchTextField = new JTextField();
        this.m_oSearchTextField.setName("sam_SAMSearchDialog_m_oSearchTextField");
        AbstractDocument ao = (AbstractDocument)this.m_oSearchTextField.getDocument();
        this.m_oSearchTextFilter = new TextFieldFilter(30);
        ao.setDocumentFilter(this.m_oSearchTextFilter);
        this.m_oKeyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                SAMSearchDialog.this.checkForWildCard(SAMSearchDialog.this.m_oSearchTextField.getText().trim());
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        };
        this.m_oSearchTextField.addKeyListener(this.m_oKeyListener);
    }

    private void initializeDropDown() {
        this.createDeviceTypeDropDown();
        this.m_oDeviceVersionDropDown = new ComboBoxWithToolTip();
        this.m_oDeviceVersionDropDown.setName("sam_SAMSearchDialog_m_oDeviceVersionDropDown");
        this.m_oContentTypeDropDown = new ComboBoxWithToolTip();
        this.m_oContentTypeDropDown.setName("sam_SAMSearchDialog_m_oContentTypeDropDown");
        this.m_oDeviceTypesDropDown.setSelectedIndex(0);
    }

    private void checkForWildCard(String strSearchString) {
        if (-1 != strSearchString.indexOf("*")) {
            this.m_oMatchWholeWordCheckBox.setSelected(false);
            this.m_oMatchWholeWordCheckBox.setEnabled(false);
        } else {
            this.m_oMatchWholeWordCheckBox.setEnabled(true);
        }
    }

    private void createDeviceTypeDropDown() {
        ArrayList<Object> oDevTypeLst = new ArrayList(0);
        oDevTypeLst = this.getDeviceTypeList();
        if (null != oDevTypeLst) {
            DeviceTypeInfo[] arrDevType = new DeviceTypeInfo[oDevTypeLst.size()];
            for (int i = 0; i < oDevTypeLst.size(); ++i) {
                arrDevType[i] = (DeviceTypeInfo)oDevTypeLst.get(i);
            }
            this.m_oDeviceTypesModel = new DefaultComboBoxModel<DeviceTypeInfo>(arrDevType);
        } else {
            DeviceTypeInfo[] arrDevType = new DeviceTypeInfo[]{};
            this.m_oDeviceTypesModel = new DefaultComboBoxModel<DeviceTypeInfo>(arrDevType);
        }
        this.m_oDeviceTypesDropDown = new ComboBoxWithToolTip((ComboBoxModel)this.m_oDeviceTypesModel);
        this.m_oDeviceTypesDropDown.setName("sam_SAMSearchDialog_m_oDeviceTypesDropDown");
        this.m_oDeviceTypesDropDown.insertItemAt("All", 0);
        this.m_oDeviceTypesDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int iSelectedIndex = SAMSearchDialog.this.m_oDeviceTypesDropDown.getSelectedIndex();
                DeviceTypeInfo oDevTypeInfo = null;
                if (iSelectedIndex > 0) {
                    oDevTypeInfo = (DeviceTypeInfo)SAMSearchDialog.this.m_oDeviceTypesDropDown.getSelectedItem();
                }
                SAMSearchDialog.this.loadContentTypeDropDown(oDevTypeInfo);
                SAMSearchDialog.this.loadDeviceVersionDropDown(oDevTypeInfo);
            }
        });
    }

    private ArrayList<DeviceTypeInfo> getDeviceTypeList() {
        ArrayList<DeviceTypeInfo> oDevTypeLst = new ArrayList<DeviceTypeInfo>(0);
        ConcurrentHashMap oDevTypeMap = this.m_oSAMDataModel.getSAMDevTypeMap();
        if (null != oDevTypeMap) {
            Set oDevTypeSet = oDevTypeMap.keySet();
            for (DeviceTypeInfo oDeviceTypeInfo : oDevTypeSet) {
                ArrayList oFileList = this.m_oSAMDataModel.getFileInfoLst(oDeviceTypeInfo);
                if (0 == oFileList.size()) continue;
                oDevTypeLst.add(oDeviceTypeInfo);
            }
        }
        return oDevTypeLst;
    }

    protected void loadDeviceVersionDropDown(DeviceTypeInfo oDeviceTypeInfo) {
        this.m_oDeviceVersionDropDown.removeAllItems();
        this.m_oDeviceVersionDropDown.addItem("All");
        if (null == oDeviceTypeInfo) {
            return;
        }
        List oDevVerLst = this.getDeviceVersionList(oDeviceTypeInfo);
        if (null != oDevVerLst) {
            this.addDeviceVersionToComboBox(oDevVerLst);
        }
    }

    private void addDeviceVersionToComboBox(List oDevVerLst) {
        int iNoOfDevVer = oDevVerLst.size();
        for (int j = 0; j < iNoOfDevVer; ++j) {
            String oDevVer = (String)oDevVerLst.get(j);
            this.m_oDeviceVersionDropDown.addItem(oDevVer);
        }
    }

    private List getDeviceVersionList(DeviceTypeInfo oDeviceTypeInfo) {
        HashMap oDevVerMap;
        ArrayList<String> oDevVerLst = new ArrayList<String>(0);
        if (null != oDeviceTypeInfo && null != (oDevVerMap = new HashMap(0))) {
            if (null != this.m_oSAMDataModel.getVersionHashMap(oDeviceTypeInfo)) {
                oDevVerMap.putAll(this.m_oSAMDataModel.getVersionHashMap(oDeviceTypeInfo));
            }
            Set oVersionSet = oDevVerMap.keySet();
            for (String strVersion : oVersionSet) {
                ArrayList oFileList = this.m_oSAMDataModel.getFileInfoLst(oDeviceTypeInfo, strVersion, null);
                if (0 == oFileList.size()) continue;
                oDevVerLst.add(strVersion);
            }
        }
        return oDevVerLst;
    }

    public int loadContentTypeDropDown(DeviceTypeInfo oDeviceTypeInfo) {
        this.m_oContentTypeDropDown.removeAllItems();
        this.m_oContentTypeDropDown.addItem("All");
        if (null == oDeviceTypeInfo) {
            return 0;
        }
        List oContTypeLst = this.getContentTypesFromXMLConfig(oDeviceTypeInfo, 26);
        if (null != oContTypeLst) {
            this.addContentTypesToComboBox(oContTypeLst);
        }
        if (this.m_oContentTypeDropDown.getItemCount() <= 0) {
            return 0;
        }
        return 1;
    }

    private List getContentTypesFromXMLConfig(DeviceTypeInfo oDeviceTypeInfo, int iOperationID) {
        List<Object> oContTypeLst = null;
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, null);
        if (null != deviceTypeConfigModel) {
            IOperation oOperationObj = deviceTypeConfigModel.getOperationObj(5, iOperationID);
            if (null == oOperationObj) {
                return null;
            }
            IParaList oGetoPerationParaList = oOperationObj.getoPerationParaList();
            Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
            if (null != arrParaVals) {
                oContTypeLst = Arrays.asList(arrParaVals);
            }
        }
        return oContTypeLst;
    }

    private void addContentTypesToComboBox(List oContentTypeList) {
        int iNoOfXMLContentTypes = oContentTypeList.size();
        for (int j = 0; j < iNoOfXMLContentTypes; ++j) {
            ContentType oContType = (ContentType)oContentTypeList.get(j);
            this.m_oContentTypeDropDown.addItem(oContType);
        }
    }

    private void addFieldsToPane() {
        this.m_oContentPane.add((Component)this.m_oDeviceTypesDropDown, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oDeviceVersionDropDown, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oContentTypeDropDown, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oSearchTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.redStarLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oMatchWholeWordCheckBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oMatchCaseCheckBox, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
    }

    private void alignFields() {
        this.m_oSearchTextField.setPreferredSize(new Dimension(170, 22));
        this.m_oSearchTextField.setMinimumSize(new Dimension(170, 22));
        this.m_oDeviceTypesDropDown.setPreferredSize(new Dimension(170, 22));
        this.m_oDeviceTypesDropDown.setMinimumSize(new Dimension(170, 22));
        this.m_oDeviceVersionDropDown.setPreferredSize(new Dimension(170, 22));
        this.m_oDeviceVersionDropDown.setMinimumSize(new Dimension(170, 22));
        this.m_oContentTypeDropDown.setPreferredSize(new Dimension(170, 22));
        this.m_oContentTypeDropDown.setMinimumSize(new Dimension(170, 22));
        this.m_oMatchWholeWordCheckBox.setPreferredSize(new Dimension(130, 20));
        this.m_oMatchWholeWordCheckBox.setMinimumSize(new Dimension(140, 20));
        this.m_oMatchWholeWordCheckBox.setMnemonic('M');
        this.m_oMatchCaseCheckBox.setPreferredSize(new Dimension(120, 20));
        this.m_oMatchCaseCheckBox.setMinimumSize(new Dimension(120, 20));
        this.m_oMatchCaseCheckBox.setMnemonic('C');
    }

    private void initializeDirectionFields() {
        JPanel oDirectionsPanel = new JPanel();
        oDirectionsPanel.setName("sam_SAMSearchDialog_oDirectionsPanel");
        this.m_oDirectionUpRadioButton = new JRadioButton(DCFrameWorkUtil.getLocalizedString("SEARCH_DEVICE_DIRECTION_UP"));
        this.m_oDirectionUpRadioButton.setName("sam_SAMSearchDialog_m_oDirectionUpRadioButton");
        this.m_oDirectionUpRadioButton.setFocusable(false);
        this.m_oDirectionDownRadioButton = new JRadioButton(DCFrameWorkUtil.getLocalizedString("SEARCH_DEVICE_DIRECTION_DOWN"));
        this.m_oDirectionDownRadioButton.setName("sam_SAMSearchDialog_m_oDirectionDownRadioButton");
        this.m_oDirectionDownRadioButton.setFocusable(false);
        this.addFieldsToDirectionPanel(oDirectionsPanel);
        this.m_oButtonGroup = new ButtonGroup();
        this.m_oButtonGroup.add(this.m_oDirectionUpRadioButton);
        this.m_oButtonGroup.add(this.m_oDirectionDownRadioButton);
        this.m_oDirectionDownRadioButton.setSelected(true);
        TitledBorder oTitledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), DCFrameWorkUtil.getLocalizedString("SEARCH_DEVICE_DIRECTION_LABEL"));
        oDirectionsPanel.setBorder(oTitledBorder);
    }

    private void addFieldsToDirectionPanel(JPanel oDirectionsPanel) {
        oDirectionsPanel.setLayout(new GridBagLayout());
        oDirectionsPanel.add((Component)this.m_oDirectionUpRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        oDirectionsPanel.add((Component)this.m_oDirectionDownRadioButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 0), 0, 0));
        this.m_oDirectionUpRadioButton.setPreferredSize(new Dimension(80, 20));
        this.m_oDirectionUpRadioButton.setMinimumSize(new Dimension(80, 20));
        this.m_oDirectionUpRadioButton.setMnemonic('u');
        this.m_oDirectionDownRadioButton.setPreferredSize(new Dimension(80, 20));
        this.m_oDirectionDownRadioButton.setMinimumSize(new Dimension(80, 20));
        this.m_oDirectionDownRadioButton.setMnemonic('d');
        this.m_oContentPane.add((Component)oDirectionsPanel, new GridBagConstraints(2, 2, 1, 2, 1.0, 0.0, 18, 0, new Insets(0, 10, 5, 0), 0, 0));
        oDirectionsPanel.setPreferredSize(new Dimension(123, 65));
        oDirectionsPanel.setMinimumSize(new Dimension(123, 65));
    }

    private void createButtons() {
        this.initializeButtons();
        this.addButtonsToPane();
        this.alignButtons();
    }

    private void initializeButtons() {
        this.m_oFindNextBtn = new JButton(DCFrameWorkUtil.getLocalizedString("SEARCH_DEVICE_SEARCH_BUTTON_LABEL"));
        this.m_oFindNextBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BTN"));
        this.m_oFindNextBtn.setName("sam_SAMSearchDialog_m_oFindNextBtn");
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("SEARCH_DEVICE_CANCEL_BUTTON_LABEL"));
        this.m_oCancelBtn.setName("sam_SAMSearchDialog_m_oCancelBtn");
        this.m_oFindNextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAMSearchDialog.this.performSearch();
            }
        });
    }

    private void addButtonsToPane() {
        this.m_oContentPane.add((Component)this.m_oFindNextBtn, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.m_oContentPane.add((Component)this.m_oCancelBtn, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
    }

    private void alignButtons() {
        this.m_oFindNextBtn.setPreferredSize(new Dimension(120, 22));
        this.m_oFindNextBtn.setMinimumSize(new Dimension(120, 22));
        this.m_oCancelBtn.setPreferredSize(new Dimension(120, 22));
        this.m_oCancelBtn.setMinimumSize(new Dimension(120, 22));
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_SAM_SEARCH_FILE";
    }

    private void performSearch() {
        int iStatusCode = this.m_oSAMSearchManager.validateSearchString(this.m_oSearchTextField.getText().trim());
        if (9 != iStatusCode) {
            this.m_oSAMSearchManager.processErrorCode(iStatusCode);
            return;
        }
        SAMSearchCriteria oSearchCriteria = this.retrieveSearchCriteria();
        this.m_oSAMSearchManager.storeSearchCriteria(this.m_oSAMSearchPanel, oSearchCriteria);
        if (null != this.m_oSAMSearchPanel) {
            this.m_oSAMSearchPanel.getSearchBtn().doClick();
        }
        super.cancelButton_ActionPerformed();
    }

    private SAMSearchCriteria retrieveSearchCriteria() {
        SAMSearchCriteria oSearchCriteria = new SAMSearchCriteria();
        this.setDevTypeInfo(oSearchCriteria);
        this.setDevVerInfo(oSearchCriteria);
        this.setContentTypeInfo(oSearchCriteria);
        oSearchCriteria.setSearchString(this.m_oSearchTextField.getText().trim());
        oSearchCriteria.setMatchWholeWord(this.m_oMatchWholeWordCheckBox.isSelected());
        oSearchCriteria.setCaseSensitive(this.m_oMatchCaseCheckBox.isSelected());
        int iDirection = 0;
        if (this.m_oDirectionUpRadioButton.isSelected()) {
            iDirection = 1;
        }
        oSearchCriteria.setSearchDirection(iDirection);
        return oSearchCriteria;
    }

    private void setContentTypeInfo(SAMSearchCriteria oSearchCriteria) {
        if (0 == this.m_oContentTypeDropDown.getSelectedIndex()) {
            oSearchCriteria.setContentType(null);
        } else {
            oSearchCriteria.setContentType((ContentType)this.m_oContentTypeDropDown.getSelectedItem());
        }
    }

    private void setDevVerInfo(SAMSearchCriteria oSearchCriteria) {
        if (0 == this.m_oDeviceVersionDropDown.getSelectedIndex()) {
            oSearchCriteria.setDeviceVersion(null);
        } else {
            oSearchCriteria.setDeviceVersion((String)this.m_oDeviceVersionDropDown.getSelectedItem());
        }
    }

    private void setDevTypeInfo(SAMSearchCriteria oSearchCriteria) {
        if (0 == this.m_oDeviceTypesDropDown.getSelectedIndex()) {
            oSearchCriteria.setDeviceTypeInfo(null);
        } else {
            oSearchCriteria.setDeviceTypeInfo((DeviceTypeInfo)this.m_oDeviceTypesDropDown.getSelectedItem());
        }
    }

    public void clearRes() {
        this.m_oSearchTextFilter = null;
        this.m_oFindNextBtn = null;
        this.m_oContentTypeDropDown.removeAll();
        this.m_oDeviceTypesDropDown.removeAll();
        this.m_oDeviceVersionDropDown.removeAll();
        this.m_oContentTypeDropDown = null;
        this.m_oDeviceTypesDropDown = null;
        this.m_oDeviceVersionDropDown = null;
        this.m_oSAMSearchManager = null;
        this.m_oSAMSearchPanel = null;
        this.m_oSAMDataModel = null;
        this.c_oDeviceInfoManager = null;
    }

    private void initializeKeyEventForEnterBtn() {
        ActionListener EnterKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAMSearchDialog.this.m_oFindNextBtn.doClick();
            }
        };
        this.m_oEnterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.rootPane.registerKeyboardAction(EnterKeyHandler, this.m_oEnterKeyStroke, 2);
    }

    private void requestFocusToSearchString() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                SAMSearchDialog.this.setFocusToSearchStringField();
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                SAMSearchDialog.this.setFocusToSearchStringField();
            }
        });
    }

    @Override
    protected void closeDialog() {
        this.rootPane.unregisterKeyboardAction(this.m_oEnterKeyStroke);
        this.m_oEnterKeyStroke = null;
        this.m_oSearchTextField.removeKeyListener(this.m_oKeyListener);
        this.m_oKeyListener = null;
        this.clearRes();
        super.closeDialog();
        this.m_oSAMSearchManager = null;
        this.c_oDeviceInfoManager = null;
        this.m_oSAMDataModel = null;
    }
}

