/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.descriptor.MainDeviceTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.renderer.DeviceTreeRenderer;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.event.SAMChangeEventReceiver;
import com.huawei.dc.sam.model.ISAMDataModel;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMDataModel;
import com.huawei.dc.sam.view.SAMDeviceTreePopupManager;
import com.huawei.dc.sam.view.SAMFileInfoTablePanel;
import com.huawei.dc.sam.view.search.SAMSearchPanel;
import com.swimap.mdi.ExtendedWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class SoftwareArchiveMgmtPanel
extends ExtendedWindow {
    private static final long serialVersionUID = 1L;
    private JSplitPane m_oHorizontalSplitPane;
    private DeviceTreePanel m_oDeviceTreePanel;
    private JPanel m_oParentPanel;
    private SAMFileInfoTablePanel m_oFileInfoTablePanel;
    private SAMSearchPanel m_oSAMSearchPanel;
    private DeviceTree m_oSAMDeviceTree;
    private SAMDeviceTreePopupManager m_oSAMDeviceTreePopupMenuMgr;
    private JPopupMenu m_oSAMDeviceTreePopupMenu;
    private ISAMManager m_oSAMManager;
    private DataCenterModuleManager m_oDCModuleMgr;
    private final ImageIcon m_oDeviceTypeVersionImageIcon = ResourceManager.getInstance().getImage("versiontreenodeicon.gif");
    private final ImageIcon m_oDeviceTypeImageIcon = ResourceManager.getInstance().getImage("folderclosed.gif");
    private final ImageIcon m_oRootNodeImageIcon = ResourceManager.getInstance().getImage("rooticon.gif");
    private MouseListener m_oMouseListener;

    public SoftwareArchiveMgmtPanel(DataCenterModuleManager dcModuleMgr) {
        this.m_oDCModuleMgr = dcModuleMgr;
        MainDeviceTreeDescriptor oDeviceTreeDescriptor = new MainDeviceTreeDescriptor(1);
        this.m_oDeviceTreePanel = new DeviceTreePanel(null, oDeviceTreeDescriptor, ResourceManager.getInstance().getResString("SAM_ROOT"));
        this.m_oDeviceTreePanel.setName("Componenets_DataCenterMainPanel_oDeviceTreePanel");
        MySAMTreeRenderer oTreeRenderer = new MySAMTreeRenderer();
        this.m_oDeviceTreePanel.getDeviceTree().setCellRenderer(oTreeRenderer);
        SAMChangeEventReceiver.getInstance();
        this.m_oSAMManager = SAMManager.getInstance();
        this.m_oSAMManager.getSAMFileInfoRequest();
        this.jbinit();
        this.initializePopupMenuManager();
    }

    public SoftwareArchiveMgmtPanel(ISAMManager oSAMManager, DeviceTreePanel oDeviceTreePanel) {
        this.m_oSAMManager = oSAMManager;
        this.m_oDeviceTreePanel = oDeviceTreePanel;
        this.initializeSAMManager();
        this.jbinit();
        this.initializePopupMenuManager();
    }

    private void initializeSAMManager() {
        this.m_oSAMManager.registerForFileDeleteNtfn();
    }

    private void jbinit() {
        this.createDeviceTreePanel();
        this.initTablePanel();
        this.initSearchPanel();
        this.initParentPanel();
        this.addHorizontalSplitPane();
        this.addPanelsToSplitPanes();
        this.setLayout(new GridLayout());
        this.setName("Componenets_DataCenterMainPanel_m_oSoftwareArchiveMgmtPanel");
        this.setTitle(ResourceManager.getInstance().getResString("SOFTWARE_ARCHIVE_MANAGEMENT_TAB"));
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)this), "HELP_TOPIC_SAM");
    }

    private void initParentPanel() {
        this.m_oParentPanel = new JPanel();
        this.m_oParentPanel.setName("SAM_SoftwareArchiveMgmtPanel_m_oParentPanel");
        this.m_oParentPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_oParentPanel.setLayout(new BorderLayout());
        this.m_oParentPanel.add((Component)this.m_oSAMSearchPanel, "North");
        JPanel tempPanel = new JPanel();
        tempPanel.setName("SAM_SoftwareArchiveMgmtPanel_tempPanel");
        tempPanel.setLayout(new BorderLayout());
        JPanel m_ButtonPane = this.m_oFileInfoTablePanel.getButtonPanel();
        m_ButtonPane.setName("SAM_SoftwareArchiveMgmtPanel_m_ButtonPane");
        m_ButtonPane.setPreferredSize(new Dimension(150, 40));
        m_ButtonPane.setMinimumSize(new Dimension(150, 40));
        tempPanel.add((Component)this.m_oFileInfoTablePanel, "Center");
        tempPanel.add((Component)m_ButtonPane, "South");
        this.m_oParentPanel.add((Component)tempPanel, "Center");
    }

    private void initSearchPanel() {
        this.m_oSAMSearchPanel = new SAMSearchPanel(this.m_oFileInfoTablePanel);
        this.m_oSAMSearchPanel.setName("SAM_SoftwareArchiveMgmtPanel_m_oSAMSearchPanel");
        this.m_oSAMSearchPanel.setPreferredSize(new Dimension(150, 40));
        this.m_oSAMSearchPanel.setMinimumSize(new Dimension(150, 40));
    }

    private void initTablePanel() {
        this.m_oFileInfoTablePanel = new SAMFileInfoTablePanel(this);
        ObjectStore.getInstance().putObjectInstance("SAMFileInfoTablePanel", this.m_oFileInfoTablePanel);
        this.m_oFileInfoTablePanel.setName("SAM_SoftwareArchiveMgmtPanel_m_oFileInfoTablePanel");
        this.m_oFileInfoTablePanel.setPreferredSize(new Dimension(500, 350));
        this.m_oFileInfoTablePanel.setMinimumSize(new Dimension(500, 550));
    }

    private void createDeviceTreePanel() {
        this.m_oDeviceTreePanel.setMinimumSize(new Dimension(200, 200));
        this.m_oDeviceTreePanel.setPreferredSize(new Dimension(230, 200));
        this.m_oDeviceTreePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_oDeviceTreePanel.setName("SAM_SoftwareArchiveMgmtPanel_m_oDeviceTreePanel");
        this.updateDeviceTree();
    }

    private void updateDeviceTree() {
        ISAMDataModel oSAMDataModel = SAMDataModel.getInstance();
        ConcurrentHashMap oDeviceTypeMap = oSAMDataModel.getSAMDevTypeMap();
        if (null == oDeviceTypeMap) {
            return;
        }
        ConcurrentHashMap oDeviceVersionMap = null;
        if (null != this.m_oSAMDeviceTree) {
            this.m_oSAMDeviceTree.getRoot().removeAllChildren();
            MouseListener[] oListners = this.m_oSAMDeviceTree.getMouseListeners();
            for (int i = 0; i < oListners.length; ++i) {
                this.m_oSAMDeviceTree.removeMouseListener(oListners[i]);
            }
            this.m_oSAMDeviceTree = null;
        }
        this.m_oSAMDeviceTree = this.m_oDeviceTreePanel.getDeviceTree();
        this.m_oMouseListener = this.generateMouseAdapterForTree();
        this.m_oSAMDeviceTree.addMouseListener(this.m_oMouseListener);
        String strDeviceVersion = " ";
        DeviceTypeInfo oDevTypeInfo = null;
        Iterator oDeviceVersionIterator = null;
        DefaultMutableTreeNode oDevTypeNode = null;
        boolean bisDevVersionNodeExist = false;
        this.removeAllVersionNodes();
        Iterator oDevTypeItr = oDeviceTypeMap.entrySet().iterator();
        Map.Entry oDevTypeEntry = null;
        while (oDevTypeItr.hasNext()) {
            oDevTypeEntry = oDevTypeItr.next();
            oDevTypeInfo = (DeviceTypeInfo)oDevTypeEntry.getKey();
            DCDebugTracer.trace("updateDeviceTree() oDevTypeInfo:" + oDevTypeInfo);
            if (null == oDevTypeInfo) continue;
            oDeviceVersionMap = (ConcurrentHashMap)oDevTypeEntry.getValue();
            oDeviceVersionIterator = oDeviceVersionMap.keySet().iterator();
            oDevTypeNode = this.getDeviceTypeNode(oDevTypeInfo.toString());
            if (null == oDevTypeNode) {
                DefaultMutableTreeNode oRootNode = this.m_oSAMDeviceTree.getRoot();
                TreeNodeInfo oTreeNodeInfo = new TreeNodeInfo(oDevTypeInfo);
                oDevTypeNode = new DefaultMutableTreeNode();
                oDevTypeNode.setUserObject(oTreeNodeInfo);
                oRootNode.add(oDevTypeNode);
            }
            while (oDeviceVersionIterator.hasNext()) {
                strDeviceVersion = oDeviceVersionIterator.next().toString();
                bisDevVersionNodeExist = this.isVersionNodeExists(oDevTypeNode, strDeviceVersion);
                if (bisDevVersionNodeExist) continue;
                this.addVersionNode(oDevTypeNode, oDevTypeInfo, strDeviceVersion);
            }
        }
    }

    private MouseListener generateMouseAdapterForTree() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                SoftwareArchiveMgmtPanel.this.samDeviceTree_MousePressed(oMouseEvent);
            }
        };
    }

    protected void samDeviceTree_MousePressed(MouseEvent oMouseEvent) {
        if (!oMouseEvent.isPopupTrigger() && 0 != (0x10 & oMouseEvent.getModifiers())) {
            return;
        }
        int iClickedRow = this.m_oSAMDeviceTree.getClosestRowForLocation(oMouseEvent.getX(), oMouseEvent.getY());
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oSAMDeviceTree.getSelectionRows();
        if (nRows.length > 1) {
            bIsClickedRowSelected = this.isClickedRowSelected(iClickedRow, nRows);
        }
        if (!bIsClickedRowSelected) {
            TreeSelectionModel selectionModel = this.m_oSAMDeviceTree.getSelectionModel();
            selectionModel.setSelectionPath(this.m_oSAMDeviceTree.getPathForRow(iClickedRow));
        }
        this.getMenuItems();
        this.m_oSAMDeviceTreePopupMenu.show(this.m_oSAMDeviceTree, oMouseEvent.getX(), oMouseEvent.getY());
    }

    private boolean isClickedRowSelected(int iClickedRow, int[] nRows) {
        boolean bRetval = false;
        for (int i = 0; i < nRows.length; ++i) {
            if (nRows[i] != iClickedRow) continue;
            bRetval = true;
            break;
        }
        return bRetval;
    }

    private void getMenuItems() {
        this.m_oSAMDeviceTreePopupMenu = this.m_oSAMDeviceTreePopupMenuMgr.loadMenu();
    }

    private void initializePopupMenuManager() {
        this.m_oSAMDeviceTreePopupMenuMgr = new SAMDeviceTreePopupManager((Object)this);
    }

    private void removeAllVersionNodes() {
        DeviceTree oDeviceTree = this.m_oDeviceTreePanel.getDeviceTree();
        DefaultMutableTreeNode oRootTreeNode = oDeviceTree.getRoot();
        int iDeviceTypesCount = oRootTreeNode.getChildCount();
        for (int i = iDeviceTypesCount - 1; i >= 0; --i) {
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oRootTreeNode.getChildAt(i);
            int iVersionCount = oTreeNode.getChildCount();
            for (int j = iVersionCount - 1; j >= 0; --j) {
                DefaultMutableTreeNode oVerTreeNode = (DefaultMutableTreeNode)oTreeNode.getChildAt(j);
                oTreeNode.remove(oVerTreeNode);
            }
            oRootTreeNode.remove(i);
            oDeviceTree.updateUI();
        }
    }

    private DefaultMutableTreeNode getDeviceTypeNode(String strDevType) {
        DefaultMutableTreeNode oRootNode = this.m_oSAMDeviceTree.getRoot();
        int iDevTypeCount = oRootNode.getChildCount();
        boolean bNodePresent = false;
        DefaultMutableTreeNode oDevTypeNode = null;
        for (int index = 0; index < iDevTypeCount; ++index) {
            oDevTypeNode = (DefaultMutableTreeNode)oRootNode.getChildAt(index);
            if (!oDevTypeNode.toString().equals(strDevType)) continue;
            bNodePresent = true;
            break;
        }
        if (!bNodePresent) {
            return null;
        }
        return oDevTypeNode;
    }

    private boolean isVersionNodeExists(DefaultMutableTreeNode oDevTypeNode, String strDevVersion) {
        int iDevVersionCount = oDevTypeNode.getChildCount();
        DefaultMutableTreeNode oDevVersionNode = null;
        boolean bisDevVersionExists = false;
        for (int index = 0; index < iDevVersionCount; ++index) {
            oDevVersionNode = (DefaultMutableTreeNode)oDevTypeNode.getChildAt(index);
            if (!oDevVersionNode.toString().equals(strDevVersion)) continue;
            bisDevVersionExists = true;
            break;
        }
        return bisDevVersionExists;
    }

    private void addVersionNode(DefaultMutableTreeNode oDevTypeNode, DeviceTypeInfo oDevTypeInfo, String strVersion) {
        DefaultMutableTreeNode oDevVersionNode = new DefaultMutableTreeNode();
        TreeNodeInfo oTreeNodeInfo = new TreeNodeInfo(strVersion, oDevTypeInfo);
        oDevVersionNode.setUserObject(oTreeNodeInfo);
        oDevTypeNode.add(oDevVersionNode);
    }

    private void addPanelsToSplitPanes() {
        this.m_oHorizontalSplitPane.add((Component)this.m_oDeviceTreePanel, "left");
        this.m_oHorizontalSplitPane.add((Component)this.m_oParentPanel, "right");
        this.add(this.m_oHorizontalSplitPane, null);
    }

    private void addHorizontalSplitPane() {
        this.m_oHorizontalSplitPane = new JSplitPane(1);
        this.m_oHorizontalSplitPane.setName("SAM_SoftwareArchiveMgmtPanel_m_oHorizontalSplitPane");
        this.m_oHorizontalSplitPane.setMinimumSize(new Dimension(285, 77));
        this.m_oHorizontalSplitPane.setPreferredSize(new Dimension(285, 534));
        this.m_oHorizontalSplitPane.setAutoscrolls(false);
        this.m_oHorizontalSplitPane.setContinuousLayout(true);
        this.m_oHorizontalSplitPane.setOneTouchExpandable(false);
        this.m_oHorizontalSplitPane.setDividerLocation(200);
        this.m_oHorizontalSplitPane.setDividerSize(6);
        this.setLayout(new GridLayout());
    }

    private void expandTreeAtRoot() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoftwareArchiveMgmtPanel.this.m_oSAMDeviceTree.treeDidChange();
                TreePath rowTreePath = SoftwareArchiveMgmtPanel.this.m_oSAMDeviceTree.getPathForRow(0);
                SoftwareArchiveMgmtPanel.this.m_oSAMDeviceTree.setSelectionRow(0);
                if (SoftwareArchiveMgmtPanel.this.m_oSAMDeviceTree.isCollapsed(rowTreePath)) {
                    SoftwareArchiveMgmtPanel.this.m_oSAMDeviceTree.expandPath(rowTreePath);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSAMPanel() {
        ISAMManager oSAMManager = SAMManager.getInstance();
        ISAMDataModel oSAMDataModel = SAMDataModel.getInstance();
        oSAMDataModel.getSAMDevTypeMap().clear();
        oSAMManager.getSAMFileInfoRequest();
        try {
            Object object = oSAMManager.getSAMSyncObj();
            synchronized (object) {
                DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
                oSAMManager.getSAMSyncObj().wait(DCConstants.DEFAULT_WAIT_TIME);
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        this.updataDevTreeAndTable(oSAMDataModel);
    }

    private void updataDevTreeAndTable(ISAMDataModel oSAMDataModel) {
        ArrayList oFileInfoLst = oSAMDataModel.getFileInfoLst();
        if (null != this.m_oFileInfoTablePanel) {
            this.m_oFileInfoTablePanel.populateAllFileInfoFromDataModel(oFileInfoLst);
        }
        this.updateDeviceTree();
        this.expandTreeAtRoot();
        this.m_oFileInfoTablePanel.clearSortFlag();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoftwareArchiveMgmtPanel.this.m_oSAMDeviceTree.updateUI();
            }
        });
        DCFrameWorkUtil.defaultCursor();
    }

    public void setHelpKeyValue(String strHelpKeyValue) {
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)this), strHelpKeyValue);
    }

    public void deleteAllFiles() {
        ArrayList<ISAMFileInfo> oFileList = this.getFileListForDeletion();
        if (0 == oFileList.size()) {
            return;
        }
        int iConfirm = -1;
        iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_CONFIRM_DELETE_FILES"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
        if (iConfirm != 0) {
            return;
        }
        SAMUtil.getInstance().samFileDelete(oFileList);
    }

    private ArrayList<ISAMFileInfo> getFileListForDeletion() {
        DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)this.m_oSAMDeviceTree.getLastSelectedPathComponent();
        TreeNodeInfo oNodeInfo = (TreeNodeInfo)nodeObject.getUserObject();
        ISAMDataModel oSAMDataModel = SAMDataModel.getInstance();
        ArrayList oFileList = new ArrayList(0);
        DeviceTypeInfo oDevTypeInfo = oNodeInfo.getDeviceTypeInfo();
        String strVersion = oNodeInfo.getVersion();
        if (0 == nodeObject.getLevel()) {
            oFileList = oSAMDataModel.getFileInfoLst();
        } else if (1 == nodeObject.getLevel()) {
            oFileList = oSAMDataModel.getFileInfoLst(oDevTypeInfo);
        } else if (2 == nodeObject.getLevel()) {
            oFileList = oSAMDataModel.getFileInfoLst(oDevTypeInfo, strVersion, null);
        }
        return oFileList;
    }

    public DeviceTreePanel getSAMDeviceTreePanel() {
        return this.m_oDeviceTreePanel;
    }

    public void updateSAMFileInfo(DeviceTypeInfo oDeviceTypeInfo, ISAMFileInfo oSAMFileInfo) {
        this.m_oDeviceTreePanel.updateSAMDeviceTreeNode(oDeviceTypeInfo, oSAMFileInfo);
        this.m_oFileInfoTablePanel.updateFileInfoTable(oDeviceTypeInfo, oSAMFileInfo);
    }

    public void windowActivated() {
        super.windowActivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoftwareArchiveMgmtPanel.this.m_oDCModuleMgr.setToolBarIconVisible(true);
            }
        });
        MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "SoftwareArchiveManagement", false);
        DCFrameWorkUtil.getToolBarButton("SoftwareArchiveManagemnt").setEnabled(false);
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
    }

    public void windowDeactivated() {
        super.windowDeactivated();
        MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "SoftwareArchiveManagement", true);
        DCFrameWorkUtil.getToolBarButton("SoftwareArchiveManagemnt").setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoftwareArchiveMgmtPanel.this.m_oDCModuleMgr.setToolBarIconVisible(false);
            }
        });
    }

    public void windowClosed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoftwareArchiveMgmtPanel.this.m_oDCModuleMgr.setToolBarIconVisible(false);
            }
        });
        this.m_oDCModuleMgr.closePanel("SoftwareInfoPanel");
    }

    public void windowOpened() {
        this.m_oDCModuleMgr.openPanel("SoftwareInfoPanel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoftwareArchiveMgmtPanel.this.m_oDCModuleMgr.setToolBarIconVisible(true);
            }
        });
    }

    public void setToNull() {
        this.m_oSAMManager.removeSAMEventListener(this.m_oFileInfoTablePanel);
        ((SAMManager)SAMManager.getInstance()).setToNULL();
        ((SAMDataModel)SAMDataModel.getInstance()).setToNULL();
        ((DCObjectDestructor)DCObjectDestructor.getInstance()).removeObjectForDestructor(SAMUtil.getInstance());
        SAMUtil.getInstance().setToNULL();
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this.m_oDeviceTreePanel);
        if (null != this.m_oSAMDeviceTreePopupMenuMgr) {
            this.m_oSAMDeviceTreePopupMenuMgr.cleanUp();
            this.m_oSAMDeviceTreePopupMenuMgr = null;
        }
        if (null != this.m_oSAMSearchPanel) {
            this.m_oSAMSearchPanel.disposePanel();
            this.m_oSAMSearchPanel = null;
        }
        if (null != this.m_oFileInfoTablePanel) {
            ObjectStore.getInstance().removeObjectInstance("SAMFileInfoTablePanel");
            this.m_oFileInfoTablePanel.disposePanel();
            this.m_oFileInfoTablePanel = null;
        }
        this.m_oParentPanel.removeAll();
        this.m_oParentPanel = null;
        this.m_oSAMDeviceTreePopupMenu = null;
        if (null != this.m_oDeviceTreePanel) {
            this.m_oSAMDeviceTree.removeMouseListener(this.m_oMouseListener);
            this.m_oMouseListener = null;
            this.m_oDeviceTreePanel.disposePanel();
            this.m_oDeviceTreePanel = null;
        }
        if (null != this.m_oHorizontalSplitPane) {
            this.m_oHorizontalSplitPane.removeAll();
            this.m_oHorizontalSplitPane = null;
        }
        this.m_oSAMDeviceTree = null;
        this.removeAll();
        this.m_oSAMManager = null;
    }

    public Rectangle getWindowBounds() {
        return new Rectangle(0, 0, DCConstants.DC_WINDOW_WIDTH, DCConstants.DC_WINDOW_HEIGHT);
    }

    class MySAMTreeRenderer
    extends DeviceTreeRenderer {
        MySAMTreeRenderer() {
        }

        @Override
        public JLabel createLabelForNode(TreeNodeInfo oTreeNodeInfo, boolean anIsSelected, boolean anIsExpanded) {
            JLabel oLabel = new JLabel();
            if (anIsSelected) {
                oLabel.setForeground(Color.BLUE);
            } else {
                oLabel.setForeground(Color.BLACK);
            }
            if (3 == oTreeNodeInfo.m_iNodeType) {
                oLabel.setIcon(SoftwareArchiveMgmtPanel.this.m_oRootNodeImageIcon);
            } else if (2 == oTreeNodeInfo.m_iNodeType) {
                oLabel.setIcon(SoftwareArchiveMgmtPanel.this.m_oDeviceTypeVersionImageIcon);
            } else {
                oLabel.setIcon(SoftwareArchiveMgmtPanel.this.m_oDeviceTypeImageIcon);
            }
            return oLabel;
        }
    }
}

