/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.asndatacenter.ASNDCFileInfoStruct;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionDirRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMTargerVersionDirLst;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.LocalDiskDriveDetails;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.deviceoperation.util.DirListNode;
import com.huawei.dc.framework.ClientFileOperations;
import com.huawei.dc.framework.INotifyTransferProgress;
import com.huawei.dc.framework.IRequest;
import com.huawei.dc.sam.ISAMFileTransfer;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.view.SAMFileInfoTablePanel;
import com.huawei.dc.sam.view.SAMFilesProgressDlg;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.io.File;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class SaveAsSAMFile
implements IDCObjectDeallocator {
    private JTable m_oSAMFileInfoTable = null;
    private SAMFilesProgressDlg m_oprogressDlg;
    private static Object m_oSyncObj = new Object();
    private TIntObjectHashMap m_ReqidCancelSelectedMap = new TIntObjectHashMap(0);
    private boolean m_bCancelSelected = false;
    private int m_iOpRequestId = -1;
    private static SaveAsSAMFile m_oSaveAsSAMFile = new SaveAsSAMFile();
    private int m_iOperationType = -1;
    private SAMFileInfoTablePanel m_oSAMFileInfoTablePanel = null;
    private static int m_iErrorcode = -1;
    private SystemManager m_sysMgr = new SystemManager();
    private IRequest m_oRequest = null;

    public void setSAMFileInfoPanel(SAMFileInfoTablePanel oSAMFileInfoTablePanel) {
        this.m_oSAMFileInfoTablePanel = oSAMFileInfoTablePanel;
        this.m_oSAMFileInfoTable = this.m_oSAMFileInfoTablePanel.getTable();
    }

    private SaveAsSAMFile() {
        DCObjectDestructor.getInstance().addObjectForDestructor(m_oSaveAsSAMFile);
    }

    public static SaveAsSAMFile getInstance() {
        return m_oSaveAsSAMFile;
    }

    public int getOperationType() {
        return this.m_iOperationType;
    }

    @Override
    public void setToNULL() {
        if (this.m_oprogressDlg != null && this.m_oprogressDlg.isVisible()) {
            this.m_oprogressDlg.dispose();
            this.m_oprogressDlg = null;
        }
        if (null != this.m_ReqidCancelSelectedMap) {
            this.m_ReqidCancelSelectedMap.clear();
            this.m_ReqidCancelSelectedMap = null;
        }
        m_oSaveAsSAMFile = null;
        this.m_oRequest = null;
    }

    private boolean isMemoryAvailable(String strSaveasFilePath, String strVersionDirPath, boolean bT2000NE) {
        boolean bIsMemoryAvailable = true;
        String Property = System.getProperty("os.name");
        if (null != Property && Property.startsWith("Win")) {
            int strLocalDriveIndex = strSaveasFilePath.indexOf(":");
            String strLocalDriveName = strSaveasFilePath.substring(0, strLocalDriveIndex);
            LocalDiskDriveDetails oDiskDriveDetails = LocalDiskDriveDetails.getInstance();
            long lFreeMemoryAvail = oDiskDriveDetails.getFreeMemoryAvail(strLocalDriveName);
            long lFileSize = 0L;
            if (bT2000NE) {
                if (null != strVersionDirPath) {
                    lFileSize = this.getSelectedT2000FileSize(strVersionDirPath);
                }
            } else {
                String strFileSize = this.getSelectedFileSize();
                lFileSize = Long.parseLong(strFileSize);
            }
            if (lFreeMemoryAvail < lFileSize) {
                bIsMemoryAvailable = false;
            }
        }
        return bIsMemoryAvailable;
    }

    private long getSelectedT2000FileSize(String strVersionDirPath) {
        long lSize = 0L;
        File oFile = new File(strVersionDirPath);
        String[] strFileList = oFile.list();
        if (null == strFileList) {
            return 0L;
        }
        for (int i = 0; i < strFileList.length; ++i) {
            String checkPath = strVersionDirPath + "/" + strFileList[i];
            File oDirTest = new File(checkPath);
            if (oDirTest.isDirectory()) continue;
            lSize += oDirTest.length();
        }
        return lSize;
    }

    private String getSelectedFileSize() {
        String strFileSize = this.m_oSAMFileInfoTable.getValueAt(this.m_oSAMFileInfoTable.getSelectedRow(), 5).toString();
        return strFileSize;
    }

    public void saveSAMFile() {
        String strPath = System.getProperty("user.dir") + System.getProperty("file.separator") + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists()) {
            try {
                fileDoc.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return;
            }
        }
        DCFileChooser oSaveasFileChooser = new DCFileChooser(strPath, false);
        oSaveasFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("SAVE_AS"));
        oSaveasFileChooser.setFileSelectionMode(1);
        oSaveasFileChooser.setControlButtonsAreShown(true);
        oSaveasFileChooser.setAcceptAllFileFilterUsed(true);
        int returnValue = oSaveasFileChooser.showDialog(this.m_oSAMFileInfoTable, ResourceManager.getInstance().getResString("OK"));
        if (0 != returnValue) {
            return;
        }
        File oFile = oSaveasFileChooser.getSelectedFile();
        String strSaveasFilePath = oFile.getAbsolutePath();
        int[] iSelectedRows = this.m_oSAMFileInfoTable.getSelectedRows();
        boolean bT2000NE = false;
        int iRows = iSelectedRows.length;
        LinkedList<SamFileInfo> oSamFileInfoLst = new LinkedList<SamFileInfo>();
        String sDevTypeAndVersion = "";
        SamFileInfo oSamFileInfo = null;
        boolean bIgnorePrompt = false;
        for (int i = 0; i < iRows; ++i) {
            String strFilePath;
            int iRowSelected = iSelectedRows[i];
            String strFileName = (String)this.m_oSAMFileInfoTable.getValueAt(iRowSelected, 1);
            String strVersion = (String)this.m_oSAMFileInfoTable.getValueAt(iRowSelected, 3);
            DeviceTypeInfo oDeviceTypeInfo = this.m_oSAMFileInfoTablePanel.getDeviceType(iRowSelected);
            ContentType oContentType = (ContentType)this.m_oSAMFileInfoTable.getValueAt(iRowSelected, 2);
            String strPatch = (String)this.m_oSAMFileInfoTable.getValueAt(iRowSelected, 4);
            AsnDCGetTargetVersionDirReq oAsnDCGetTargetVersionDirReq = new AsnDCGetTargetVersionDirReq();
            oAsnDCGetTargetVersionDirReq.iDeviceTypeId = new BigInteger(String.valueOf(oDeviceTypeInfo.getDevTypeID()));
            oAsnDCGetTargetVersionDirReq.iDeviceTypeVersionID = new BigInteger(String.valueOf(oDeviceTypeInfo.getDevTypeVersionId()));
            oAsnDCGetTargetVersionDirReq.strTargetVersionName = strVersion.getBytes();
            oAsnDCGetTargetVersionDirReq.iFileContentType = BigInteger.valueOf(oContentType.getContentTypeCode());
            oAsnDCGetTargetVersionDirReq.strPatchVersionName = strPatch.getBytes();
            ISAMManager oSAManager = SAMManager.getInstance();
            AsnDCGetTargetVersionDirRsp oAsnDCGetTargetVersionDirRsp = oSAManager.getAsnSAMGetTargetVersionDir(oAsnDCGetTargetVersionDirReq);
            AsnSAMTargerVersionDirLst oTargerVersionDirLst = oAsnDCGetTargetVersionDirRsp.oTargerVersionDirLst;
            byte[] charPath = (byte[])oTargerVersionDirLst.get(0);
            String strDirPath = strFilePath = new String(charPath);
            strDirPath = strDirPath.replace('/', File.separatorChar);
            DCDebugTracer.trace("strDirPath  : " + strDirPath);
            int index = strDirPath.lastIndexOf(this.getFileSeperstor(strDirPath));
            if (index != -1) {
                strDirPath = strDirPath.substring(0, index);
                DCDebugTracer.trace("strDirPath  : " + strDirPath);
            }
            if (!this.isMemoryAvailable(strSaveasFilePath, strDirPath, bT2000NE = oDeviceTypeInfo.isT2000Domain())) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_FILES_INSUFFICIENT_MEMORY"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                return;
            }
            List<Object> strFileList = null;
            if (!bT2000NE) {
                strFileList = new LinkedList();
                strFileList.add(strFileName);
            } else {
                strFileList = this.getDirectoryFromServer(strDirPath);
                if (null == strFileList) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_FILES_NOT_FOUND"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                    return;
                }
            }
            oSamFileInfo = new SamFileInfo();
            oSamFileInfo.setFileNameLst(strFileList);
            oSamFileInfo.setDirPath(strDirPath);
            sDevTypeAndVersion = oDeviceTypeInfo.toString() + "_" + strVersion;
            sDevTypeAndVersion = sDevTypeAndVersion.replaceAll(" ", "_");
            String sSavesaFilePathNew = "";
            sSavesaFilePathNew = strSaveasFilePath + "/" + sDevTypeAndVersion;
            if (bT2000NE) {
                String sContentType = oContentType.toString().replaceAll(" ", "_");
                sSavesaFilePathNew = sSavesaFilePathNew + "/" + sContentType;
            }
            File oDir = new File(sSavesaFilePathNew);
            if (!bIgnorePrompt && oDir.exists()) {
                int iOption = DCOptionPane.showConfirmDialog((Component)this.m_oSAMFileInfoTablePanel, ResourceManager.getInstance().getResString("CATALOG_ALREADY_EXIST"), ResourceManager.getInstance().getResString("PRINT_CONFIRM_TITLE"), 0);
                if (iOption != 0) {
                    return;
                }
                bIgnorePrompt = true;
            }
            if (!oDir.exists()) {
                if (!oDir.mkdirs()) {
                    DCDebugTracer.trace("dc make dir failed " + sSavesaFilePathNew);
                }
                bIgnorePrompt = true;
            }
            oSamFileInfo.setSaveasFilePath(sSavesaFilePathNew);
            oSamFileInfoLst.add(oSamFileInfo);
        }
        ProgressHandler progressHandler = new ProgressHandler(oSamFileInfoLst);
        progressHandler.start();
    }

    private char getFileSeperstor(String strPath) {
        int strFileSeperator = File.separatorChar;
        int charLength = strPath.length();
        for (int i = 0; i < charLength; ++i) {
            if (strPath.charAt(i) != '/') continue;
            strFileSeperator = 47;
            break;
        }
        return (char)strFileSeperator;
    }

    public void openingProgressDlg(boolean isShowInfoLabel) {
        this.m_oprogressDlg = new SAMFilesProgressDlg(isShowInfoLabel);
        this.m_oprogressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("GETTING_SAM_FILES"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveAsSAMFile.this.m_oprogressDlg.setVisible(true);
            }
        });
    }

    public void resetReqIdOnCancel() {
        this.m_bCancelSelected = true;
        this.m_ReqidCancelSelectedMap.put(Integer.valueOf(this.m_iOpRequestId).intValue(), (Object)this.m_bCancelSelected);
        this.m_iOpRequestId = -1;
        if (null != this.m_oRequest) {
            this.m_oRequest.cancelTransfer();
        }
    }

    private int generateReqId() {
        Calendar oCal = Calendar.getInstance();
        StringBuffer strReqId = new StringBuffer(100);
        strReqId.append(oCal.get(10));
        strReqId.append(oCal.get(12));
        strReqId.append(oCal.get(13));
        return Integer.parseInt(strReqId.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFileTransferProgress(int iErrorCode) {
        m_iErrorcode = iErrorCode;
        Object object = m_oSyncObj;
        synchronized (object) {
            m_oSyncObj.notifyAll();
        }
    }

    private List<String> getDirectoryFromServer(String strPath) {
        int returnCode;
        final BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        final AsnDCGetDirReq dirGetReq = new AsnDCGetDirReq();
        dirGetReq.strRootPath = strPath.getBytes();
        dirGetReq.oDeviceOperationType.value = 10;
        final AsnDCGetDirRsp dirRsp = new AsnDCGetDirRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = commManager.sendSyncMsg(BaseCommManager.getMSGHead(43842), (FStruct)dirGetReq, (FStruct)dirRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), returnCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return null;
        }
        if (dirRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), dirRsp.oErrorInfo.iErrorNo.intValue(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return null;
        }
        LinkedList<String> oFileList = new LinkedList<String>();
        if (0 < dirRsp.oFiles.size()) {
            oFileList.clear();
            for (int i = 0; i < dirRsp.oFiles.size(); ++i) {
                ASNDCFileInfoStruct oAsnFileInfo = (ASNDCFileInfoStruct)dirRsp.oFiles.elementAt(i);
                DirListNode dir = new DirListNode(new String(oAsnFileInfo.strFilename), false);
                oFileList.add(dir.m_strName);
            }
        }
        return oFileList;
    }

    class SamFileInfo {
        private List<String> oFileNameLst = new LinkedList<String>();
        private String sDirPath = "";
        private String sSaveasFilePath = "";

        SamFileInfo() {
        }

        public String getDirPath() {
            return this.sDirPath;
        }

        public void setDirPath(String sDirPath) {
            this.sDirPath = sDirPath;
        }

        public String getSaveasFilePath() {
            return this.sSaveasFilePath;
        }

        public void setSaveasFilePath(String sSaveasFilePath) {
            this.sSaveasFilePath = sSaveasFilePath;
        }

        public List<String> getFileNameLst() {
            return this.oFileNameLst;
        }

        public void setFileNameLst(List<String> oFileNameLst) {
            this.oFileNameLst = oFileNameLst;
        }
    }

    class SaveasFileTransferThreadExt
    extends Thread {
        private String m_strFilePath;
        private ClientFileOperations oclientFileOperations;
        private String strSaveasFileName;
        private ISAMFileTransfer m_oFileTransfer;

        public SaveasFileTransferThreadExt(String strDestinationFilename, String strFilePath, ISAMFileTransfer oFileTransfer) {
            this.m_oFileTransfer = oFileTransfer;
            this.strSaveasFileName = strDestinationFilename;
            this.m_strFilePath = strFilePath;
            SaveAsSAMFile.this.m_iOperationType = 39;
            this.oclientFileOperations = new ClientFileOperations();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int iSAMFileErrorcode = 0;
            int iOperationRequestId = -1;
            String strSAMFilePath = this.m_strFilePath.substring(0, this.m_strFilePath.lastIndexOf("/")) + "/" + this.m_strFilePath.substring(this.m_strFilePath.lastIndexOf("/") + 1);
            iOperationRequestId = SaveAsSAMFile.this.m_iOpRequestId;
            SaveAsSAMFile.this.m_ReqidCancelSelectedMap.put(Integer.valueOf(iOperationRequestId).intValue(), (Object)Boolean.FALSE);
            SaveAsSAMFile.this.m_oRequest = this.oclientFileOperations.getFileForSAMSaveas(strSAMFilePath, this.strSaveasFileName, iOperationRequestId, (ProgressHandler)this.m_oFileTransfer);
            Object object = m_oSyncObj;
            synchronized (object) {
                try {
                    m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
            }
            iSAMFileErrorcode = m_iErrorcode;
            if (null != SaveAsSAMFile.this.m_ReqidCancelSelectedMap.get(Integer.valueOf(iOperationRequestId).intValue())) {
                SaveAsSAMFile.this.m_bCancelSelected = (Boolean)SaveAsSAMFile.this.m_ReqidCancelSelectedMap.get(Integer.valueOf(iOperationRequestId).intValue());
            }
            if (!SaveAsSAMFile.this.m_bCancelSelected) {
                if (0 == iSAMFileErrorcode) {
                    this.m_oFileTransfer.onSuccess();
                } else {
                    this.m_oFileTransfer.onFailure(iSAMFileErrorcode);
                }
            } else {
                this.m_oFileTransfer.onCancel();
            }
            SaveAsSAMFile.this.m_ReqidCancelSelectedMap.remove(Integer.valueOf(iOperationRequestId).intValue());
        }
    }

    private class ProgressHandler
    implements ISAMFileTransfer,
    INotifyTransferProgress {
        private List<SamFileInfo> m_oSamFileInfoLst = null;
        private int iProgressCount = 0;
        private int iCurIndex = 0;
        private int iFileCount;
        private int iListIndex = 0;
        private int iFileIndexInList = 0;

        ProgressHandler(List<SamFileInfo> oSamFileInfoLst) {
            this.m_oSamFileInfoLst = oSamFileInfoLst;
            this.initFileCount();
        }

        private void initFileCount() {
            if (null == this.m_oSamFileInfoLst || this.m_oSamFileInfoLst.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.m_oSamFileInfoLst.size(); ++i) {
                this.iFileCount += this.m_oSamFileInfoLst.get(i).getFileNameLst().size();
            }
        }

        public void start() {
            SaveasFileTransferThreadExt oSaveasFileTransferThreadExt = this.getNext();
            oSaveasFileTransferThreadExt.start();
            if (1 < this.iFileCount) {
                SaveAsSAMFile.this.openingProgressDlg(true);
            } else {
                SaveAsSAMFile.this.openingProgressDlg(false);
            }
            SaveAsSAMFile.this.m_oprogressDlg.setProgressInfo(this.getProgressInfo());
        }

        private String getProgressInfo() {
            return MessageFormat.format(ResourceManager.getInstance().getResString("SAM_SAVE_AS_PROGRESS_INFO"), this.iCurIndex + 1, this.iFileCount);
        }

        private SaveasFileTransferThreadExt getNext() {
            if (this.iCurIndex < this.iFileCount) {
                SaveAsSAMFile.this.m_iOpRequestId = SaveAsSAMFile.this.generateReqId();
                String strDirPath = "";
                String sFile = "";
                String sSavesaFilePath = "";
                SamFileInfo oCurSamFileInfo = null;
                if (this.iListIndex < this.m_oSamFileInfoLst.size()) {
                    oCurSamFileInfo = this.m_oSamFileInfoLst.get(this.iListIndex);
                }
                if (null != oCurSamFileInfo && this.iFileIndexInList < oCurSamFileInfo.getFileNameLst().size()) {
                    strDirPath = oCurSamFileInfo.getDirPath();
                    sSavesaFilePath = oCurSamFileInfo.getSaveasFilePath();
                    sFile = oCurSamFileInfo.getFileNameLst().get(this.iFileIndexInList);
                } else {
                    DCDebugTracer.trace("dc change to another file");
                    ++this.iListIndex;
                    oCurSamFileInfo = this.m_oSamFileInfoLst.get(this.iListIndex);
                    this.iFileIndexInList = 0;
                    strDirPath = oCurSamFileInfo.getDirPath();
                    sSavesaFilePath = oCurSamFileInfo.getSaveasFilePath();
                    sFile = oCurSamFileInfo.getFileNameLst().get(this.iFileIndexInList);
                    DCDebugTracer.trace("dir=" + strDirPath + " sFile=" + sFile + "savesaPath=" + sSavesaFilePath);
                }
                ++this.iFileIndexInList;
                String strSourcePath = strDirPath + "/" + sFile;
                String strDestPath = sSavesaFilePath + "/" + sFile;
                SaveasFileTransferThreadExt oSaveasFileTransferThreadExt = new SaveasFileTransferThreadExt(strDestPath, strSourcePath, this);
                return oSaveasFileTransferThreadExt;
            }
            return null;
        }

        @Override
        public void onCancel() {
            SaveAsSAMFile.this.m_oprogressDlg.setVisible(false);
            SaveAsSAMFile.this.m_oprogressDlg.dispose();
        }

        @Override
        public void onFailure(int iSAMFileErrorcode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iSAMFileErrorcode, DCFrameWorkUtil.getLocalizedString("BACKUP_FILES_SFTP_ERROR"), 0);
            SaveAsSAMFile.this.m_oprogressDlg.setVisible(false);
            SaveAsSAMFile.this.m_oprogressDlg.dispose();
        }

        @Override
        public void onSuccess() {
            ++this.iProgressCount;
            ++this.iCurIndex;
            if (this.iProgressCount == this.iFileCount) {
                SaveAsSAMFile.this.m_oprogressDlg.setVisible(false);
                SaveAsSAMFile.this.m_oprogressDlg.dispose();
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAVE_SUCCESS"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
            } else {
                SaveAsSAMFile.this.m_oprogressDlg.setProgressInfo(this.getProgressInfo());
                SaveAsSAMFile.this.m_oprogressDlg.getProgressBar().setValue(0);
                this.getNext().start();
            }
        }

        @Override
        public void notifyProgress(int progress) {
            SaveAsSAMFile.this.m_oprogressDlg.getProgressBar().setValue(progress);
        }
    }
}

