/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.view.SAMFileInfoTablePanel;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class SAMPopupManager {
    private HashMap<Object, Object> m_oMenuListFromXML;
    private JPopupMenu m_oFileInfoTablePopupMenu;
    private SAMFileInfoTablePanel m_oTablePanel;
    private JTable m_oFileInfoTable;
    boolean m_hasSAMMgrPrivilege = true;

    public SAMPopupManager(SAMFileInfoTablePanel oTablePanel, JTable oTable) {
        this.m_oTablePanel = oTablePanel;
        this.m_oFileInfoTable = oTable;
        this.m_oMenuListFromXML = new HashMap(10);
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oFileInfoTablePopupMenu = oPopupMenuManager.load(this.m_oTablePanel, "samfileinfotablepopupmenu");
        this.m_oMenuListFromXML = oPopupMenuManager.getMenuItemMap();
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.m_hasSAMMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43916);
        }
    }

    public JPopupMenu loadMenu() {
        String value;
        int[] arrSelectedRows = this.m_oFileInfoTable.getSelectedRows();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            MenuUtil.getMenuItemForID(this.m_oMenuListFromXML, "Save").setVisible(false);
        }
        if ((value = ResourceManager.getInstance().getResString("ENABLE_SAM_SAVEAS", "config").trim()).equals("0")) {
            MenuUtil.getMenuItemForID(this.m_oMenuListFromXML, "Save").setVisible(false);
        }
        if (null == arrSelectedRows || 0 >= arrSelectedRows.length || 0 >= this.m_oFileInfoTable.getRowCount()) {
            this.enableOnlyImportItem();
            this.displayBreakPacketMenuItem(arrSelectedRows);
            return this.m_oFileInfoTablePopupMenu;
        }
        this.enableMenuOnSelection(arrSelectedRows);
        this.displayBreakPacketMenuItem(arrSelectedRows);
        if (!this.m_hasSAMMgrPrivilege) {
            MenuUtil.enableAllMenuItems(this.m_oMenuListFromXML, false);
        }
        return this.m_oFileInfoTablePopupMenu;
    }

    private void enableMenuOnSelection(int[] arrSelectedRows) {
        if (1 == arrSelectedRows.length) {
            this.enableMenuForSingleSelection();
        } else {
            this.enableMenuForMultipleSelection(arrSelectedRows);
        }
    }

    private void displayBreakPacketMenuItem(int[] arrSelectedRows) {
        boolean bSupported = true;
        if (null == arrSelectedRows || 0 >= arrSelectedRows.length || this.m_oFileInfoTable.getRowCount() == 0) {
            bSupported = false;
        } else {
            ISAMFileInfo oSAMFileInfo = null;
            for (int i = 0; i < arrSelectedRows.length; ++i) {
                oSAMFileInfo = this.m_oTablePanel.getFileInfoAtRow(arrSelectedRows[i]);
                if (null != oSAMFileInfo && null != oSAMFileInfo.getBreakPacketInfo() && 3 != oSAMFileInfo.getBreakPacketInfo().getOperationStatus()) continue;
                bSupported = false;
                break;
            }
        }
        MenuUtil.getMenuItemForID(this.m_oMenuListFromXML, "BreakPacket").setVisible(bSupported);
        MenuUtil.getSeparator(this.m_oFileInfoTablePopupMenu, 1).setVisible(bSupported);
    }

    private void enableMenuForMultipleSelection(int[] arrSelectedRows) {
        MenuUtil.enableAllMenuItems(this.m_oMenuListFromXML, true);
        if (MenuUtil.getMenuItemForID(this.m_oMenuListFromXML, "Save").isVisible()) {
            boolean bSaveEnable = this.bSaveMenuEnable(arrSelectedRows);
            MenuUtil.getMenuItemForID(this.m_oMenuListFromXML, "Save").setEnabled(bSaveEnable);
        }
        MenuUtil.getMenuItemForID(this.m_oMenuListFromXML, "Update").setEnabled(false);
    }

    private boolean bSaveMenuEnable(int[] arrSelectedRows) {
        boolean bEnable = true;
        int iLength = arrSelectedRows.length;
        DeviceTypeInfo oFirstDevType = this.m_oTablePanel.getDeviceType(arrSelectedRows[0]);
        String sFirstDevVersion = this.m_oTablePanel.getDeviceVersion(arrSelectedRows[0]);
        DeviceTypeInfo oDevType = null;
        String sDevVersion = "";
        for (int i = 1; i < iLength; ++i) {
            oDevType = this.m_oTablePanel.getDeviceType(arrSelectedRows[i]);
            sDevVersion = this.m_oTablePanel.getDeviceVersion(arrSelectedRows[i]);
            if (oDevType.equals(oFirstDevType) && sDevVersion.equals(sFirstDevVersion)) continue;
            bEnable = false;
            break;
        }
        return bEnable;
    }

    private void enableMenuForSingleSelection() {
        MenuUtil.enableAllMenuItems(this.m_oMenuListFromXML, true);
    }

    private void enableOnlyImportItem() {
        MenuUtil.enableAllMenuItems(this.m_oMenuListFromXML, false);
        MenuUtil.getMenuItemForID(this.m_oMenuListFromXML, "Import").setEnabled(this.m_hasSAMMgrPrivilege);
    }

    public JMenuItem getMenuItemForID(String strMenuItemID) {
        JMenuItem tempMenu = null;
        if (null != this.m_oMenuListFromXML.get(strMenuItemID)) {
            tempMenu = (JMenuItem)this.m_oMenuListFromXML.get(strMenuItemID);
        } else {
            DCDebugTracer.traceError("[menu] get Menu Item  : " + strMenuItemID + " failed, please check samfileinfotablepopupmenu.xml file. ");
            tempMenu = new JMenuItem();
        }
        return tempMenu;
    }

    public void cleanUp() {
        this.m_oFileInfoTablePopupMenu.removeAll();
        this.m_oFileInfoTablePopupMenu = null;
    }
}

