/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCSyncCancelReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.event.ISAMEventListener;
import com.huawei.dc.sam.event.SAMEvent;
import com.huawei.dc.sam.model.BreakPacketInfo;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.text.Collator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import net.commustru.fstru.FStruct;

public class SAMOperationProgressDlg
extends ProgressDlg
implements ISAMEventListener {
    private static final long serialVersionUID = 1L;
    private List<ISAMFileInfo> m_oSAMFileList;
    private static final int DEVICE_TYPE_COLUMN = 0;
    private static final int FILE_NAME_COLUMN = 1;
    private static final int FILE_TYPE_COLUMN = 2;
    private static final int VERSION_COLUMN = 3;
    private static final int PATCH_VERSION_COLUMN = 4;
    private static final int RESULT_COLUMN = 5;

    public SAMOperationProgressDlg(List<ISAMFileInfo> oSAMFileList, int iCommandCode) {
        this.m_oSAMFileList = oSAMFileList;
        this.m_iCommandCode = iCommandCode;
        this.m_progressBar.setIndeterminate(true);
        this.m_progressBar.setStringPainted(false);
        SAMManager.getInstance().addSAMEventListener(this);
    }

    @Override
    protected String[] getTableColumnNames() {
        String[] columnNames = new String[]{DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_TYPE"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_FILE_NAME"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_FILE_TYPE"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_VERSION"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_PATCH_VERSION"), DCFrameWorkUtil.getLocalizedString("OPERATE_RESULT")};
        return columnNames;
    }

    @Override
    public synchronized void onSAMEvent(SAMEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        if (oEvent.getSource() instanceof SAMFileInfo) {
            SAMFileInfo oFileInfo = (SAMFileInfo)oEvent.getSource();
            String strResult = null;
            strResult = 43973 == this.m_iCommandCode && null != oFileInfo.getBreakPacketInfo() ? this.getResultForBreakPacketOperation(oFileInfo) : (43948 == this.m_iCommandCode ? (0 == oEvent.getErrorCode() ? DCFrameWorkUtil.getLocalizedString("OPERTION_SUCCESS") : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oEvent.getErrorCode()))) : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oEvent.getErrorCode())));
            Vector oRow = this.getRowForFileInTable(oFileInfo);
            if (null != oRow) {
                oRow.setElementAt(strResult, 5);
            } else {
                this.addFileResultToTable(oFileInfo, strResult);
            }
            if (oEvent.isFinal()) {
                if (43948 == this.m_iCommandCode) {
                    this.updateDetailsTable();
                    this.enableDisableButtons();
                    SAMManager.getInstance().removeSAMEventListener(this);
                }
                this.m_progressBar.setValue(100);
                this.m_progressBar.setIndeterminate(false);
                this.m_cancelBtn.setEnabled(false);
                this.m_closeBtn.setEnabled(true);
            } else if (this.m_cancelBtn.isEnabled() && !this.isAnyFileWithOperationState(DCFrameWorkUtil.getLocalizedString("OPERATION_NOT_STARTED"))) {
                this.m_cancelBtn.setEnabled(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SAMOperationProgressDlg.this.m_oScrollPane.repaint();
                }
            });
        }
    }

    public void initResultTable() {
        int iFileCount = this.m_oSAMFileList.size();
        for (int i = 0; i < iFileCount; ++i) {
            this.addFileResultToTable(this.m_oSAMFileList.get(i), DCFrameWorkUtil.getLocalizedString("OPERATION_NOT_STARTED"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SAMOperationProgressDlg.this.m_oScrollPane.repaint();
            }
        });
    }

    private String getResultForBreakPacketOperation(ISAMFileInfo oFileInfo) {
        BreakPacketInfo oBreakPacketInfo = oFileInfo.getBreakPacketInfo();
        switch (oBreakPacketInfo.getOperationStatus()) {
            case 0: {
                return this.getResultMessageForNotRun(oFileInfo);
            }
            case 1: {
                return DCFrameWorkUtil.getLocalizedString("OPERATION_IN_PROGRESS");
            }
            case 2: {
                return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oBreakPacketInfo.getErrorCode()));
            }
            case 3: {
                return DCFrameWorkUtil.getLocalizedString("OPERTION_SUCCESS");
            }
        }
        return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oBreakPacketInfo.getErrorCode()));
    }

    private String getResultMessageForNotRun(ISAMFileInfo oFileInfo) {
        Vector oRow = this.getRowForFileInTable(oFileInfo);
        if (null == oRow) {
            return DCFrameWorkUtil.getLocalizedString("OPERATION_NOT_STARTED");
        }
        String strResult = (String)oRow.get(5);
        if (Collator.getInstance() != null && null != strResult && Collator.getInstance().equals(DCFrameWorkUtil.getLocalizedString("OPERATION_IS_BEING_CANCELLED"), strResult)) {
            return DCFrameWorkUtil.getLocalizedString("OPERATION_CANCELLED");
        }
        return DCFrameWorkUtil.getLocalizedString("OPERATION_NOT_STARTED");
    }

    private void addFileResultToTable(ISAMFileInfo oFileInfo, String strErrorMsg) {
        Vector<Object> oRowVector = new Vector<Object>(6);
        oRowVector.addElement(oFileInfo.getDeviceTypeInfo());
        oRowVector.addElement(oFileInfo.getFileName());
        oRowVector.addElement(oFileInfo.getFileType());
        oRowVector.addElement(oFileInfo.getVersion());
        oRowVector.addElement(oFileInfo.getPatchVer());
        oRowVector.addElement(strErrorMsg);
        this.m_oDetailsTableModel.addRow(oRowVector);
    }

    @Override
    protected void cancelButtonActionPerformed() {
        AsnDCSyncCancelReq oAsnDCCancelReq = new AsnDCSyncCancelReq();
        oAsnDCCancelReq.oReqID = BigInteger.valueOf(this.getProgressDlgId());
        if (43948 == this.m_iCommandCode) {
            try {
                this.sendCancelRequestForDelete(oAsnDCCancelReq);
            }
            catch (DCException e) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                DCDebugTracer.trace("DC::SAMOperationProgressDlg::cancelButtonActionPerformed::throw exception::" + e.getMessage());
                return;
            }
        }
        this.m_bCancelOpPerformed = true;
        try {
            this.updateDetailsTable();
            this.sendCancelRequest();
            ToolTipManager.sharedInstance().setEnabled(true);
            this.enableDisableButtons();
        }
        catch (DCException e) {
            return;
        }
    }

    private void sendCancelRequestForDelete(final AsnDCSyncCancelReq oAsnDCCancelReq) throws DCException {
        int iErrorCode;
        final BaseCommManager oCommManager = DCFrameWorkUtil.getCommManager();
        final AsnDCSyncRsp oAsnDCOpertionRsp = this.getAsnDCOperationRspInstance();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int iErrorCode = oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43977), (FStruct)oAsnDCCancelReq, (FStruct)oAsnDCOpertionRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult() && 0 != (iErrorCode = ((Integer)syncCommand.getResult()).intValue())) {
            throw new DCException(iErrorCode, DCFrameWorkUtil.getLocalizedString("SEND_FAIL"));
        }
        if (0 != oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue()) {
            throw new DCException(oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue(), DCFrameWorkUtil.getLocalizedString("CANCEL_REQUEST_FAILED"));
        }
    }

    @Override
    protected void updateDetailsTable() {
        String strOpResult = this.getCancelResult();
        int iFileCount = this.m_oSAMFileList.size();
        ISAMFileInfo oFileInfo = null;
        Vector oRow = null;
        for (int index = 0; index < iFileCount; ++index) {
            oFileInfo = this.m_oSAMFileList.get(index);
            oRow = this.getRowForFileInTable(oFileInfo);
            if (null != oRow) {
                if (null == oRow.get(5) || !DCFrameWorkUtil.getLocalizedString("OPERATION_NOT_STARTED").equalsIgnoreCase((String)oRow.get(5))) continue;
                oRow.set(5, strOpResult);
                continue;
            }
            if (null != oFileInfo.getBreakPacketInfo() && 1 == oFileInfo.getBreakPacketInfo().getOperationStatus()) continue;
            this.addFileResultToTable(oFileInfo, strOpResult);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SAMOperationProgressDlg.this.repaintPanel();
            }
        });
    }

    private Vector getRowForFileInTable(ISAMFileInfo oFileInfo) {
        Vector<Vector> oDataVector = this.m_oDetailsTableModel.getDataVector();
        Vector oRowVector = null;
        String strFileName = null;
        ContentType oFileType = null;
        String strVersion = null;
        String strPatchVersion = null;
        DeviceTypeInfo oDeviceType = null;
        int iRowCount = oDataVector.size();
        for (int i = 0; i < iRowCount; ++i) {
            oRowVector = oDataVector.get(i);
            strFileName = (String)oRowVector.get(1);
            if (null == strFileName || !Collator.getInstance().equals(strFileName, oFileInfo.getFileName()) || null == (oFileType = (ContentType)oRowVector.get(2)) || !oFileType.equals(oFileInfo.getFileType()) || null == (strVersion = (String)oRowVector.get(3)) || !strVersion.equals(oFileInfo.getVersion()) || null == (strPatchVersion = (String)oRowVector.get(4)) || !strPatchVersion.equals(oFileInfo.getPatchVer()) || null == (oDeviceType = (DeviceTypeInfo)oRowVector.get(0)) || !oDeviceType.equals(oFileInfo.getDeviceTypeInfo())) continue;
            return oRowVector;
        }
        return null;
    }

    public void setColumnShowForDelete() {
        this.m_progressBar.setString("");
        this.m_progressBar.setStringPainted(true);
        for (int i = this.m_oDetailsTableModel.getColumnCount() - 1; i >= 0; --i) {
            if (1 == i || 5 == i) continue;
            this.m_oResultTable.removeColumn(this.m_oResultTable.getColumnModel().getColumn(i));
        }
    }

    @Override
    public void doCleanUp() {
        if (43973 == this.m_iCommandCode) {
            if (this.m_closeBtn.isEnabled()) {
                SAMManager.getInstance().removeSAMEventListener(this);
                this.m_oDetailsTableModel.getDataVector().removeAllElements();
                this.dispose();
            }
        } else {
            super.doCleanUp();
        }
    }

    private boolean isAnyFileWithOperationState(String strState) {
        int iFileCount = this.m_oSAMFileList.size();
        for (int i = 0; i < iFileCount; ++i) {
            Vector oRow = this.getRowForFileInTable(this.m_oSAMFileList.get(i));
            if (null == oRow || null == oRow.get(5) || !strState.equalsIgnoreCase((String)oRow.get(5))) continue;
            return true;
        }
        return false;
    }
}

