/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.sam.model.BreakPacketInfo;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.view.SAMFileInfoTablePanel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SAMFileTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private SAMFileInfoTablePanel m_oTablePanel;
    public static final String FILE_TYPE_PROGRAM_ID = "PROGRAM";
    public static final String FILE_TYPE_PATCH_ID = "PATCH";

    public SAMFileTableCellRenderer(SAMFileInfoTablePanel oTablePanel) {
        this.m_oTablePanel = oTablePanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable tblObj, Object obj, boolean isChoosed, boolean isFocus, int rowNo, int colNo) {
        if (0 == colNo) {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            ISAMFileInfo oSAMFileInfo = this.m_oTablePanel.getFileInfoAtRow(rowNo);
            if (null != oSAMFileInfo) {
                String strIcon = null;
                BreakPacketInfo oBreakPacket = oSAMFileInfo.getBreakPacketInfo();
                strIcon = null == oBreakPacket ? this.getDifferntIconByFileType(oSAMFileInfo) : this.getNodeIconForPacket(oBreakPacket);
                ImageIcon oIcon = ResourceManager.getInstance().getImage(strIcon);
                oLabel.setHorizontalAlignment(0);
                oLabel.setIcon(oIcon);
            }
            if (isChoosed) {
                oLabel.setBackground(tblObj.getSelectionBackground());
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setBackground(tblObj.getBackground());
                oLabel.setForeground(tblObj.getForeground());
            }
            return oLabel;
        }
        if (5 == colNo) {
            obj = StringUtils.getNumberFormatStr(obj);
        }
        return super.getTableCellRendererComponent(tblObj, obj, isChoosed, isFocus, rowNo, colNo);
    }

    private String getNodeIconForPacket(BreakPacketInfo oBreakPacket) {
        String strIcon;
        switch (oBreakPacket.getOperationStatus()) {
            case 0: 
            case 1: {
                strIcon = "sam_file_package.gif";
                break;
            }
            case 3: {
                strIcon = "sam_file_break_success.gif";
                break;
            }
            case 2: {
                strIcon = "sam_file_break_fail.gif";
                break;
            }
            default: {
                strIcon = "sam_file_normal.gif";
            }
        }
        return strIcon;
    }

    private String getDifferntIconByFileType(ISAMFileInfo oSAMFileInfo) {
        String content = oSAMFileInfo.getFileType().getId();
        if (FILE_TYPE_PROGRAM_ID.equals(content)) {
            return "soft_software_inuse.gif";
        }
        if (FILE_TYPE_PATCH_ID.equals(content)) {
            return "soft_patch_inuse.gif";
        }
        return "sam_file_normal.gif";
    }
}

